/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.network.ElasticIP;
import org.dasein.cloud.aws.network.ElasticLoadBalancer;
import org.dasein.cloud.aws.network.Route53;
import org.dasein.cloud.aws.network.SecurityGroup;
import org.dasein.cloud.aws.network.VPC;
import org.dasein.cloud.network.AbstractNetworkServices;
import org.dasein.cloud.network.DNSSupport;

public class EC2NetworkServices
extends AbstractNetworkServices {
    private AWSCloud cloud;

    public EC2NetworkServices(AWSCloud cloud) {
        this.cloud = cloud;
    }

    @Nullable
    public DNSSupport getDnsSupport() {
        if (this.cloud.getEC2Provider().isAWS() || this.cloud.getEC2Provider().isEnStratus()) {
            return new Route53(this.cloud);
        }
        return null;
    }

    @Nonnull
    public SecurityGroup getFirewallSupport() {
        return new SecurityGroup(this.cloud);
    }

    @Nonnull
    public ElasticIP getIpAddressSupport() {
        return new ElasticIP(this.cloud);
    }

    @Nullable
    public ElasticLoadBalancer getLoadBalancerSupport() {
        if (this.cloud.getEC2Provider().isAWS() || this.cloud.getEC2Provider().isEnStratus()) {
            return new ElasticLoadBalancer(this.cloud);
        }
        return null;
    }

    @Nullable
    public VPC getVlanSupport() {
        if (this.cloud.getEC2Provider().isAWS() || this.cloud.getEC2Provider().isEnStratus()) {
            return new VPC(this.cloud);
        }
        return null;
    }
}

