/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.Map;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.LoadBalancerSupport;

public class ELBMethod
extends EC2Method {
    public static final String ELB_PREFIX = "elasticloadbalancing:";
    public static final String CREATE_LOAD_BALANCER = "CreateLoadBalancer";
    public static final String DELETE_LOAD_BALANCER = "DeleteLoadBalancer";
    public static final String DEREGISTER_INSTANCES = "DeregisterInstancesFromLoadBalancer";
    public static final String DESCRIBE_LOAD_BALANCERS = "DescribeLoadBalancers";
    public static final String DISABLE_AVAILABILITY_ZONES = "DisableAvailabilityZonesForLoadBalancer";
    public static final String ENABLE_AVAILABILITY_ZONES = "EnableAvailabilityZonesForLoadBalancer";
    public static final String REGISTER_INSTANCES = "RegisterInstancesWithLoadBalancer";

    @Nonnull
    public static ServiceAction[] asELBServiceAction(@Nonnull String action) {
        if (action.equals(CREATE_LOAD_BALANCER)) {
            return new ServiceAction[]{LoadBalancerSupport.CREATE_LOAD_BALANCER};
        }
        if (action.equals(DELETE_LOAD_BALANCER)) {
            return new ServiceAction[]{LoadBalancerSupport.REMOVE_LOAD_BALANCER};
        }
        if (action.equals(DEREGISTER_INSTANCES)) {
            return new ServiceAction[]{LoadBalancerSupport.REMOVE_VMS};
        }
        if (action.equals(DESCRIBE_LOAD_BALANCERS)) {
            return new ServiceAction[]{LoadBalancerSupport.GET_LOAD_BALANCER, LoadBalancerSupport.LIST_LOAD_BALANCER};
        }
        if (action.equals(DISABLE_AVAILABILITY_ZONES)) {
            return new ServiceAction[]{LoadBalancerSupport.REMOVE_DATA_CENTERS};
        }
        if (action.equals(ENABLE_AVAILABILITY_ZONES)) {
            return new ServiceAction[]{LoadBalancerSupport.ADD_DATA_CENTERS};
        }
        if (action.equals(REGISTER_INSTANCES)) {
            return new ServiceAction[]{LoadBalancerSupport.ADD_VMS};
        }
        return new ServiceAction[0];
    }

    public ELBMethod(@Nonnull AWSCloud provider, @Nonnull ProviderContext ctx, @Nonnull Map<String, String> parameters) throws CloudException, InternalException {
        super(provider, "https://elasticloadbalancing." + ctx.getRegionId() + ".amazonaws.com", parameters);
    }
}

