/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElasticIP
implements IpAddressSupport {
    private static final Logger logger = AWSCloud.getLogger(ElasticIP.class);
    private AWSCloud provider = null;

    ElasticIP(AWSCloud provider) {
        this.provider = provider;
    }

    @Nullable
    private VirtualMachine getInstance(@Nonnull String instanceId) throws InternalException, CloudException {
        VirtualMachineSupport support;
        EC2ComputeServices services = this.provider.getComputeServices();
        if (services != null && (support = services.getVirtualMachineSupport()) != null) {
            return support.getVirtualMachine(instanceId);
        }
        throw new CloudException("Instances are not supported in " + this.provider.getCloudName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(@Nonnull String addressId, @Nonnull String instanceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"assignAddressToServer");
        try {
            Document doc;
            long timeout = System.currentTimeMillis() + 1200000L;
            VirtualMachine vm = this.getInstance(instanceId);
            while (System.currentTimeMillis() < timeout) {
                if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                    throw new CloudException("No such virtual machine " + instanceId);
                }
                VmState s = vm.getCurrentState();
                if (VmState.RUNNING.equals((Object)s) || VmState.STOPPED.equals((Object)s) || VmState.PAUSED.equals((Object)s) || VmState.SUSPENDED.equals((Object)s)) break;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    vm = this.getInstance(instanceId);
                }
                catch (Throwable ignore) {}
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AssociateAddress");
            this.setId("", parameters, this.getIpAddress(addressId), addressId);
            parameters.put("InstanceId", instanceId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Association of address denied.");
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"assignAddressToNetworkInterface");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AssociateAddress");
            parameters.put("AllocationId", addressId);
            parameters.put("NetworkInterfaceId", nicId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Association of address denied.");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String serverId) throws InternalException, CloudException {
        throw new OperationNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getIpAddress");
        try {
            IpAddress address = this.getEC2Address(addressId);
            IpAddress ipAddress = address == null && this.provider.getEC2Provider().isAWS() ? this.getVPCAddress(addressId) : address;
            return ipAddress;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private IpAddress getEC2Address(@Nonnull String addressId) throws InternalException, CloudException {
        block12: {
            APITrace.begin((CloudProvider)this.provider, (String)"getEC2Address");
            ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeAddresses");
            address = null;
            parameters.put("PublicIp.1", addressId);
            method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                code = e.getCode();
                if (!(code != null && code.equals("InvalidAddress.NotFound") || e.getMessage().contains("Invalid value"))) {
                    ElasticIP.logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                var10_12 = null;
                APITrace.end();
                return var10_12;
            }
            blocks = doc.getElementsByTagName("addressesSet");
            i = 0;
lbl24:
            // 2 sources

            while (true) {
                if (i < blocks.getLength()) {
                    items = blocks.item(i).getChildNodes();
                    break block12;
                }
                var8_9 = address;
                return var8_9;
            }
            finally {
                APITrace.end();
            }
        }
        for (j = 0; j < items.getLength(); ++j) {
            item = items.item(j);
            if (!item.getNodeName().equals("item") || (address = this.toAddress(ctx, item)) == null || !addressId.equals(address.getProviderIpAddressId())) continue;
            var12_16 = address;
            return var12_16;
        }
        ++i;
        ** continue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private IpAddress getVPCAddress(@Nonnull String addressId) throws InternalException, CloudException {
        block12: {
            APITrace.begin((CloudProvider)this.provider, (String)"getVPCAddress");
            ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeAddresses");
            address = null;
            parameters.put("AllocationId.1", addressId);
            method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                code = e.getCode();
                if (code != null && (code.equals("InvalidAllocationID.NotFound") || code.equals("InvalidAddress.NotFound") || e.getMessage().contains("Invalid value") || e.getMessage().startsWith("InvalidAllocation"))) {
                    var10_12 = null;
                    APITrace.end();
                    return var10_12;
                }
                ElasticIP.logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            blocks = doc.getElementsByTagName("addressesSet");
            i = 0;
lbl24:
            // 2 sources

            while (true) {
                if (i < blocks.getLength()) {
                    items = blocks.item(i).getChildNodes();
                    break block12;
                }
                var8_9 = address;
                return var8_9;
            }
            finally {
                APITrace.end();
            }
        }
        for (j = 0; j < items.getLength(); ++j) {
            item = items.item(j);
            if (!item.getNodeName().equals("item") || (address = this.toAddress(ctx, item)) == null || !addressId.equals(address.getProviderIpAddressId())) continue;
            var12_16 = address;
            return var12_16;
        }
        ++i;
        ** continue;
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "elastic IP";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() {
        return Requirement.NONE;
    }

    public boolean isAssigned(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC);
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isForwarding() {
        return false;
    }

    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isRequestable(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC);
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return this.listIpPool(IPVersion.IPV4, unassignedOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listIpPool");
        try {
            Document doc;
            if (!version.equals((Object)IPVersion.IPV4)) {
                List<IpAddress> list = Collections.emptyList();
                return list;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeAddresses");
            ArrayList<IpAddress> list = new ArrayList<IpAddress>();
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("addressesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    IpAddress address;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (address = this.toAddress(ctx, item)) == null || unassignedOnly && (address.getServerId() != null || address.getProviderLoadBalancerId() != null)) continue;
                    list.add(address);
                }
            }
            ArrayList<IpAddress> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listIpPoolStatus");
        try {
            Document doc;
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new OperationNotSupportedException(version + " is not supported in " + this.provider.getCloudName());
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeAddresses");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("addressesSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (status = this.toStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)IpAddressSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)IpAddressSupport.ASSIGN)) {
            return new String[]{"ec2:AssociateAddress"};
        }
        if (action.equals((Object)IpAddressSupport.CREATE_IP_ADDRESS)) {
            return new String[]{"ec2:AllocateAddress"};
        }
        if (action.equals((Object)IpAddressSupport.FORWARD)) {
            return new String[0];
        }
        if (action.equals((Object)IpAddressSupport.GET_IP_ADDRESS)) {
            return new String[]{"ec2:DescribeAddresses"};
        }
        if (action.equals((Object)IpAddressSupport.LIST_IP_ADDRESS)) {
            return new String[]{"ec2:DescribeAddresses"};
        }
        if (action.equals((Object)IpAddressSupport.RELEASE)) {
            return new String[]{"ec2:DisassociateAddress"};
        }
        if (action.equals((Object)IpAddressSupport.REMOVE_IP_ADDRESS)) {
            return new String[]{"ec2:ReleaseAddress"};
        }
        if (action.equals((Object)IpAddressSupport.STOP_FORWARD)) {
            return new String[0];
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"releaseAddressFromServer");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DisassociateAddress");
            this.setId("", parameters, this.getIpAddress(addressId), addressId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Release of address denied.");
            }
        }
        finally {
            APITrace.end();
        }
    }

    private void setId(@Nonnull String postfix, @Nonnull Map<String, String> parameters, @Nullable IpAddress address, @Nonnull String addressId) throws CloudException {
        if (address == null) {
            throw new CloudException("Invalid IP address: " + addressId);
        }
        if (address.isForVlan()) {
            parameters.put("AllocationId" + postfix, addressId);
        } else {
            parameters.put("PublicIp" + postfix, addressId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"releaseAddressFromPool");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ReleaseAddress");
            this.setId("", parameters, this.getIpAddress(addressId), addressId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Deletion of address denied.");
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String request(@Nonnull AddressType betterBePublic) throws InternalException, CloudException {
        if (!betterBePublic.equals((Object)AddressType.PUBLIC)) {
            throw new OperationNotSupportedException("AWS supports only public IP address requests.");
        }
        return this.request(IPVersion.IPV4);
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"requestIPAddress");
        try {
            Document doc;
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support " + version);
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AllocateAddress");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("publicIp");
            if (blocks.getLength() > 0) {
                String string = blocks.item(0).getFirstChild().getNodeValue().trim();
                return string;
            }
            throw new CloudException("Unable to create an address.");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion forVersion) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"requestAddressForVLAN");
        try {
            Document doc;
            if (!forVersion.equals((Object)IPVersion.IPV4)) {
                throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support " + forVersion + ".");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AllocateAddress");
            parameters.put("Domain", "vpc");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("allocationId");
            if (blocks.getLength() > 0) {
                String string = blocks.item(0).getFirstChild().getNodeValue().trim();
                return string;
            }
            throw new CloudException("Unable to create an address.");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("AWS IP addresses may not be assigned to a specific VLAN");
    }

    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        throw new OperationNotSupportedException();
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion version) throws InternalException, CloudException {
        return version.equals((Object)IPVersion.IPV4);
    }

    @Nullable
    private IpAddress toAddress(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No regionID was set in context");
        }
        NodeList attrs = node.getChildNodes();
        IpAddress address = new IpAddress();
        String instanceId = null;
        String ip = null;
        String ipAddressId = null;
        String nicId = null;
        boolean forVlan = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("publicIp")) {
                ip = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("instanceId")) {
                String value;
                Node id;
                if (attr.getChildNodes().getLength() <= 0 || (id = attr.getFirstChild()) == null || (value = id.getNodeValue()) == null || (value = value.trim()).length() <= 0) continue;
                instanceId = value;
                continue;
            }
            if (name.equals("allocationId") && attr.hasChildNodes()) {
                ipAddressId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("domain") && attr.hasChildNodes()) {
                forVlan = attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("vpc");
                continue;
            }
            if (!name.equals("networkInterfaceId") || !attr.hasChildNodes()) continue;
            nicId = attr.getFirstChild().getNodeValue().trim();
        }
        if (ip == null) {
            throw new CloudException("Invalid address data, no IP.");
        }
        if (ipAddressId == null) {
            ipAddressId = ip;
        }
        address.setVersion(IPVersion.IPV4);
        address.setAddressType(AddressType.PUBLIC);
        address.setAddress(ip);
        address.setIpAddressId(ipAddressId);
        address.setRegionId(regionId);
        address.setForVlan(forVlan);
        address.setProviderNetworkInterfaceId(nicId);
        if (instanceId != null && this.provider.getEC2Provider().isEucalyptus()) {
            if (instanceId.startsWith("available")) {
                instanceId = null;
            } else {
                int idx = instanceId.indexOf(32);
                if (idx > 0) {
                    instanceId = instanceId.substring(0, idx);
                }
            }
        }
        address.setServerId(instanceId);
        return address;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String instanceId = null;
        String ipAddressId = null;
        String nicId = null;
        String ip = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("publicIp")) {
                ip = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("instanceId")) {
                String value;
                Node id;
                if (attr.getChildNodes().getLength() <= 0 || (id = attr.getFirstChild()) == null || (value = id.getNodeValue()) == null || (value = value.trim()).length() <= 0) continue;
                instanceId = value;
                continue;
            }
            if (name.equals("allocationId") && attr.hasChildNodes()) {
                ipAddressId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("networkInterfaceId") || !attr.hasChildNodes()) continue;
            nicId = attr.getFirstChild().getNodeValue().trim();
        }
        if (ipAddressId == null) {
            ipAddressId = ip;
        }
        if (ipAddressId == null) {
            return null;
        }
        return new ResourceStatus(ipAddressId, (Object)(instanceId == null && nicId == null ? 1 : 0));
    }
}

