/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.network.ELBMethod;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElasticLoadBalancer
implements LoadBalancerSupport {
    private static final Logger logger = Logger.getLogger(ElasticLoadBalancer.class);
    private AWSCloud provider = null;
    private static volatile List<LbAlgorithm> algorithms;
    private static volatile List<IPVersion> versions;
    private static volatile List<LbProtocol> protocols;

    ElasticLoadBalancer(AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataCenters(String toLoadBalancerId, String ... availabilityZoneIds) throws CloudException, InternalException {
        block7: {
            APITrace.begin((CloudProvider)this.provider, (String)"addDataCentersToLB");
            try {
                if (availabilityZoneIds == null || availabilityZoneIds.length <= 0) break block7;
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new CloudException("No valid context is established for this request");
                }
                Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "EnableAvailabilityZonesForLoadBalancer");
                parameters.put("LoadBalancerName", toLoadBalancerId);
                int i = 1;
                for (String zoneId : availabilityZoneIds) {
                    parameters.put("AvailabilityZones.member." + i++, zoneId);
                }
                ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServers(String toLoadBalancerId, String ... instanceIds) throws CloudException, InternalException {
        block8: {
            APITrace.begin((CloudProvider)this.provider, (String)"addServersToLB");
            try {
                if (instanceIds == null || instanceIds.length <= 0) break block8;
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new CloudException("No valid context is established for this request");
                }
                Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "RegisterInstancesWithLoadBalancer");
                LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
                LbListener[] listeners = lb.getListeners();
                if (listeners == null) {
                    throw new CloudException("The load balancer " + toLoadBalancerId + " is improperly configered.");
                }
                parameters.put("LoadBalancerName", toLoadBalancerId);
                int i = 1;
                for (String instanceId : instanceIds) {
                    parameters.put("Instances.member." + i++ + ".InstanceId", instanceId);
                }
                ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    public String create(String name, String description, String addressId, String[] zoneIds, LbListener[] listeners, String[] serverIds) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createLoadBalancer");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "CreateLoadBalancer");
            if (addressId != null) {
                throw new CloudException("AWS does not support assignment of IP addresses to load balancers.");
            }
            name = this.verifyName(name);
            parameters.put("LoadBalancerName", name);
            int i = 1;
            for (LbListener lbListener : listeners) {
                switch (lbListener.getNetworkProtocol()) {
                    case HTTP: {
                        parameters.put("Listeners.member." + i + ".Protocol", "HTTP");
                        break;
                    }
                    case RAW_TCP: {
                        parameters.put("Listeners.member." + i + ".Protocol", "TCP");
                        break;
                    }
                    default: {
                        throw new CloudException("Invalid protocol: " + lbListener.getNetworkProtocol());
                    }
                }
                parameters.put("Listeners.member." + i + ".LoadBalancerPort", String.valueOf(lbListener.getPublicPort()));
                parameters.put("Listeners.member." + i + ".InstancePort", String.valueOf(lbListener.getPrivatePort()));
                ++i;
            }
            i = 1;
            for (String string : zoneIds) {
                parameters.put("AvailabilityZones.member." + i++, string);
            }
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception eC2Exception) {
                logger.error((Object)eC2Exception.getSummary());
                throw new CloudException((Throwable)eC2Exception);
            }
            NodeList blocks = doc.getElementsByTagName("DNSName");
            if (blocks.getLength() > 0) {
                if (serverIds != null && serverIds.length > 0) {
                    this.addServers(name, serverIds);
                }
                String string = name;
                return string;
            }
            throw new CloudException("Unable to create a load balancer and no error message from AWS.");
        }
        finally {
            APITrace.end();
        }
    }

    public LoadBalancerAddressType getAddressType() {
        return LoadBalancerAddressType.DNS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getELBParameters(ProviderContext ctx, String action) throws InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getELBParameters");
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("Action", action);
            parameters.put("SignatureVersion", "2");
            try {
                parameters.put("AWSAccessKeyId", new String(ctx.getAccessPublic(), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            parameters.put("SignatureMethod", "HmacSHA256");
            parameters.put("Timestamp", this.provider.getTimestamp(System.currentTimeMillis(), true));
            parameters.put("Version", this.provider.getElbVersion());
            HashMap<String, String> hashMap = parameters;
            return hashMap;
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxPublicPorts() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalancer getLoadBalancer(String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getLoadBalancer");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DescribeLoadBalancers");
            if (loadBalancerId.length() > 32) {
                LoadBalancer loadBalancer = null;
                return loadBalancer;
            }
            parameters.put("LoadBalancerNames.member.1", loadBalancerId);
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.equals("LoadBalancerNotFound")) {
                    LoadBalancer loadBalancer = null;
                    APITrace.end();
                    return loadBalancer;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LoadBalancerDescriptions");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    LoadBalancer loadBalancer;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (loadBalancer = this.toLoadBalancer(ctx, item)) == null) continue;
                    LoadBalancer loadBalancer2 = loadBalancer;
                    return loadBalancer2;
                }
            }
            LoadBalancer loadBalancer = null;
            return loadBalancer;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<LbAlgorithm> listSupportedAlgorithms() {
        if (algorithms == null) {
            ArrayList<LbAlgorithm> list = new ArrayList<LbAlgorithm>();
            list.add(LbAlgorithm.ROUND_ROBIN);
            algorithms = Collections.unmodifiableList(list);
        }
        return algorithms;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        if (versions == null) {
            ArrayList<IPVersion> tmp = new ArrayList<IPVersion>();
            tmp.add(IPVersion.IPV4);
            tmp.add(IPVersion.IPV6);
            versions = Collections.unmodifiableList(tmp);
        }
        return versions;
    }

    public Iterable<LbProtocol> listSupportedProtocols() {
        if (protocols == null) {
            ArrayList<LbProtocol> list = new ArrayList<LbProtocol>();
            list.add(LbProtocol.HTTP);
            list.add(LbProtocol.RAW_TCP);
            protocols = Collections.unmodifiableList(list);
        }
        return protocols;
    }

    public String getProviderTermForLoadBalancer(Locale locale) {
        return "load balancer";
    }

    public boolean isAddressAssignedByProvider() {
        return true;
    }

    public boolean isDataCenterLimited() {
        return true;
    }

    public boolean requiresListenerOnCreate() {
        return true;
    }

    public boolean requiresServerOnCreate() {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedELB");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            if (!this.provider.getEC2Provider().isAWS()) {
                boolean bl = false;
                return bl;
            }
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DescribeLoadBalancers");
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block17: {
                    block16: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block16;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block17;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                try {
                    throw new CloudException((Throwable)e);
                }
                catch (RuntimeException e2) {
                    logger.error((Object)("Could not check subscription status: " + e2.getMessage()));
                    if (logger.isDebugEnabled()) {
                        e2.printStackTrace();
                    }
                    throw new InternalException((Throwable)e2);
                }
                catch (Error e3) {
                    logger.error((Object)("Could not check subscription status: " + e3.getMessage()));
                    if (logger.isDebugEnabled()) {
                        e3.printStackTrace();
                    }
                    throw new InternalException((Throwable)e3);
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsMonitoring() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listLoadBalancerStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listLoadBalancerStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            if (!this.provider.getEC2Provider().isAWS()) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DescribeLoadBalancers");
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LoadBalancerDescriptions");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (status = this.toStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listLoadBalancers");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            if (!this.provider.getEC2Provider().isAWS()) {
                List<LoadBalancer> list = Collections.emptyList();
                return list;
            }
            ArrayList<LoadBalancer> list = new ArrayList<LoadBalancer>();
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DescribeLoadBalancers");
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("LoadBalancerDescriptions");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    LoadBalancer loadBalancer;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (loadBalancer = this.toLoadBalancer(ctx, item)) == null) continue;
                    list.add(loadBalancer);
                }
            }
            ArrayList<LoadBalancer> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)LoadBalancerSupport.ANY)) {
            return new String[]{"elasticloadbalancing:*"};
        }
        if (action.equals((Object)LoadBalancerSupport.ADD_DATA_CENTERS)) {
            return new String[]{"elasticloadbalancing:EnableAvailabilityZonesForLoadBalancer"};
        }
        if (action.equals((Object)LoadBalancerSupport.ADD_VMS)) {
            return new String[]{"elasticloadbalancing:RegisterInstancesWithLoadBalancer"};
        }
        if (action.equals((Object)LoadBalancerSupport.CREATE_LOAD_BALANCER)) {
            return new String[]{"elasticloadbalancing:CreateLoadBalancer"};
        }
        if (action.equals((Object)LoadBalancerSupport.GET_LOAD_BALANCER) || action.equals((Object)LoadBalancerSupport.LIST_LOAD_BALANCER)) {
            return new String[]{"elasticloadbalancing:DescribeLoadBalancers"};
        }
        if (action.equals((Object)LoadBalancerSupport.REMOVE_DATA_CENTERS)) {
            return new String[]{"elasticloadbalancing:DisableAvailabilityZonesForLoadBalancer"};
        }
        if (action.equals((Object)LoadBalancerSupport.REMOVE_LOAD_BALANCER)) {
            return new String[]{"elasticloadbalancing:DeleteLoadBalancer"};
        }
        if (action.equals((Object)LoadBalancerSupport.REMOVE_VMS)) {
            return new String[]{"elasticloadbalancing:DeregisterInstancesFromLoadBalancer"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeLoadBalancer");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No valid context is established for this request");
            }
            Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DeleteLoadBalancer");
            parameters.put("LoadBalancerName", loadBalancerId);
            ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataCenters(String toLoadBalancerId, String ... availabilityZoneIds) throws CloudException, InternalException {
        block7: {
            APITrace.begin((CloudProvider)this.provider, (String)"removeDataCentersFromLB");
            try {
                if (availabilityZoneIds == null || availabilityZoneIds.length <= 0) break block7;
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new CloudException("No valid context is established for this request");
                }
                Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DisableAvailabilityZonesForLoadBalancer");
                parameters.put("LoadBalancerName", toLoadBalancerId);
                int i = 1;
                for (String zoneId : availabilityZoneIds) {
                    parameters.put("AvailabilityZones.member." + i++, zoneId);
                }
                ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServers(String toLoadBalancerId, String ... instanceIds) throws CloudException, InternalException {
        block7: {
            APITrace.begin((CloudProvider)this.provider, (String)"removeServersFromLB");
            try {
                if (instanceIds == null || instanceIds.length <= 0) break block7;
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new CloudException("No valid context is established for this request");
                }
                Map<String, String> parameters = this.getELBParameters(this.provider.getContext(), "DeregisterInstancesFromLoadBalancer");
                parameters.put("LoadBalancerName", toLoadBalancerId);
                int i = 1;
                for (String instanceId : instanceIds) {
                    parameters.put("Instances.member." + i++ + ".InstanceId", instanceId);
                }
                ELBMethod method = new ELBMethod(this.provider, ctx, parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    private LbListener toListener(Node node) {
        LbListener listener = new LbListener();
        NodeList attrs = node.getChildNodes();
        listener.setAlgorithm(LbAlgorithm.ROUND_ROBIN);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName().toLowerCase();
            if (name.equals("protocol")) {
                listener.setNetworkProtocol(this.toProtocol(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (name.equals("loadbalancerport")) {
                listener.setPublicPort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                continue;
            }
            if (!name.equals("instanceport")) continue;
            listener.setPrivatePort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
        }
        return listener;
    }

    @Nullable
    private LoadBalancer toLoadBalancer(@Nonnull ProviderContext ctx, @Nullable Node node) {
        if (node == null) {
            return null;
        }
        LoadBalancer loadBalancer = new LoadBalancer();
        NodeList attrs = node.getChildNodes();
        loadBalancer.setListeners(new LbListener[0]);
        loadBalancer.setProviderDataCenterIds(new String[0]);
        loadBalancer.setProviderServerIds(new String[0]);
        loadBalancer.setProviderRegionId(ctx.getRegionId());
        loadBalancer.setAddressType(LoadBalancerAddressType.DNS);
        loadBalancer.setCurrentState(LoadBalancerState.ACTIVE);
        loadBalancer.setProviderOwnerId(ctx.getAccountNumber());
        loadBalancer.setPublicPorts(new int[0]);
        loadBalancer.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4, IPVersion.IPV6});
        for (int i = 0; i < attrs.getLength(); ++i) {
            NodeList zones;
            ArrayList<String> ids;
            Node attr = attrs.item(i);
            String name = attr.getNodeName().toLowerCase();
            if (name.equals("listeners")) {
                NodeList listeners;
                ArrayList<Integer> ports = new ArrayList<Integer>();
                if (attr.hasChildNodes() && (listeners = attr.getChildNodes()).getLength() > 0) {
                    ArrayList<LbListener> list = new ArrayList<LbListener>();
                    for (int j = 0; j < listeners.getLength(); ++j) {
                        LbListener l;
                        Node item = listeners.item(j);
                        if (!item.getNodeName().equals("member") || (l = this.toListener(item)) == null) continue;
                        list.add(l);
                        ports.add(l.getPublicPort());
                    }
                    loadBalancer.setListeners(list.toArray(new LbListener[list.size()]));
                }
                int[] p = new int[ports.size()];
                int idx = 0;
                for (Integer port : ports) {
                    p[idx++] = port;
                }
                loadBalancer.setPublicPorts(p);
                continue;
            }
            if (name.equals("loadbalancername")) {
                loadBalancer.setName(attr.getFirstChild().getNodeValue());
                loadBalancer.setDescription(attr.getFirstChild().getNodeValue());
                loadBalancer.setProviderLoadBalancerId(attr.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equals("instances")) {
                NodeList instances;
                if (!attr.hasChildNodes() || (instances = attr.getChildNodes()).getLength() <= 0) continue;
                ids = new ArrayList<String>();
                for (int j = 0; j < instances.getLength(); ++j) {
                    Node instance = instances.item(j);
                    if (!instance.getNodeName().equalsIgnoreCase("member") || !instance.hasChildNodes()) continue;
                    NodeList idList = instance.getChildNodes();
                    for (int k = 0; k < idList.getLength(); ++k) {
                        Node n = idList.item(k);
                        if (!n.getNodeName().equalsIgnoreCase("instanceid")) continue;
                        ids.add(n.getFirstChild().getNodeValue());
                    }
                }
                String[] tmp = new String[ids.size()];
                int j = 0;
                for (String id : ids) {
                    tmp[j++] = id;
                }
                loadBalancer.setProviderServerIds(tmp);
                continue;
            }
            if (name.equals("createdtime")) {
                try {
                    loadBalancer.setCreationTimestamp(this.provider.parseTime(attr.getFirstChild().getNodeValue()));
                }
                catch (CloudException e) {
                    logger.warn((Object)("Unable to parse time: " + e.getMessage()));
                }
                continue;
            }
            if (name.equals("healthcheck")) continue;
            if (name.equals("dnsname")) {
                loadBalancer.setAddress(attr.getFirstChild().getNodeValue());
                continue;
            }
            if (!name.equals("availabilityzones") || !attr.hasChildNodes() || (zones = attr.getChildNodes()).getLength() <= 0) continue;
            ids = new ArrayList();
            for (int j = 0; j < zones.getLength(); ++j) {
                Node zone = zones.item(j);
                if (!zone.hasChildNodes()) continue;
                ids.add(zone.getFirstChild().getNodeValue());
            }
            String[] tmp = new String[ids.size()];
            int j = 0;
            for (String id : ids) {
                tmp[j++] = id;
            }
            loadBalancer.setProviderDataCenterIds(tmp);
        }
        return loadBalancer;
    }

    private LbProtocol toProtocol(String txt) {
        if (txt.equals("HTTP")) {
            return LbProtocol.HTTP;
        }
        return LbProtocol.RAW_TCP;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String lbId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName().toLowerCase();
            if (!name.equals("loadbalancername")) continue;
            lbId = attr.getFirstChild().getNodeValue();
            break;
        }
        if (lbId == null) {
            return null;
        }
        return new ResourceStatus(lbId, (Object)LoadBalancerState.ACTIVE);
    }

    private String verifyName(String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                str.append(c);
                continue;
            }
            if (c != '-' || i <= 0) continue;
            str.append(c);
        }
        name = str.toString();
        if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        while (name.charAt(name.length() - 1) == '-') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

