/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.network.Route53Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.network.DNSZone;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Route53
implements DNSSupport {
    private AWSCloud provider;

    Route53(AWSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    private String generateCallerReference() {
        return UUID.randomUUID().toString();
    }

    @Nonnull
    public DNSRecord addDnsRecord(@Nonnull String providerDnsZoneId, @Nonnull DNSRecordType recordType, @Nonnull String name, @Nonnegative int ttl, String ... values) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addDnsRecord");
        try {
            for (DNSRecord record : this.listDnsRecords(providerDnsZoneId, recordType, name)) {
                if (record == null) continue;
                this.deleteDnsRecords(record);
            }
            Route53Method method = new Route53Method("ChangeResourceRecordSets", this.provider, this.getResourceUrl(providerDnsZoneId));
            StringBuilder xml = new StringBuilder();
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            xml.append("<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2010-10-01/\">");
            xml.append("<ChangeBatch>");
            xml.append("<Changes>");
            xml.append("<Change>");
            xml.append("<Action>CREATE</Action>");
            xml.append("<ResourceRecordSet>");
            xml.append("<Name>");
            xml.append(name);
            xml.append("</Name>");
            xml.append("<Type>");
            xml.append(recordType.toString());
            xml.append("</Type>");
            xml.append("<TTL>");
            xml.append(String.valueOf(ttl));
            xml.append("</TTL>");
            xml.append("<ResourceRecords>");
            if (values.length > 0) {
                for (String value : values) {
                    xml.append("<ResourceRecord>");
                    xml.append("<Value>");
                    xml.append(AWSCloud.escapeXml(value));
                    xml.append("</Value>");
                    xml.append("</ResourceRecord>");
                }
            }
            xml.append("</ResourceRecords>");
            xml.append("</ResourceRecordSet>");
            xml.append("</Change>");
            xml.append("</Changes>");
            xml.append("</ChangeBatch>");
            xml.append("</ChangeResourceRecordSetsRequest>");
            try {
                method.invoke(xml.toString(), false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            for (DNSRecord record : this.listDnsRecords(providerDnsZoneId, recordType, name)) {
                if (record == null) continue;
                DNSRecord dNSRecord = record;
                return dNSRecord;
            }
            throw new CloudException("Unable to identified newly added record");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String createDnsZone(@Nonnull String domainName, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDnsZone");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured for this request");
            }
            Route53Method method = new Route53Method("CreateHostedZone", this.provider, this.getHostedZoneUrl(null));
            StringBuilder xml = new StringBuilder();
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            xml.append("<CreateHostedZoneRequest xmlns=\"https://route53.amazonaws.com/doc/2010-10-01/\">");
            xml.append("<Name>");
            xml.append(domainName);
            xml.append("</Name>");
            xml.append("<CallerReference>");
            xml.append(this.generateCallerReference());
            xml.append("</CallerReference>");
            xml.append("<HostedZoneConfig><Comment>");
            xml.append(AWSCloud.escapeXml(description));
            xml.append("</Comment></HostedZoneConfig>");
            xml.append("</CreateHostedZoneRequest>");
            try {
                doc = method.invoke(xml.toString(), false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            ArrayList<String> ns = new ArrayList<String>();
            NodeList blocks = doc.getElementsByTagName("NameServer");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                ns.add(item.getFirstChild().getNodeValue().trim());
            }
            String[] nameservers = new String[ns.size()];
            ns.toArray(nameservers);
            blocks = doc.getElementsByTagName("HostedZone");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                DNSZone zone = this.toDnsZone(ctx, item, nameservers);
                if (zone == null) continue;
                String string = zone.getProviderDnsZoneId();
                return string;
            }
            throw new CloudException("Unable to identify newly created zone");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteDnsRecords(DNSRecord ... dnsRecords) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteDnsRecords");
        try {
            if (dnsRecords.length < 1) {
                return;
            }
            TreeSet<String> zones = new TreeSet<String>();
            for (DNSRecord record : dnsRecords) {
                zones.add(record.getProviderZoneId());
            }
            for (String zoneId : zones) {
                Route53Method method = new Route53Method("ChangeResourceRecordSets", this.provider, this.getResourceUrl(zoneId));
                StringBuilder xml = new StringBuilder();
                xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
                xml.append("<ChangeResourceRecordSetsRequest xmlns=\"https://route53.amazonaws.com/doc/2010-10-01/\">");
                xml.append("<ChangeBatch>");
                xml.append("<Changes>");
                for (DNSRecord record : dnsRecords) {
                    if (!record.getProviderZoneId().equals(zoneId)) continue;
                    xml.append("<Change>");
                    xml.append("<Action>DELETE</Action>");
                    xml.append("<ResourceRecordSet>");
                    xml.append("<Name>");
                    xml.append(record.getName());
                    xml.append("</Name>");
                    xml.append("<Type>");
                    xml.append(record.getType().toString());
                    xml.append("</Type>");
                    xml.append("<TTL>");
                    xml.append(String.valueOf(record.getTtl()));
                    xml.append("</TTL>");
                    xml.append("<ResourceRecords>");
                    String[] values = record.getValues();
                    if (values != null && values.length > 0) {
                        for (String value : values) {
                            xml.append("<ResourceRecord>");
                            xml.append("<Value>");
                            xml.append(AWSCloud.escapeXml(value));
                            xml.append("</Value>");
                            xml.append("</ResourceRecord>");
                        }
                    }
                    xml.append("</ResourceRecords>");
                    xml.append("</ResourceRecordSet>");
                    xml.append("</Change>");
                }
                xml.append("</Changes>");
                xml.append("</ChangeBatch>");
                xml.append("</ChangeResourceRecordSetsRequest>");
                try {
                    method.invoke(xml.toString(), false);
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDnsZone(@Nonnull String providerDnsZoneId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteDnsZone");
        try {
            Route53Method method = new Route53Method("DeleteHostedZone", this.provider, this.getHostedZoneUrl(providerDnsZoneId));
            try {
                method.invoke(false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public DNSZone getDnsZone(@Nonnull String providerDnsZoneId) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public String getProviderTermForRecord(@Nonnull Locale locale) {
        return "resource";
    }

    @Nonnull
    public String getProviderTermForZone(@Nonnull Locale locale) {
        return "hosted zone";
    }

    @Nonnull
    private String getHostedZoneUrl(@Nullable String zoneId) {
        if (zoneId == null) {
            return "https://route53.amazonaws.com/" + this.provider.getRoute53Version() + "/hostedzone";
        }
        return "https://route53.amazonaws.com/" + this.provider.getRoute53Version() + "/hostedzone/" + zoneId;
    }

    @Nonnull
    private String getResourceUrl(@Nonnull String zoneId) {
        return "https://route53.amazonaws.com/" + this.provider.getRoute53Version() + "/hostedzone/" + zoneId + "/rrset";
    }

    @Nonnull
    public Iterable<DNSRecord> listDnsRecords(@Nonnull String providerDnsZoneId, @Nullable DNSRecordType forType, @Nullable String name) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured for this request");
        }
        final String zoneId = providerDnsZoneId;
        final DNSRecordType type = forType;
        final String nom = name;
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DNSRecord>(){

            public void populate(@Nonnull Jiterator<DNSRecord> iterator) throws CloudException, InternalException {
                Route53.this.populateRecords((Jiterator<DNSRecord>)iterator, zoneId, type, nom);
                Route53.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRecords(@Nonnull Jiterator<DNSRecord> iterator, @Nonnull String providerDnsZoneId, @Nullable DNSRecordType forType, @Nullable String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateRecords");
        try {
            Document doc;
            String url = this.getResourceUrl(providerDnsZoneId);
            if (forType == null) {
                if (name != null) {
                    url = url + "?name=" + name;
                }
            } else {
                url = url + "?type=" + forType.toString();
                if (name != null) {
                    url = url + "&name=" + name;
                }
            }
            Route53Method method = new Route53Method("ListResourceRecordSets", this.provider, url);
            try {
                doc = method.invoke(false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("ResourceRecordSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                DNSRecord record = this.toDnsRecord(providerDnsZoneId, item);
                if (record == null) continue;
                iterator.push((Object)record);
            }
            blocks = doc.getElementsByTagName("IsTruncated");
            if (blocks != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes() && blocks.item(0).getFirstChild().getNodeValue().trim().equalsIgnoreCase("true")) {
                DNSRecordType nextType = null;
                String nextName = null;
                blocks = doc.getElementsByTagName("NextRecordName");
                if (blocks != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes()) {
                    nextName = blocks.item(0).getFirstChild().getNodeValue().trim();
                }
                if ((blocks = doc.getElementsByTagName("NextRecordType")) != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes()) {
                    nextType = DNSRecordType.valueOf((String)blocks.item(0).getFirstChild().getNodeValue().trim());
                }
                if (nextName != null && nextType != null) {
                    this.populateRecords(iterator, providerDnsZoneId, nextType, nextName);
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listDnsZoneStatus() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured for this request");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<ResourceStatus>(){

            public void populate(@Nonnull Jiterator<ResourceStatus> iterator) throws CloudException, InternalException {
                Route53.this.populateZoneStatus((Jiterator<ResourceStatus>)iterator, null);
                Route53.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    public Iterable<DNSZone> listDnsZones() throws CloudException, InternalException {
        final ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured for this request");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DNSZone>(){

            public void populate(@Nonnull Jiterator<DNSZone> iterator) throws CloudException, InternalException {
                Route53.this.populateZones(ctx, (Jiterator<DNSZone>)iterator, null);
                Route53.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)DNSSupport.ANY)) {
            return new String[]{"route53*"};
        }
        if (action.equals((Object)DNSSupport.ADD_RECORD)) {
            return new String[]{"route53ChangeResourceRecordSets"};
        }
        if (action.equals((Object)DNSSupport.CREATE_ZONE)) {
            return new String[]{"route53CreateHostedZone"};
        }
        if (action.equals((Object)DNSSupport.GET_ZONE)) {
            return new String[]{"route53GetHostedZone"};
        }
        if (action.equals((Object)DNSSupport.LIST_ZONE)) {
            return new String[]{"route53ListHostedZones"};
        }
        if (action.equals((Object)DNSSupport.LIST_RECORD)) {
            return new String[]{"route53ListResourceRecordSets"};
        }
        if (action.equals((Object)DNSSupport.REMOVE_RECORD)) {
            return new String[]{"route53ChangeResourceRecordSets"};
        }
        if (action.equals((Object)DNSSupport.REMOVE_ZONE)) {
            return new String[]{"route53DeleteHostedZone"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateZoneStatus(@Nonnull Jiterator<ResourceStatus> iterator, @Nullable String marker) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateZoneStatus");
        try {
            Document doc;
            String url = this.getHostedZoneUrl(null);
            if (marker != null) {
                url = url + "?marker=" + marker;
            }
            Route53Method method = new Route53Method("ListHostedZones", this.provider, url);
            try {
                doc = method.invoke(false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("HostedZone");
            for (int i = 0; i < blocks.getLength(); ++i) {
                ResourceStatus status = this.toStatus(blocks.item(i));
                if (status == null) continue;
                iterator.push((Object)status);
            }
            blocks = doc.getElementsByTagName("IsTruncated");
            if (blocks != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes() && blocks.item(0).getFirstChild().getNodeValue().trim().equalsIgnoreCase("true") && (blocks = doc.getElementsByTagName("NextMarker")) != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes()) {
                this.populateZoneStatus(iterator, blocks.item(0).getFirstChild().getNodeValue().trim());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateZones(@Nonnull ProviderContext ctx, @Nonnull Jiterator<DNSZone> iterator, @Nullable String marker) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateZones");
        try {
            Document doc;
            String url = this.getHostedZoneUrl(null);
            if (marker != null) {
                url = url + "?marker=" + marker;
            }
            Route53Method method = new Route53Method("ListHostedZones", this.provider, url);
            try {
                doc = method.invoke(false);
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("HostedZone");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                DNSZone zone = this.toDnsZone(ctx, item, new String[0]);
                if (zone == null) continue;
                iterator.push((Object)zone);
            }
            blocks = doc.getElementsByTagName("IsTruncated");
            if (blocks != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes() && blocks.item(0).getFirstChild().getNodeValue().trim().equalsIgnoreCase("true") && (blocks = doc.getElementsByTagName("NextMarker")) != null && blocks.getLength() == 1 && blocks.item(0).hasChildNodes()) {
                this.populateZones(ctx, iterator, blocks.item(0).getFirstChild().getNodeValue().trim());
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedRoute53");
        try {
            Route53Method method = new Route53Method("ListHostedZones", this.provider, this.getHostedZoneUrl(null));
            try {
                method.invoke(false);
            }
            catch (EC2Exception e) {
                block8: {
                    if (e.getStatus() == 401 || e.getStatus() == 403) {
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block8;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw new CloudException((Throwable)e);
            }
            boolean bl = true;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private DNSRecord toDnsRecord(@Nonnull String providerDnsZoneId, @Nullable Node xmlRecord) {
        if (xmlRecord == null) {
            return null;
        }
        NodeList attrs = xmlRecord.getChildNodes();
        DNSRecord record = new DNSRecord();
        record.setProviderZoneId(providerDnsZoneId);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("name")) {
                value = attr.getFirstChild().getNodeValue();
                if (value == null) {
                    return null;
                }
                record.setName(value.trim());
                continue;
            }
            if (name.equalsIgnoreCase("type")) {
                value = attr.getFirstChild().getNodeValue();
                if (value == null) continue;
                record.setType(DNSRecordType.valueOf((String)value.trim()));
                continue;
            }
            if (name.equalsIgnoreCase("ttl")) {
                value = attr.getFirstChild().getNodeValue();
                if (value == null) continue;
                record.setTtl(Integer.parseInt(value.trim()));
                continue;
            }
            if (!name.equalsIgnoreCase("resourcerecords")) continue;
            ArrayList<String> data = new ArrayList<String>();
            NodeList configs = attr.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node item = configs.item(j);
                if (!item.getNodeName().equalsIgnoreCase("resourcerecord")) continue;
                NodeList values = item.getChildNodes();
                for (int k = 0; k < values.getLength(); ++k) {
                    String value2;
                    Node r = values.item(k);
                    if (!r.getNodeName().equalsIgnoreCase("value")) continue;
                    String string = value2 = r.hasChildNodes() ? r.getFirstChild().getNodeValue() : null;
                    if (value2 == null) continue;
                    data.add(value2.trim());
                }
            }
            record.setValues(data.toArray(new String[data.size()]));
        }
        return record;
    }

    @Nullable
    private DNSZone toDnsZone(@Nonnull ProviderContext ctx, @Nullable Node xmlZone, @Nullable String[] nameservers) {
        if (xmlZone == null) {
            return null;
        }
        NodeList attrs = xmlZone.getChildNodes();
        DNSZone zone = new DNSZone();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("id")) {
                value = attr.getFirstChild().getNodeValue().trim();
                if (value == null) {
                    return null;
                }
                int idx = value.lastIndexOf(47);
                value = value.substring(idx + 1);
                zone.setProviderDnsZoneId(value);
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                value = attr.getFirstChild().getNodeValue().trim();
                zone.setDomainName(value);
                continue;
            }
            if (!name.equalsIgnoreCase("config")) continue;
            NodeList configs = attr.getChildNodes();
            for (int j = 0; j < configs.getLength(); ++j) {
                Node item = configs.item(j);
                if (!item.getNodeName().equalsIgnoreCase("comment")) continue;
                zone.setDescription(item.getFirstChild().getNodeValue().trim());
            }
        }
        if (zone.getName() == null) {
            zone.setName(zone.getDomainName());
        }
        if (zone.getDescription() == null) {
            zone.setDescription(zone.getName());
        }
        zone.setProviderOwnerId(ctx.getAccountNumber());
        zone.setNameservers(nameservers);
        return zone;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node xmlZone) {
        if (xmlZone == null) {
            return null;
        }
        NodeList attrs = xmlZone.getChildNodes();
        String zoneId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (!name.equalsIgnoreCase("id")) continue;
            String value = attr.getFirstChild().getNodeValue().trim();
            if (value == null) {
                return null;
            }
            int idx = value.lastIndexOf(47);
            zoneId = value = value.substring(idx + 1);
            break;
        }
        if (zoneId == null) {
            return null;
        }
        return new ResourceStatus(zoneId, (Object)true);
    }
}

