/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.DNSSupport;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Route53Method {
    private static final Logger logger = AWSCloud.getLogger(Route53Method.class);
    public static final String R53_PREFIX = "route53";
    public static final String CREATE_HOSTED_ZONE = "CreateHostedZone";
    public static final String DELETE_HOSTED_ZONE = "DeleteHostedZone";
    public static final String GET_HOSTED_ZONE = "GetHostedZone";
    public static final String LIST_HOSTED_ZONES = "ListHostedZones";
    public static final String CHANGE_RESOURCE_RECORD_SETS = "ChangeResourceRecordSets";
    public static final String GET_CHANGE = "GetChange";
    public static final String LIST_RESOURCE_RECORD_SETS = "ListResourceRecordSets";
    private int attempts = 0;
    private String dateString = null;
    private String method = null;
    private String operation = null;
    private AWSCloud provider = null;
    private String signature = null;
    private String url = null;

    @Nonnull
    public static ServiceAction[] asRoute53ServiceAction(@Nonnull String action) {
        if (action.equals(CREATE_HOSTED_ZONE)) {
            return new ServiceAction[]{DNSSupport.CREATE_ZONE};
        }
        if (action.equals(DELETE_HOSTED_ZONE)) {
            return new ServiceAction[]{DNSSupport.REMOVE_ZONE};
        }
        if (action.equals(GET_HOSTED_ZONE)) {
            return new ServiceAction[]{DNSSupport.GET_ZONE};
        }
        if (action.equals(LIST_HOSTED_ZONES)) {
            return new ServiceAction[]{DNSSupport.LIST_ZONE};
        }
        if (action.equals(CHANGE_RESOURCE_RECORD_SETS)) {
            return new ServiceAction[]{DNSSupport.ADD_RECORD, DNSSupport.REMOVE_RECORD};
        }
        if (action.equals(GET_CHANGE)) {
            return new ServiceAction[0];
        }
        if (action.equals(LIST_RESOURCE_RECORD_SETS)) {
            return new ServiceAction[]{DNSSupport.LIST_RECORD};
        }
        return new ServiceAction[0];
    }

    public Route53Method(String operation, AWSCloud provider, String url) throws InternalException {
        this.url = url;
        this.provider = provider;
        this.operation = operation;
        this.method = this.translateMethod(operation);
        this.dateString = this.getTimestamp(System.currentTimeMillis());
        ProviderContext ctx = provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        try {
            this.signature = provider.signAWS3(new String(ctx.getAccessPublic(), "utf-8"), ctx.getAccessPrivate(), this.dateString);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String getTimestamp(long timestamp) {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return fmt.format(new Date(timestamp));
    }

    private Document delete(boolean debug) throws EC2Exception, CloudException, InternalException {
        return this.invoke((HttpRequestBase)new HttpDelete(this.url), debug);
    }

    private Document get(boolean debug) throws EC2Exception, CloudException, InternalException {
        return this.invoke((HttpRequestBase)new HttpGet(this.url), debug);
    }

    private Document post(String body, boolean debug) throws EC2Exception, CloudException, InternalException {
        HttpPost post = new HttpPost(this.url);
        if (body != null) {
            try {
                post.setEntity((HttpEntity)new StringEntity(body, "text/xml", "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return this.invoke((HttpRequestBase)post, debug);
    }

    public Document invoke(String body, boolean debug) throws EC2Exception, CloudException, InternalException {
        if (this.method.equals("GET")) {
            return this.get(debug);
        }
        if (this.method.equals("DELETE")) {
            return this.delete(debug);
        }
        if (this.method.equals("POST")) {
            return this.post(body, debug);
        }
        throw new InternalException("No such method: " + this.method);
    }

    public Document invoke(boolean debug) throws EC2Exception, CloudException, InternalException {
        if (this.method.equals("GET")) {
            return this.get(debug);
        }
        if (this.method.equals("DELETE")) {
            return this.delete(debug);
        }
        if (this.method.equals("POST")) {
            return this.post(null, debug);
        }
        throw new InternalException("No such method: " + this.method);
    }

    @Nonnull
    protected HttpClient getClient() throws InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        boolean ssl = this.url.startsWith("https");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document invoke(HttpRequestBase method, boolean debug) throws EC2Exception, CloudException, InternalException {
        int status;
        HttpResponse response;
        block70: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Talking to server at " + this.url));
            }
            HttpClient client = this.getClient();
            ++this.attempts;
            method.addHeader("Content-Type", "text/xml");
            method.addHeader("x-amz-date", this.dateString);
            method.addHeader("Date", this.dateString);
            method.addHeader("X-Amzn-Authorization", this.signature);
            try {
                APITrace.trace((CloudProvider)this.provider, (String)this.operation);
                response = client.execute((HttpUriRequest)method);
                status = response.getStatusLine().getStatusCode();
            }
            catch (IOException e) {
                logger.error((Object)e);
                e.printStackTrace();
                throw new InternalException((Throwable)e);
            }
            if (status == 200 || status == 202 || status == 201) {
                Document e2;
                InputStream input;
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new CloudException("No response body was specified");
                }
                try {
                    input = entity.getContent();
                }
                catch (IOException e2) {
                    throw new CloudException((Throwable)e2);
                }
                try {
                    e2 = this.parseResponse(input, debug);
                }
                catch (Throwable throwable) {
                    try {
                        input.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        logger.error((Object)e3);
                        e3.printStackTrace();
                        throw new CloudException((Throwable)e3);
                    }
                }
                input.close();
                return e2;
            }
            if (status != 403) break block70;
            String msg = "API Access Denied (403)";
            try {
                InputStream input;
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new CloudException("No response body was specified");
                }
                try {
                    input = entity.getContent();
                }
                catch (IOException e) {
                    throw new CloudException((Throwable)e);
                }
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(input));
                    StringBuilder sb = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        sb.append(line);
                        sb.append("\n");
                    }
                    try {
                        Document doc = this.parseResponse(sb.toString(), debug);
                        if (doc != null) {
                            NodeList blocks = doc.getElementsByTagName("Error");
                            String code = null;
                            String message = null;
                            String requestId = null;
                            if (blocks.getLength() > 0) {
                                Node error = blocks.item(0);
                                NodeList attrs = error.getChildNodes();
                                for (int i = 0; i < attrs.getLength(); ++i) {
                                    Node attr = attrs.item(i);
                                    if (attr.getNodeName().equals("Code")) {
                                        code = attr.getFirstChild().getNodeValue().trim();
                                        continue;
                                    }
                                    if (!attr.getNodeName().equals("Message")) continue;
                                    message = attr.getFirstChild().getNodeValue().trim();
                                }
                            }
                            if ((blocks = doc.getElementsByTagName("RequestID")).getLength() > 0) {
                                Node id = blocks.item(0);
                                requestId = id.getFirstChild().getNodeValue().trim();
                            }
                            if (message == null) {
                                throw new CloudException("Unable to identify error condition: " + status + "/" + requestId + "/" + code);
                            }
                            throw new EC2Exception(status, requestId, code, message);
                        }
                    }
                    catch (RuntimeException ignore) {
                    }
                    catch (Error ignore) {
                        // empty catch block
                    }
                    msg = msg + ": " + sb.toString().trim().replaceAll("\n", " / ");
                }
                finally {
                    input.close();
                }
            }
            catch (IOException ignore) {
            }
            catch (RuntimeException ignore) {
            }
            catch (Error ignore) {
                // empty catch block
            }
            throw new CloudException(msg);
        }
        if (status == 503 || status == 500) {
            if (this.attempts >= 5) {
                String msg;
                if (status == 503) {
                    msg = "Cloud service is currently unavailable.";
                } else {
                    msg = "The cloud service encountered a server error while processing your request.";
                    try {
                        InputStream input;
                        HttpEntity entity = response.getEntity();
                        if (entity == null) {
                            throw new CloudException("No response body was specified");
                        }
                        try {
                            input = entity.getContent();
                        }
                        catch (IOException e) {
                            throw new CloudException((Throwable)e);
                        }
                        try {
                            String line;
                            BufferedReader in = new BufferedReader(new InputStreamReader(input));
                            StringBuilder sb = new StringBuilder();
                            while ((line = in.readLine()) != null) {
                                sb.append(line);
                                sb.append("\n");
                            }
                            msg = msg + "Response from server was:\n" + sb.toString();
                        }
                        finally {
                            input.close();
                        }
                    }
                    catch (IOException ignore) {
                    }
                    catch (RuntimeException ignore) {
                    }
                    catch (Error ignore) {
                        // empty catch block
                    }
                }
                logger.error((Object)msg);
                throw new CloudException(msg);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                Document ignore = this.invoke((HttpRequestBase)method.getClass().newInstance(), false);
                return ignore;
            }
            catch (Throwable t) {
                throw new InternalException(t);
            }
        }
        try {
            Document doc;
            InputStream input;
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new CloudException("No response body was specified");
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                throw new CloudException((Throwable)e);
            }
            try {
                doc = this.parseResponse(input, debug);
            }
            finally {
                input.close();
            }
            if (doc != null) {
                NodeList blocks = doc.getElementsByTagName("Error");
                String code = null;
                String message = null;
                String requestId = null;
                if (blocks.getLength() > 0) {
                    Node error = blocks.item(0);
                    NodeList attrs = error.getChildNodes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        if (attr.getNodeName().equals("Code")) {
                            code = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!attr.getNodeName().equals("Message")) continue;
                        message = attr.getFirstChild().getNodeValue().trim();
                    }
                }
                if ((blocks = doc.getElementsByTagName("RequestID")).getLength() > 0) {
                    Node id = blocks.item(0);
                    requestId = id.getFirstChild().getNodeValue().trim();
                }
                if (message == null) {
                    throw new CloudException("Unable to identify error condition: " + status + "/" + requestId + "/" + code);
                }
                throw new EC2Exception(status, requestId, code, message);
            }
            throw new CloudException("Unable to parse error.");
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        finally {
            logger.debug((Object)"Done");
        }
    }

    private Document parseResponse(String responseBody, boolean debug) throws CloudException, InternalException {
        try {
            if (debug) {
                System.out.println(responseBody);
            }
            return XMLParser.parse((InputStream)new ByteArrayInputStream(responseBody.getBytes()));
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CloudException((Throwable)e);
        }
    }

    private Document parseResponse(InputStream responseBodyAsStream, boolean debug) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            return this.parseResponse(sb.toString(), debug);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
    }

    private String translateMethod(String operation) {
        if (operation.equalsIgnoreCase(CREATE_HOSTED_ZONE)) {
            return "POST";
        }
        if (operation.equalsIgnoreCase(GET_HOSTED_ZONE) || operation.equalsIgnoreCase(LIST_HOSTED_ZONES)) {
            return "GET";
        }
        if (operation.equalsIgnoreCase(DELETE_HOSTED_ZONE)) {
            return "DELETE";
        }
        if (operation.equalsIgnoreCase(CHANGE_RESOURCE_RECORD_SETS)) {
            return "POST";
        }
        if (operation.equalsIgnoreCase(LIST_RESOURCE_RECORD_SETS)) {
            return "GET";
        }
        if (operation.equalsIgnoreCase(GET_CHANGE)) {
            return "GET";
        }
        return "POST";
    }
}

