/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityGroup
implements FirewallSupport {
    private static final Logger logger = AWSCloud.getLogger(SecurityGroup.class);
    private AWSCloud provider = null;

    private static boolean isIP(@Nonnull String test) {
        String[] parts = test.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                Integer x = Integer.parseInt(part);
                if (x >= 0 && x <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    SecurityGroup(AWSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    public String authorize(@Nonnull String securityGroupId, @Nonnull String cidr, @Nonnull Protocol protocol, int startPort, int endPort) throws CloudException, InternalException {
        return this.authorize(securityGroupId, Direction.INGRESS, Permission.ALLOW, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)securityGroupId), startPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, Permission.ALLOW, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, Permission.ALLOW, RuleTarget.getGlobal((String)firewallId), protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, permission, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, permission, RuleTarget.getGlobal((String)firewallId), protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, @Nonnull RuleTarget destination, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, permission, RuleTarget.getCIDR((String)cidr), protocol, destination, beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, permission, destination, protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort, @Nonnegative int precedence) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"authorizeSecurityGroupRule");
        try {
            Document doc;
            boolean group;
            if (Permission.DENY.equals((Object)permission)) {
                throw new OperationNotSupportedException("AWS does not support DENY rules");
            }
            Firewall fw = this.getFirewall(firewallId);
            if (fw == null) {
                throw new CloudException("No such firewall: " + firewallId);
            }
            if (direction.equals((Object)Direction.EGRESS) && fw.getProviderVlanId() == null) {
                throw new OperationNotSupportedException("AWS does not support EGRESS rules for non-VPC security groups");
            }
            String action = direction.equals((Object)Direction.INGRESS) ? "AuthorizeSecurityGroupIngress" : "AuthorizeSecurityGroupEgress";
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), action);
            String targetGroupId = null;
            if (direction.equals((Object)Direction.INGRESS)) {
                group = sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (group) {
                    targetGroupId = sourceEndpoint.getProviderFirewallId();
                }
            } else {
                group = destinationEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (group) {
                    targetGroupId = destinationEndpoint.getProviderFirewallId();
                }
            }
            if (this.provider.getEC2Provider().isEucalyptus()) {
                parameters.put("GroupName", firewallId);
                parameters.put("IpProtocol", protocol.name().toLowerCase());
                parameters.put("FromPort", String.valueOf(beginPort));
                parameters.put("ToPort", endPort == -1 ? String.valueOf(beginPort) : String.valueOf(endPort));
                if (group) {
                    parameters.put("GroupName", targetGroupId);
                } else {
                    parameters.put("CidrIp", sourceEndpoint.getCidr());
                }
            } else {
                parameters.put("GroupId", firewallId);
                parameters.put("IpPermissions.1.IpProtocol", protocol.name().toLowerCase());
                parameters.put("IpPermissions.1.FromPort", String.valueOf(beginPort));
                parameters.put("IpPermissions.1.ToPort", endPort == -1 ? String.valueOf(beginPort) : String.valueOf(endPort));
                if (group) {
                    if (targetGroupId.startsWith("sg-")) {
                        parameters.put("IpPermissions.1.Groups.1.GroupId", targetGroupId);
                    } else {
                        parameters.put("IpPermissions.1.Groups.1.GroupName", targetGroupId);
                    }
                } else if (direction.equals((Object)Direction.INGRESS)) {
                    parameters.put("IpPermissions.1.IpRanges.1.CidrIp", sourceEndpoint.getCidr());
                } else {
                    parameters.put("IpPermissions.1.IpRanges.1.CidrIp", destinationEndpoint.getCidr());
                }
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code == null || !code.equals("InvalidPermission.Duplicate") || direction.equals((Object)Direction.INGRESS)) {
                    // empty if block
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Failed to authorize security group rule without explanation.");
            }
            String string = FirewallRule.getInstance(null, (String)firewallId, (RuleTarget)sourceEndpoint, (Direction)direction, (Protocol)protocol, (Permission)permission, (RuleTarget)destinationEndpoint, (int)beginPort, (int)endPort).getProviderRuleId();
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createSecurityGroup");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateSecurityGroup");
            name = this.getUniqueName(name);
            parameters.put("GroupName", name);
            parameters.put("GroupDescription", description);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            if (this.provider.getEC2Provider().isEucalyptus()) {
                String string = name;
                return string;
            }
            NodeList blocks = doc.getElementsByTagName("groupId");
            if (blocks.getLength() > 0) {
                String string = blocks.item(0).getFirstChild().getNodeValue().trim();
                return string;
            }
            throw new CloudException("Failed to create security group without explanation.");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String createInVLAN(@Nonnull String name, @Nonnull String description, @Nonnull String providerVlanId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createSecurityGroupInVLAN");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateSecurityGroup");
            name = this.getUniqueName(name);
            parameters.put("GroupName", name);
            parameters.put("GroupDescription", description);
            parameters.put("VpcId", providerVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("groupId");
            if (blocks.getLength() > 0) {
                String string = blocks.item(0).getFirstChild().getNodeValue().trim();
                return string;
            }
            throw new CloudException("Failed to create security group without explanation.");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull String securityGroupId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteSecurityGroup");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteSecurityGroup");
            if (this.provider.getEC2Provider().isEucalyptus()) {
                parameters.put("GroupName", securityGroupId);
            } else {
                parameters.put("GroupId", securityGroupId);
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("return");
            if (blocks.getLength() > 0 && !blocks.item(0).getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                throw new CloudException("Failed to delete security group without explanation.");
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Firewall getFirewall(@Nonnull String securityGroupId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getFirewall");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSecurityGroups");
            if (this.provider.getEC2Provider().isEucalyptus()) {
                parameters.put("GroupName.1", securityGroupId);
            } else {
                parameters.put("GroupId.1", securityGroupId);
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.startsWith("InvalidGroup")) {
                    Firewall firewall = null;
                    APITrace.end();
                    return firewall;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("securityGroupInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Firewall firewall;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (firewall = this.toFirewall(ctx, item)) == null || !securityGroupId.equals(firewall.getProviderFirewallId())) continue;
                    Firewall firewall2 = firewall;
                    return firewall2;
                }
            }
            Firewall firewall = null;
            return firewall;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String securityGroupId) throws InternalException, CloudException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"getSecurityGroupRules");
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSecurityGroups");
        ArrayList<FirewallRule> list = new ArrayList<FirewallRule>();
        if (this.provider.getEC2Provider().isEucalyptus()) {
            parameters.put("GroupName.1", securityGroupId);
        } else {
            parameters.put("GroupId.1", securityGroupId);
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidGroup")) {
                List<FirewallRule> list2 = Collections.emptyList();
                APITrace.end();
                return list2;
            }
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = doc.getElementsByTagName("securityGroupInfo");
        for (int i = 0; i < blocks.getLength(); ++i) {
            NodeList items = blocks.item(i).getChildNodes();
            for (int j = 0; j < items.getLength(); ++j) {
                Node item = items.item(j);
                if (!item.getNodeName().equals("item")) continue;
                NodeList attrs = item.getChildNodes();
                for (int k = 0; k < attrs.getLength(); ++k) {
                    Node sub;
                    int l;
                    NodeList subList;
                    Node attr = attrs.item(k);
                    if (attr.getNodeName().equals("ipPermissions")) {
                        subList = attr.getChildNodes();
                        for (l = 0; l < subList.getLength(); ++l) {
                            sub = subList.item(l);
                            if (!sub.getNodeName().equals("item")) continue;
                            list.addAll(this.toFirewallRules(securityGroupId, sub, Direction.INGRESS));
                        }
                        continue;
                    }
                    if (!attr.getNodeName().equals("ipPermissionsEgress")) continue;
                    subList = attr.getChildNodes();
                    for (l = 0; l < subList.getLength(); ++l) {
                        sub = subList.item(l);
                        if (!sub.getNodeName().equals("item")) continue;
                        list.addAll(this.toFirewallRules(securityGroupId, sub, Direction.EGRESS));
                    }
                }
            }
        }
        ArrayList<FirewallRule> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement identifyPrecedenceRequirement(boolean inVlan) throws InternalException, CloudException {
        return Requirement.NONE;
    }

    @Nonnull
    private String getUniqueName(@Nonnull String name) throws InternalException, CloudException {
        boolean found;
        String baseName;
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_' || c == '-') {
                str.append(c);
                continue;
            }
            if (i == 0 && Character.isDigit(c)) {
                str.append("e-");
                str.append(c);
                continue;
            }
            if (i == 0 && Character.isLetter(c)) {
                str.append(c);
                continue;
            }
            if (i <= 0 || !Character.isLetterOrDigit(c)) continue;
            str.append(c);
        }
        if (str.length() < 1) {
            return "new-group";
        }
        String withName = baseName = str.toString();
        int count = 1;
        int c = 97;
        block1: do {
            found = false;
            for (Firewall fw : this.list()) {
                String id = fw.getProviderFirewallId();
                if (id == null || !id.equals(withName)) continue;
                found = true;
                withName = count == 1 ? baseName + "-" + String.valueOf((char)c) : baseName + String.valueOf((char)c);
                if (c == 122) {
                    baseName = count == 1 ? baseName + "-a" : baseName + "a";
                    c = 97;
                    if (++count <= 10) continue block1;
                    throw new CloudException("Could not generate a unique firewall name from " + baseName);
                }
                c = (char)(c + '\u0001');
                continue block1;
            }
        } while (found);
        return withName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedSecurityGroup");
        try {
            EC2ComputeServices svc = this.provider.getComputeServices();
            if (svc == null) {
                boolean bl = false;
                return bl;
            }
            VirtualMachineSupport support = svc.getVirtualMachineSupport();
            boolean bl = support != null && support.isSubscribed();
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isZeroPrecedenceHighest() throws InternalException, CloudException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSecurityGroups");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSecurityGroups");
            ArrayList<Firewall> list = new ArrayList<Firewall>();
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("securityGroupInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Firewall firewall;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (firewall = this.toFirewall(ctx, item)) == null) continue;
                    list.add(firewall);
                }
            }
            ArrayList<Firewall> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSecurityGroupStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context has been established for this request");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSecurityGroups");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("securityGroupInfo");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("item") || (status = this.toStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        return Collections.singletonList(RuleTargetType.GLOBAL);
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            ArrayList<Direction> list = new ArrayList<Direction>();
            list.add(Direction.EGRESS);
            list.add(Direction.INGRESS);
            return list;
        }
        return Collections.singletonList(Direction.INGRESS);
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        return Collections.singletonList(Permission.ALLOW);
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        ArrayList<RuleTargetType> types = new ArrayList<RuleTargetType>();
        types.add(RuleTargetType.CIDR);
        types.add(RuleTargetType.GLOBAL);
        return types;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)FirewallSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)FirewallSupport.AUTHORIZE)) {
            return new String[]{"ec2:AuthorizeSecurityGroupIngress", "ec2:AuthorizeSecurityGroupEgress"};
        }
        if (action.equals((Object)FirewallSupport.CREATE_FIREWALL)) {
            return new String[]{"ec2:CreateSecurityGroup"};
        }
        if (action.equals((Object)FirewallSupport.GET_FIREWALL) || action.equals((Object)FirewallSupport.LIST_FIREWALL)) {
            return new String[]{"ec2:DescribeSecurityGroups"};
        }
        if (action.equals((Object)FirewallSupport.REMOVE_FIREWALL)) {
            return new String[]{"ec2:DeleteSecurityGroup"};
        }
        if (action.equals((Object)FirewallSupport.REVOKE)) {
            return new String[]{"ec2:RevokeSecurityGroupIngress", "ec2:RevokeSecurityGroupEgress"};
        }
        return new String[0];
    }

    public void revoke(@Nonnull String securityGroupId, @Nonnull String cidr, @Nonnull Protocol protocol, int startPort, int endPort) throws CloudException, InternalException {
        this.revoke(securityGroupId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)securityGroupId), startPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, permission, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        FirewallRule rule = null;
        block0: for (Firewall f : this.list()) {
            String fwId = f.getProviderFirewallId();
            if (fwId == null) continue;
            for (FirewallRule r : this.getRules(fwId)) {
                if (!providerFirewallRuleId.equals(r.getProviderRuleId())) continue;
                rule = r;
                continue block0;
            }
        }
        if (rule == null) {
            throw new CloudException("Unable to parse rule ID: " + providerFirewallRuleId);
        }
        this.revoke(rule.getFirewallId(), rule.getDirection(), rule.getPermission(), rule.getSourceEndpoint(), rule.getProtocol(), rule.getDestinationEndpoint(), rule.getStartPort(), rule.getEndPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Firewall.revoke");
        try {
            Document doc;
            boolean group;
            if (Permission.DENY.equals((Object)permission)) {
                throw new OperationNotSupportedException("AWS does not support DENY rules");
            }
            Firewall fw = this.getFirewall(firewallId);
            if (fw == null) {
                throw new CloudException("No such firewall: " + firewallId);
            }
            if (direction.equals((Object)Direction.EGRESS) && fw.getProviderVlanId() == null) {
                throw new OperationNotSupportedException("AWS does not support EGRESS rules for non-VPC security groups");
            }
            String action = direction.equals((Object)Direction.INGRESS) ? "RevokeSecurityGroupIngress" : "RevokeSecurityGroupEgress";
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), action);
            String targetGroupId = null;
            if (direction.equals((Object)Direction.INGRESS)) {
                group = sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (group) {
                    targetGroupId = sourceEndpoint.getProviderFirewallId();
                }
            } else {
                group = destinationEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (group) {
                    targetGroupId = destinationEndpoint.getProviderFirewallId();
                }
            }
            if (this.provider.getEC2Provider().isEucalyptus()) {
                parameters.put("GroupName", firewallId);
                parameters.put("IpProtocol", protocol.name().toLowerCase());
                parameters.put("FromPort", String.valueOf(beginPort));
                parameters.put("ToPort", endPort == -1 ? String.valueOf(beginPort) : String.valueOf(endPort));
                if (group) {
                    parameters.put("GroupName", targetGroupId);
                } else {
                    parameters.put("CidrIp", sourceEndpoint.getCidr());
                }
            } else {
                parameters.put("GroupId", firewallId);
                parameters.put("IpPermissions.1.IpProtocol", protocol.name().toLowerCase());
                parameters.put("IpPermissions.1.FromPort", String.valueOf(beginPort));
                parameters.put("IpPermissions.1.ToPort", endPort == -1 ? String.valueOf(beginPort) : String.valueOf(endPort));
                if (group) {
                    if (targetGroupId.startsWith("sg-")) {
                        parameters.put("IpPermissions.1.Groups.1.GroupId", targetGroupId);
                    } else {
                        parameters.put("IpPermissions.1.Groups.1.GroupName", targetGroupId);
                    }
                } else if (direction.equals((Object)Direction.INGRESS)) {
                    parameters.put("IpPermissions.1.IpRanges.1.CidrIp", sourceEndpoint.getCidr());
                } else {
                    parameters.put("IpPermissions.1.IpRanges.1.CidrIp", destinationEndpoint.getCidr());
                }
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            method.checkSuccess(doc.getElementsByTagName("return"));
        }
        finally {
            APITrace.end();
        }
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, @Nonnull RuleTarget destination, int beginPort, int endPort) throws CloudException, InternalException {
        RuleTarget source = cidr.startsWith("sg-") ? RuleTarget.getGlobal((String)cidr) : RuleTarget.getCIDR((String)cidr);
        if (direction.equals((Object)Direction.INGRESS)) {
            this.revoke(firewallId, direction, permission, source, protocol, destination, beginPort, endPort);
        } else {
            this.revoke(firewallId, direction, permission, destination, protocol, source, beginPort, endPort);
        }
    }

    public boolean supportsFirewallSources() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return !(!permission.equals((Object)Permission.ALLOW) || inVlan && this.provider.getEC2Provider().isEucalyptus() || !inVlan && !direction.equals((Object)Direction.INGRESS));
    }

    @Nullable
    private Firewall toFirewall(@Nonnull ProviderContext ctx, @Nullable Node node) {
        if (node == null) {
            return null;
        }
        String fwName = null;
        String fwId = null;
        String fwDesc = null;
        NodeList attrs = node.getChildNodes();
        Firewall firewall = new Firewall();
        String regionId = ctx.getRegionId();
        String vpcId = null;
        if (regionId == null) {
            return null;
        }
        firewall.setRegionId(regionId);
        firewall.setAvailable(true);
        firewall.setActive(true);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("groupName")) {
                fwName = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("groupDescription")) {
                fwDesc = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("groupId")) {
                fwId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("vpcId") || !attr.hasChildNodes() || (vpcId = attr.getFirstChild().getNodeValue()) == null) continue;
            vpcId = vpcId.trim();
        }
        if (fwId == null) {
            if (fwName == null) {
                return null;
            }
            fwId = fwName;
        }
        if (fwName == null) {
            fwName = fwId;
        }
        firewall.setProviderFirewallId(fwId);
        firewall.setName(fwName);
        if (fwDesc == null) {
            fwDesc = fwName;
        }
        firewall.setDescription(fwDesc);
        if (vpcId != null) {
            firewall.setName(firewall.getName() + " (VPC " + vpcId + ")");
            firewall.setProviderVlanId(vpcId);
        }
        return firewall;
    }

    @Nonnull
    private Collection<FirewallRule> toFirewallRules(@Nonnull String securityGroupId, @Nullable Node node, @Nonnull Direction direction) {
        ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
        if (node == null) {
            return rules;
        }
        ArrayList<String> cidrs = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        NodeList attrs = node.getChildNodes();
        int startPort = -2;
        int endPort = -2;
        Protocol protocol = Protocol.TCP;
        for (int i = 0; i < attrs.getLength(); ++i) {
            NodeList targets;
            Node child;
            int j;
            NodeList children;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("ipProtocol")) {
                String val = attr.getFirstChild().getNodeValue().trim();
                if (!val.equals("") && !val.equals("-1")) {
                    protocol = Protocol.valueOf((String)attr.getFirstChild().getNodeValue().trim().toUpperCase());
                    continue;
                }
                protocol = Protocol.ICMP;
                continue;
            }
            if (name.equals("fromPort")) {
                startPort = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("toPort")) {
                endPort = Integer.parseInt(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("groups") && attr.hasChildNodes()) {
                children = attr.getChildNodes();
                for (j = 0; j < children.getLength(); ++j) {
                    child = children.item(j);
                    if (!child.getNodeName().equals("item") || !child.hasChildNodes()) continue;
                    targets = child.getChildNodes();
                    String groupId = null;
                    String groupName = null;
                    for (int k = 0; k < targets.getLength(); ++k) {
                        Node group = targets.item(k);
                        if (group.getNodeName().equals("groupId")) {
                            groupId = group.getFirstChild().getNodeValue().trim();
                        }
                        if (!group.getNodeName().equals("groupName")) continue;
                        groupName = group.getFirstChild().getNodeValue().trim();
                    }
                    if (groupId != null) {
                        groups.add(groupId);
                        continue;
                    }
                    if (groupName == null) continue;
                    groups.add(groupName);
                }
                continue;
            }
            if (!name.equals("ipRanges") || !attr.hasChildNodes()) continue;
            children = attr.getChildNodes();
            for (j = 0; j < children.getLength(); ++j) {
                child = children.item(j);
                if (!child.getNodeName().equals("item") || !child.hasChildNodes()) continue;
                targets = child.getChildNodes();
                for (int k = 0; k < targets.getLength(); ++k) {
                    Node cidr = targets.item(k);
                    if (!cidr.getNodeName().equals("cidrIp")) continue;
                    cidrs.add(cidr.getFirstChild().getNodeValue());
                }
            }
        }
        for (String gid : groups) {
            rules.add(FirewallRule.getInstance(null, (String)securityGroupId, (RuleTarget)RuleTarget.getGlobal((String)gid), (Direction)direction, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getGlobal((String)securityGroupId), (int)startPort, (int)endPort));
        }
        for (String cidr : cidrs) {
            rules.add(FirewallRule.getInstance(null, (String)securityGroupId, (RuleTarget)RuleTarget.getCIDR((String)cidr), (Direction)direction, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getGlobal((String)securityGroupId), (int)startPort, (int)endPort));
        }
        return rules;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String fwId = null;
        String fwName = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("groupName")) {
                fwName = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("groupId")) continue;
            fwId = attr.getFirstChild().getNodeValue().trim();
        }
        if (fwId == null && fwName == null) {
            return null;
        }
        if (fwId == null) {
            fwId = fwName;
        }
        return new ResourceStatus(fwId, (Object)true);
    }
}

