/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2ComputeServices;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.aws.network.EC2NetworkServices;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NICState;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.Route;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.SubnetState;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VPC
implements VLANSupport {
    private static final Logger logger = Logger.getLogger(VPC.class);
    private AWSCloud provider;

    VPC(AWSCloud provider) {
        this.provider = provider;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRoutingTableToSubnet(@Nonnull String subnetId, @Nonnull String routingTableId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"assignRoutingTableToSubnet");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AssociateRouteTable");
            parameters.put("SubnetId", subnetId);
            parameters.put("RouteTableId", routingTableId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String getAssociationId(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getAssociationIdForVLAN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeRouteTables");
            parameters.put("Filter.1.Name", "association.main");
            parameters.put("Filter.1.Value.1", "true");
            parameters.put("Filter.2.Name", "vpc-id");
            parameters.put("Filter.2.Value.1", vlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("associationSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node set = blocks.item(i);
                NodeList items = set.getChildNodes();
                for (int i1 = 0; i1 < items.getLength(); ++i1) {
                    Node item = items.item(i1);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes()) continue;
                    NodeList attrs = item.getChildNodes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node attr = attrs.item(j);
                        if (!attr.getNodeName().equalsIgnoreCase("routeTableAssociationId") || !attr.hasChildNodes()) continue;
                        String string = attr.getFirstChild().getNodeValue().trim();
                        return string;
                    }
                }
            }
            throw new CloudException("Could not identify the main routing table for " + vlanId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignRoutingTableToVlan(@Nonnull String vlanId, @Nonnull String routingTableId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"assignRoutingTableToVLAN");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            String associationId = this.getAssociationId(vlanId);
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "ReplaceRouteTableAssociation");
            parameters.put("AssociationId", associationId);
            parameters.put("RouteTableId", routingTableId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachNetworkInterface(@Nonnull String nicId, @Nonnull String vmId, int index) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"attachNICToVM");
        try {
            if (index < 1) {
                index = 1;
                for (NetworkInterface nic : this.listNetworkInterfacesForVM(vmId)) {
                    if (nic == null) continue;
                    ++index;
                }
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AttachNetworkInterface");
            parameters.put("NetworkInterfaceId", nicId);
            parameters.put("InstanceId", vmId);
            parameters.put("DeviceIndex", String.valueOf(index));
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public String createInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createInternetGateway");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateInternetGateway");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            String gatewayId = null;
            NodeList blocks = doc.getElementsByTagName("internetGatewayId");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                if (!item.hasChildNodes()) continue;
                gatewayId = item.getFirstChild().getNodeValue().trim();
            }
            if (gatewayId == null) {
                throw new CloudException("No internet gateway was created, but no error was reported");
            }
            parameters = this.provider.getStandardParameters(this.provider.getContext(), "AttachInternetGateway");
            parameters.put("VpcId", forVlanId);
            parameters.put("InternetGatewayId", gatewayId);
            method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
                String i = gatewayId;
                return i;
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String createRoutingTable(@Nonnull String forVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createRoutingTable");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateRouteTable");
            parameters.put("VpcId", forVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("routeTable");
            String id = null;
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                RoutingTable table = this.toRoutingTable(ctx, item);
                if (table == null) continue;
                id = table.getProviderRoutingTableId();
                break;
            }
            if (id == null) {
                throw new CloudException("No table was created, but no error was reported");
            }
            Tag[] tags = new Tag[2];
            Tag t = new Tag();
            t.setKey("Name");
            t.setValue(name);
            tags[0] = t;
            t = new Tag();
            t.setKey("Description");
            t.setValue(description);
            tags[1] = t;
            this.provider.createTags(id, tags);
            String string = id;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public NetworkInterface createNetworkInterface(@Nonnull NICCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createNetworkInterface");
        try {
            Document doc;
            int i;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateNetworkInterface");
            parameters.put("SubnetId", options.getSubnetId());
            if (options.getIpAddress() != null) {
                parameters.put("PrivateIpAddress", options.getIpAddress());
            }
            parameters.put("Description", options.getDescription());
            if (options.getFirewallIds().length > 0) {
                i = 1;
                for (String id : options.getFirewallIds()) {
                    parameters.put("SecurityGroupId." + i, id);
                }
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("networkInterface");
            for (i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                Tag[] tags = new Tag[2];
                Tag t = new Tag();
                t.setKey("Name");
                t.setValue(options.getName());
                tags[0] = t;
                t = new Tag();
                t.setKey("Description");
                t.setValue(options.getDescription());
                tags[1] = t;
                this.provider.createTags(nic.getProviderNetworkInterfaceId(), tags);
                nic.setName(options.getName());
                nic.setDescription(options.getDescription());
                NetworkInterface networkInterface = nic;
                return networkInterface;
            }
            throw new CloudException("No network interface was created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    public void addRouteToAddress(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String address) throws CloudException, InternalException {
        throw new OperationNotSupportedException("You cannot route to a raw IP address in " + this.provider.getCloudName() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRouteToGateway(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String gatewayId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addRouteToGateway");
        try {
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new CloudException(this.provider.getCloudName() + " does not support " + version);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateRoute");
            parameters.put("GatewayId", gatewayId);
            parameters.put("RouteTableId", toRoutingTableId);
            parameters.put("DestinationCidrBlock", destinationCidr);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRouteToNetworkInterface(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addRouteToNetworkInterface");
        try {
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new CloudException(this.provider.getCloudName() + " does not support " + version);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateRoute");
            parameters.put("NetworkInterfaceId", nicId);
            parameters.put("RouteTableId", toRoutingTableId);
            parameters.put("DestinationCidrBlock", destinationCidr);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRouteToVirtualMachine(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addRouteToVirtualMachine");
        try {
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new CloudException(this.provider.getCloudName() + " does not support " + version);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateRoute");
            parameters.put("InstanceId", vmId);
            parameters.put("RouteTableId", toRoutingTableId);
            parameters.put("DestinationCidrBlock", destinationCidr);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        return true;
    }

    private void assignDHCPOptions(VLAN vlan, String domainName, String[] dnsServers, String[] ntpServers) throws CloudException, InternalException {
        boolean differs = false;
        if (vlan.getDomainName() != null) {
            if (domainName == null) {
                differs = true;
            } else if (!domainName.equals(vlan.getDomainName())) {
                differs = true;
            }
        } else if (domainName != null) {
            differs = true;
        }
        if (!differs) {
            int i;
            if (vlan.getDnsServers() != null) {
                if (dnsServers == null || vlan.getDnsServers().length != dnsServers.length) {
                    differs = true;
                } else {
                    for (i = 0; i < dnsServers.length; ++i) {
                        if (dnsServers[i].equalsIgnoreCase(vlan.getDnsServers()[i])) continue;
                        differs = true;
                        break;
                    }
                }
            } else if (dnsServers != null) {
                if (vlan.getDnsServers().length != dnsServers.length) {
                    differs = true;
                } else {
                    for (i = 0; i < dnsServers.length; ++i) {
                        if (dnsServers[i].equalsIgnoreCase(vlan.getDnsServers()[i])) continue;
                        differs = true;
                        break;
                    }
                }
            }
            if (!differs) {
                if (vlan.getNtpServers() != null) {
                    if (ntpServers == null || vlan.getNtpServers().length != ntpServers.length) {
                        differs = true;
                    } else {
                        for (i = 0; i < ntpServers.length; ++i) {
                            if (ntpServers[i].equalsIgnoreCase(vlan.getNtpServers()[i])) continue;
                            differs = true;
                            break;
                        }
                    }
                } else if (ntpServers != null) {
                    if (vlan.getNtpServers().length != ntpServers.length) {
                        differs = true;
                    } else {
                        for (i = 0; i < ntpServers.length; ++i) {
                            if (ntpServers[i].equalsIgnoreCase(vlan.getNtpServers()[i])) continue;
                            differs = true;
                            break;
                        }
                    }
                }
            }
        }
        if (differs) {
            String dhcp = this.createDhcp(domainName, dnsServers, ntpServers);
            this.assignDhcp(vlan.getProviderVlanId(), dhcp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignDhcp(String vlanId, String dhcp) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"assignDHCP");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AssociateDhcpOptions");
            parameters.put("DhcpOptionsId", dhcp);
            parameters.put("VpcId", vlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    private String createDhcp(String domainName, String[] dnsServers, String[] ntpServers) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDHCP");
        try {
            Document doc;
            int vdx;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateDhcpOptions");
            int idx = 1;
            if (domainName != null) {
                parameters.put("DhcpConfiguration." + idx + ".Key", "domain-name");
                parameters.put("DhcpConfiguration." + idx + ".Value.1", domainName);
                ++idx;
            }
            if (dnsServers != null && dnsServers.length > 0) {
                vdx = 1;
                parameters.put("DhcpConfiguration." + idx + ".Key", "domain-name-servers");
                for (String dns : dnsServers) {
                    parameters.put("DhcpConfiguration." + idx + ".Value." + vdx, dns);
                    ++vdx;
                }
            }
            if (ntpServers != null && ntpServers.length > 0) {
                vdx = 1;
                parameters.put("DhcpConfiguration." + idx + ".Key", "ntp-servers");
                for (String ntp : ntpServers) {
                    parameters.put("DhcpConfiguration." + idx + ".Value." + vdx, ntp);
                    ++vdx;
                }
            }
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("dhcpOptionsId");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node id = blocks.item(i);
                if (id == null) continue;
                String string = id.getFirstChild().getNodeValue().trim();
                return string;
            }
            throw new CloudException("No DHCP options were created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Subnet createSubnet(@Nonnull String cidr, @Nonnull String inProviderVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createSubnet");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateSubnet");
            parameters.put("CidrBlock", cidr);
            parameters.put("VpcId", inProviderVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("subnet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                Subnet subnet = this.toSubnet(ctx, item);
                if (subnet == null) continue;
                Tag[] tags = new Tag[2];
                Tag t = new Tag();
                t.setKey("Name");
                t.setValue(name);
                tags[0] = t;
                t = new Tag();
                t.setKey("Description");
                t.setValue(description);
                tags[1] = t;
                this.provider.createTags(subnet.getProviderSubnetId(), tags);
                subnet.setName(name);
                subnet.setDescription(description);
                Subnet subnet2 = subnet;
                return subnet2;
            }
            throw new CloudException("No subnet was created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nullable String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createVLAN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateVpc");
            parameters.put("CidrBlock", cidr);
            parameters.put("InstanceTenancy", "default");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("vpc");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                VLAN vlan = this.toVLAN(ctx, item);
                if (vlan == null) continue;
                if (domainName != null || dnsServers.length > 0 || ntpServers.length > 0) {
                    this.assignDHCPOptions(vlan, domainName, dnsServers, ntpServers);
                }
                Tag[] tags = new Tag[2];
                Tag t = new Tag();
                t.setKey("Name");
                t.setValue(name);
                tags[0] = t;
                t = new Tag();
                t.setKey("Description");
                t.setValue(description);
                tags[1] = t;
                this.provider.createTags(vlan.getProviderVlanId(), tags);
                vlan.setName(name);
                vlan.setDescription(description);
                VLAN vLAN = vlan;
                return vLAN;
            }
            throw new CloudException("No VLAN was created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Collection<Attachment> getAttachments(@Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getNICAttachments");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("NetworkInterfaceId.1", nicId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                if (e.getCode() != null && e.getCode().startsWith("InvalidNetworkInterfaceID")) {
                    Collections.emptyList();
                }
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NodeList attrs = item.getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (!attr.getNodeName().equalsIgnoreCase("attachment")) continue;
                    NodeList parts = attr.getChildNodes();
                    Attachment a = new Attachment();
                    for (int k = 0; k < parts.getLength(); ++k) {
                        Node part = parts.item(k);
                        if (part.getNodeName().equalsIgnoreCase("instanceId") && part.hasChildNodes()) {
                            a.virtualMachineId = part.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!part.getNodeName().equalsIgnoreCase("attachmentId") || !part.hasChildNodes()) continue;
                        a.attachmentId = part.getFirstChild().getNodeValue().trim();
                    }
                    if (a.virtualMachineId == null || a.attachmentId == null) continue;
                    attachments.add(a);
                }
            }
            ArrayList<Attachment> arrayList = attachments;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void detachNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"detachNetworkInterface");
        try {
            Collection<Attachment> attachments = this.getAttachments(nicId);
            for (Attachment a : attachments) {
                Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DetachNetworkInterface");
                parameters.put("AttachmentId", a.attachmentId);
                EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    logger.error((Object)e.getSummary());
                    e.printStackTrace();
                    throw new CloudException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return -2;
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return 1;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "network interface";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "VPC";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetworkInterface getNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getNetworkInterface");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("NetworkInterfaceId.1", nicId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                if (e.getCode() != null && e.getCode().toLowerCase().startsWith("invalidnetworkinterfaceid")) {
                    NetworkInterface networkInterface = null;
                    APITrace.end();
                    return networkInterface;
                }
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                NetworkInterface networkInterface = nic;
                return networkInterface;
            }
            NetworkInterface networkInterface = null;
            return networkInterface;
        }
        finally {
            APITrace.end();
        }
    }

    public RoutingTable getRoutingTableForSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getRoutingTableForSubnet");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeRouteTables");
            parameters.put("Filter.1.Name", "association.subnet-id");
            parameters.put("Filter.1.Value.1", subnetId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("routeTableSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node set = blocks.item(i);
                NodeList items = set.getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    RoutingTable t;
                    Node item = items.item(j);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes() || (t = this.toRoutingTable(ctx, item)) == null) continue;
                    RoutingTable routingTable = t;
                    return routingTable;
                }
            }
            throw new CloudException("Could not identify the subnet routing table for " + subnetId);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public RoutingTable getRoutingTableForVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getRoutingTableForVLAN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeRouteTables");
            parameters.put("Filter.1.Name", "association.main");
            parameters.put("Filter.1.Value.1", "true");
            parameters.put("Filter.2.Name", "vpc-id");
            parameters.put("Filter.2.Value.1", vlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("routeTableSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node set = blocks.item(i);
                NodeList items = set.getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    RoutingTable t;
                    Node item = items.item(j);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes() || (t = this.toRoutingTable(ctx, item)) == null) continue;
                    RoutingTable routingTable = t;
                    return routingTable;
                }
            }
            throw new CloudException("Could not identify the main routing table for " + vlanId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Subnet getSubnet(@Nonnull String providerSubnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getSubnet");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSubnets");
            parameters.put("SubnetId.1", providerSubnetId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                if (e.getCode() != null && e.getCode().startsWith("InvalidSubnetID")) {
                    Subnet subnet = null;
                    APITrace.end();
                    return subnet;
                }
                logger.error((Object)e.getSummary());
                if (!logger.isDebugEnabled()) throw new CloudException((Throwable)e);
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                Subnet subnet = this.toSubnet(ctx, item);
                if (subnet == null) continue;
                Subnet subnet2 = subnet;
                return subnet2;
            }
            Subnet subnet = null;
            return subnet;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public VLAN getVlan(@Nonnull String providerVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getVLAN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpcs");
            parameters.put("VpcId.1", providerVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                if (e.getCode() != null && e.getCode().startsWith("InvalidVpcID")) {
                    VLAN vLAN = null;
                    APITrace.end();
                    return vLAN;
                }
                logger.error((Object)e.getSummary());
                if (!logger.isDebugEnabled()) throw new CloudException((Throwable)e);
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                VLAN vlan = this.toVLAN(ctx, item);
                if (vlan == null) continue;
                VLAN vLAN = vlan;
                return vLAN;
            }
            VLAN vLAN = null;
            return vLAN;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return true;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedVPC");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpcs");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block10: {
                    block9: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block9;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("UnsupportedOperation") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listFirewallIdsForNIC(@Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listFirewallIdsForNIC");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("NetworkInterfaceId.1", nicId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                if (e.getCode() != null && e.getCode().startsWith("InvalidNetworkInterfaceID")) {
                    Collections.emptyList();
                }
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            TreeSet<String> firewallIds = new TreeSet<String>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NodeList attrs = item.getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (!attr.getNodeName().equalsIgnoreCase("groupSet")) continue;
                    NodeList parts = attr.getChildNodes();
                    for (int k = 0; k < parts.getLength(); ++k) {
                        Node part = parts.item(k);
                        if (!part.getNodeName().equalsIgnoreCase("item") || !part.hasChildNodes()) continue;
                        NodeList fws = part.getChildNodes();
                        for (int l = 0; l < fws.getLength(); ++l) {
                            Node fw = fws.item(l);
                            if (!fw.hasChildNodes()) continue;
                            NodeList faList = fw.getChildNodes();
                            for (int m = 0; m < faList.getLength(); ++m) {
                                Node fa = faList.item(m);
                                if (!fa.getNodeName().equalsIgnoreCase("groupId") || !fa.hasChildNodes()) continue;
                                firewallIds.add(fw.getFirstChild().getNodeValue().trim());
                            }
                        }
                    }
                }
            }
            TreeSet<String> treeSet = firewallIds;
            return treeSet;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listNetworkInterfaceStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listNetworkInterfaceStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<ResourceStatus> nics = new ArrayList<ResourceStatus>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                ResourceStatus status = this.toNICStatus(blocks.item(i));
                if (status == null) continue;
                nics.add(status);
            }
            ArrayList<ResourceStatus> arrayList = nics;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listNetworkInterfaces");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                nics.add(nic);
            }
            ArrayList<NetworkInterface> arrayList = nics;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String forVmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listNetworkInterfacesForVM");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("Filter.1.Name", "attachment.instance-id");
            parameters.put("Filter.1.Value.1", forVmId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                nics.add(nic);
            }
            ArrayList<NetworkInterface> arrayList = nics;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listNetworkInterfacesInSubnet");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("Filter.1.Name", "subnet-id");
            parameters.put("Filter.1.Value.1", subnetId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                nics.add(nic);
            }
            ArrayList<NetworkInterface> arrayList = nics;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listNetworkInterfacesInVLAN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeNetworkInterfaces");
            parameters.put("Filter.1.Name", "vpc-id");
            parameters.put("Filter.1.Value.1", vlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<NetworkInterface> nics = new ArrayList<NetworkInterface>();
            NodeList blocks = doc.getElementsByTagName("item");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                NetworkInterface nic = this.toNIC(ctx, item);
                if (nic == null) continue;
                nics.add(nic);
            }
            ArrayList<NetworkInterface> arrayList = nics;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        ArrayList<Networkable> resources = new ArrayList<Networkable>();
        EC2NetworkServices network = this.provider.getNetworkServices();
        if (network != null) {
            IpAddressSupport ipSupport;
            FirewallSupport fwSupport = network.getFirewallSupport();
            if (fwSupport != null) {
                for (Firewall fw : fwSupport.list()) {
                    if (!inVlanId.equals(fw.getProviderVlanId())) continue;
                    resources.add((Networkable)fw);
                }
            }
            if ((ipSupport = network.getIpAddressSupport()) != null) {
                for (IPVersion version : ipSupport.listSupportedIPVersions()) {
                    for (IpAddress addr : ipSupport.listIpPool(version, false)) {
                        if (!inVlanId.equals(addr.getProviderVlanId())) continue;
                        resources.add((Networkable)addr);
                    }
                }
            }
            for (RoutingTable table : this.listRoutingTables(inVlanId)) {
                resources.add((Networkable)table);
            }
            EC2ComputeServices compute = this.provider.getComputeServices();
            VirtualMachineSupport vmSupport = compute == null ? null : compute.getVirtualMachineSupport();
            Iterable<Object> vms = vmSupport == null ? Collections.emptyList() : vmSupport.listVirtualMachines();
            for (Subnet subnet : this.listSubnets(inVlanId)) {
                resources.add((Networkable)subnet);
                for (VirtualMachine virtualMachine : vms) {
                    if (!subnet.getProviderSubnetId().equals(virtualMachine.getProviderVlanId())) continue;
                    resources.add((Networkable)virtualMachine);
                }
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String inVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listRoutingTables");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeRouteTables");
            parameters.put("Filter.1.Name", "vpc-id");
            parameters.put("Filter.1.Value.1", inVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            ArrayList<RoutingTable> tables = new ArrayList<RoutingTable>();
            NodeList blocks = doc.getElementsByTagName("routeTableSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node set = blocks.item(i);
                NodeList items = set.getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    RoutingTable t;
                    Node item = items.item(j);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes() || (t = this.toRoutingTable(ctx, item)) == null) continue;
                    tables.add(t);
                }
            }
            ArrayList<RoutingTable> arrayList = tables;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String providerVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSubnets");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeSubnets");
            parameters.put("Filter.1.Name", "vpc-id");
            parameters.put("Filter.1.Value.1", providerVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            ArrayList<Subnet> list = new ArrayList<Subnet>();
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                Subnet subnet = this.toSubnet(ctx, item);
                if (subnet == null) continue;
                list.add(subnet);
            }
            ArrayList<Subnet> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listVLANStatus");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpcs");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            for (int i = 0; i < blocks.getLength(); ++i) {
                ResourceStatus status = this.toVLANStatus(blocks.item(i));
                if (status == null) continue;
                list.add(status);
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listVLANs");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpcs");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("item");
            ArrayList<VLAN> list = new ArrayList<VLAN>();
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                VLAN vlan = this.toVLAN(ctx, item);
                if (vlan == null) continue;
                list.add(vlan);
            }
            ArrayList<VLAN> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private String getInternetGatewayId(@Nonnull String forVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getInternetGatewayId");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeInternetGateways");
            parameters.put("Filter.1.Name", "attachment.vpc-id");
            parameters.put("Filter.1.Value.1", forVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("internetGatewaySet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node set = blocks.item(i);
                NodeList items = set.getChildNodes();
                for (int i1 = 0; i1 < items.getLength(); ++i1) {
                    Node item = items.item(i1);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes()) continue;
                    NodeList attrs = item.getChildNodes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node attr = attrs.item(j);
                        if (!attr.getNodeName().equalsIgnoreCase("internetGatewayId") || !attr.hasChildNodes()) continue;
                        String string = attr.getFirstChild().getNodeValue().trim();
                        return string;
                    }
                }
            }
            throw new CloudException("Could not identify the Internet gateway for " + forVlanId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeInternetGateway");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DetachInternetGateway");
            String gatewayId = this.getInternetGatewayId(forVlanId);
            if (gatewayId == null) {
                return;
            }
            parameters.put("InternetGatewayId", gatewayId);
            parameters.put("VpcId", forVlanId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteInternetGateway");
            parameters.put("InternetGatewayId", gatewayId);
            method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeNetworkInterface");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteNetworkInterface");
            parameters.put("NetworkInterfaceId", nicId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoute(@Nonnull String inRoutingTableId, @Nonnull String destinationCidr) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeRoute");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteRoute");
            parameters.put("RouteTableId", inRoutingTableId);
            parameters.put("DestinationCidrBlock", destinationCidr);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoutingTable(@Nonnull String routingTableId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeRoutingTable");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteRouteTable");
            parameters.put("RouteTableId", routingTableId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDHCPOptions(String dhcpOptionsId, VLAN vlan) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"loadDHCPOptions");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeDhcpOptions");
            parameters.put("DhcpOptionsId.1", dhcpOptionsId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("dhcpConfigurationSet");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node config = blocks.item(i);
                if (!config.hasChildNodes()) continue;
                NodeList items = config.getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    String nodeName = item.getNodeName();
                    if (!nodeName.equals("item")) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    NodeList attributes = item.getChildNodes();
                    String key = null;
                    for (int k = 0; k < attributes.getLength(); ++k) {
                        Node attribute = attributes.item(k);
                        nodeName = attribute.getNodeName();
                        if (nodeName.equalsIgnoreCase("key")) {
                            key = attribute.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!nodeName.equalsIgnoreCase("valueSet")) continue;
                        NodeList attrItems = attribute.getChildNodes();
                        for (int l = 0; l < attrItems.getLength(); ++l) {
                            Node attrItem = attrItems.item(l);
                            if (!attrItem.getNodeName().equalsIgnoreCase("item")) continue;
                            NodeList values = attrItem.getChildNodes();
                            for (int m = 0; m < values.getLength(); ++m) {
                                Node value = values.item(m);
                                if (!value.getNodeName().equalsIgnoreCase("value")) continue;
                                list.add(value.getFirstChild().getNodeValue().trim());
                            }
                        }
                    }
                    if (key == null || list.size() <= 0) continue;
                    if (key.equals("domain-name")) {
                        vlan.setDomainName((String)list.iterator().next());
                        continue;
                    }
                    if (key.equals("domain-name-servers")) {
                        vlan.setDnsServers(list.toArray(new String[list.size()]));
                        continue;
                    }
                    if (!key.equals("ntp-servers")) continue;
                    vlan.setNtpServers(list.toArray(new String[list.size()]));
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)VLANSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)VLANSupport.ASSIGN_ROUTE_TO_SUBNET)) {
            return new String[]{"ec2:AssociateRouteTable"};
        }
        if (action.equals((Object)VLANSupport.ASSIGN_ROUTE_TO_VLAN)) {
            return new String[]{"ec2:ReplaceRouteTableAssociation"};
        }
        if (action.equals((Object)VLANSupport.ATTACH_INTERNET_GATEWAY)) {
            return new String[]{"ec2:AttachInternetGateway"};
        }
        if (action.equals((Object)VLANSupport.CREATE_INTERNET_GATEWAY)) {
            return new String[]{"ec2:CreateInternetGateway"};
        }
        if (action.equals((Object)VLANSupport.CREATE_ROUTING_TABLE)) {
            return new String[]{"ec2:CreateRouteTable"};
        }
        if (action.equals((Object)VLANSupport.ADD_ROUTE)) {
            return new String[]{"ec2:CreateRoute"};
        }
        if (action.equals((Object)VLANSupport.CREATE_SUBNET)) {
            return new String[]{"ec2:CreateSubnet"};
        }
        if (action.equals((Object)VLANSupport.CREATE_VLAN)) {
            return new String[]{"ec2:CreateVpc", "ec2:CreateDhcpOptions", "ec2:AssociateDhcpOptions", "ec2:CreateInternetGateway", "ec2:AttachInternetGateway"};
        }
        if (action.equals((Object)VLANSupport.GET_SUBNET)) {
            return new String[]{"ec2:DescribeSubnets"};
        }
        if (action.equals((Object)VLANSupport.GET_VLAN)) {
            return new String[]{"ec2:DescribeVpcs", "ec2:DescribeDhcpOptions", "ec2:DescribeInternetGateways"};
        }
        if (action.equals((Object)VLANSupport.LIST_SUBNET)) {
            return new String[]{"ec2:DescribeSubnets"};
        }
        if (action.equals((Object)VLANSupport.LIST_VLAN)) {
            return new String[]{"ec2:DescribeVpcs", "ec2:DescribeDhcpOptions", "ec2:DescribeInternetGateways"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_INTERNET_GATEWAY)) {
            return new String[]{"ec2:DeleteInternetGateway", "ec2:DetachInternetGateway"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_SUBNET)) {
            return new String[]{"ec2:DeleteSubnet"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_VLAN)) {
            return new String[]{"ec2:DeleteVpc"};
        }
        if (action.equals((Object)VLANSupport.CREATE_NIC)) {
            return new String[]{"ec2:CreateNetworkInterface"};
        }
        if (action.equals((Object)VLANSupport.ATTACH_NIC)) {
            return new String[]{"ec2:AttachNetworkInterface"};
        }
        if (action.equals((Object)VLANSupport.DETACH_NIC)) {
            return new String[]{"ec2:DetachNetworkInterface"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_NIC)) {
            return new String[]{"ec2:DeleteNetworkInterface"};
        }
        if (action.equals((Object)VLANSupport.GET_NIC)) {
            return new String[]{"ec2:DescribeNetworkInterfaces"};
        }
        if (action.equals((Object)VLANSupport.LIST_NIC)) {
            return new String[]{"ec2:DescribeNetworkInterfaces"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_ROUTE)) {
            return new String[]{"ec2:DeleteRoute"};
        }
        if (action.equals((Object)VLANSupport.REMOVE_ROUTING_TABLE)) {
            return new String[]{"ec2:DeleteRouteTable"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubnet(String providerSubnetId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeSubnet");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteSubnet");
            parameters.put("SubnetId", providerSubnetId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String providerVpcId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeVLAN");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteVpc");
            parameters.put("VpcId", providerVpcId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                logger.error((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    private NetworkInterface toNIC(@Nonnull ProviderContext ctx, @Nullable Node item) throws CloudException, InternalException {
        if (item == null) {
            return null;
        }
        NodeList children = item.getChildNodes();
        NetworkInterface nic = new NetworkInterface();
        String name = null;
        String description = null;
        nic.setProviderOwnerId(ctx.getAccountNumber());
        nic.setProviderRegionId(ctx.getRegionId());
        nic.setCurrentState(NICState.PENDING);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("networkInterfaceId") && child.hasChildNodes()) {
                nic.setProviderNetworkInterfaceId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("subnetId") && child.hasChildNodes()) {
                nic.setProviderSubnetId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("vpcId") && child.hasChildNodes()) {
                nic.setProviderVlanId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("availabilityZone") && child.hasChildNodes()) {
                nic.setProviderDataCenterId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("description") && child.hasChildNodes()) {
                nic.setDescription(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("privateIpAddress") && child.hasChildNodes()) {
                nic.setIpAddress(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("status") && child.hasChildNodes()) {
                nic.setCurrentState(this.toNICState(child.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (nodeName.equalsIgnoreCase("macAddress") && child.hasChildNodes()) {
                nic.setMacAddress(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("privateDnsName") && child.hasChildNodes()) {
                nic.setDnsName(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("attachment") && child.hasChildNodes()) {
                NodeList sublist = child.getChildNodes();
                for (int j = 0; j < sublist.getLength(); ++j) {
                    Node sub = sublist.item(j);
                    if (!sub.getNodeName().equalsIgnoreCase("instanceID") || !sub.hasChildNodes()) continue;
                    nic.setProviderVirtualMachineId(sub.getFirstChild().getNodeValue().trim());
                }
                continue;
            }
            if (!nodeName.equalsIgnoreCase("tagSet") || !child.hasChildNodes()) continue;
            this.provider.setTags(child, (Taggable)nic);
            if (nic.getTags().get("name") != null) {
                name = (String)nic.getTags().get("name");
            }
            if (nic.getTags().get("description") == null) continue;
            description = (String)nic.getTags().get("description");
        }
        if (nic.getProviderNetworkInterfaceId() == null) {
            return null;
        }
        if (nic.getName() == null) {
            nic.setName(name == null ? nic.getProviderNetworkInterfaceId() : name);
        }
        if (nic.getDescription() == null) {
            nic.setDescription(description == null ? nic.getName() : description);
        }
        return nic;
    }

    @Nonnull
    private NICState toNICState(@Nonnull String status) {
        if (status.equalsIgnoreCase("pending")) {
            return NICState.PENDING;
        }
        if (status.equalsIgnoreCase("available")) {
            return NICState.AVAILABLE;
        }
        if (status.equalsIgnoreCase("in-use")) {
            return NICState.IN_USE;
        }
        System.out.println("DEBUG: New AWS network interface status: " + status);
        return NICState.PENDING;
    }

    @Nullable
    private ResourceStatus toNICStatus(@Nullable Node item) throws CloudException, InternalException {
        if (item == null) {
            return null;
        }
        NodeList children = item.getChildNodes();
        NICState state = NICState.PENDING;
        String nicId = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("networkInterfaceId") && child.hasChildNodes()) {
                nicId = child.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("status") || !child.hasChildNodes()) continue;
            state = this.toNICState(child.getFirstChild().getNodeValue().trim());
        }
        if (nicId == null) {
            return null;
        }
        return new ResourceStatus(nicId, (Object)state);
    }

    @Nullable
    private RoutingTable toRoutingTable(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        RoutingTable table = new RoutingTable();
        String name = null;
        String description = null;
        table.setProviderOwnerId(ctx.getAccountNumber());
        table.setProviderRegionId(ctx.getRegionId());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("routeTableId") && child.hasChildNodes()) {
                table.setProviderRoutingTableId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("vpcId") && child.hasChildNodes()) {
                table.setProviderVlanId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("routeSet") && child.hasChildNodes()) {
                ArrayList<Route> routes = new ArrayList<Route>();
                NodeList set = child.getChildNodes();
                for (int j = 0; j < set.getLength(); ++j) {
                    Node item = set.item(j);
                    if (!item.getNodeName().equalsIgnoreCase("item") || !item.hasChildNodes()) continue;
                    String destination = null;
                    String gateway = null;
                    String instanceId = null;
                    String ownerId = null;
                    String nicId = null;
                    NodeList attrs = item.getChildNodes();
                    boolean active = false;
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        if (attr.getNodeName().equalsIgnoreCase("destinationCidrBlock") && attr.hasChildNodes()) {
                            destination = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (attr.getNodeName().equalsIgnoreCase("gatewayId") && attr.hasChildNodes()) {
                            gateway = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (attr.getNodeName().equalsIgnoreCase("instanceId") && attr.hasChildNodes()) {
                            instanceId = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (attr.getNodeName().equalsIgnoreCase("instanceOwnerId") && attr.hasChildNodes()) {
                            ownerId = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (attr.getNodeName().equalsIgnoreCase("networkInterfaceId") && attr.hasChildNodes()) {
                            nicId = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!attr.getNodeName().equalsIgnoreCase("state") || !attr.hasChildNodes()) continue;
                        active = attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("active");
                    }
                    if (!active || destination == null || gateway == null && instanceId == null && nicId == null) continue;
                    if (gateway == null) {
                        gateway = instanceId == null ? "instance:" + ownerId + ":" + instanceId : "nic:" + nicId;
                    }
                    routes.add(Route.getRouteToGateway((IPVersion)IPVersion.IPV4, destination, gateway));
                }
                table.setRoutes(routes.toArray(new Route[routes.size()]));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("tagSet") || !child.hasChildNodes()) continue;
            this.provider.setTags(child, (Taggable)table);
            if (table.getTags().get("name") != null) {
                name = (String)table.getTags().get("name");
            }
            if (table.getTags().get("description") == null) continue;
            description = (String)table.getTags().get("description");
        }
        if (table.getProviderRoutingTableId() == null) {
            return null;
        }
        if (table.getName() == null) {
            table.setName(name == null ? table.getProviderRoutingTableId() : name);
        }
        if (table.getDescription() == null) {
            table.setDescription(description == null ? table.getName() : description);
        }
        return table;
    }

    @Nullable
    private Subnet toSubnet(@Nonnull ProviderContext ctx, @Nullable Node item) throws CloudException, InternalException {
        if (item == null) {
            return null;
        }
        NodeList children = item.getChildNodes();
        Subnet subnet = new Subnet();
        subnet.setProviderOwnerId(ctx.getAccountNumber());
        subnet.setProviderRegionId(ctx.getRegionId());
        subnet.setTags(new HashMap());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("subnetId")) {
                subnet.setProviderSubnetId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("state")) {
                SubnetState state;
                String value = child.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("available")) {
                    state = SubnetState.AVAILABLE;
                } else if (value.equalsIgnoreCase("pending")) {
                    state = SubnetState.PENDING;
                } else {
                    logger.warn((Object)("Unknown subnet state: " + value));
                    state = null;
                }
                subnet.setCurrentState(state);
                continue;
            }
            if (nodeName.equalsIgnoreCase("vpcId")) {
                subnet.setProviderVlanId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("cidrBlock")) {
                subnet.setCidr(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("availableIpAddressCount")) {
                subnet.setAvailableIpAddresses(Integer.parseInt(child.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("availabilityZone")) continue;
            subnet.setProviderDataCenterId(child.getFirstChild().getNodeValue().trim());
        }
        if (subnet.getProviderSubnetId() == null) {
            return null;
        }
        if (subnet.getName() == null) {
            subnet.setName(subnet.getProviderSubnetId());
        }
        if (subnet.getDescription() == null) {
            subnet.setDescription(subnet.getName());
        }
        return subnet;
    }

    @Nullable
    private VLAN toVLAN(@Nonnull ProviderContext ctx, @Nullable Node item) throws CloudException, InternalException {
        if (item == null) {
            return null;
        }
        NodeList children = item.getChildNodes();
        VLAN vlan = new VLAN();
        String dhcp = null;
        vlan.setProviderOwnerId(ctx.getAccountNumber());
        vlan.setProviderRegionId(ctx.getRegionId());
        vlan.setTags(new HashMap());
        vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("vpcId")) {
                vlan.setProviderVlanId(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("state")) {
                VLANState state;
                String value = child.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("available")) {
                    state = VLANState.AVAILABLE;
                } else if (value.equalsIgnoreCase("pending")) {
                    state = VLANState.PENDING;
                } else {
                    logger.warn((Object)("Unknown VLAN state: " + value));
                    state = null;
                }
                vlan.setCurrentState(state);
                continue;
            }
            if (nodeName.equalsIgnoreCase("cidrBlock")) {
                vlan.setCidr(child.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!nodeName.equalsIgnoreCase("dhcpOptionsId")) continue;
            dhcp = child.getFirstChild().getNodeValue().trim();
        }
        if (vlan.getProviderVlanId() == null) {
            return null;
        }
        if (vlan.getName() == null) {
            vlan.setName(vlan.getProviderVlanId());
        }
        if (vlan.getDescription() == null) {
            vlan.setDescription(vlan.getName());
        }
        if (dhcp != null) {
            this.loadDHCPOptions(dhcp, vlan);
        }
        return vlan;
    }

    @Nonnull
    private VLANState toVLANState(@Nonnull String status) {
        if (status.equalsIgnoreCase("available")) {
            return VLANState.AVAILABLE;
        }
        if (status.equalsIgnoreCase("pending")) {
            return VLANState.PENDING;
        }
        logger.warn((Object)("DEBUG: Unknown AWS VLAN state: " + status));
        return VLANState.PENDING;
    }

    @Nullable
    private ResourceStatus toVLANStatus(@Nullable Node item) throws CloudException, InternalException {
        if (item == null) {
            return null;
        }
        NodeList children = item.getChildNodes();
        VLANState state = VLANState.PENDING;
        String vlanId = null;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("vpcId")) {
                vlanId = child.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("state")) continue;
            state = this.toVLANState(child.getFirstChild().getNodeValue().trim());
        }
        if (vlanId == null) {
            return null;
        }
        return new ResourceStatus(vlanId, (Object)state);
    }

    private static class Attachment {
        public String attachmentId;
        public String virtualMachineId;

        private Attachment() {
        }
    }
}

