/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.VPN;
import org.dasein.cloud.network.VPNConnection;
import org.dasein.cloud.network.VPNConnectionState;
import org.dasein.cloud.network.VPNGateway;
import org.dasein.cloud.network.VPNGatewayState;
import org.dasein.cloud.network.VPNProtocol;
import org.dasein.cloud.network.VPNState;
import org.dasein.cloud.network.VPNSupport;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VPCGateway
implements VPNSupport {
    Logger logger = AWSCloud.getLogger(VPCGateway.class);
    private AWSCloud provider;

    public VPCGateway(@Nonnull AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachToVLAN(@Nonnull String providerVpnId, @Nonnull String providerVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"attachVPNToVLAN");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "AttachVpnGateway");
            parameters.put("VpcId", providerVlanId);
            parameters.put("VpnGatewayId", providerVpnId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToGateway(@Nonnull String providerVpnId, @Nonnull String toGatewayId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"connectVPNToGateway");
        try {
            VPNGateway gateway = this.getGateway(toGatewayId);
            VPN vpn = this.getVPN(providerVpnId);
            if (gateway == null) {
                throw new CloudException("No such VPN gateway: " + toGatewayId);
            }
            if (vpn == null) {
                throw new CloudException("No such VPN: " + providerVpnId);
            }
            if (!gateway.getProtocol().equals((Object)vpn.getProtocol())) {
                throw new CloudException("VPN protocol mismatch between VPN and gateway: " + vpn.getProtocol() + " vs " + gateway.getProtocol());
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateVpnConnection");
            parameters.put("Type", this.getAWSProtocol(vpn.getProtocol()));
            parameters.put("CustomerGatewayId", gateway.getProviderVpnGatewayId());
            parameters.put("VpnGatewayId", vpn.getProviderVpnId());
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VPN createVPN(@Nullable String dataCenterId, @Nonnull String name, @Nonnull String description, @Nonnull VPNProtocol protocol) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createVPN");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateVpnGateway");
            parameters.put("Type", this.getAWSProtocol(protocol));
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("vpnGateway");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                VPN vpn = this.toVPN(ctx, item);
                if (vpn == null) continue;
                VPN vPN = vpn;
                return vPN;
            }
            throw new CloudException("No VPN was created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VPNGateway createVPNGateway(@Nonnull String endpoint, @Nonnull String name, @Nonnull String description, @Nonnull VPNProtocol protocol, @Nonnull String bgpAsn) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createVPNGateway");
        try {
            Document doc;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "CreateCustomerGateway");
            parameters.put("Type", this.getAWSProtocol(protocol));
            parameters.put("IpAddress", endpoint);
            parameters.put("BgpAsn", bgpAsn);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                if (this.logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("customerGateway");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                VPNGateway gateway = this.toGateway(ctx, item);
                if (gateway == null) continue;
                VPNGateway vPNGateway = gateway;
                return vPNGateway;
            }
            throw new CloudException("No VPN gateway was created, but no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVPN(@Nonnull String providerVpnId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteVPN");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteVpnGateway");
            parameters.put("VpnGatewayId", providerVpnId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVPNGateway(@Nonnull String gatewayId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteVPNGateway");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteCustomerGateway");
            parameters.put("CustomerGatewayId", gatewayId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromVLAN(@Nonnull String providerVpnId, @Nonnull String providerVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"detachVPNFromVLAN");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DetachVpnGateway");
            parameters.put("VpcId", providerVlanId);
            parameters.put("VpnGatewayId", providerVpnId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectFromGateway(@Nonnull String vpnId, @Nonnull String gatewayId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"disconnectVPNFromGateway");
        try {
            VPNGateway gateway = this.getGateway(gatewayId);
            VPN vpn = this.getVPN(vpnId);
            if (gateway == null) {
                throw new CloudException("No such VPN gateway: " + gatewayId);
            }
            if (vpn == null) {
                throw new CloudException("No such VPN: " + vpnId);
            }
            String connectionId = null;
            for (VPNConnection c : this.listConnections(vpnId, null)) {
                if (!gatewayId.equals(c.getProviderGatewayId())) continue;
                connectionId = c.getProviderVpnConnectionId();
                break;
            }
            if (connectionId == null) {
                this.logger.warn((Object)"Attempt to disconnect a VPN from a gateway when there was no connection in the cloud");
                return;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured");
            }
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DeleteVpnConnection");
            parameters.put("VpnConnectionId", connectionId);
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    private String getAWSProtocol(VPNProtocol protocol) throws CloudException {
        if (protocol.equals((Object)VPNProtocol.IPSEC1)) {
            return "ipsec.1";
        }
        throw new CloudException("AWS does not support " + protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VPNGateway getGateway(@Nonnull String gatewayId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getGateway");
        try {
            Iterator<VPNGateway> it = this.listGateways(gatewayId, null).iterator();
            if (it.hasNext()) {
                VPNGateway vPNGateway = it.next();
                return vPNGateway;
            }
            VPNGateway vPNGateway = null;
            return vPNGateway;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VPN getVPN(@Nonnull String providerVpnId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getVPN");
        try {
            Iterator<VPN> it = this.listVPNs(providerVpnId).iterator();
            VPN vPN = it.hasNext() ? it.next() : null;
            return vPN;
        }
        finally {
            APITrace.end();
        }
    }

    public Requirement getVPNDataCenterConstraint() {
        return Requirement.NONE;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedVPCGateway");
        try {
            Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeCustomerCateways");
            EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block9: {
                    block8: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block8;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("UnsupportedOperation") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block9;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                this.logger.error((Object)e.getSummary());
                e.printStackTrace();
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VPNConnection> listGatewayConnections(@Nonnull String toGatewayId) throws CloudException, InternalException {
        return this.listConnections(null, toGatewayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<VPNConnection> listConnections(@Nullable String vpnId, @Nullable String gatewayId) throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listVPCConnections");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpnConnections");
        if (gatewayId != null) {
            parameters.put("Filter.1.Name", "customer-gateway-id");
            parameters.put("Filter.1.Value.1", gatewayId);
        } else if (vpnId != null) {
            parameters.put("Filter.1.Name", "vpn-gateway-id");
            parameters.put("Filter.1.Value.1", vpnId);
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && (code.startsWith("InvalidCustomer") || code.startsWith("InvalidVpn"))) {
                List<VPNConnection> list = Collections.emptyList();
                APITrace.end();
                return list;
            }
            this.logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        ArrayList<VPNConnection> list = new ArrayList<VPNConnection>();
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            VPNConnection c = this.toConnection(ctx, item);
            if (c == null) continue;
            list.add(c);
        }
        ArrayList<VPNConnection> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listGatewayStatus() throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listVPCGatewayStatus");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeCustomerCateways");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && (code.startsWith("InvalidCustomer") || code.startsWith("InvalidB"))) {
                List<ResourceStatus> list = Collections.emptyList();
                APITrace.end();
                return list;
            }
            this.logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            ResourceStatus status = this.toGatewayStatus(blocks.item(i));
            if (status == null) continue;
            list.add(status);
        }
        ArrayList<ResourceStatus> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VPNGateway> listGateways() throws CloudException, InternalException {
        return this.listGateways(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<VPNGateway> listGateways(@Nullable String gatewayId, @Nullable String bgpAsn) throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listVPCGateways");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeCustomerCateways");
        if (gatewayId != null) {
            parameters.put("Filter.1.Name", "customer-gateway-id");
            parameters.put("Filter.1.Value.1", gatewayId);
        } else if (bgpAsn != null) {
            parameters.put("Filter.1.Name", "bgp-asn");
            parameters.put("Filter.1.Value.1", bgpAsn);
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && (code.startsWith("InvalidCustomer") || code.startsWith("InvalidB"))) {
                List<VPNGateway> list = Collections.emptyList();
                APITrace.end();
                return list;
            }
            this.logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        ArrayList<VPNGateway> list = new ArrayList<VPNGateway>();
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            VPNGateway gw = this.toGateway(ctx, item);
            if (gw == null) continue;
            list.add(gw);
        }
        ArrayList<VPNGateway> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VPNGateway> listGatewaysWithBgpAsn(@Nonnull String bgpAsn) throws CloudException, InternalException {
        return this.listGateways(null, bgpAsn);
    }

    @Nonnull
    public Iterable<VPNConnection> listVPNConnections(@Nonnull String toVpnId) throws CloudException, InternalException {
        return this.listConnections(toVpnId, null);
    }

    @Nonnull
    public Iterable<VPNProtocol> listSupportedVPNProtocols() throws CloudException, InternalException {
        return Collections.singletonList(VPNProtocol.IPSEC1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVPNStatus() throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listVPNStatus");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpnGateways");
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidVpn")) {
                List<ResourceStatus> list = Collections.emptyList();
                APITrace.end();
                return list;
            }
            this.logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            ResourceStatus status = this.toVPNStatus(blocks.item(i));
            if (status == null) continue;
            list.add(status);
        }
        ArrayList<ResourceStatus> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VPN> listVPNs() throws CloudException, InternalException {
        return this.listVPNs(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private Iterable<VPN> listVPNs(@Nullable String vpnId) throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"listVPNs");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured");
        }
        Map<String, String> parameters = this.provider.getStandardParameters(this.provider.getContext(), "DescribeVpnGateways");
        if (vpnId != null) {
            parameters.put("VpnGatewayId.1", vpnId);
        }
        EC2Method method = new EC2Method(this.provider, this.provider.getEc2Url(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.startsWith("InvalidVpn")) {
                List<VPN> list = Collections.emptyList();
                APITrace.end();
                return list;
            }
            this.logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        ArrayList<VPN> list = new ArrayList<VPN>();
        NodeList blocks = doc.getElementsByTagName("item");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node item = blocks.item(i);
            VPN vpn = this.toVPN(ctx, item);
            if (vpn == null) continue;
            list.add(vpn);
        }
        ArrayList<VPN> arrayList = list;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)VPNSupport.ANY)) {
            return new String[]{"ec2:*"};
        }
        if (action.equals((Object)VPNSupport.ATTACH)) {
            return new String[]{"ec2:AttachVpnGateway"};
        }
        if (action.equals((Object)VPNSupport.CREATE_GATEWAY)) {
            return new String[]{"ec2:CreateCustomerGateway"};
        }
        if (action.equals((Object)VPNSupport.CREATE_VPN)) {
            return new String[]{"ec2:CreateVpnGateway"};
        }
        if (action.equals((Object)VPNSupport.GET_GATEWAY) || action.equals((Object)VPNSupport.LIST_GATEWAY)) {
            return new String[]{"ec2:DescribeCustomerCateways", "ec2:DescribeVpnConnections"};
        }
        if (action.equals((Object)VPNSupport.GET_VPN) || action.equals((Object)VPNSupport.LIST_VPN)) {
            return new String[]{"ec2:DescribeVpnGateways", "ec2:DescribeVpnConnections"};
        }
        if (action.equals((Object)VPNSupport.REMOVE_GATEWAY)) {
            return new String[]{"ec2:DeleteCustomerGateway"};
        }
        if (action.equals((Object)VPNSupport.REMOVE_VPN)) {
            return new String[]{"ec2:DeleteVpnGateway"};
        }
        if (action.equals((Object)VPNSupport.DETACH)) {
            return new String[]{"ec2:DetachVpnGateway"};
        }
        return new String[0];
    }

    @Nullable
    private VPNConnection toConnection(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VPNConnection connection = new VPNConnection();
        connection.setCurrentState(VPNConnectionState.PENDING);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.equalsIgnoreCase("vpnConnectionId") && attr.hasChildNodes()) {
                connection.setProviderVpnConnectionId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("customerGatewayId") && attr.hasChildNodes()) {
                connection.setProviderGatewayId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("vpnGatewayId") && attr.hasChildNodes()) {
                connection.setProviderVpnId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("customerGatewayConfiguration") && attr.hasChildNodes()) {
                connection.setConfigurationXml(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("state") && attr.hasChildNodes()) {
                String state = attr.getFirstChild().getNodeValue().trim();
                if (state.equalsIgnoreCase("available")) {
                    connection.setCurrentState(VPNConnectionState.AVAILABLE);
                    continue;
                }
                if (state.equalsIgnoreCase("deleting")) {
                    connection.setCurrentState(VPNConnectionState.DELETING);
                    continue;
                }
                if (state.equalsIgnoreCase("deleted")) {
                    connection.setCurrentState(VPNConnectionState.DELETED);
                    continue;
                }
                if (state.equalsIgnoreCase("pending")) {
                    connection.setCurrentState(VPNConnectionState.PENDING);
                    continue;
                }
                this.logger.warn((Object)("DEBUG: Unknown VPN connection state: " + state));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("type") || !attr.hasChildNodes()) continue;
            String t = attr.getFirstChild().getNodeValue().trim();
            if (t.equalsIgnoreCase("ipsec.1")) {
                connection.setProtocol(VPNProtocol.IPSEC1);
                continue;
            }
            if (t.equalsIgnoreCase("openvpn")) {
                connection.setProtocol(VPNProtocol.OPEN_VPN);
                continue;
            }
            this.logger.warn((Object)("DEBUG: Unknown VPN connection type: " + t));
            connection.setProtocol(VPNProtocol.IPSEC1);
        }
        if (connection.getProviderVpnConnectionId() == null) {
            return null;
        }
        return connection;
    }

    @Nullable
    private VPNGateway toGateway(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VPNGateway gateway = new VPNGateway();
        gateway.setProviderOwnerId(ctx.getAccountNumber());
        gateway.setProviderRegionId(ctx.getRegionId());
        gateway.setCurrentState(VPNGatewayState.PENDING);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.equalsIgnoreCase("customerGatewayId") && attr.hasChildNodes()) {
                gateway.setProviderVpnGatewayId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("state") && attr.hasChildNodes()) {
                String state = attr.getFirstChild().getNodeValue().trim();
                if (state.equalsIgnoreCase("available")) {
                    gateway.setCurrentState(VPNGatewayState.AVAILABLE);
                    continue;
                }
                if (state.equalsIgnoreCase("deleting")) {
                    gateway.setCurrentState(VPNGatewayState.DELETING);
                    continue;
                }
                if (state.equalsIgnoreCase("deleted")) {
                    gateway.setCurrentState(VPNGatewayState.DELETED);
                    continue;
                }
                if (state.equalsIgnoreCase("pending")) {
                    gateway.setCurrentState(VPNGatewayState.PENDING);
                    continue;
                }
                this.logger.warn((Object)("DEBUG: Unknown VPN gateway state: " + state));
                continue;
            }
            if (nodeName.equalsIgnoreCase("type") && attr.hasChildNodes()) {
                String t = attr.getFirstChild().getNodeValue().trim();
                if (t.equalsIgnoreCase("ipsec.1")) {
                    gateway.setProtocol(VPNProtocol.IPSEC1);
                    continue;
                }
                if (t.equalsIgnoreCase("openvpn")) {
                    gateway.setProtocol(VPNProtocol.OPEN_VPN);
                    continue;
                }
                this.logger.warn((Object)("DEBUG: Unknown VPN gateway type: " + t));
                gateway.setProtocol(VPNProtocol.IPSEC1);
                continue;
            }
            if (nodeName.equalsIgnoreCase("ipAddress") && attr.hasChildNodes()) {
                gateway.setEndpoint(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("bgpAsn") && attr.hasChildNodes()) {
                gateway.setBgpAsn(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!nodeName.equalsIgnoreCase("tagSet") || !attr.hasChildNodes()) continue;
            this.provider.setTags(attr, (Taggable)gateway);
        }
        if (gateway.getProviderVpnGatewayId() == null) {
            return null;
        }
        if (gateway.getName() == null) {
            gateway.setName(gateway.getProviderVpnGatewayId() + " [" + gateway.getEndpoint() + "]");
        }
        if (gateway.getDescription() == null) {
            gateway.setDescription(gateway.getName());
        }
        return gateway;
    }

    @Nonnull
    private VPNGatewayState toGatewayState(@Nonnull String state) {
        if (state.equalsIgnoreCase("available")) {
            return VPNGatewayState.AVAILABLE;
        }
        if (state.equalsIgnoreCase("deleting")) {
            return VPNGatewayState.DELETING;
        }
        if (state.equalsIgnoreCase("deleted")) {
            return VPNGatewayState.DELETED;
        }
        if (state.equalsIgnoreCase("pending")) {
            return VPNGatewayState.PENDING;
        }
        this.logger.warn((Object)("DEBUG: Unknown AWS VPN gateway state: " + state));
        return VPNGatewayState.PENDING;
    }

    @Nullable
    private ResourceStatus toGatewayStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VPNGatewayState state = VPNGatewayState.PENDING;
        String gatewayId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.equalsIgnoreCase("customerGatewayId") && attr.hasChildNodes()) {
                gatewayId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("state") || !attr.hasChildNodes()) continue;
            state = this.toGatewayState(attr.getFirstChild().getNodeValue().trim());
        }
        if (gatewayId == null) {
            return null;
        }
        return new ResourceStatus(gatewayId, (Object)state);
    }

    @Nullable
    private VPN toVPN(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String name = null;
        String description = null;
        VPN vpn = new VPN();
        vpn.setCurrentState(VPNState.PENDING);
        vpn.setProviderRegionId(ctx.getRegionId());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.equalsIgnoreCase("vpnGatewayId") && attr.hasChildNodes()) {
                vpn.setProviderVpnId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("state")) {
                vpn.setCurrentState(this.toVPNState(attr.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (nodeName.equalsIgnoreCase("type") && attr.hasChildNodes()) {
                String t = attr.getFirstChild().getNodeValue().trim();
                if (t.equalsIgnoreCase("ipsec.1")) {
                    vpn.setProtocol(VPNProtocol.IPSEC1);
                    continue;
                }
                if (t.equalsIgnoreCase("openvpn")) {
                    vpn.setProtocol(VPNProtocol.OPEN_VPN);
                    continue;
                }
                this.logger.warn((Object)("DEBUG: Unknown VPN gateway type: " + t));
                vpn.setProtocol(VPNProtocol.IPSEC1);
                continue;
            }
            if (nodeName.equalsIgnoreCase("attachments") && attr.hasChildNodes()) {
                TreeSet<String> vlans = new TreeSet<String>();
                NodeList list = attr.getChildNodes();
                for (int j = 0; j < list.getLength(); ++j) {
                    Node att = list.item(j);
                    if (!att.getNodeName().equalsIgnoreCase("item") || !att.hasChildNodes()) continue;
                    NodeList aaList = attr.getChildNodes();
                    String id = null;
                    for (int k = 0; k < aaList.getLength(); ++k) {
                        Node aa = aaList.item(k);
                        if (!aa.getNodeName().equalsIgnoreCase("vpcId") || !aa.hasChildNodes()) continue;
                        id = aa.getFirstChild().getNodeValue().trim();
                        break;
                    }
                    if (id == null) continue;
                    vlans.add(id);
                }
                vpn.setProviderVlanIds(vlans.toArray(new String[vlans.size()]));
                continue;
            }
            if (!nodeName.equalsIgnoreCase("tagSet") || !attr.hasChildNodes()) continue;
            this.provider.setTags(attr, (Taggable)vpn);
            if (vpn.getTags().get("name") != null) {
                name = (String)vpn.getTags().get("name");
            }
            if (vpn.getTags().get("description") == null) continue;
            description = (String)vpn.getTags().get("description");
        }
        if (vpn.getProviderVpnId() == null) {
            return null;
        }
        if (vpn.getName() == null) {
            vpn.setName(name == null ? vpn.getProviderVpnId() : name);
        }
        if (vpn.getDescription() == null) {
            vpn.setDescription(description == null ? vpn.getName() : description);
        }
        return vpn;
    }

    @Nonnull
    private VPNState toVPNState(@Nonnull String status) throws CloudException, InternalException {
        if (status.equalsIgnoreCase("available")) {
            return VPNState.AVAILABLE;
        }
        if (status.equalsIgnoreCase("deleting")) {
            return VPNState.DELETING;
        }
        if (status.equalsIgnoreCase("deleted")) {
            return VPNState.DELETED;
        }
        if (status.equalsIgnoreCase("pending")) {
            return VPNState.PENDING;
        }
        this.logger.warn((Object)("DEBUG: Unknown AWS VPN state: " + status));
        return VPNState.PENDING;
    }

    @Nullable
    private ResourceStatus toVPNStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VPNState state = VPNState.PENDING;
        String vpnId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            String nodeName = attr.getNodeName();
            if (nodeName.equalsIgnoreCase("vpnGatewayId") && attr.hasChildNodes()) {
                vpnId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("state")) continue;
            state = this.toVPNState(attr.getFirstChild().getNodeValue().trim());
        }
        if (vpnId == null) {
            return null;
        }
        return new ResourceStatus(vpnId, (Object)state);
    }
}

