/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.platform.CloudFrontAction;
import org.dasein.cloud.aws.platform.CloudFrontException;
import org.dasein.cloud.aws.platform.CloudFrontMethod;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.platform.Distribution;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CloudFront
implements CDNSupport {
    private static final Logger logger = AWSCloud.getLogger(CloudFront.class);
    private AWSCloud provider = null;

    CloudFront(AWSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    public String create(@Nonnull String bucket, @Nonnull String name, boolean active, String ... cnames) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDistribution");
        try {
            CloudFrontMethod.CloudFrontResponse response;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            this.provider.getStorageServices().getBlobStoreSupport().makePublic(bucket);
            for (Blob file : this.provider.getStorageServices().getBlobStoreSupport().list(bucket)) {
                if (file.isContainer()) continue;
                this.provider.getStorageServices().getBlobStoreSupport().makePublic(file.getBucketName(), file.getObjectName());
            }
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.CREATE_DISTRIBUTION, null, this.toConfigXml(bucket, name, null, null, null, active, cnames));
            try {
                response = method.invoke(new String[0]);
            }
            catch (CloudFrontException e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("Distribution");
            for (int i = 0; i < blocks.getLength(); ++i) {
                String id;
                Distribution dist = this.toDistributionFromInfo(ctx, blocks.item(i));
                if (dist == null || (id = dist.getProviderDistributionId()) == null) continue;
                String string = id;
                return string;
            }
            throw new CloudException("No CDN distribution was created and no error was reported");
        }
        finally {
            APITrace.end();
        }
    }

    public void delete(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"deleteDistribution");
        try {
            Distribution distribution = this.getDistribution(distributionId);
            if (distribution == null) {
                throw new CloudException("No such distribution: " + distributionId);
            }
            if (distribution.isActive()) {
                String name = distribution.getName();
                if (name == null) {
                    name = distributionId;
                }
                this.update(distributionId, name, false, distribution.getAliases());
            }
            do {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            } while ((distribution = this.getDistribution(distributionId)) != null && distribution.isActive());
            while (true) {
                HashMap<String, String> headers = new HashMap<String, String>();
                String etag = (String)this.getDistributionWithEtag(distributionId)[1];
                headers.put("If-Match", etag);
                CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.DELETE_DISTRIBUTION, headers, null);
                try {
                    method.invoke(distributionId);
                    return;
                }
                catch (CloudFrontException e) {
                    String code = e.getCode();
                    if (code != null && code.equals("DistributionNotDisabled")) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interrupt) {}
                        continue;
                    }
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                break;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Distribution getDistribution(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getDistribution");
        try {
            Object[] parts = this.getDistributionWithEtag(distributionId);
            if (parts.length < 1) {
                Distribution distribution = null;
                return distribution;
            }
            Distribution distribution = (Distribution)parts[0];
            return distribution;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private Object[] getDistributionWithEtag(@Nonnull String distributionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getDistributionWithEtag");
        try {
            CloudFrontMethod.CloudFrontResponse response;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.GET_DISTRIBUTION, null, null);
            try {
                response = method.invoke(distributionId);
            }
            catch (CloudFrontException e) {
                String code = e.getCode();
                if (code != null && code.equals("NoSuchDistribution")) {
                    Object[] objectArray = new Object[]{null, null, null};
                    APITrace.end();
                    return objectArray;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("Distribution");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Distribution dist = this.toDistributionFromInfo(ctx, blocks.item(i));
                if (dist == null || !distributionId.equals(dist.getProviderDistributionId())) continue;
                String callerReference = null;
                blocks = response.document.getElementsByTagName("CallerReference");
                if (blocks.getLength() > 0) {
                    callerReference = blocks.item(0).getFirstChild().getNodeValue();
                }
                Object[] objectArray = new Object[]{dist, response.etag, callerReference};
                return objectArray;
            }
            Object[] objectArray = new Object[]{};
            return objectArray;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDistribution(@Nonnull Locale locale) {
        return "distribution";
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedCDN");
        try {
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.LIST_DISTRIBUTIONS, null, null);
            try {
                method.invoke(new String[0]);
                boolean bl = true;
                return bl;
            }
            catch (CloudFrontException e) {
                block10: {
                    block9: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block9;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.warn((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Distribution> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listDistributions");
        try {
            CloudFrontMethod.CloudFrontResponse response;
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.LIST_DISTRIBUTIONS, null, null);
            ArrayList<Distribution> list = new ArrayList<Distribution>();
            try {
                response = method.invoke(new String[0]);
            }
            catch (CloudFrontException e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("DistributionSummary");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Distribution dist = this.toDistributionFromSummary(blocks.item(i));
                if (dist == null) continue;
                list.add(dist);
            }
            ArrayList<Distribution> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<ResourceStatus> listDistributionStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"listDistributionStatus");
        try {
            CloudFrontMethod.CloudFrontResponse response;
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.LIST_DISTRIBUTIONS, null, null);
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            try {
                response = method.invoke(new String[0]);
            }
            catch (CloudFrontException e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("DistributionSummary");
            for (int i = 0; i < blocks.getLength(); ++i) {
                ResourceStatus status = this.toStatus(blocks.item(i));
                if (status == null) continue;
                list.add(status);
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)CDNSupport.ANY)) {
            return new String[]{"cloudfront:*"};
        }
        if (action.equals((Object)CDNSupport.CREATE_DISTRIBUTION)) {
            return new String[]{"cloudfront:CreateDistribution"};
        }
        if (action.equals((Object)CDNSupport.GET_DISTRIBUTION)) {
            return new String[]{"cloudfront:GetDistribution"};
        }
        if (action.equals((Object)CDNSupport.LIST_DISTRIBUTION)) {
            return new String[]{"cloudfront:ListDistributions"};
        }
        if (action.equals((Object)CDNSupport.REMOVE_DISTRIBUTION)) {
            return new String[]{"cloudfront:DeleteDistribution"};
        }
        return new String[0];
    }

    public void update(@Nonnull String distributionId, @Nonnull String name, boolean active, String ... cnames) throws InternalException, CloudException {
        this.updateWithReturn(distributionId, name, active, cnames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateWithReturn(@Nonnull String distributionId, @Nonnull String name, boolean active, String ... cnames) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"updateDistribution");
        try {
            CloudFrontMethod.CloudFrontResponse response;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was established for this request");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            Object[] distData = this.getDistributionWithEtag(distributionId);
            Distribution distribution = (Distribution)distData[0];
            String location = distribution == null ? null : distribution.getLocation();
            String[] parts = location == null ? new String[]{} : location.split("\\.");
            String bucket = parts[0];
            headers.put("If-Match", (String)distData[1]);
            String logDirectory = distribution == null ? null : distribution.getLogDirectory();
            String logName = distribution == null ? null : distribution.getLogName();
            CloudFrontMethod method = new CloudFrontMethod(this.provider, CloudFrontAction.UPDATE_DISTRIBUTION, headers, this.toConfigXml(bucket, name, (String)distData[2], logDirectory, logName, active, cnames));
            try {
                response = method.invoke(distributionId, "config");
            }
            catch (CloudFrontException e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("Distribution");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Distribution dist = this.toDistributionFromInfo(ctx, blocks.item(i));
                if (dist == null) continue;
                String string = response.etag;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String toConfigXml(@Nonnull String bucket, @Nonnull String name, @Nullable String callerReference, @Nullable String logDirectory, @Nullable String logName, boolean active, String ... cnames) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        xml.append("<DistributionConfig xmlns=\"http://cloudfront.amazonaws.com/doc/2009-04-02/\">\r\n");
        xml.append("<Origin>");
        xml.append(this.toXml(bucket));
        xml.append(".s3.amazonaws.com");
        xml.append("</Origin>\r\n");
        xml.append("<CallerReference>");
        xml.append(callerReference == null ? String.valueOf(System.currentTimeMillis()) : callerReference);
        xml.append("</CallerReference>\r\n");
        if (cnames != null) {
            for (String cname : cnames) {
                xml.append("<CNAME>");
                xml.append(this.toXml(cname));
                xml.append("</CNAME>\r\n");
            }
        }
        xml.append("<Comment>");
        xml.append(this.toXml(name));
        xml.append("</Comment>\r\n");
        xml.append("<Enabled>");
        xml.append(String.valueOf(active));
        xml.append("</Enabled>");
        if (logDirectory != null && logName != null) {
            xml.append("<Logging>\r\n");
            xml.append("<Bucket>");
            xml.append(logDirectory);
            xml.append("</Bucket>\r\n");
            xml.append("<Prefix>");
            xml.append(logName);
            xml.append("</Prefix>\r\n");
            xml.append("</Logging>\r\n");
        }
        xml.append("</DistributionConfig>\r\n");
        return xml.toString();
    }

    @Nullable
    private Distribution toDistributionFromInfo(@Nonnull ProviderContext ctx, @Nullable Node node) {
        if (node == null) {
            return null;
        }
        ArrayList<String> cnames = new ArrayList<String>();
        Distribution distribution = new Distribution();
        NodeList attrs = node.getChildNodes();
        distribution.setProviderOwnerId(ctx.getAccountNumber());
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("Id")) {
                distribution.setProviderDistributionId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("Status")) {
                String s = attr.getFirstChild().getNodeValue();
                distribution.setDeployed(s != null && s.trim().equalsIgnoreCase("deployed"));
                continue;
            }
            if (name.equals("DomainName")) {
                distribution.setDnsName(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!name.equals("DistributionConfig")) continue;
            NodeList configList = attr.getChildNodes();
            for (int j = 0; j < configList.getLength(); ++j) {
                String comment;
                Node config = configList.item(j);
                if (config.getNodeName().equals("Enabled")) {
                    String s = config.getFirstChild().getNodeValue();
                    distribution.setActive(s != null && s.trim().equalsIgnoreCase("true"));
                    continue;
                }
                if (config.getNodeName().equals("Origin")) {
                    String origin = config.getFirstChild().getNodeValue().trim();
                    distribution.setLocation(origin);
                    continue;
                }
                if (config.getNodeName().equals("CNAME")) {
                    cnames.add(config.getFirstChild().getNodeValue().trim());
                    continue;
                }
                if (config.getNodeName().equals("Logging")) {
                    if (!config.hasChildNodes()) continue;
                    NodeList logging = config.getChildNodes();
                    for (int k = 0; k < logging.getLength(); ++k) {
                        Node logInfo = logging.item(k);
                        if (logInfo.getNodeName().equals("Bucket")) {
                            if (!logInfo.hasChildNodes()) continue;
                            distribution.setLogDirectory(logInfo.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (!logInfo.getNodeName().equals("Prefix") || !logInfo.hasChildNodes()) continue;
                        distribution.setLogName(logInfo.getFirstChild().getNodeValue());
                    }
                    continue;
                }
                if (!config.getNodeName().equals("Comment") || !config.hasChildNodes() || (comment = config.getFirstChild().getNodeValue()) == null) continue;
                distribution.setName(comment.trim());
            }
        }
        if (distribution.getName() == null) {
            String name = distribution.getDnsName();
            if (name == null && (name = distribution.getProviderDistributionId()) == null) {
                return null;
            }
            distribution.setName(name);
        }
        String[] aliases = new String[cnames.size()];
        int i = 0;
        for (String cname : cnames) {
            aliases[i++] = cname;
        }
        distribution.setAliases(aliases);
        return distribution;
    }

    private Distribution toDistributionFromSummary(Node node) {
        ArrayList<String> cnames = new ArrayList<String>();
        Distribution distribution = new Distribution();
        NodeList attrs = node.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String comment;
            String s;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("Id")) {
                distribution.setProviderDistributionId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("Status")) {
                s = attr.getFirstChild().getNodeValue();
                distribution.setDeployed(s != null && s.trim().equalsIgnoreCase("deployed"));
                continue;
            }
            if (name.equals("Enabled")) {
                s = attr.getFirstChild().getNodeValue();
                distribution.setActive(s != null && s.trim().equalsIgnoreCase("true"));
                continue;
            }
            if (name.equals("DomainName")) {
                distribution.setDnsName(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equals("Origin")) {
                String origin = attr.getFirstChild().getNodeValue().trim();
                distribution.setLocation(origin);
                continue;
            }
            if (name.equals("CNAME")) {
                cnames.add(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!name.equals("Comment") || !attr.hasChildNodes() || (comment = attr.getFirstChild().getNodeValue()) == null) continue;
            distribution.setName(comment.trim());
        }
        if (distribution.getName() == null) {
            String name = distribution.getDnsName();
            if (name == null && (name = distribution.getProviderDistributionId()) == null) {
                return null;
            }
            distribution.setName(name);
        }
        String[] aliases = new String[cnames.size()];
        int i = 0;
        for (String cname : cnames) {
            aliases[i++] = cname;
        }
        distribution.setAliases(aliases);
        return distribution;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String distributionId = null;
        boolean deployed = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("Id")) {
                distributionId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("Status")) continue;
            String s = attr.getFirstChild().getNodeValue();
            deployed = s != null && s.trim().equalsIgnoreCase("deployed");
        }
        if (distributionId == null) {
            return null;
        }
        return new ResourceStatus(distributionId, (Object)deployed);
    }

    private String toXml(String value) {
        return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

