/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.platform;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.platform.CloudFrontAction;
import org.dasein.cloud.aws.platform.CloudFrontException;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.CDNSupport;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CloudFrontMethod {
    private static final Logger logger = Logger.getLogger(CloudFrontMethod.class);
    public static final String CF_PREFIX = "cloudfront:";
    public static final String CLOUD_FRONT_URL = "https://cloudfront.amazonaws.com";
    public static final String CF_VERSION = "2010-05-01";
    private CloudFrontAction action = null;
    private int attempts = 0;
    private String body = null;
    private Map<String, String> headers = null;
    private AWSCloud provider = null;

    @Nonnull
    public static ServiceAction[] asCloudFrontServiceAction(@Nonnull String action) {
        if (action.equals("CreateDistribution")) {
            return new ServiceAction[]{CDNSupport.CREATE_DISTRIBUTION};
        }
        if (action.equals("GetDistribution")) {
            return new ServiceAction[]{CDNSupport.GET_DISTRIBUTION};
        }
        if (action.equals("ListDistributions")) {
            return new ServiceAction[]{CDNSupport.LIST_DISTRIBUTION};
        }
        if (action.equals("DeleteDistribution")) {
            return new ServiceAction[]{CDNSupport.REMOVE_DISTRIBUTION};
        }
        return new ServiceAction[0];
    }

    public CloudFrontMethod(AWSCloud provider, CloudFrontAction action, Map<String, String> headers, String body) {
        this.action = action;
        this.headers = headers;
        this.body = body;
        this.provider = provider;
    }

    private String getDate() throws CloudException {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return fmt.format(new Date());
    }

    @Nonnull
    protected HttpClient getClient(String url) throws InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        boolean ssl = url.startsWith("https");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloudFrontResponse invoke(String ... args) throws CloudFrontException, CloudException, InternalException {
        int status;
        HttpResponse httpResponse;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("Context not specified for this request");
        }
        StringBuilder url = new StringBuilder();
        String dateString = this.getDate();
        url.append("https://cloudfront.amazonaws.com/2010-05-01/distribution");
        if (args != null && args.length > 0) {
            for (String arg : args) {
                url.append("/");
                url.append(arg);
            }
        }
        HttpRequestBase method = this.action.getMethod(url.toString());
        method.addHeader("x-amz-date", dateString);
        try {
            String signature = this.provider.signCloudFront(new String(ctx.getAccessPublic(), "utf-8"), ctx.getAccessPrivate(), dateString);
            method.addHeader("Authorization", signature);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                method.addHeader(entry.getKey(), entry.getValue());
            }
        }
        if (this.body != null) {
            try {
                ((HttpEntityEnclosingRequestBase)method).setEntity((HttpEntity)new StringEntity(this.body, "application/xml", "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        ++this.attempts;
        HttpClient client = this.getClient(url.toString());
        CloudFrontResponse response = new CloudFrontResponse();
        try {
            APITrace.trace((CloudProvider)this.provider, (String)this.action.toString());
            httpResponse = client.execute((HttpUriRequest)method);
            status = httpResponse.getStatusLine().getStatusCode();
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        Header header = httpResponse.getFirstHeader("ETag");
        response.etag = header != null ? header.getValue() : null;
        if (status == 200 || status == 201 || status == 202) {
            CloudFrontResponse e2;
            InputStream input;
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                throw new CloudFrontException(status, null, null, "NoResponse", "No response body was specified");
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e2) {
                throw new CloudException((Throwable)e2);
            }
            try {
                response.document = this.parseResponse(input);
                e2 = response;
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    logger.error((Object)e3);
                    e3.printStackTrace();
                    throw new CloudException((Throwable)e3);
                }
            }
            input.close();
            return e2;
        }
        if (status == 204) {
            return null;
        }
        if (status == 503 || status == 500) {
            if (this.attempts >= 5) {
                String msg = status == 503 ? "Cloud service is currently unavailable." : "The cloud service encountered a server error while processing your request.";
                logger.error((Object)msg);
                throw new CloudException(msg);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            return this.invoke(args);
        }
        try {
            Document doc;
            InputStream input;
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                throw new CloudFrontException(status, null, null, "NoResponse", "No response body was specified");
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                throw new CloudException((Throwable)e);
            }
            try {
                doc = this.parseResponse(input);
            }
            finally {
                input.close();
            }
            if (doc != null) {
                String code = null;
                String message = null;
                String requestId = null;
                String type = null;
                NodeList blocks = doc.getElementsByTagName("Error");
                if (blocks.getLength() > 0) {
                    Node error = blocks.item(0);
                    NodeList attrs = error.getChildNodes();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node attr = attrs.item(i);
                        if (attr.getNodeName().equals("Code")) {
                            code = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (attr.getNodeName().equals("Type")) {
                            type = attr.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!attr.getNodeName().equals("Message")) continue;
                        message = attr.getFirstChild().getNodeValue().trim();
                    }
                }
                if ((blocks = doc.getElementsByTagName("RequestId")).getLength() > 0) {
                    Node id = blocks.item(0);
                    requestId = id.getFirstChild().getNodeValue().trim();
                }
                if (message == null) {
                    throw new CloudException("Unable to identify error condition: " + status + "/" + requestId + "/" + code);
                }
                throw new CloudFrontException(status, requestId, type, code, message);
            }
            throw new CloudException("Unable to parse error.");
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
    }

    private Document parseResponse(InputStream responseBodyAsStream) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            return XMLParser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
    }

    public static class CloudFrontResponse {
        public Document document;
        public String etag;
    }
}

