/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.DayOfWeek;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.TimeWindow;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.ConfigurationParameter;
import org.dasein.cloud.platform.Database;
import org.dasein.cloud.platform.DatabaseConfiguration;
import org.dasein.cloud.platform.DatabaseEngine;
import org.dasein.cloud.platform.DatabaseProduct;
import org.dasein.cloud.platform.DatabaseSnapshot;
import org.dasein.cloud.platform.DatabaseSnapshotState;
import org.dasein.cloud.platform.DatabaseState;
import org.dasein.cloud.platform.RelationalDatabaseSupport;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RDS
implements RelationalDatabaseSupport {
    private static final Logger logger = AWSCloud.getLogger(RDS.class);
    public static final String AUTHORIZE_DB_SECURITY_GROUP_INGRESS = "AuthorizeDBSecurityGroupIngress";
    public static final String CREATE_DB_INSTANCE = "CreateDBInstance";
    public static final String CREATE_DB_PARAMETER_GROUP = "CreateDBParameterGroup";
    public static final String CREATE_DB_SECURITY_GROUP = "CreateDBSecurityGroup";
    public static final String CREATE_DB_SNAPSHOT = "CreateDBSnapshot";
    public static final String DELETE_DB_INSTANCE = "DeleteDBInstance";
    public static final String DELETE_DB_PARAMETER_GROUP = "DeleteDBParameterGroup";
    public static final String DELETE_DB_SECURITY_GROUP = "DeleteDBSecurityGroup";
    public static final String DELETE_DB_SNAPSHOT = "DeleteDBSnapshot";
    public static final String DESCRIBE_DB_ENGINE_VERSIONS = "DescribeDBEngineVersions";
    public static final String DESCRIBE_DB_INSTANCES = "DescribeDBInstances";
    public static final String DESCRIBE_ENGINE_DEFAULT_PARAMETERS = "DescribeEngineDefaultParameters";
    public static final String DESCRIBE_DB_PARAMETER_GROUPS = "DescribeDBParameterGroups";
    public static final String DESCRIBE_DB_PARAMETERS = "DescribeDBParameters";
    public static final String DESCRIBE_DB_SECURITY_GROUPS = "DescribeDBSecurityGroups";
    public static final String DESCRIBE_DB_SNAPSHOTS = "DescribeDBSnapshots";
    public static final String DESCRIBE_DB_EVENTS = "DescribeDBEvents";
    public static final String MODIFY_DB_INSTANCE = "ModifyDBInstance";
    public static final String MODIFY_DB_PARAMETER_GROUP = "ModifyDBParameterGroup";
    public static final String REBOOT_DB_INSTANCE = "RebootDBInstance";
    public static final String RESET_DB_PARAMETER_GROUP = "ResetDBParameterGroup";
    public static final String RESTORE_DB_INSTANCE_FROM_SNAPSHOT = "RestoreDBInstanceFromDBSnapshot";
    public static final String RESTORE_DB_INSTANCE_TO_TIME = "RestoreDBInstanceToPointInTime";
    public static final String REVOKE_DB_SECURITY_GROUP_INGRESS = "RevokeDBSecurityGroupIngress";
    private AWSCloud provider;
    private static volatile ArrayList<DatabaseEngine> engines = null;
    private static volatile HashMap<DatabaseEngine, String> defaultVersions = new HashMap();
    private static volatile HashMap<DatabaseEngine, Collection<String>> engineVersions = new HashMap();
    private volatile ArrayList<DatabaseProduct> databaseProducts = null;

    @Nonnull
    public static ServiceAction[] asRDSServiceAction(@Nonnull String action) {
        return null;
    }

    RDS(AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccess(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"addDatabaseAccessRule");
        try {
            String id;
            Iterator<String> securityGroups = this.getSecurityGroups(providerDatabaseId).iterator();
            if (!securityGroups.hasNext()) {
                id = this.createSecurityGroup(providerDatabaseId);
                this.setSecurityGroup(providerDatabaseId, id);
            } else {
                id = securityGroups.next();
            }
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), AUTHORIZE_DB_SECURITY_GROUP_INGRESS);
            parameters.put("DBSecurityGroupName", id);
            parameters.put("CIDRIP", sourceCidr);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.equals("AuthorizationAlreadyExists")) {
                    APITrace.end();
                    return;
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    private String getWindowString(TimeWindow window) {
        StringBuilder str = new StringBuilder();
        if (window.getStartDayOfWeek() == null) {
            str.append("*");
        } else {
            str.append(window.getStartDayOfWeek().getShortString());
        }
        str.append(":");
        str.append(String.valueOf(window.getStartHour()));
        str.append(":");
        str.append(String.valueOf(window.getStartMinute()));
        str.append("-");
        if (window.getEndDayOfWeek() == null) {
            str.append("*");
        } else {
            str.append(window.getEndDayOfWeek().getShortString());
        }
        str.append(":");
        str.append(String.valueOf(window.getEndHour()));
        str.append(":");
        str.append(String.valueOf(window.getEndMinute()));
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterDatabase(String providerDatabaseId, boolean applyImmediately, String productSize, int storageInGigabytes, String configurationId, String newAdminUser, String newAdminPassword, int newPort, int snapshotRetentionInDays, TimeWindow preferredMaintenanceWindow, TimeWindow preferredBackupWindow) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"alterDatabase");
        try {
            String window;
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), MODIFY_DB_INSTANCE);
            parameters.put("DBInstanceIdentifier", providerDatabaseId);
            parameters.put("ApplyImmediately", String.valueOf(applyImmediately));
            if (configurationId != null) {
                parameters.put("DBParameterGroupName", configurationId);
            }
            if (preferredMaintenanceWindow != null) {
                window = this.getWindowString(preferredMaintenanceWindow);
                parameters.put("PreferredMaintenanceWindow", window);
            }
            if (preferredBackupWindow != null) {
                window = this.getWindowString(preferredBackupWindow);
                parameters.put("PreferredBackupWindow", window);
            }
            if (newAdminPassword != null) {
                parameters.put("MasterUserPassword", newAdminPassword);
            }
            if (storageInGigabytes > 0) {
                parameters.put("AllocatedStorage", String.valueOf(storageInGigabytes));
            }
            if (productSize != null) {
                parameters.put("DBInstanceClass", productSize);
            }
            if (snapshotRetentionInDays > -1) {
                parameters.put("BackupRetentionPeriod", String.valueOf(snapshotRetentionInDays));
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createSecurityGroup(String id) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDatabaseSecurityGroup");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), CREATE_DB_SECURITY_GROUP);
            parameters.put("DBSecurityGroupName", id);
            parameters.put("DBSecurityGroupDescription", "Auto-generated DB security group for " + id);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                String code = e.getCode();
                if (code != null && code.equals("DBSecurityGroupAlreadyExists")) {
                    String string = id;
                    APITrace.end();
                    return string;
                }
                throw new CloudException((Throwable)e);
            }
            String string = id;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromScratch(String databaseName, DatabaseProduct product, String engineVersion, String withAdminUser, String withAdminPassword, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDatabaseFromScratch");
        try {
            Document doc;
            int size;
            String id = this.toIdentifier(databaseName);
            if (engineVersion == null) {
                engineVersion = this.getDefaultVersion(product.getEngine());
            }
            if ((size = product.getStorageInGigabytes()) < 5) {
                size = 5;
            }
            String securityGroupId = this.createSecurityGroup(id);
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), CREATE_DB_INSTANCE);
            parameters.put("DBInstanceIdentifier", id);
            parameters.put("AllocatedStorage", String.valueOf(size));
            parameters.put("DBInstanceClass", product.getProductSize());
            parameters.put("Engine", this.getEngineString(product.getEngine()));
            parameters.put("EngineVersion", engineVersion);
            parameters.put("MasterUsername", withAdminUser);
            parameters.put("MasterUserPassword", withAdminPassword);
            parameters.put("Port", String.valueOf(hostPort));
            parameters.put("DBSecurityGroups.member.1", securityGroupId);
            if (product.getEngine().isMySQL()) {
                parameters.put("LicenseModel", "general-public-license");
            } else if (product.getEngine().equals((Object)DatabaseEngine.ORACLE11G)) {
                parameters.put("LicenseModel", "license-included");
            } else {
                parameters.put("LicenseModel", "bring-your-own-license");
            }
            if (product.isHighAvailability() || product.getProviderDataCenterId() == null) {
                parameters.put("MultiAZ", "true");
            } else {
                parameters.put("AvailabilityZone", product.getProviderDataCenterId());
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBInstanceIdentifier");
            if (blocks.getLength() > 0) {
                String string = blocks.item(0).getFirstChild().getNodeValue().trim();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromLatest(String databaseName, String providerDatabaseId, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDatabaseFromLatest");
        try {
            Document doc;
            String id = this.toIdentifier(databaseName);
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), RESTORE_DB_INSTANCE_TO_TIME);
            parameters.put("SourceDBInstanceIdentifier", providerDatabaseId);
            parameters.put("UseLatestRestorableTime", "True");
            parameters.put("TargetDBInstanceIdentifier", id);
            parameters.put("DBInstanceClass", productSize);
            parameters.put("Port", String.valueOf(hostPort));
            if (providerDataCenterId == null) {
                parameters.put("MultiAZ", "true");
            } else {
                parameters.put("AvailabilityZone", providerDataCenterId);
                parameters.put("MultiAZ", "false");
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBInstanceIdentifier");
            if (blocks.getLength() > 0) {
                String string = id;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromSnapshot(String databaseName, String providerDatabaseId, String providerDbSnapshotId, String productSize, String providerDataCenterId, int hostPort) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDatabaseFromSnapshot");
        try {
            Document doc;
            String id = this.toIdentifier(databaseName);
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), RESTORE_DB_INSTANCE_FROM_SNAPSHOT);
            parameters.put("DBSnapshotIdentifier", providerDbSnapshotId);
            parameters.put("DBInstanceIdentifier", id);
            parameters.put("DBInstanceClass", productSize);
            parameters.put("Port", String.valueOf(hostPort));
            if (providerDataCenterId == null) {
                parameters.put("MultiAZ", "true");
            } else {
                parameters.put("AvailabilityZone", providerDataCenterId);
                parameters.put("MultiAZ", "false");
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBInstanceIdentifier");
            if (blocks.getLength() > 0) {
                String string = id;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFromTimestamp(String databaseName, String providerDatabaseId, long beforeTimestamp, String productSize, String providerDataCenterId, int hostPort) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"createDatabaseFromTimestamp");
        try {
            Document doc;
            String id = this.toIdentifier(databaseName);
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), RESTORE_DB_INSTANCE_TO_TIME);
            parameters.put("SourceDBInstanceIdentifier", providerDatabaseId);
            parameters.put("RestoreTime", this.provider.getTimestamp(beforeTimestamp, false));
            parameters.put("TargetDBInstanceIdentifier", id);
            parameters.put("DBInstanceClass", productSize);
            parameters.put("Port", String.valueOf(hostPort));
            if (providerDataCenterId == null) {
                parameters.put("MultiAZ", "true");
            } else {
                parameters.put("AvailabilityZone", providerDataCenterId);
                parameters.put("MultiAZ", "false");
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBInstanceIdentifier");
            if (blocks.getLength() > 0) {
                String string = id;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public DatabaseConfiguration getConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        if (providerConfigurationId == null) {
            return null;
        }
        final String id = providerConfigurationId;
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DatabaseConfiguration>(){

            public void populate(Jiterator<DatabaseConfiguration> iterator) throws CloudException, InternalException {
                RDS.this.populateConfigurationList(id, (Jiterator<DatabaseConfiguration>)iterator);
            }
        });
        populator.populate();
        Iterator it = populator.getResult().iterator();
        if (it.hasNext()) {
            return (DatabaseConfiguration)it.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getDatabase(String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getDatabase");
        try {
            if (providerDatabaseId == null) {
                Database database = null;
                return database;
            }
            for (Database database : this.listDatabases(providerDatabaseId)) {
                if (!database.getProviderDatabaseId().equals(providerDatabaseId)) continue;
                Database database2 = database;
                return database2;
            }
            Database database = null;
            return database;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<DatabaseEngine> getDatabaseEngines() {
        ArrayList<Object> tmp = engines;
        if (tmp == null) {
            tmp = new ArrayList();
            tmp.add(DatabaseEngine.MYSQL);
            tmp.add(DatabaseEngine.ORACLE11G);
            tmp.add(DatabaseEngine.ORACLE11GX);
            tmp.add(DatabaseEngine.ORACLE11GEX);
            engines = tmp;
        }
        return engines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultVersion(DatabaseEngine forEngine) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getDefaultVersion");
        try {
            Iterator<String> i$;
            String version = defaultVersions.get(forEngine);
            if (version == null) {
                Document doc;
                Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_ENGINE_VERSIONS);
                parameters.put("Engine", this.getEngineString(forEngine));
                parameters.put("DefaultOnly", "true");
                EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = doc.getElementsByTagName("DBEngineVersions");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    NodeList items = blocks.item(i).getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        Node item = items.item(j);
                        if (!item.getNodeName().equals("DBEngineVersion")) continue;
                        NodeList attrs = item.getChildNodes();
                        for (int k = 0; k < attrs.getLength(); ++k) {
                            Node attr = attrs.item(k);
                            if (!attr.getNodeName().equals("EngineVersion")) continue;
                            version = attr.getFirstChild().getNodeValue().trim();
                            defaultVersions.put(forEngine, version);
                            String string = version;
                            return string;
                        }
                    }
                }
            }
            if (version == null && (i$ = this.getSupportedVersions(forEngine).iterator()).hasNext()) {
                String v;
                String string = v = i$.next();
                return string;
            }
            String string = version;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getSupportedVersions(DatabaseEngine forEngine) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"getSupportedVersions");
        try {
            Collection<String> versions = engineVersions.get(forEngine);
            if (versions == null) {
                ArrayList<String> list = new ArrayList<String>();
                String marker = null;
                do {
                    int i;
                    Document doc;
                    Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_ENGINE_VERSIONS);
                    parameters.put("Engine", this.getEngineString(forEngine));
                    EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                    try {
                        doc = method.invoke();
                    }
                    catch (EC2Exception e) {
                        throw new CloudException((Throwable)e);
                    }
                    marker = null;
                    NodeList blocks = doc.getElementsByTagName("Marker");
                    if (blocks.getLength() > 0) {
                        for (i = 0; i < blocks.getLength(); ++i) {
                            Node item = blocks.item(i);
                            if (!item.hasChildNodes()) continue;
                            marker = item.getFirstChild().getNodeValue().trim();
                        }
                        if (marker != null) break;
                    }
                    blocks = doc.getElementsByTagName("DBEngineVersions");
                    for (i = 0; i < blocks.getLength(); ++i) {
                        NodeList items = blocks.item(i).getChildNodes();
                        for (int j = 0; j < items.getLength(); ++j) {
                            Node item = items.item(j);
                            if (!item.getNodeName().equals("DBEngineVersion")) continue;
                            NodeList attrs = item.getChildNodes();
                            for (int k = 0; k < attrs.getLength(); ++k) {
                                Node attr = attrs.item(k);
                                if (!attr.getNodeName().equals("EngineVersion")) continue;
                                list.add(attr.getFirstChild().getNodeValue().trim());
                            }
                        }
                    }
                } while (marker != null);
                if (list.isEmpty()) {
                    List<String> list2 = Collections.emptyList();
                    return list2;
                }
                versions = list;
                engineVersions.put(forEngine, versions);
            }
            Collection<String> collection = versions;
            return collection;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<DatabaseProduct> getDatabaseProducts(DatabaseEngine engine) {
        ArrayList<Object> products = this.databaseProducts;
        if (products == null) {
            boolean us = this.provider.getContext().getRegionId().equals("us-east-1");
            products = new ArrayList();
            if (engine.equals((Object)DatabaseEngine.MYSQL) || engine.equals((Object)DatabaseEngine.MYSQL51) || engine.equals((Object)DatabaseEngine.MYSQL55)) {
                DatabaseProduct product = new DatabaseProduct("db.m1.small", "64-bit, 1.7GB RAM, 1x1.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.11f : 0.12f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.small", "Multi-AZ 64-bit, 1.7GB RAM, 1x1.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 0.22f : 0.24f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.large", "64-bit, 7.5GB RAM, 2x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.44f : 0.48f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.large", "Multi-AZ 64-bit, 7.5GB RAM, 2x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 0.88f : 0.96f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.xlarge", "64-bit, 15.0GB RAM, 4x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.88f : 0.97f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.xlarge", "Multi-AZ 64-bit, 15.0GB RAM, 4x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 1.66f : 1.94f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.xlarge", "64-bit, 17.1GB RAM, 2x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.65f : 0.74f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.xlarge", "Multi-AZ 64-bit, 17.1GB RAM, 2x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 1.3f : 1.48f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.2xlarge", "64-bit, 34GB RAM, 4x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 1.3f : 1.48f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.2xlarge", "64-bit, 34GB RAM, 4x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 2.6f : 2.96f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.4xlarge", "64-bit, 68GB RAM, 8x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 2.6f : 2.96f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.4xlarge", "Multi-AZ 64-bit, 68GB RAM, 8x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(true);
                product.setStandardHourlyRate(us ? 5.2f : 5.92f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
            } else if (engine.equals((Object)DatabaseEngine.ORACLE11G)) {
                DatabaseProduct product = new DatabaseProduct("db.m1.small", "64-bit, 1.7GB RAM, 1x1.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.16f : 0.17f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.large", "64-bit, 7.5GB RAM, 2x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.64f : 0.68f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.xlarge", "64-bit, 15GB RAM, 4x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.85f : 0.94f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.2xlarge", "64-bit, 34GB RAM, 4x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 1.7f : 1.88f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.4xlarge", "64-bit, 68GB RAM, 8x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 3.4f : 3.76f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
            } else if (engine.equals((Object)DatabaseEngine.ORACLE11GX) || engine.equals((Object)DatabaseEngine.ORACLE11GEX)) {
                DatabaseProduct product = new DatabaseProduct("db.m1.small", "64-bit, 1.7GB RAM, 1x1.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.11f : 0.12f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m1.large", "64-bit, 7.5GB RAM, 2x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.44f : 0.48f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.xlarge", "64-bit, 15GB RAM, 4x2.0 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 0.65f : 0.74f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.2xlarge", "64-bit, 34GB RAM, 4x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setHighAvailability(false);
                product.setStandardHourlyRate(us ? 1.3f : 1.48f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
                product = new DatabaseProduct("db.m2.4xlarge", "64-bit, 68GB RAM, 8x3.25 GHz CPU Core");
                product.setEngine(engine);
                product.setStandardHourlyRate(us ? 2.6f : 2.96f);
                product.setStandardIoRate(us ? 0.1f : 0.11f);
                product.setStandardStorageRate(us ? 0.1f : 0.11f);
                product.setStorageInGigabytes(0);
                products.add(product);
            }
            this.databaseProducts = products;
        }
        return this.databaseProducts;
    }

    private DayOfWeek getDay(String str) {
        if (str.equalsIgnoreCase("Sun")) {
            return DayOfWeek.SUNDAY;
        }
        if (str.equalsIgnoreCase("Mon")) {
            return DayOfWeek.MONDAY;
        }
        if (str.equalsIgnoreCase("Tue")) {
            return DayOfWeek.TUESDAY;
        }
        if (str.equalsIgnoreCase("Wed")) {
            return DayOfWeek.WEDNESDAY;
        }
        if (str.equalsIgnoreCase("Thu")) {
            return DayOfWeek.THURSDAY;
        }
        if (str.equalsIgnoreCase("Fri")) {
            return DayOfWeek.FRIDAY;
        }
        if (str.equalsIgnoreCase("Sat")) {
            return DayOfWeek.SATURDAY;
        }
        return null;
    }

    private TimeWindow getTimeWindow(String start, String end) {
        String[] parts = start.split(":");
        int startHour = 0;
        int endHour = 0;
        int startMinute = 0;
        int endMinute = 0;
        DayOfWeek startDay = null;
        DayOfWeek endDay = null;
        if (parts.length < 3) {
            if (parts.length < 2) {
                try {
                    startHour = Integer.parseInt(start);
                }
                catch (NumberFormatException ignore) {}
            } else {
                try {
                    startHour = Integer.parseInt(parts[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                try {
                    startMinute = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {}
            }
        } else {
            startDay = this.getDay(parts[0]);
            try {
                startHour = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            try {
                startMinute = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        parts = end.split(":");
        if (parts.length < 3) {
            if (parts.length < 2) {
                try {
                    endHour = Integer.parseInt(start);
                }
                catch (NumberFormatException ignore) {}
            } else {
                try {
                    endHour = Integer.parseInt(parts[0]);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
                try {
                    endMinute = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {}
            }
        } else {
            endDay = this.getDay(parts[0]);
            try {
                endHour = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            try {
                endMinute = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        TimeWindow window = new TimeWindow();
        window.setStartDayOfWeek(startDay);
        window.setStartHour(startHour);
        window.setStartMinute(startMinute);
        window.setEndDayOfWeek(endDay);
        window.setEndHour(endHour);
        window.setEndMinute(endMinute);
        return window;
    }

    private String getEngineString(DatabaseEngine engine) {
        switch (engine) {
            case MYSQL: {
                return "MySQL";
            }
            case ORACLE11G: {
                return "oracle-se1";
            }
            case ORACLE11GX: {
                return "oracle-se";
            }
            case ORACLE11GEX: {
                return "oracle-ee";
            }
        }
        return "MySQL";
    }

    public String getProviderTermForDatabase(Locale locale) {
        return "database";
    }

    public String getProviderTermForSnapshot(Locale locale) {
        return "snapshot";
    }

    private String getRDSUrl() throws InternalException, CloudException {
        return "https://rds." + this.provider.getContext().getRegionId() + ".amazonaws.com";
    }

    private Iterable<String> getSecurityGroups(String databaseId) throws CloudException, InternalException {
        final String dbId = databaseId;
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<String>(){

            public void populate(Jiterator<String> iterator) throws CloudException, InternalException {
                RDS.this.populateSecurityGroupIds(dbId, (Jiterator<String>)iterator);
            }
        });
        populator.populate();
        return populator.getResult();
    }

    public DatabaseSnapshot getSnapshot(String providerDbSnapshotId) throws CloudException, InternalException {
        if (providerDbSnapshotId == null) {
            return null;
        }
        final String id = providerDbSnapshotId;
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DatabaseSnapshot>(){

            public void populate(Jiterator<DatabaseSnapshot> iterator) throws CloudException, InternalException {
                RDS.this.populateSnapshotList(id, null, (Jiterator<DatabaseSnapshot>)iterator);
            }
        });
        populator.populate();
        Iterator it = populator.getResult().iterator();
        if (it.hasNext()) {
            return (DatabaseSnapshot)it.next();
        }
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedRDS");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_INSTANCES);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block10: {
                    block9: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block9;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.warn((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSupportsFirewallRules() {
        return true;
    }

    public boolean isSupportsHighAvailability() {
        return true;
    }

    public boolean isSupportsLowAvailability() {
        return true;
    }

    public boolean isSupportsMaintenanceWindows() {
        return true;
    }

    public boolean isSupportsSnapshots() {
        return true;
    }

    public Iterable<String> listAccess(String toProviderDatabaseId) throws CloudException, InternalException {
        final String dbId = toProviderDatabaseId;
        PopulatorThread idPopulator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<String>(){

            public void populate(Jiterator<String> iterator) throws CloudException, InternalException {
                RDS.this.populateSecurityGroupIds(dbId, (Jiterator<String>)iterator);
            }
        });
        idPopulator.populate();
        final Collection ids = idPopulator.getResult();
        PopulatorThread accessPopulator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<String>(){

            public void populate(Jiterator<String> iterator) throws CloudException, InternalException {
                for (String id : ids) {
                    RDS.this.populateAccess(id, (Jiterator<String>)iterator);
                }
            }
        });
        accessPopulator.populate();
        return accessPopulator.getResult();
    }

    public Iterable<DatabaseConfiguration> listConfigurations() throws CloudException, InternalException {
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DatabaseConfiguration>(){

            public void populate(Jiterator<DatabaseConfiguration> iterator) throws CloudException, InternalException {
                RDS.this.populateConfigurationList(null, (Jiterator<DatabaseConfiguration>)iterator);
            }
        });
        populator.populate();
        return populator.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listDatabaseStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listDatabaseStatus");
        try {
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            String marker = null;
            do {
                int i;
                Document doc;
                Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_INSTANCES);
                if (marker != null) {
                    parameters.put("Marker", marker);
                }
                EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                marker = null;
                NodeList blocks = doc.getElementsByTagName("Marker");
                if (blocks.getLength() > 0) {
                    for (i = 0; i < blocks.getLength(); ++i) {
                        Node item = blocks.item(i);
                        if (!item.hasChildNodes()) continue;
                        marker = item.getFirstChild().getNodeValue().trim();
                    }
                    if (marker != null) break;
                }
                blocks = doc.getElementsByTagName("DBInstances");
                for (i = 0; i < blocks.getLength(); ++i) {
                    NodeList items = blocks.item(i).getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        ResourceStatus status;
                        Node item = items.item(j);
                        if (!item.getNodeName().equals("DBInstance") || (status = this.toDatabaseStatus(item)) == null) continue;
                        list.add(status);
                    }
                }
            } while (marker != null);
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Iterable<Database> listDatabases() throws CloudException, InternalException {
        return this.listDatabases(null);
    }

    /*
     * Exception decompiling
     */
    private Iterable<Database> listDatabases(String targetId) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Collection<ConfigurationParameter> listParameters(String forProviderConfigurationId) throws CloudException, InternalException {
        final String id = forProviderConfigurationId;
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<ConfigurationParameter>(){

            public void populate(Jiterator<ConfigurationParameter> iterator) throws CloudException, InternalException {
                RDS.this.populateParameterList(id, null, (Jiterator<ConfigurationParameter>)iterator);
                RDS.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    public Collection<ConfigurationParameter> listDefaultParameters(DatabaseEngine engine) throws CloudException, InternalException {
        final DatabaseEngine dbEngine = engine;
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<ConfigurationParameter>(){

            public void populate(Jiterator<ConfigurationParameter> iterator) throws CloudException, InternalException {
                RDS.this.populateParameterList(null, dbEngine, (Jiterator<ConfigurationParameter>)iterator);
                RDS.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    public Iterable<DatabaseSnapshot> listSnapshots(String forOptionalProviderDatabaseId) throws CloudException, InternalException {
        this.provider.hold();
        final String id = forOptionalProviderDatabaseId == null ? null : forOptionalProviderDatabaseId;
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<DatabaseSnapshot>(){

            public void populate(Jiterator<DatabaseSnapshot> iterator) throws CloudException, InternalException {
                RDS.this.populateSnapshotList(null, id, (Jiterator<DatabaseSnapshot>)iterator);
                RDS.this.provider.release();
            }
        });
        populator.populate();
        return populator.getResult();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAccess(String securityGroupId, Jiterator<String> iterator) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateDBSGAccess");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_SECURITY_GROUPS);
            parameters.put("DBSecurityGroupName", securityGroupId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBSecurityGroups");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("DBSecurityGroup")) continue;
                    NodeList attrs = item.getChildNodes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        String name = attr.getNodeName();
                        if (!name.equalsIgnoreCase("IPRanges") || !attr.hasChildNodes()) continue;
                        NodeList ranges = attr.getChildNodes();
                        for (int l = 0; l < ranges.getLength(); ++l) {
                            Node range = ranges.item(l);
                            if (!range.hasChildNodes()) continue;
                            NodeList rangeAttrs = range.getChildNodes();
                            String cidr = null;
                            boolean authorized = false;
                            for (int m = 0; m < rangeAttrs.getLength(); ++m) {
                                Node ra = rangeAttrs.item(m);
                                if (ra.getNodeName().equalsIgnoreCase("Status")) {
                                    authorized = ra.getFirstChild().getNodeValue().trim().equalsIgnoreCase("authorized");
                                    continue;
                                }
                                if (!ra.getNodeName().equalsIgnoreCase("CIDRIP")) continue;
                                cidr = ra.getFirstChild().getNodeValue().trim();
                            }
                            if (cidr == null || !authorized) continue;
                            iterator.push(cidr);
                        }
                    }
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateConfigurationList(String targetId, Jiterator<DatabaseConfiguration> iterator) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateConfigurationList");
        try {
            String marker = null;
            do {
                int i;
                Document doc;
                Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_PARAMETER_GROUPS);
                if (marker != null) {
                    parameters.put("Marker", marker);
                }
                if (targetId != null) {
                    parameters.put("DBParameterGroupName", targetId);
                }
                EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                marker = null;
                NodeList blocks = doc.getElementsByTagName("Marker");
                if (blocks.getLength() > 0) {
                    for (i = 0; i < blocks.getLength(); ++i) {
                        Node item = blocks.item(i);
                        if (!item.hasChildNodes()) continue;
                        marker = item.getFirstChild().getNodeValue().trim();
                    }
                    if (marker != null) {
                        break;
                    }
                }
                blocks = doc.getElementsByTagName("DBParameterGroups");
                for (i = 0; i < blocks.getLength(); ++i) {
                    NodeList items = blocks.item(i).getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        DatabaseConfiguration cfg;
                        Node item = items.item(j);
                        if (!item.getNodeName().equals("DBParameterGroup") || (cfg = this.toConfiguration(item)) == null) continue;
                        iterator.push((Object)cfg);
                    }
                }
            } while (marker != null);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateParameterList(String cfgId, DatabaseEngine engine, Jiterator<ConfigurationParameter> iterator) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateParameterList");
        try {
            String marker = null;
            do {
                int i;
                Document doc;
                Map<String, String> parameters;
                if (cfgId != null) {
                    parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_PARAMETERS);
                    parameters.put("DBParameterGroupName", cfgId);
                } else {
                    parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_ENGINE_DEFAULT_PARAMETERS);
                    parameters.put("Engine", this.getEngineString(engine));
                }
                if (marker != null) {
                    parameters.put("Marker", marker);
                }
                EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                marker = null;
                NodeList blocks = doc.getElementsByTagName("Marker");
                if (blocks.getLength() > 0) {
                    for (i = 0; i < blocks.getLength(); ++i) {
                        Node item = blocks.item(i);
                        if (!item.hasChildNodes()) continue;
                        marker = item.getFirstChild().getNodeValue().trim();
                    }
                    if (marker != null) {
                        break;
                    }
                }
                blocks = doc.getElementsByTagName("Parameters");
                for (i = 0; i < blocks.getLength(); ++i) {
                    NodeList items = blocks.item(i).getChildNodes();
                    for (int j = 0; j < items.getLength(); ++j) {
                        ConfigurationParameter param;
                        Node item = items.item(j);
                        if (!item.getNodeName().equals("Parameter") || (param = this.toParameter(item)) == null) continue;
                        iterator.push((Object)param);
                    }
                }
            } while (marker != null);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSecurityGroupIds(String providerDatabaseId, Jiterator<String> iterator) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"populateDBSecurityGroups");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DESCRIBE_DB_INSTANCES);
            parameters.put("DBInstanceIdentifier", providerDatabaseId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("DBInstances");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("DBInstance")) continue;
                    NodeList attrs = item.getChildNodes();
                    for (int k = 0; k < attrs.getLength(); ++k) {
                        Node attr = attrs.item(k);
                        String name = attr.getNodeName();
                        if (!name.equalsIgnoreCase("DBSecurityGroups") || !attr.hasChildNodes()) continue;
                        NodeList groups = attr.getChildNodes();
                        for (int l = 0; l < groups.getLength(); ++l) {
                            Node group = groups.item(l);
                            if (!group.hasChildNodes()) continue;
                            NodeList groupAttrs = group.getChildNodes();
                            String groupName = null;
                            boolean active = false;
                            for (int m = 0; m < groupAttrs.getLength(); ++m) {
                                Node ga = groupAttrs.item(m);
                                if (ga.getNodeName().equalsIgnoreCase("Status")) {
                                    active = ga.getFirstChild().getNodeValue().trim().equalsIgnoreCase("active");
                                    continue;
                                }
                                if (!ga.getNodeName().equalsIgnoreCase("DBSecurityGroupName")) continue;
                                groupName = ga.getFirstChild().getNodeValue().trim();
                            }
                            if (groupName == null || !active) continue;
                            iterator.push(groupName);
                        }
                    }
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Exception decompiling
     */
    private void populateSnapshotList(String snapshotId, String databaseId, Jiterator<DatabaseSnapshot> iterator) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfiguration(String providerConfigurationId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeDatabaseConfiguration");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DELETE_DB_PARAMETER_GROUP);
            parameters.put("DBParameterGroupName", providerConfigurationId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSecurityGroup(String securityGroupId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeDatabaseSecurityGroup");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DELETE_DB_SECURITY_GROUP);
            parameters.put("DBSecurityGroupName", securityGroupId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(String providerDatabaseId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeDatabase");
        try {
            Iterable<String> securityGroups = this.getSecurityGroups(providerDatabaseId);
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DELETE_DB_INSTANCE);
            parameters.put("DBInstanceIdentifier", providerDatabaseId);
            parameters.put("FinalDBSnapshotIdentifier", providerDatabaseId + "-FINAL-" + System.currentTimeMillis());
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DELETE_DB_INSTANCE);
                parameters.put("DBInstanceIdentifier", providerDatabaseId);
                parameters.put("SkipFinalSnapshot", "true");
                method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception again) {
                    throw new CloudException((Throwable)e);
                }
            }
            try {
                for (String securityGroupId : securityGroups) {
                    if (!securityGroupId.equals(providerDatabaseId)) continue;
                    try {
                        this.removeSecurityGroup(securityGroupId);
                    }
                    catch (CloudException ignore) {}
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSnapshot(String providerSnapshotId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeSnapshot");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), DELETE_DB_SNAPSHOT);
            parameters.put("DBSnapshotIdentifier", providerSnapshotId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConfiguration(String providerConfigurationId, String ... params) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"resetDatabaseConfiguration");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), RESET_DB_PARAMETER_GROUP);
            parameters.put("DBParameterGroupName", providerConfigurationId);
            if (params == null || params.length < 1) {
                parameters.put("ResetAllParameters", "True");
            } else {
                int i = 0;
                parameters.put("ResetAllParameters", "False");
                for (String param : params) {
                    parameters.put("Parameters.member." + ++i + ".ParameterName", param);
                    parameters.put("Parameters.member." + i + ".ApplyMethod", "pending-reboot");
                }
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(String providerDatabaseId, boolean blockUntilDone) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"restartDatabase");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), REBOOT_DB_INSTANCE);
            parameters.put("DBInstanceIdentifier", providerDatabaseId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeAccess(String providerDatabaseId, String sourceCidr) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"revokeDatabaseAccess");
        try {
            EC2Exception error = null;
            for (String securityGroupId : this.getSecurityGroups(providerDatabaseId)) {
                Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), REVOKE_DB_SECURITY_GROUP_INGRESS);
                parameters.put("DBSecurityGroupName", securityGroupId);
                parameters.put("CIDRIP", sourceCidr);
                EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    error = e;
                }
            }
            if (error != null) {
                throw new CloudException(error);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfiguration(String providerConfigurationId, ConfigurationParameter ... params) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"updateDatabaseconfiguration");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), MODIFY_DB_PARAMETER_GROUP);
            parameters.put("DBParameterGroupName", providerConfigurationId);
            int i = 0;
            for (ConfigurationParameter param : params) {
                parameters.put("Parameters.member." + ++i + ".ParameterName", param.getKey());
                parameters.put("Parameters.member." + i + ".ParameterValue", param.getParameter().toString());
                parameters.put("Parameters.member." + i + ".ApplyMethod", param.isApplyImmediately() ? "immediate" : "pending-reboot");
                if (i >= 20) break;
            }
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            if (params.length > 20) {
                ConfigurationParameter[] repeat = new ConfigurationParameter[params.length - 20];
                for (i = 0; i < repeat.length; ++i) {
                    repeat[i] = params[i + 20];
                }
                this.updateConfiguration(providerConfigurationId, params);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSecurityGroup(String id, String securityGroupId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"setDatabaseSecurityGroup");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), MODIFY_DB_INSTANCE);
            parameters.put("DBInstanceIdentifier", id);
            parameters.put("ApplyImmediately", "true");
            parameters.put("DBSecurityGroups.member.1", securityGroupId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseSnapshot snapshot(String providerDatabaseId, String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"snapshotDatabase");
        try {
            Map<String, String> parameters = this.provider.getStandardRdsParameters(this.provider.getContext(), CREATE_DB_SNAPSHOT);
            String id = this.toIdentifier(name);
            parameters.put("DBSnapshotIdentifier", id);
            parameters.put("DBInstanceIdentifier", providerDatabaseId);
            EC2Method method = new EC2Method(this.provider, this.getRDSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            DatabaseSnapshot databaseSnapshot = this.getSnapshot(id);
            return databaseSnapshot;
        }
        finally {
            APITrace.end();
        }
    }

    private DatabaseConfiguration toConfiguration(Node cfgNode) throws CloudException {
        String id = null;
        String cfgName = null;
        String description = null;
        DatabaseEngine engine = DatabaseEngine.MYSQL51;
        NodeList attrs = cfgNode.getChildNodes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("DBParameterGroupName")) {
                cfgName = id = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equalsIgnoreCase("Description")) {
                description = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equals("Engine")) continue;
            String val = attr.getFirstChild().getNodeValue().trim().toLowerCase();
            if (val == null) {
                engine = DatabaseEngine.MYSQL51;
                continue;
            }
            if (val.equalsIgnoreCase("mysql5.1")) {
                engine = DatabaseEngine.MYSQL51;
                continue;
            }
            if (val.equalsIgnoreCase("mysql5.5")) {
                engine = DatabaseEngine.MYSQL55;
                continue;
            }
            if (val.equalsIgnoreCase("oracle-se1")) {
                engine = DatabaseEngine.ORACLE11G;
                continue;
            }
            if (val.equalsIgnoreCase("oracle-se")) {
                engine = DatabaseEngine.ORACLE11GX;
                continue;
            }
            if (!val.equalsIgnoreCase("oracle-ee")) continue;
            engine = DatabaseEngine.ORACLE11GEX;
        }
        if (id == null || cfgName == null) {
            return null;
        }
        if (description == null) {
            description = cfgName;
        }
        return new DatabaseConfiguration((RelationalDatabaseSupport)this, engine, id, cfgName, description);
    }

    private Database toDatabase(Node dbNode) throws CloudException {
        NodeList attrs = dbNode.getChildNodes();
        Database db = new Database();
        String engineVersion = null;
        db.setCreationTimestamp(0L);
        db.setProviderRegionId(this.provider.getContext().getRegionId());
        db.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        for (int i = 0; i < attrs.getLength(); ++i) {
            TimeWindow window;
            int j;
            String val;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("EngineVersion")) {
                val = attr.getFirstChild().getNodeValue().trim();
                if (val == null) continue;
                engineVersion = val.toLowerCase().trim();
                continue;
            }
            if (name.equalsIgnoreCase("Engine")) {
                val = attr.getFirstChild().getNodeValue().trim();
                String string = val = val == null ? "mysql5.1" : val.toLowerCase();
                if (val.startsWith("mysql")) {
                    db.setEngine(DatabaseEngine.MYSQL51);
                    continue;
                }
                if (val.startsWith("mysql5.1")) {
                    db.setEngine(DatabaseEngine.MYSQL51);
                    continue;
                }
                if (val.startsWith("mysql5.5")) {
                    db.setEngine(DatabaseEngine.MYSQL55);
                    continue;
                }
                if (val.startsWith("oracle-se1")) {
                    db.setEngine(DatabaseEngine.ORACLE11G);
                    continue;
                }
                if (val.startsWith("oracle-se")) {
                    db.setEngine(DatabaseEngine.ORACLE11GX);
                    continue;
                }
                if (val.startsWith("oracle-ee")) {
                    db.setEngine(DatabaseEngine.ORACLE11GEX);
                    continue;
                }
                logger.warn((Object)("Unknown database engine: " + val));
                continue;
            }
            if (name.equalsIgnoreCase("DBInstanceIdentifier")) {
                db.setProviderDatabaseId(attr.getFirstChild().getNodeValue().trim());
                db.setName(db.getProviderDatabaseId());
                continue;
            }
            if (name.equalsIgnoreCase("MultiAZ")) {
                db.setHighAvailability(attr.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                continue;
            }
            if (name.equalsIgnoreCase("DBInstanceClass")) {
                db.setProductSize(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("DBInstanceStatus")) {
                db.setCurrentState(this.toDatabaseState(attr.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (name.equalsIgnoreCase("Endpoint")) {
                if (!attr.hasChildNodes()) continue;
                NodeList nodes = attr.getChildNodes();
                for (j = 0; j < nodes.getLength(); ++j) {
                    Node child = nodes.item(j);
                    if (child == null) continue;
                    if (child.getNodeName().equalsIgnoreCase("Port")) {
                        try {
                            db.setHostPort(Integer.parseInt(child.getFirstChild().getNodeValue().trim()));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new CloudException("Invalid storage value: " + child.getFirstChild().getNodeValue());
                        }
                    }
                    if (!child.getNodeName().equalsIgnoreCase("Address")) continue;
                    db.setHostName(child.getFirstChild().getNodeValue().trim());
                }
                continue;
            }
            if (name.equalsIgnoreCase("AllocatedStorage")) {
                try {
                    db.setAllocatedStorageInGb(Integer.parseInt(attr.getFirstChild().getNodeValue().trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new CloudException("Invalid storage value: " + attr.getFirstChild().getNodeValue());
                }
            }
            if (name.equalsIgnoreCase("MasterUsername")) {
                db.setAdminUser(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("PreferredMaintenanceWindow")) {
                String[] parts;
                if (!attr.hasChildNodes() || (val = attr.getFirstChild().getNodeValue()) == null || (parts = val.split("-")).length != 2) continue;
                window = this.getTimeWindow(parts[0], parts[1]);
                db.setMaintenanceWindow(window);
                continue;
            }
            if (name.equalsIgnoreCase("PreferredBackupWindow")) {
                String[] parts;
                if (!attr.hasChildNodes() || (val = attr.getFirstChild().getNodeValue()) == null || (parts = val.split("-")).length != 2) continue;
                window = this.getTimeWindow(parts[0], parts[1]);
                db.setSnapshotWindow(window);
                continue;
            }
            if (name.equalsIgnoreCase("AvailabilityZone")) {
                db.setProviderDataCenterId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("InstanceCreateTime")) {
                String tstr = attr.getFirstChild().getNodeValue().trim();
                db.setCreationTimestamp(this.provider.parseTime(tstr));
                continue;
            }
            if (name.equalsIgnoreCase("LatestRestorableTime")) {
                db.setRecoveryPointTimestamp(this.provider.parseTime(attr.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (name.equalsIgnoreCase("BackupRetentionPeriod")) {
                try {
                    db.setSnapshotRetentionInDays(Integer.parseInt(attr.getFirstChild().getNodeValue().trim()));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new CloudException("Invalid backup retention period: " + attr.getFirstChild().getNodeValue());
                }
            }
            if (!name.equalsIgnoreCase("DBParameterGroups")) continue;
            NodeList groups = attr.getChildNodes();
            for (j = 0; j < groups.getLength(); ++j) {
                Node group = groups.item(j);
                if (!group.getNodeName().equalsIgnoreCase("DBParameterGroup") || !group.hasChildNodes()) continue;
                NodeList nodes = group.getChildNodes();
                for (int k = 0; k < nodes.getLength(); ++k) {
                    Node child = nodes.item(k);
                    if (child == null || !child.getNodeName().equalsIgnoreCase("DBParameterGroupName")) continue;
                    db.setConfiguration(child.getFirstChild().getNodeValue().trim());
                }
            }
        }
        if (db.getHostName() == null) {
            if (db.getCurrentState().equals((Object)DatabaseState.PENDING) || db.getCurrentState().equals((Object)DatabaseState.MODIFYING) || db.getCurrentState().equals((Object)DatabaseState.RESTARTING)) {
                db.setHostName("");
            } else {
                System.out.println("DEBUG: null database for " + db.getCurrentState());
                return null;
            }
        }
        if (engineVersion != null && db.getEngine().isMySQL() && engineVersion.startsWith("5.5")) {
            db.setEngine(DatabaseEngine.MYSQL55);
        }
        return db;
    }

    @Nullable
    private ResourceStatus toDatabaseStatus(@Nullable Node dbNode) throws CloudException {
        NodeList attrs = dbNode.getChildNodes();
        DatabaseState state = DatabaseState.PENDING;
        String dbId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("DBInstanceIdentifier")) {
                dbId = attr.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!name.equalsIgnoreCase("DBInstanceStatus")) continue;
            state = this.toDatabaseState(attr.getFirstChild().getNodeValue().trim());
        }
        if (dbId == null) {
            return null;
        }
        return new ResourceStatus(dbId, (Object)state);
    }

    private DatabaseState toDatabaseState(String value) throws CloudException {
        if (value == null) {
            System.out.println("DEBUG: Null state value");
            return DatabaseState.PENDING;
        }
        if (value.equalsIgnoreCase("available")) {
            return DatabaseState.AVAILABLE;
        }
        if (value.equalsIgnoreCase("backing-up")) {
            return DatabaseState.BACKUP;
        }
        if (value.equalsIgnoreCase("creating")) {
            return DatabaseState.PENDING;
        }
        if (value.equalsIgnoreCase("deleted")) {
            return DatabaseState.DELETED;
        }
        if (value.equalsIgnoreCase("deleting")) {
            return DatabaseState.DELETING;
        }
        if (value.equalsIgnoreCase("failed")) {
            return DatabaseState.FAILED;
        }
        if (value.equalsIgnoreCase("modifying")) {
            return DatabaseState.MODIFYING;
        }
        if (value.equalsIgnoreCase("rebooting")) {
            return DatabaseState.RESTARTING;
        }
        if (value.equalsIgnoreCase("resetting-mastercredentials")) {
            return DatabaseState.AVAILABLE;
        }
        if (value.equalsIgnoreCase("storage-full")) {
            return DatabaseState.STORAGE_FULL;
        }
        System.out.println("DEBUG: Unknown database state: " + value);
        return DatabaseState.PENDING;
    }

    private String toIdentifier(String rawName) {
        StringBuilder str = new StringBuilder();
        if (rawName.length() < 1) {
            return "x";
        }
        if (!Character.isLetter(rawName.charAt(0))) {
            rawName = "db-" + rawName;
        }
        char last = '\u0000';
        for (int i = 0; i < rawName.length(); ++i) {
            char c = rawName.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                str.append(c);
            }
            if (c == '-' && last != '-') {
                str.append(c);
            }
            last = c;
        }
        rawName = str.toString();
        if (rawName.length() > 63) {
            rawName = rawName.substring(0, 63);
        }
        while (rawName.charAt(rawName.length() - 1) == '-') {
            rawName = rawName.substring(0, rawName.length() - 1);
        }
        if (rawName.length() < 1) {
            return "x";
        }
        return rawName;
    }

    private ConfigurationParameter toParameter(Node pNode) throws CloudException {
        ConfigurationParameter param = new ConfigurationParameter();
        NodeList attrs = pNode.getChildNodes();
        param.setModifiable(false);
        param.setApplyImmediately(false);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("ParameterValue")) {
                param.setParameter((Object)attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("DataType")) {
                param.setDataType(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("IsModifiable") && attr.hasChildNodes()) {
                param.setModifiable(attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true"));
                continue;
            }
            if (name.equalsIgnoreCase("Description")) {
                param.setDescription(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("AllowedValues") && attr.hasChildNodes()) {
                param.setValidation(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("ParameterName")) {
                param.setKey(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!name.equalsIgnoreCase("ApplyType") || !attr.hasChildNodes()) continue;
            param.setApplyImmediately(attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("static"));
        }
        return param;
    }

    private DatabaseSnapshot toSnapshot(Node snapshotNode) throws CloudException {
        DatabaseSnapshot snapshot = new DatabaseSnapshot();
        NodeList attrs = snapshotNode.getChildNodes();
        snapshot.setProviderRegionId(this.provider.getContext().getRegionId());
        snapshot.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equalsIgnoreCase("SnapshotCreateTime")) {
                snapshot.setSnapshotTimestamp(this.provider.parseTime(attr.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (name.equalsIgnoreCase("Status")) {
                DatabaseSnapshotState state;
                String value = attr.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("available")) {
                    state = DatabaseSnapshotState.AVAILABLE;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = DatabaseSnapshotState.CREATING;
                } else if (value.equalsIgnoreCase("deleting")) {
                    state = DatabaseSnapshotState.DELETING;
                } else {
                    throw new CloudException("Unknown database snapshot state: " + value);
                }
                snapshot.setCurrentState(state);
                continue;
            }
            if (name.equalsIgnoreCase("MasterUsername")) {
                snapshot.setAdminUser(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("DBInstanceIdentifier")) {
                snapshot.setProviderDatabaseId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (name.equalsIgnoreCase("DBSnapshotIdentifier")) {
                snapshot.setProviderSnapshotId(attr.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!name.equalsIgnoreCase("AllocatedStorage")) continue;
            snapshot.setStorageInGigabytes(Integer.parseInt(attr.getFirstChild().getNodeValue().trim()));
        }
        return snapshot;
    }
}

