/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.platform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.DataFormat;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.EndpointType;
import org.dasein.cloud.platform.PushNotificationSupport;
import org.dasein.cloud.platform.Subscription;
import org.dasein.cloud.platform.Topic;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SNS
implements PushNotificationSupport {
    private static final Logger logger = AWSCloud.getLogger(SNS.class);
    public static final String CONFIRM_SUBSCRIPTION = "ConfirmSubscription";
    public static final String CREATE_TOPIC = "CreateTopic";
    public static final String DELETE_TOPIC = "DeleteTopic";
    public static final String GET_TOPIC_ATTRIBUTES = "GetTopicAttributes";
    public static final String LIST_SUBSCRIPTIONS = "ListSubscriptions";
    public static final String LIST_SUBSCRIPTIONS_BY_TOPIC = "ListSubscriptionsByTopic";
    public static final String LIST_TOPICS = "ListTopics";
    public static final String PUBLISH = "Publish";
    public static final String SET_TOPIC_ATTRIBUTES = "SetTopicAttributes";
    public static final String SUBSCRIBE = "Subscribe";
    public static final String UNSUBSCRIBE = "Unsubscribe";
    private AWSCloud provider = null;

    @Nonnull
    public static ServiceAction[] asSNSServiceAction(@Nonnull String action) {
        if (action.equals(CREATE_TOPIC)) {
            return new ServiceAction[]{PushNotificationSupport.CREATE_TOPIC};
        }
        if (action.equals(DELETE_TOPIC)) {
            return new ServiceAction[]{PushNotificationSupport.REMOVE_TOPIC};
        }
        if (action.equals(LIST_TOPICS)) {
            return new ServiceAction[]{PushNotificationSupport.GET_TOPIC, PushNotificationSupport.LIST_TOPIC};
        }
        if (action.equals(PUBLISH)) {
            return new ServiceAction[]{PushNotificationSupport.PUBLISH};
        }
        if (action.equals(SUBSCRIBE)) {
            return new ServiceAction[]{PushNotificationSupport.SUBSCRIBE};
        }
        return new ServiceAction[0];
    }

    SNS(AWSCloud provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String confirmSubscription(String providerTopicId, String token, boolean authenticateUnsubscribe) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"confirmSubscription");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), CONFIRM_SUBSCRIPTION);
            parameters.put("TopicArn", providerTopicId);
            parameters.put("Token", token);
            if (authenticateUnsubscribe) {
                parameters.put("AuthenticateOnUnsubscribe", "true");
            }
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("ConfirmSubscriptionResult");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                for (int j = 0; j < item.getChildNodes().getLength(); ++j) {
                    Node attr = item.getChildNodes().item(j);
                    String name = attr.getNodeName();
                    if (!name.equals("SubscriptionArn")) continue;
                    String string = attr.getFirstChild().getNodeValue().trim();
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topic createTopic(String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createTopic");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), CREATE_TOPIC);
            Topic topic = null;
            parameters.put("Name", name);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("CreateTopicResult");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                topic = this.toTopic(item);
                if (topic == null) continue;
                try {
                    this.setTopicAttribute(topic, "DisplayName", name);
                }
                catch (Throwable t) {
                    logger.warn((Object)("Unable to set DisplayName for " + name + ": " + t.getMessage()));
                }
                topic.setName(name);
                Topic topic2 = topic;
                return topic2;
            }
            Topic topic3 = topic;
            return topic3;
        }
        finally {
            APITrace.end();
        }
    }

    public String getProviderTermForSubscription(Locale locale) {
        return "subscription";
    }

    public String getProviderTermForTopic(Locale locale) {
        return "topic";
    }

    public String getSNSUrl() throws InternalException, CloudException {
        return "https://sns." + this.provider.getContext().getRegionId() + ".amazonaws.com";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedSNS");
        try {
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), LIST_TOPICS);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block10: {
                    block9: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block9;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.warn((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Subscription> listSubscriptions(String optionalTopicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listSubscriptions");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), optionalTopicId == null ? LIST_SUBSCRIPTIONS : LIST_SUBSCRIPTIONS_BY_TOPIC);
            ArrayList<Subscription> list = new ArrayList<Subscription>();
            if (optionalTopicId != null) {
                parameters.put("TopicArn", optionalTopicId);
            }
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("Subscriptions");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Subscription subscription;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (subscription = this.toSubscription(item)) == null) continue;
                    list.add(subscription);
                }
            }
            ArrayList<Subscription> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listTopicStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listTopicStatus");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), LIST_TOPICS);
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("Topics");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    ResourceStatus status;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (status = this.toStatus(item)) == null) continue;
                    list.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Topic> listTopics() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listTopics");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), LIST_TOPICS);
            ArrayList<Topic> list = new ArrayList<Topic>();
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("Topics");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Topic topic;
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("member") || (topic = this.toTopic(item)) == null) continue;
                    list.add(topic);
                }
            }
            ArrayList<Topic> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String publish(String providerTopicId, String subject, String message) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"publishSNSMessage");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), PUBLISH);
            parameters.put("TopicArn", providerTopicId);
            parameters.put("Subject", subject);
            parameters.put("Message", message);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("PublishResult");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node item = blocks.item(i);
                for (int j = 0; j < item.getChildNodes().getLength(); ++j) {
                    Node attr = item.getChildNodes().item(j);
                    String name = attr.getNodeName();
                    if (!name.equals("MessageId")) continue;
                    String string = attr.getFirstChild().getNodeValue().trim();
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTopic(String providerTopicId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeTopic");
        try {
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), DELETE_TOPIC);
            parameters.put("TopicArn", providerTopicId);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTopicAttribute(Topic topic, String attributeName, String attributeValue) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Notifications.setTopicAttributes");
        try {
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), SET_TOPIC_ATTRIBUTES);
            parameters.put("TopicArn", topic.getProviderTopicId());
            parameters.put("AttributeName", attributeName);
            parameters.put("AttributeValue", attributeValue);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTopicAttributes(Topic topic) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"getTopicAttributes");
        try {
            Document doc;
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), GET_TOPIC_ATTRIBUTES);
            parameters.put("TopicArn", topic.getProviderTopicId());
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                doc = method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = doc.getElementsByTagName("Attributes");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    if (!item.getNodeName().equals("entry")) continue;
                    NodeList parts = item.getChildNodes();
                    String name = null;
                    String value = null;
                    if (parts != null) {
                        for (int k = 0; k < parts.getLength(); ++k) {
                            Node node = parts.item(k);
                            if (node == null) continue;
                            if (node.getNodeName().equals("key")) {
                                name = node.getFirstChild().getNodeValue().trim();
                                continue;
                            }
                            if (!node.getNodeName().equals("value")) continue;
                            value = node.getFirstChild().getNodeValue().trim();
                        }
                    }
                    if (name == null) continue;
                    if (name.equals("DisplayName")) {
                        if (value == null) continue;
                        topic.setName(value);
                        topic.setDescription(value + " (" + topic.getProviderTopicId() + ")");
                        continue;
                    }
                    if (!name.equals("Owner") || value == null) continue;
                    topic.setProviderOwnerId(value);
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String providerTopicId, EndpointType endpointType, DataFormat dataFormat, String endpoint) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"subscribeSNS");
        try {
            Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), SUBSCRIBE);
            parameters.put("TopicArn", providerTopicId);
            switch (endpointType) {
                case HTTP: {
                    parameters.put("Protocol", "http");
                    break;
                }
                case HTTPS: {
                    parameters.put("Protocol", "https");
                    break;
                }
                case EMAIL: {
                    if (dataFormat.equals((Object)DataFormat.JSON)) {
                        parameters.put("Protocol", "email-json");
                        break;
                    }
                    parameters.put("Protocol", "email");
                    break;
                }
                case AWS_SQS: {
                    parameters.put("Protocol", "sqs");
                }
            }
            parameters.put("Endpoint", endpoint);
            EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node fromAws) throws InternalException, CloudException {
        if (fromAws == null) {
            return null;
        }
        NodeList attrs = fromAws.getChildNodes();
        String topicId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (!name.equals("TopicArn")) continue;
            topicId = attr.getFirstChild().getNodeValue().trim();
        }
        return new ResourceStatus(topicId, (Object)true);
    }

    private Subscription toSubscription(Node fromAws) throws InternalException, CloudException {
        Subscription subscription = new Subscription();
        NodeList attrs = fromAws.getChildNodes();
        subscription.setProviderRegionId(this.provider.getContext().getRegionId());
        for (int i = 0; i < attrs.getLength(); ++i) {
            String proto;
            String id;
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (name.equals("TopicArn")) {
                id = attr.getFirstChild().getNodeValue().trim();
                subscription.setProviderTopicId(id);
                continue;
            }
            if (name.equals("SubscriptionArn")) {
                id = attr.getFirstChild().getNodeValue().trim();
                subscription.setProviderSubscriptionId(id);
                subscription.setDescription(id);
                subscription.setName(id);
                continue;
            }
            if (name.equals("Owner")) {
                id = attr.getFirstChild().getNodeValue().trim();
                subscription.setProviderOwnerId(id);
                continue;
            }
            if (name.equals("Endpoint")) {
                String endpoint = attr.getFirstChild().getNodeValue().trim();
                subscription.setEndpoint(endpoint);
                continue;
            }
            if (!name.equals("Protocol") || (proto = attr.getFirstChild().getNodeValue().trim()) == null) continue;
            if (proto.equals("email")) {
                subscription.setEndpointType(EndpointType.EMAIL);
                subscription.setDataFormat(DataFormat.PLAINTEXT);
                continue;
            }
            if (proto.equals("email-json")) {
                subscription.setEndpointType(EndpointType.EMAIL);
                subscription.setDataFormat(DataFormat.JSON);
                continue;
            }
            if (proto.equals("http")) {
                subscription.setEndpointType(EndpointType.HTTP);
                subscription.setDataFormat(DataFormat.JSON);
                continue;
            }
            if (proto.equals("https")) {
                subscription.setEndpointType(EndpointType.HTTPS);
                subscription.setDataFormat(DataFormat.JSON);
                continue;
            }
            if (!proto.equals("sqs")) continue;
            subscription.setEndpointType(EndpointType.AWS_SQS);
            subscription.setDataFormat(DataFormat.JSON);
        }
        if (subscription.getProviderSubscriptionId() == null) {
            return null;
        }
        return subscription;
    }

    private Topic toTopic(Node fromAws) throws InternalException, CloudException {
        NodeList attrs = fromAws.getChildNodes();
        Topic topic = new Topic();
        topic.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        topic.setProviderRegionId(this.provider.getContext().getRegionId());
        topic.setActive(true);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            if (!name.equals("TopicArn")) continue;
            String id = attr.getFirstChild().getNodeValue().trim();
            topic.setProviderTopicId(id);
            topic.setName(id);
            topic.setDescription(id);
        }
        if (topic.getProviderTopicId() == null) {
            return null;
        }
        this.setTopicAttributes(topic);
        return topic;
    }

    public void unsubscribe(String providerSubscriptionId) throws CloudException, InternalException {
        Map<String, String> parameters = this.provider.getStandardSnsParameters(this.provider.getContext(), UNSUBSCRIBE);
        parameters.put("SubscriptionArn", providerSubscriptionId);
        EC2Method method = new EC2Method(this.provider, this.getSNSUrl(), parameters);
        try {
            method.invoke();
        }
        catch (EC2Exception e) {
            throw new CloudException((Throwable)e);
        }
    }
}

