/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.platform;

import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.compute.EC2Exception;
import org.dasein.cloud.aws.compute.EC2Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.platform.KeyValueDatabase;
import org.dasein.cloud.platform.KeyValueDatabaseSupport;
import org.dasein.cloud.platform.KeyValuePair;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleDB
implements KeyValueDatabaseSupport {
    private static final Logger logger = AWSCloud.getLogger(SimpleDB.class);
    public static final String CREATE_DOMAIN = "CreateDomain";
    public static final String DELETE_ATTRIBUTES = "DeleteAttributes";
    public static final String DELETE_DOMAIN = "DeleteDomain";
    public static final String DOMAIN_META_DATA = "DomainMetadata";
    public static final String GET_ATTRIBUTES = "GetAttributes";
    public static final String LIST_DOMAINS = "ListDomains";
    public static final String PUT_ATTRIBUTES = "PutAttributes";
    public static final String SELECT = "Select";
    private AWSCloud provider;

    @Nonnull
    public static ServiceAction[] asSimpleDBServiceAction(@Nonnull String action) {
        if (action.equals(CREATE_DOMAIN)) {
            return new ServiceAction[]{KeyValueDatabaseSupport.CREATE_KVDB};
        }
        if (action.equals(DELETE_DOMAIN)) {
            return new ServiceAction[]{KeyValueDatabaseSupport.REMOVE_KVDB};
        }
        if (action.equals(LIST_DOMAINS)) {
            return new ServiceAction[]{KeyValueDatabaseSupport.LIST_KVDB, KeyValueDatabaseSupport.GET_KVDB};
        }
        if (action.equals(SELECT)) {
            return new ServiceAction[]{KeyValueDatabaseSupport.SELECT};
        }
        return new ServiceAction[0];
    }

    SimpleDB(AWSCloud cloud) {
        this.provider = cloud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyValuePairs(String inDomainId, String itemId, KeyValuePair ... pairs) throws CloudException, InternalException {
        block6: {
            APITrace.begin((CloudProvider)this.provider, (String)"addKeyValuePairs");
            try {
                if (pairs == null || pairs.length <= 0) break block6;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), PUT_ATTRIBUTES);
                int i = 0;
                parameters.put("DomainName", inDomainId);
                parameters.put("ItemName", itemId);
                for (KeyValuePair pair : pairs) {
                    parameters.put("Attribute." + i + ".Name", pair.getKey());
                    parameters.put("Attribute." + i + ".Value", pair.getValue());
                    ++i;
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDatabase(String name, String description) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"createKVDatabase");
        try {
            Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), CREATE_DOMAIN);
            name = this.validateName(name);
            parameters.put("DomainName", name);
            EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
            String string = name;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyValueDatabase getDatabase(String domainId) throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"getDatabase");
        Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), DOMAIN_META_DATA);
        parameters.put("DomainName", domainId);
        EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.equals("NoSuchDomain")) {
                KeyValueDatabase keyValueDatabase = null;
                APITrace.end();
                return keyValueDatabase;
            }
            throw new CloudException((Throwable)e);
        }
        KeyValueDatabase database = new KeyValueDatabase();
        database.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        database.setProviderRegionId(this.provider.getContext().getRegionId());
        database.setProviderDatabaseId(domainId);
        database.setName(domainId);
        database.setDescription(domainId);
        NodeList blocks = doc.getElementsByTagName("DomainMetadataResult");
        if (blocks.getLength() > 0) {
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList items = blocks.item(i).getChildNodes();
                for (int j = 0; j < items.getLength(); ++j) {
                    Node item = items.item(j);
                    String name = item.getNodeName();
                    if (name.equals("ItemCount")) {
                        if (!item.hasChildNodes()) continue;
                        database.setItemCount(Integer.parseInt(item.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (name.equals("AttributeValueCount")) {
                        if (!item.hasChildNodes()) continue;
                        database.setKeyValueCount(Integer.parseInt(item.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (name.equals("AttributeNameCount")) {
                        if (!item.hasChildNodes()) continue;
                        database.setKeyCount(Integer.parseInt(item.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (name.equals("ItemNamesSizeBytes")) {
                        if (!item.hasChildNodes()) continue;
                        database.setItemSize(Integer.parseInt(item.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (name.equals("AttributeValuesSizeBytes")) {
                        if (!item.hasChildNodes()) continue;
                        database.setKeyValueSize(Integer.parseInt(item.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (!name.equals("AttributeNamesSizeBytes") || !item.hasChildNodes()) continue;
                    database.setKeySize(Integer.parseInt(item.getFirstChild().getNodeValue()));
                }
            }
        }
        KeyValueDatabase keyValueDatabase = database;
        return keyValueDatabase;
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<KeyValuePair> getKeyValuePairs(String inDomainId, String itemId, boolean consistentRead) throws CloudException, InternalException {
        Document doc;
        APITrace.begin((CloudProvider)this.provider, (String)"getKeyValuePairs");
        Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), GET_ATTRIBUTES);
        parameters.put("DomainName", inDomainId);
        parameters.put("ItemName", itemId);
        parameters.put("ConsistentRead", String.valueOf(consistentRead));
        EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
        try {
            doc = method.invoke();
        }
        catch (EC2Exception e) {
            String code = e.getCode();
            if (code != null && code.equals("NoSuchDomain")) {
                Iterable<KeyValuePair> iterable = null;
                APITrace.end();
                return iterable;
            }
            throw new CloudException((Throwable)e);
        }
        ArrayList<KeyValuePair> pairs = new ArrayList<KeyValuePair>();
        NodeList blocks = doc.getElementsByTagName("Attribute");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node node = blocks.item(i);
            if (!node.hasChildNodes()) continue;
            NodeList children = node.getChildNodes();
            String key = null;
            String value = null;
            for (int j = 0; j < children.getLength(); ++j) {
                Node item = children.item(j);
                if (!item.hasChildNodes()) continue;
                String nv = item.getFirstChild().getNodeValue();
                if (item.getNodeName().equals("Name")) {
                    key = nv;
                    continue;
                }
                if (!item.getNodeName().equals("Value")) continue;
                value = nv;
            }
            if (key == null) continue;
            pairs.add(new KeyValuePair(key, value));
        }
        ArrayList<KeyValuePair> arrayList = pairs;
        return arrayList;
        finally {
            APITrace.end();
        }
    }

    public String getProviderTermForDatabase(Locale locale) {
        return "domain";
    }

    private String getSimpleDBUrl() throws InternalException, CloudException {
        if (this.provider.getContext().getRegionId() == null || this.provider.getContext().getRegionId().equals("us-east-1")) {
            return "https://sdb.amazonaws.com";
        }
        return "https://sdb." + this.provider.getContext().getRegionId() + ".amazonaws.com";
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"isSubscribedKVDB");
        try {
            Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), LIST_DOMAINS);
            EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
            try {
                method.invoke();
                boolean bl = true;
                return bl;
            }
            catch (EC2Exception e) {
                block10: {
                    block9: {
                        if (e.getStatus() != 401 && e.getStatus() != 403) break block9;
                        boolean bl = false;
                        APITrace.end();
                        return bl;
                    }
                    String code = e.getCode();
                    if (code == null || !code.equals("SubscriptionCheckFailed") && !code.equals("AuthFailure") && !code.equals("SignatureDoesNotMatch") && !code.equals("InvalidClientTokenId") && !code.equals("OptInRequired")) break block10;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                logger.warn((Object)e.getSummary());
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSupportsKeyValueDatabases() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> list() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listKVDBs");
        try {
            ArrayList<String> list = new ArrayList<String>();
            String marker = null;
            do {
                int i;
                Document doc;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), LIST_DOMAINS);
                if (marker != null) {
                    parameters.put("NextToken", marker);
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                marker = null;
                NodeList blocks = doc.getElementsByTagName("NextToken");
                if (blocks.getLength() > 0) {
                    for (i = 0; i < blocks.getLength(); ++i) {
                        Node item = blocks.item(i);
                        if (!item.hasChildNodes()) continue;
                        marker = item.getFirstChild().getNodeValue().trim();
                    }
                    if (marker != null) break;
                }
                blocks = doc.getElementsByTagName("DomainName");
                for (i = 0; i < blocks.getLength(); ++i) {
                    String domain;
                    Node name = blocks.item(i);
                    if (!name.hasChildNodes() || (domain = name.getFirstChild().getNodeValue()) == null) continue;
                    list.add(domain);
                }
            } while (marker != null);
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<ResourceStatus> listKeyValueDatabaseStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"listKVDBStatus");
        try {
            ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
            String marker = null;
            do {
                int i;
                Document doc;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), LIST_DOMAINS);
                if (marker != null) {
                    parameters.put("NextToken", marker);
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    doc = method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
                marker = null;
                NodeList blocks = doc.getElementsByTagName("NextToken");
                if (blocks.getLength() > 0) {
                    for (i = 0; i < blocks.getLength(); ++i) {
                        Node item = blocks.item(i);
                        if (!item.hasChildNodes()) continue;
                        marker = item.getFirstChild().getNodeValue().trim();
                    }
                    if (marker != null) break;
                }
                blocks = doc.getElementsByTagName("DomainName");
                for (i = 0; i < blocks.getLength(); ++i) {
                    Node name = blocks.item(i);
                    if (!name.hasChildNodes()) continue;
                    list.add(new ResourceStatus(name.getFirstChild().getNodeValue(), (Object)true));
                }
            } while (marker != null);
            ArrayList<ResourceStatus> arrayList = list;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)KeyValueDatabaseSupport.ANY)) {
            return new String[]{"sdb:*"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.CREATE_KVDB)) {
            return new String[]{"sdb:CreateDomain"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.DELETE)) {
            return new String[]{"sdb:DeleteDomain"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.GET_KVDB)) {
            return new String[]{"sdb:ListDomains"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.LIST_KVDB)) {
            return new String[]{"sdb:ListDomains"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.PUT)) {
            return new String[]{"sdb:PutAttributes"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.REMOVE_KVDB)) {
            return new String[]{"sdb:DeleteDomain"};
        }
        if (action.equals((Object)KeyValueDatabaseSupport.SELECT)) {
            return new String[]{"sdb:Select"};
        }
        return new String[0];
    }

    /*
     * Exception decompiling
     */
    public Map<String, Set<KeyValuePair>> query(String queryString, boolean consistentRead) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDatabase(String domainId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"removeKVDB");
        try {
            Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), DELETE_DOMAIN);
            parameters.put("DomainName", domainId);
            EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
            try {
                method.invoke();
            }
            catch (EC2Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyValuePairs(String inDomainId, String itemId, KeyValuePair ... pairs) throws CloudException, InternalException {
        block7: {
            APITrace.begin((CloudProvider)this.provider, (String)"removeKeyValuePairs");
            try {
                if (pairs == null || pairs.length <= 0) break block7;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), DELETE_ATTRIBUTES);
                int i = 0;
                parameters.put("DomainName", inDomainId);
                parameters.put("ItemName", itemId);
                for (KeyValuePair pair : pairs) {
                    parameters.put("Attribute." + i + ".Name", pair.getKey());
                    if (pair.getValue() != null) {
                        parameters.put("Attribute." + i + ".Value", pair.getValue());
                    }
                    ++i;
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyValuePairs(String inDomainId, String itemId, String ... pairs) throws CloudException, InternalException {
        block6: {
            APITrace.begin((CloudProvider)this.provider, (String)"removeKeyValuePairStrings");
            try {
                if (pairs == null || pairs.length <= 0) break block6;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), DELETE_ATTRIBUTES);
                int i = 0;
                parameters.put("DomainName", inDomainId);
                parameters.put("ItemName", itemId);
                for (String pair : pairs) {
                    parameters.put("Attribute." + i + ".Name", pair);
                    ++i;
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceKeyValuePairs(String inDomainId, String itemId, KeyValuePair ... pairs) throws CloudException, InternalException {
        block6: {
            APITrace.begin((CloudProvider)this.provider, (String)"replaceKeyValuePairs");
            try {
                if (pairs == null || pairs.length <= 0) break block6;
                Map<String, String> parameters = this.provider.getStandardSimpleDBParameters(this.provider.getContext(), PUT_ATTRIBUTES);
                int i = 0;
                parameters.put("DomainName", inDomainId);
                parameters.put("ItemName", itemId);
                for (KeyValuePair pair : pairs) {
                    parameters.put("Attribute." + i + ".Name", pair.getKey());
                    parameters.put("Attribute." + i + ".Value", pair.getValue());
                    parameters.put("Attribute." + i + ".Replace", "true");
                    ++i;
                }
                EC2Method method = new EC2Method(this.provider, this.getSimpleDBUrl(), parameters);
                try {
                    method.invoke();
                }
                catch (EC2Exception e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    private String validateName(String name) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                str.append(c);
                continue;
            }
            if (c != '-' && c != '_' && c != '.') continue;
            str.append(c);
        }
        if (str.length() < 3) {
            if (str.length() < 2) {
                if (str.length() < 1) {
                    return "aaa";
                }
                return str.toString() + "aa";
            }
            return str.toString() + "a";
        }
        if (str.length() > 255) {
            return str.toString().substring(0, 255);
        }
        return str.toString();
    }
}

