/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.NameRules;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.storage.S3Action;
import org.dasein.cloud.aws.storage.S3Exception;
import org.dasein.cloud.aws.storage.S3Method;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.storage.AbstractBlobStoreSupport;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class S3
extends AbstractBlobStoreSupport {
    private static final Logger logger = AWSCloud.getLogger(S3.class);
    public static final int MAX_BUCKETS = 100;
    public static final int MAX_OBJECTS = -1;
    public static final Storage<Byte> MAX_OBJECT_SIZE = new Storage((Number)5000000000L, (StorageUnit)Storage.BYTE);
    private static final Random random = new Random();
    private static final boolean disableAffinityCache;
    private AWSCloud provider = null;

    public S3(AWSCloud provider) {
        this.provider = provider;
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob createBucket(@Nonnull String bucketName, boolean findFreeName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.createBucket");
        try {
            if (bucketName.contains("/")) {
                throw new OperationNotSupportedException("Nested buckets are not supported");
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new InternalException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new InternalException("No region ID was specified for this request");
            }
            StringBuilder body = null;
            boolean success = false;
            if (this.provider.getEC2Provider().isAWS()) {
                if (regionId.equals("eu-west-1")) {
                    body = new StringBuilder();
                    body.append("<CreateBucketConfiguration>\r\n");
                    body.append("<LocationConstraint>");
                    body.append("EU");
                    body.append("</LocationConstraint>\r\n");
                    body.append("</CreateBucketConfiguration>\r\n");
                } else if (regionId.equals("us-west-1")) {
                    body = new StringBuilder();
                    body.append("<CreateBucketConfiguration>\r\n");
                    body.append("<LocationConstraint>");
                    body.append("us-west-1");
                    body.append("</LocationConstraint>\r\n");
                    body.append("</CreateBucketConfiguration>\r\n");
                } else if (regionId.equals("ap-southeast-1")) {
                    body = new StringBuilder();
                    body.append("<CreateBucketConfiguration>\r\n");
                    body.append("<LocationConstraint>");
                    body.append("ap-southeast-1");
                    body.append("</LocationConstraint>\r\n");
                    body.append("</CreateBucketConfiguration>\r\n");
                } else if (!regionId.equals("us-east-1")) {
                    body = new StringBuilder();
                    body.append("<CreateBucketConfiguration>\r\n");
                    body.append("<LocationConstraint>");
                    body.append(regionId);
                    body.append("</LocationConstraint>\r\n");
                    body.append("</CreateBucketConfiguration>\r\n");
                }
            }
            while (!success) {
                String ct = body == null ? null : "text/xml; charset=utf-8";
                S3Method method = new S3Method(this.provider, S3Action.CREATE_BUCKET, null, null, ct, body == null ? null : body.toString());
                try {
                    method.invoke(bucketName, null);
                    success = true;
                }
                catch (S3Exception e) {
                    String code = e.getCode();
                    if (code != null && (code.equals("BucketAlreadyExists") || code.equals("BucketAlreadyOwnedByYou"))) {
                        if (code.equals("BucketAlreadyOwnedByYou")) {
                            if (!this.getRegion(bucketName, false).equals(regionId)) {
                                bucketName = this.findFreeName(bucketName);
                                continue;
                            }
                            Blob blob = Blob.getInstance((String)regionId, (String)this.getLocation(bucketName, null), (String)bucketName, (long)System.currentTimeMillis());
                            APITrace.end();
                            return blob;
                        }
                        if (findFreeName) {
                            bucketName = this.findFreeName(bucketName);
                            continue;
                        }
                        throw new CloudException((Throwable)e);
                    }
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            Blob blob = Blob.getInstance((String)regionId, (String)("http://" + bucketName + ".s3.amazonaws.com"), (String)bucketName, (long)System.currentTimeMillis());
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean exists(@Nonnull String bucketName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.exists");
        try {
            method = new S3Method(this.provider, S3Action.LOCATE_BUCKET);
            try {
                method.invoke(bucketName, "?location");
                var3_3 = true;
                return var3_3;
            }
            catch (S3Exception e) {
                block8: {
                    if (e.getStatus() == 404) ** GOTO lbl24
                    code = e.getCode();
                    if (e.getStatus() != 403) break block8;
                    var5_7 = true;
                    APITrace.end();
                    return var5_7;
                }
                if (code == null || !code.equals("NoSuchBucket")) {
                    S3.logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
lbl24:
                // 3 sources

                var3_5 = false;
                APITrace.end();
                return var3_5;
            }
        }
        finally {
            APITrace.end();
        }
    }

    private String getRegion(@Nonnull String bucket, boolean reload) throws CloudException, InternalException {
        Affinity affinity;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"affinity", Affinity.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        Iterable affinities = cache.get(ctx);
        if (affinities == null) {
            affinity = new Affinity();
            cache.put(ctx, Collections.singletonList(affinity));
        } else {
            affinity = (Affinity)affinities.iterator().next();
        }
        Constraint c = affinity.constraints.get(bucket);
        if (disableAffinityCache || reload || c == null || c.timeout <= System.currentTimeMillis()) {
            Node constraint;
            NodeList constraints;
            S3Method.S3Response response;
            String location = null;
            S3Method method = new S3Method(this.provider, S3Action.LOCATE_BUCKET);
            try {
                response = method.invoke(bucket, "?location");
            }
            catch (S3Exception e) {
                response = null;
            }
            if (response != null && (constraints = response.document.getElementsByTagName("LocationConstraint")).getLength() > 0 && (constraint = constraints.item(0)) != null && constraint.hasChildNodes()) {
                location = constraint.getFirstChild().getNodeValue().trim();
            }
            c = new Constraint(this.toRegion(location));
            affinity.constraints.put(bucket, c);
        }
        return c.regionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBucket(@Nonnull String bucketName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getBucket");
        try {
            S3Method.S3Response response;
            if (bucketName.contains("/")) {
                Blob blob = null;
                return blob;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            S3Method method = new S3Method(this.provider, S3Action.LIST_BUCKETS);
            try {
                response = method.invoke(null, null);
            }
            catch (S3Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("Bucket");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node object = blocks.item(i);
                String name = null;
                long ts = 0L;
                NodeList attrs = object.getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equals("Name")) {
                        name = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attr.getNodeName().equals("CreationDate")) continue;
                    ts = this.provider.parseTime(attr.getFirstChild().getNodeValue().trim());
                }
                if (!bucketName.equals(name)) continue;
                if (this.provider.getEC2Provider().isAWS()) {
                    if (!this.getRegion(name, true).equals(regionId)) continue;
                    Blob blob = Blob.getInstance((String)regionId, (String)this.getLocation(name, null), (String)name, (long)ts);
                    return blob;
                }
                Blob blob = Blob.getInstance((String)regionId, (String)this.getLocation(name, null), (String)name, (long)ts);
                return blob;
            }
            Blob blob = null;
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getObject(@Nullable String bucketName, @Nonnull String objectName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getObject");
        try {
            if (bucketName == null) {
                Blob blob = null;
                return blob;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            String myRegion = this.getRegion(bucketName, false);
            if (!myRegion.equals(regionId)) {
                Blob blob = null;
                return blob;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            String marker = null;
            boolean done = false;
            while (!done) {
                S3Method.S3Response response;
                parameters.clear();
                if (marker != null) {
                    parameters.put("marker", marker);
                }
                parameters.put("max-keys", String.valueOf(30));
                S3Method method = new S3Method(this.provider, S3Action.LIST_CONTENTS, parameters, null);
                try {
                    response = method.invoke(bucketName, null);
                }
                catch (S3Exception e) {
                    String code = e.getCode();
                    if (code == null || !code.equals("SignatureDoesNotMatch")) {
                        throw new CloudException((Throwable)e);
                    }
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                NodeList blocks = response.document.getElementsByTagName("IsTruncated");
                if (blocks.getLength() > 0) {
                    done = blocks.item(0).getFirstChild().getNodeValue().trim().equalsIgnoreCase("false");
                }
                blocks = response.document.getElementsByTagName("Contents");
                for (int i = 0; i < blocks.getLength(); ++i) {
                    Node object = blocks.item(i);
                    Storage size = null;
                    String name = null;
                    long ts = -1L;
                    if (object.hasChildNodes()) {
                        NodeList attrs = object.getChildNodes();
                        for (int j = 0; j < attrs.getLength(); ++j) {
                            Node attr = attrs.item(j);
                            if (attr.getNodeName().equalsIgnoreCase("Key")) {
                                String key;
                                name = key = attr.getFirstChild().getNodeValue().trim();
                                marker = key;
                                continue;
                            }
                            if (attr.getNodeName().equalsIgnoreCase("Size")) {
                                size = new Storage((Number)Long.parseLong(attr.getFirstChild().getNodeValue().trim()), (StorageUnit)Storage.BYTE);
                                continue;
                            }
                            if (!attr.getNodeName().equalsIgnoreCase("LastModified")) continue;
                            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                            String dateString = attr.getFirstChild().getNodeValue().trim();
                            try {
                                ts = fmt.parse(dateString).getTime();
                                continue;
                            }
                            catch (ParseException e) {
                                logger.error((Object)e);
                                e.printStackTrace();
                                throw new CloudException((Throwable)e);
                            }
                        }
                    }
                    if (!objectName.equals(name) || size == null) continue;
                    Blob blob = Blob.getInstance((String)regionId, (String)this.getLocation(bucketName, name), (String)bucketName, name, (long)ts, size);
                    return blob;
                }
            }
            Blob blob = null;
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean belongsToAnother(@Nonnull String bucketName) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.belongsToAnother");
        try {
            method = new S3Method(this.provider, S3Action.LOCATE_BUCKET);
            try {
                method.invoke(bucketName, "?location");
                var3_3 = false;
                return var3_3;
            }
            catch (S3Exception e) {
                block9: {
                    block8: {
                        if (e.getStatus() == 404) ** GOTO lbl31
                        code = e.getCode();
                        if (code == null || !code.equals("AccessDenied")) break block8;
                        var5_7 = true;
                        APITrace.end();
                        return var5_7;
                    }
                    if (code != null && code.equals("NoSuchBucket")) ** GOTO lbl31
                    message = e.getMessage();
                    if (message == null || !message.contains("Access forbidden")) break block9;
                    var6_9 = true;
                    APITrace.end();
                    return var6_9;
                }
                S3.logger.error((Object)(e.getSummary() + " (" + e.getCode() + ")"));
                throw new CloudException((Throwable)e);
lbl31:
                // 2 sources

                var3_5 = false;
                APITrace.end();
                return var3_5;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String getLocation(@Nonnull String bucketName, @Nullable String objectName) {
        if (objectName == null) {
            return "http://" + bucketName + ".s3.amazonaws.com";
        }
        return "http://" + bucketName + ".s3.amazonaws.com/" + objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.getObjectSize");
        try {
            if (bucket == null) {
                throw new CloudException("Requested object size for object in null bucket");
            }
            if (object == null) {
                Storage<Byte> storage = null;
                return storage;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            if (!this.getRegion(bucket, false).equals(ctx.getRegionId())) {
                Storage<Byte> storage = null;
                return storage;
            }
            S3Method method = new S3Method(this.provider, S3Action.OBJECT_EXISTS);
            try {
                S3Method.S3Response response = method.invoke(bucket, object);
                if (response != null && response.headers != null) {
                    for (Header header : response.headers) {
                        if (!header.getName().equalsIgnoreCase("Content-Length")) continue;
                        Storage storage = new Storage((Number)Long.parseLong(header.getValue()), (StorageUnit)Storage.BYTE);
                        return storage;
                    }
                }
                Header[] arr$ = null;
                return arr$;
            }
            catch (S3Exception e) {
                String code;
                if (e.getStatus() != 404 && ((code = e.getCode()) == null || !code.equals("NoSuchBucket") && !code.equals("NoSuchKey"))) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
                Storage<Byte> storage = null;
                return storage;
            }
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    private String findFreeName(@Nonnull String bucket) throws InternalException, CloudException {
        String rawName;
        String prefix;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        int idx = bucket.lastIndexOf(".");
        if (idx == -1) {
            prefix = null;
            bucket = rawName = bucket;
        } else {
            prefix = bucket.substring(0, idx);
            rawName = bucket.substring(idx + 1);
            bucket = prefix + "." + rawName;
        }
        while (this.belongsToAnother(bucket) || this.exists(bucket) && !this.getRegion(bucket, false).equals(ctx.getRegionId())) {
            idx = rawName.lastIndexOf("-");
            if (idx == -1) {
                rawName = rawName + "-1";
            } else if (idx == rawName.length() - 1) {
                rawName = rawName + "1";
            } else {
                String postfix = rawName.substring(idx + 1);
                try {
                    int x = Integer.parseInt(postfix) + 1;
                    rawName = rawName.substring(0, idx) + "-" + x;
                }
                catch (NumberFormatException e) {
                    rawName = rawName + "-1";
                }
            }
            if (prefix == null) {
                bucket = rawName;
                continue;
            }
            bucket = prefix + "." + rawName;
        }
        return bucket;
    }

    /*
     * Exception decompiling
     */
    protected void get(@Nullable String bucket, @Nonnull String object, @Nonnull File toFile, @Nullable FileTransfer transfer) throws InternalException, CloudException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private Document getAcl(@Nonnull String bucket, @Nullable String object) throws CloudException, InternalException {
        S3Method method = new S3Method(this.provider, S3Action.GET_ACL);
        try {
            S3Method.S3Response response = method.invoke(bucket, object == null ? "?acl" : object + "?acl");
            return response == null ? null : response.document;
        }
        catch (S3Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
    }

    public Storage<Byte> getMaxObjectSize() {
        return MAX_OBJECT_SIZE;
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "bucket";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPublic(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.isPublic");
        try {
            if (bucket == null) {
                throw new CloudException("A bucket name was not specified");
            }
            Document acl = this.getAcl(bucket, object);
            if (acl == null) {
                boolean bl = false;
                return bl;
            }
            NodeList grants = acl.getElementsByTagName("Grant");
            for (int i = 0; i < grants.getLength(); ++i) {
                boolean isAll = false;
                boolean isRead = false;
                Node grant = grants.item(i);
                NodeList grantData = grant.getChildNodes();
                block6: for (int j = 0; j < grantData.getLength(); ++j) {
                    Node item = grantData.item(j);
                    if (item.getNodeName().equals("Grantee")) {
                        String type = item.getAttributes().getNamedItem("xsi:type").getNodeValue();
                        if (!type.equals("Group")) continue;
                        NodeList items = item.getChildNodes();
                        for (int k = 0; k < items.getLength(); ++k) {
                            String uri;
                            Node n = items.item(k);
                            if (n.getNodeName().equals("URI") && n.hasChildNodes() && (uri = n.getFirstChild().getNodeValue()).equals("http://acs.amazonaws.com/groups/global/AllUsers")) {
                                isAll = true;
                                continue block6;
                            }
                            if (isAll) continue block6;
                        }
                        continue;
                    }
                    if (!item.getNodeName().equals("Permission") || !item.hasChildNodes()) continue;
                    String perm = item.getFirstChild().getNodeValue();
                    isRead = perm.equals("READ") || perm.equals("FULL_CONTROL");
                }
                if (!isAll) continue;
                boolean bl = isRead;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.isSubscribed");
        try {
            S3Method method = new S3Method(this.provider, S3Action.LIST_BUCKETS);
            try {
                method.invoke(null, null);
                boolean bl = true;
                return bl;
            }
            catch (S3Exception e) {
                boolean bl = false;
                APITrace.end();
                return bl;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<Blob> list(final @Nullable String bucket) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        final String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region ID was specified");
        }
        if (bucket != null && !this.getRegion(bucket, false).equals(regionId)) {
            throw new CloudException("No such bucket in target region: " + bucket + " in " + regionId);
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<Blob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
                try {
                    S3.this.list(regionId, bucket, (Jiterator<Blob>)iterator);
                }
                finally {
                    S3.this.provider.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void list(@Nonnull String regionId, @Nullable String bucket, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.list");
        try {
            if (bucket == null) {
                this.loadBuckets(regionId, iterator);
            } else {
                this.loadObjects(regionId, bucket, iterator);
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private String toRegion(@Nullable String locationConstraint) {
        if (locationConstraint == null) {
            return "us-east-1";
        }
        if (locationConstraint.equals("EU")) {
            return "eu-west-1";
        }
        if (locationConstraint.equals("US")) {
            return "us-east-1";
        }
        return locationConstraint;
    }

    private void loadBuckets(@Nonnull String regionId, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        S3Method.S3Response response;
        S3Method method = new S3Method(this.provider, S3Action.LIST_BUCKETS);
        try {
            response = method.invoke(null, null);
        }
        catch (S3Exception e) {
            logger.error((Object)e.getSummary());
            throw new CloudException((Throwable)e);
        }
        NodeList blocks = response.document.getElementsByTagName("Bucket");
        for (int i = 0; i < blocks.getLength(); ++i) {
            Node object = blocks.item(i);
            String name = null;
            long ts = 0L;
            NodeList attrs = object.getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equals("Name")) {
                    name = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attr.getNodeName().equals("CreationDate")) continue;
                ts = this.provider.parseTime(attr.getFirstChild().getNodeValue().trim());
            }
            if (name == null) {
                throw new CloudException("Bad response from server.");
            }
            if (this.provider.getEC2Provider().isAWS()) {
                Node constraint;
                NodeList constraints;
                String location = null;
                method = new S3Method(this.provider, S3Action.LOCATE_BUCKET);
                try {
                    response = method.invoke(name, "?location");
                }
                catch (S3Exception e) {
                    response = null;
                }
                if (response != null && (constraints = response.document.getElementsByTagName("LocationConstraint")).getLength() > 0 && (constraint = constraints.item(0)) != null && constraint.hasChildNodes()) {
                    location = constraint.getFirstChild().getNodeValue().trim();
                }
                if (!this.toRegion(location).equals(this.provider.getContext().getRegionId())) continue;
                iterator.push((Object)Blob.getInstance((String)regionId, (String)this.getLocation(name, null), (String)name, (long)ts));
                continue;
            }
            iterator.push((Object)Blob.getInstance((String)regionId, (String)this.getLocation(name, null), (String)name, (long)ts));
        }
    }

    private void loadObjects(@Nonnull String regionId, @Nonnull String bucket, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String marker = null;
        boolean done = false;
        while (!done) {
            S3Method.S3Response response;
            parameters.clear();
            if (marker != null) {
                parameters.put("marker", marker);
            }
            parameters.put("max-keys", String.valueOf(30));
            S3Method method = new S3Method(this.provider, S3Action.LIST_CONTENTS, parameters, null);
            try {
                response = method.invoke(bucket, null);
            }
            catch (S3Exception e) {
                String code = e.getCode();
                if (code == null || !code.equals("SignatureDoesNotMatch")) {
                    throw new CloudException((Throwable)e);
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
            NodeList blocks = response.document.getElementsByTagName("IsTruncated");
            if (blocks.getLength() > 0) {
                done = blocks.item(0).getFirstChild().getNodeValue().trim().equalsIgnoreCase("false");
            }
            blocks = response.document.getElementsByTagName("Contents");
            for (int i = 0; i < blocks.getLength(); ++i) {
                Node object = blocks.item(i);
                Storage size = null;
                String name = null;
                long ts = -1L;
                if (object.hasChildNodes()) {
                    NodeList attrs = object.getChildNodes();
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node attr = attrs.item(j);
                        if (attr.getNodeName().equalsIgnoreCase("Key")) {
                            String key;
                            name = key = attr.getFirstChild().getNodeValue().trim();
                            marker = key;
                            continue;
                        }
                        if (attr.getNodeName().equalsIgnoreCase("Size")) {
                            size = new Storage((Number)Long.parseLong(attr.getFirstChild().getNodeValue().trim()), (StorageUnit)Storage.BYTE);
                            continue;
                        }
                        if (!attr.getNodeName().equalsIgnoreCase("LastModified")) continue;
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
                        String dateString = attr.getFirstChild().getNodeValue().trim();
                        try {
                            ts = fmt.parse(dateString).getTime();
                            continue;
                        }
                        catch (ParseException e) {
                            logger.error((Object)e);
                            e.printStackTrace();
                            throw new CloudException((Throwable)e);
                        }
                    }
                }
                if (name == null || size == null) continue;
                iterator.push((Object)Blob.getInstance((String)regionId, (String)this.getLocation(bucket, name), (String)bucket, name, (long)ts, size));
            }
        }
    }

    public void makePublic(@Nonnull String bucket) throws InternalException, CloudException {
        this.makePublic(bucket, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePublic(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.makePublic");
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified for this request");
            }
            Document current = this.getAcl(bucket, object);
            if (current == null) {
                throw new CloudException("Target does not exist");
            }
            StringBuilder xml = new StringBuilder();
            NodeList blocks = current.getDocumentElement().getChildNodes();
            xml.append("<AccessControlPolicy xmlns=\"http://s3.amazonaws.com/doc/2006-03-01/\">");
            for (int i = 0; i < blocks.getLength(); ++i) {
                NodeList attrs;
                Node n = blocks.item(i);
                if (n.getNodeName().equals("Owner")) {
                    attrs = n.getChildNodes();
                    xml.append("<Owner>");
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Node attr = attrs.item(j);
                        if (attr.getNodeName().equals("ID")) {
                            xml.append("<ID>");
                            xml.append(attr.getFirstChild().getNodeValue().trim());
                            xml.append("</ID>");
                            continue;
                        }
                        if (!attr.getNodeName().equals("DisplayName")) continue;
                        xml.append("<DisplayName>");
                        xml.append(attr.getFirstChild().getNodeValue().trim());
                        xml.append("</DisplayName>");
                    }
                    xml.append("</Owner>");
                    continue;
                }
                if (!n.getNodeName().equals("AccessControlList")) continue;
                attrs = n.getChildNodes();
                boolean found = false;
                xml.append("<AccessControlList>");
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (!attr.getNodeName().equals("Grant")) continue;
                    NodeList subList = attr.getChildNodes();
                    boolean isAll = false;
                    xml.append("<Grant>");
                    for (int k = 0; k < subList.getLength(); ++k) {
                        Node sub = subList.item(k);
                        if (sub.getNodeName().equals("Grantee")) {
                            String type = sub.getAttributes().getNamedItem("xsi:type").getNodeValue();
                            NodeList agentInfo = sub.getChildNodes();
                            xml.append("<Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"");
                            xml.append(type);
                            xml.append("\">");
                            for (int l = 0; l < agentInfo.getLength(); ++l) {
                                Node item = agentInfo.item(l);
                                xml.append("<");
                                xml.append(item.getNodeName());
                                if (item.hasChildNodes()) {
                                    String val = item.getFirstChild().getNodeValue();
                                    if (type.equals("Group") && item.getNodeName().equals("URI") && val.equals("http://acs.amazonaws.com/groups/global/AllUsers")) {
                                        found = true;
                                        isAll = true;
                                    }
                                    xml.append(">");
                                    xml.append(item.getFirstChild().getNodeValue());
                                    xml.append("</");
                                    xml.append(item.getNodeName());
                                    xml.append(">");
                                    continue;
                                }
                                xml.append("/>");
                            }
                            xml.append("</Grantee>");
                            continue;
                        }
                        if (!sub.getNodeName().equals("Permission")) continue;
                        if (isAll) {
                            xml.append("<Permission>READ</Permission>");
                            continue;
                        }
                        xml.append("<Permission");
                        if (sub.hasChildNodes()) {
                            xml.append(">");
                            xml.append(sub.getFirstChild().getNodeValue());
                            xml.append("</Permission>");
                            continue;
                        }
                        xml.append("/>");
                    }
                    xml.append("</Grant>");
                }
                if (!found) {
                    xml.append("<Grant>");
                    xml.append("<Grantee xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"Group\">");
                    xml.append("<URI>http://acs.amazonaws.com/groups/global/AllUsers</URI>");
                    xml.append("</Grantee>");
                    xml.append("<Permission>READ</Permission>");
                    xml.append("</Grant>");
                }
                xml.append("</AccessControlList>");
            }
            xml.append("</AccessControlPolicy>\r\n");
            this.setAcl(bucket, object, xml.toString());
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        if (action.equals((Object)BlobStoreSupport.ANY)) {
            return new String[]{"s3:*"};
        }
        if (action.equals((Object)BlobStoreSupport.CREATE_BUCKET)) {
            return new String[]{"s3:CreateBucket"};
        }
        if (action.equals((Object)BlobStoreSupport.DOWNLOAD)) {
            return new String[]{"s3:GetObject"};
        }
        if (action.equals((Object)BlobStoreSupport.GET_BUCKET)) {
            return new String[]{"s3:GetBucket"};
        }
        if (action.equals((Object)BlobStoreSupport.LIST_BUCKET)) {
            return new String[]{"s3:ListBucket"};
        }
        if (action.equals((Object)BlobStoreSupport.LIST_BUCKET_CONTENTS)) {
            return new String[]{"s3:ListBucket"};
        }
        if (action.equals((Object)BlobStoreSupport.MAKE_PUBLIC)) {
            return new String[]{"s3:PutAccessControlPolicy"};
        }
        if (action.equals((Object)BlobStoreSupport.REMOVE_BUCKET)) {
            return new String[]{"s3:DeleteBucket"};
        }
        if (action.equals((Object)BlobStoreSupport.UPLOAD)) {
            return new String[]{"s3:PutObject"};
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(@Nullable String sourceBucket, @Nullable String object, @Nullable String targetBucket) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.move");
        try {
            if (sourceBucket == null) {
                throw new CloudException("No source bucket was specified");
            }
            if (targetBucket == null) {
                throw new CloudException("No target bucket was specified");
            }
            if (object == null) {
                throw new CloudException("No source object was specified");
            }
            this.copy(sourceBucket, object, targetBucket, object);
            this.removeObject(sourceBucket, object);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull File file) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.putFile");
        try {
            boolean bucketIsPublic = this.isPublic(bucket, null);
            HashMap<String, String> headers = null;
            if (bucketIsPublic) {
                headers = new HashMap<String, String>();
                headers.put("x-amz-acl", "public-read");
            }
            S3Method method = new S3Method(this.provider, S3Action.PUT_OBJECT, null, headers, "application/octet-stream", file);
            try {
                method.invoke(bucket, object);
            }
            catch (S3Exception e) {
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull String content) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.putString");
        try {
            boolean bucketIsPublic = this.isPublic(bucket, null);
            HashMap<String, String> headers = null;
            if (bucketIsPublic) {
                headers = new HashMap<String, String>();
                headers.put("x-amz-acl", "public-read");
            }
            File file = null;
            try {
                try {
                    file = File.createTempFile(object, ".txt");
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));
                    writer.print(content);
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                S3Method method = new S3Method(this.provider, S3Action.PUT_OBJECT, null, headers, "text/plain", file);
                try {
                    method.invoke(bucket, object);
                }
                catch (S3Exception e) {
                    logger.error((Object)e.getSummary());
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                if (file != null) {
                    file.delete();
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBucket(@Nonnull String bucket) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeBucket");
        try {
            S3Method method = new S3Method(this.provider, S3Action.DELETE_BUCKET);
            try {
                method.invoke(bucket, null);
            }
            catch (S3Exception e) {
                String code = e.getCode();
                if (code != null && code.equals("NoSuchBucket")) {
                    APITrace.end();
                    return;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(@Nullable String bucket, @Nonnull String name) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.removeObject");
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified for this request");
            }
            S3Method method = new S3Method(this.provider, S3Action.DELETE_OBJECT);
            try {
                method.invoke(bucket, name);
            }
            catch (S3Exception e) {
                String code = e.getCode();
                if (code != null && (code.equals("NoSuchBucket") || code.equals("NoSuchKey"))) {
                    APITrace.end();
                    return;
                }
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String renameBucket(@Nonnull String oldName, @Nonnull String newName, boolean findFreeName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.renameBucket");
        try {
            Blob bucket = this.createBucket(newName, findFreeName);
            block7: for (Blob file : this.list(oldName)) {
                int retries = 10;
                while (true) {
                    --retries;
                    try {
                        this.move(oldName, file.getObjectName(), bucket.getBucketName());
                        continue block7;
                    }
                    catch (CloudException e) {
                        if (retries < 1) {
                            throw e;
                        }
                        try {
                            Thread.sleep((long)retries * 10000L);
                        }
                        catch (InterruptedException ignore) {}
                        continue;
                    }
                    break;
                }
            }
            boolean ok = true;
            for (Blob file : this.list(oldName)) {
                if (file == null) continue;
                ok = false;
            }
            if (ok) {
                this.removeBucket(oldName);
            }
            String string = newName;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameObject(@Nullable String bucket, @Nonnull String object, @Nonnull String newName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.renameObject");
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified");
            }
            this.copy(bucket, object, bucket, newName);
            this.removeObject(bucket, object);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAcl(@Nonnull String bucket, @Nullable String object, @Nonnull String body) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.setAcl");
        try {
            S3Method method = new S3Method(this.provider, S3Action.SET_ACL, null, null, null, body);
            try {
                method.invoke(bucket, object == null ? "?acl" : object + "?acl");
            }
            catch (S3Exception e) {
                logger.error((Object)e.getSummary());
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob upload(@Nonnull File source, @Nullable String bucket, @Nonnull String fileName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"Blob.upload");
        try {
            if (bucket == null) {
                throw new OperationNotSupportedException("Root objects are not supported");
            }
            if (!this.exists(bucket)) {
                this.createBucket(bucket, false);
            }
            this.put(bucket, fileName, source);
            Blob blob = this.getObject(bucket, fileName);
            return blob;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public NameRules getBucketNameRules() throws CloudException, InternalException {
        return NameRules.getInstance((int)1, (int)255, (boolean)false, (boolean)true, (boolean)true, (char[])new char[]{'-', '.'});
    }

    @Nonnull
    public NameRules getObjectNameRules() throws CloudException, InternalException {
        return NameRules.getInstance((int)1, (int)255, (boolean)false, (boolean)true, (boolean)true, (char[])new char[]{'-', '.', ',', '#', '+'});
    }

    static {
        String disableStr = System.getProperty("disable.dasein.cloud.affinity.cache");
        disableAffinityCache = "true".equals(disableStr);
    }

    private static class Affinity {
        public HashMap<String, Constraint> constraints = new HashMap();

        private Affinity() {
        }
    }

    private static class Constraint {
        public String regionId;
        public long timeout;

        public Constraint(String regionId) {
            this.regionId = regionId;
            this.timeout = System.currentTimeMillis() + 1800000L + (long)random.nextInt(300000);
        }
    }
}

