/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.aws.storage;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.aws.AWSCloud;
import org.dasein.cloud.aws.storage.S3;
import org.dasein.cloud.aws.storage.S3Action;
import org.dasein.cloud.aws.storage.S3Exception;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.util.XMLParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class S3Method {
    private static final Logger logger = Logger.getLogger(S3Method.class);
    public static final String S3_PREFIX = "s3:";
    private S3Action action = null;
    private int attempts = 0;
    private String body = null;
    private String contentType = null;
    private Map<String, String> headers = null;
    private Map<String, String> parameters = null;
    private AWSCloud provider = null;
    private File uploadFile = null;
    private static final Logger wire = AWSCloud.getWireLogger(S3.class);

    @Nonnull
    public static ServiceAction[] asS3ServiceAction(@Nonnull String action) {
        if (action.equals("CreateBucket")) {
            return new ServiceAction[]{BlobStoreSupport.CREATE_BUCKET};
        }
        if (action.equals("GetObject")) {
            return new ServiceAction[]{BlobStoreSupport.DOWNLOAD};
        }
        if (action.equals("GetBucket")) {
            return new ServiceAction[]{BlobStoreSupport.GET_BUCKET};
        }
        if (action.equals("ListBucket")) {
            return new ServiceAction[]{BlobStoreSupport.LIST_BUCKET, BlobStoreSupport.LIST_BUCKET_CONTENTS};
        }
        if (action.equals("PutAccessControlPolicy")) {
            return new ServiceAction[]{BlobStoreSupport.MAKE_PUBLIC};
        }
        if (action.equals("DeleteBucket")) {
            return new ServiceAction[]{BlobStoreSupport.REMOVE_BUCKET};
        }
        if (action.equals("PutObject")) {
            return new ServiceAction[]{BlobStoreSupport.UPLOAD};
        }
        return new ServiceAction[0];
    }

    public static byte[] computeMD5Hash(String str) throws NoSuchAlgorithmException, IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes("utf-8"));
        return S3Method.computeMD5Hash(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] computeMD5Hash(InputStream is) throws NoSuchAlgorithmException, IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[16384];
            int bytesRead = -1;
            while ((bytesRead = bis.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, bytesRead);
            }
            byte[] byArray = messageDigest.digest();
            return byArray;
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e) {
                System.err.println("Unable to close input stream of hash candidate: " + e);
            }
        }
    }

    public static String getChecksum(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        return S3Method.toBase64(S3Method.computeMD5Hash(new FileInputStream(file)));
    }

    public static String toBase64(byte[] data) {
        byte[] b64 = Base64.encodeBase64((byte[])data);
        return new String(b64);
    }

    public S3Method(AWSCloud provider, S3Action action) {
        this.action = action;
        this.headers = new HashMap<String, String>();
        this.provider = provider;
    }

    public S3Method(AWSCloud provider, S3Action action, Map<String, String> parameters, Map<String, String> headers) {
        this.action = action;
        this.headers = headers == null ? new HashMap() : headers;
        this.provider = provider;
        this.parameters = parameters;
    }

    public S3Method(AWSCloud provider, S3Action action, Map<String, String> parameters, Map<String, String> headers, String contentType, String body) {
        this.action = action;
        this.headers = headers == null ? new HashMap() : headers;
        this.contentType = contentType;
        this.body = body;
        this.provider = provider;
        this.parameters = parameters;
    }

    public S3Method(AWSCloud provider, S3Action action, Map<String, String> parameters, Map<String, String> headers, String contentType, File uploadFile) {
        this.action = action;
        this.headers = headers == null ? new HashMap() : headers;
        this.contentType = contentType;
        this.uploadFile = uploadFile;
        this.provider = provider;
        this.parameters = parameters;
    }

    private String getDate() throws CloudException {
        if (this.provider.getEC2Provider().isStorage() && "google".equalsIgnoreCase(this.provider.getProviderName())) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ssz", new Locale("US"));
            Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
            format.setCalendar(cal);
            return format.format(new Date());
        }
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("US"));
        Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        fmt.setCalendar(cal);
        return fmt.format(new Date());
    }

    S3Response invoke(String bucket, String object) throws S3Exception, CloudException, InternalException {
        return this.invoke(bucket, object, null);
    }

    @Nonnull
    protected HttpClient getClient(String url, boolean multipart) throws InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        boolean ssl = url.startsWith("https");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        if (!multipart) {
            HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    /*
     * Exception decompiling
     */
    S3Response invoke(@Nullable String bucket, @Nullable String object, @Nullable String temporaryEndpoint) throws S3Exception, CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 79[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isValidDomainName(String bucket) {
        return bucket != null && Pattern.matches("^[a-z0-9](-*[a-z0-9]){2,62}$", bucket);
    }

    private Document parseResponse(InputStream responseBodyAsStream) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            in.close();
            wire.debug((Object)sb.toString());
            return XMLParser.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)e);
            e.printStackTrace();
            throw new CloudException((Throwable)e);
        }
    }

    public static class S3Response {
        public long contentLength;
        public String contentType;
        public Document document;
        public Header[] headers;
        public InputStream input;
        public HttpRequestBase method;

        public void close() {
            try {
                this.input.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

