/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureLocation;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.RandomPasswordGenerator;
import org.dasein.cloud.azure.compute.AzureComputeServices;
import org.dasein.cloud.azure.network.AzureNetworkServices;
import org.dasein.cloud.azure.storage.AzureStorageServices;
import org.dasein.cloud.azure.storage.model.CreateStorageServiceInputModel;
import org.w3c.dom.Document;

public class Azure
extends AbstractCloud {
    private static final Logger logger = Azure.getLogger(Azure.class);
    private static final Random random = new Random();
    private transient String storageEndpoint;
    private transient String storageService;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        String pkg = Azure.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("azure") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.azure.std." + pkg + Azure.getLastItem(cls.getName())));
    }

    @Nonnull
    public static Logger getWireLogger(@Nonnull Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.azure.wire." + Azure.getLastItem(cls.getPackage().getName()) + "." + Azure.getLastItem(cls.getName())));
    }

    @Nonnull
    public String generateToken(int minLength, int maxLength) {
        if (minLength < 0) {
            minLength = 0;
        }
        if (maxLength < minLength) {
            if (minLength == 0) {
                return "";
            }
            maxLength = minLength;
        }
        String token = new String(RandomPasswordGenerator.generatePassword(minLength, maxLength, 2, 2, 2));
        return token;
    }

    @Nonnull
    public String getCloudName() {
        return "Azure";
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field("apiKey", "The API Keypair", ContextRequirements.FieldType.KEYPAIR, "x509", true)});
    }

    public String getDataCenterId(String regionId) {
        return regionId;
    }

    @Nonnull
    public AzureComputeServices getComputeServices() {
        return new AzureComputeServices(this);
    }

    @Nonnull
    public AzureLocation getDataCenterServices() {
        return new AzureLocation(this);
    }

    @Nonnull
    public AzureNetworkServices getNetworkServices() {
        return new AzureNetworkServices(this);
    }

    @Nullable
    public String getStorageEndpoint() throws CloudException, InternalException {
        if (this.storageEndpoint == null) {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No configuration was set for this request");
            }
            AzureMethod method = new AzureMethod(this);
            Document xml = method.getAsXML(ctx.getAccountNumber(), "/services/storageservices");
            if (xml == null) {
                throw new CloudException("Unable to identify the blob endpoint");
            }
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            try {
                XPathExpression expr = xpath.compile("(/StorageServices/StorageService/StorageServiceProperties[GeoPrimaryRegion='" + ctx.getRegionId() + "']/Endpoints/Endpoint[contains(.,'.blob.')])[1]");
                this.storageEndpoint = expr.evaluate(xml).trim();
            }
            catch (XPathExpressionException e) {
                throw new CloudException("Invalid blob endpoint search expression");
            }
            if (this.storageEndpoint == null || this.storageEndpoint.isEmpty()) {
                this.storageEndpoint = null;
            }
        }
        return this.storageEndpoint;
    }

    @Nullable
    public String getStorageService() throws CloudException, InternalException {
        if (this.storageService == null) {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No configuration was set for this request");
            }
            AzureMethod method = new AzureMethod(this);
            Document xml = method.getAsXML(ctx.getAccountNumber(), "/services/storageservices");
            if (xml == null) {
                throw new CloudException("Unable to identify the storage service");
            }
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            try {
                XPathExpression expr = xpath.compile("(/StorageServices/StorageService/StorageServiceProperties[GeoPrimaryRegion='" + ctx.getRegionId() + "']/../ServiceName)[1]");
                this.storageService = expr.evaluate(xml).trim();
            }
            catch (XPathExpressionException e) {
                throw new CloudException("Failed to find storage service in the current region: " + ctx.getRegionId());
            }
            if (this.storageService == null || this.storageService.isEmpty()) {
                this.storageService = null;
            }
        }
        return this.storageService;
    }

    public void createDefaultStorageService() throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No configuration was set for this request");
        }
        String randomSufix = UUID.randomUUID().toString().replace("-", "").substring(0, 13);
        String serviceName = "portalvhds" + randomSufix;
        CreateStorageServiceInputModel createStorageServiceInputModel = new CreateStorageServiceInputModel();
        createStorageServiceInputModel.setServiceName(serviceName);
        createStorageServiceInputModel.setDescription("Implicitly created storage service");
        createStorageServiceInputModel.setLabel(new String(Base64.encodeBase64((byte[])randomSufix.getBytes())));
        createStorageServiceInputModel.setLocation(ctx.getRegionId());
        createStorageServiceInputModel.setGeoReplicationEnabled("true");
        String requestId = null;
        AzureMethod azureMethod = new AzureMethod(this);
        try {
            requestId = azureMethod.post("/services/storageservices", createStorageServiceInputModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        if (requestId != null) {
            int httpCode = azureMethod.getOperationStatus(requestId);
            while (httpCode == -1) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                httpCode = azureMethod.getOperationStatus(requestId);
            }
            if (httpCode == 200) {
                this.storageEndpoint = "https://" + serviceName + ".blob.core.windows.net/";
            }
        }
    }

    @Nonnull
    public AzureStorageServices getStorageServices() {
        return new AzureStorageServices(this);
    }

    @Nonnull
    public String getProviderName() {
        return "Microsoft";
    }

    @Nonnull
    public String getVMProductsResource() {
        Properties p;
        ProviderContext ctx = this.getContext();
        String value = ctx == null ? null : ((p = ctx.getCustomProperties()) == null ? null : p.getProperty("vmproducts"));
        if (value == null) {
            value = System.getProperty("azure.vmproducts");
        }
        if (value == null) {
            value = "/org/dasein/cloud/azure/vmproducts.json";
        }
        return value;
    }

    public long parseTimestamp(@Nullable String time) throws CloudException {
        if (time == null) {
            return 0L;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (time.length() > 0) {
            try {
                return fmt.parse(time).getTime();
            }
            catch (ParseException e) {
                fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                try {
                    return fmt.parse(time).getTime();
                }
                catch (ParseException encore) {
                    throw new CloudException("Could not parse date: " + time);
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + Azure.class.getName() + ".testContext()"));
        }
        try {
            AzureMethod method = new AzureMethod(this);
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                logger.error((Object)"No context was specified for a context test");
                String string = null;
                return string;
            }
            if (method.getAsStream(ctx.getAccountNumber(), "/locations") == null) {
                logger.warn((Object)("Account number was invalid for context test: " + ctx.getAccountNumber()));
                String string = null;
                return string;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Valid account: " + ctx.getAccountNumber()));
            }
            String string = ctx.getAccountNumber();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to test context: " + e.getMessage()));
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + Azure.class.getName() + ".testContext()"));
            }
        }
    }
}

