/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureLocationCapabilities;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.AzureService;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Folder;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureLocation
implements DataCenterServices {
    private static final Logger logger = Azure.getLogger(AzureLocation.class);
    private static final String LOCATIONS = "/locations";
    private Azure provider;
    private volatile transient AzureLocationCapabilities capabilities;

    AzureLocation(Azure provider) {
        this.provider = provider;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new AzureLocationCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String providerDataCenterId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new AzureConfigException("No region was specified for this request");
        }
        for (DataCenter dc : this.listDataCenters(regionId)) {
            if (!dc.getProviderDataCenterId().equals(providerDataCenterId)) continue;
            return dc;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "data center";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(providerRegionId)) continue;
            return region;
        }
        return null;
    }

    public boolean isSubscribed(AzureService toService) throws InternalException, CloudException {
        Boolean isSubscribed;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        String cacheName = "AzureLocation.isSubscribed." + (Object)((Object)toService);
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)cacheName, Boolean.class, (CacheLevel)CacheLevel.REGION_ACCOUNT);
        Iterable cachedIsSubscribed = cache.get(ctx);
        if (cachedIsSubscribed != null && cachedIsSubscribed.iterator().hasNext() && (isSubscribed = (Boolean)cachedIsSubscribed.iterator().next()) != null) {
            return isSubscribed;
        }
        Document doc = method.getAsXML(ctx.getAccountNumber(), LOCATIONS);
        if (doc == null) {
            cache.put(ctx, Collections.singleton(false));
            return false;
        }
        NodeList entries = doc.getElementsByTagName("Location");
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            if (entry == null) continue;
            NodeList attributes = entry.getChildNodes();
            String regionId = null;
            boolean subscribed = false;
            block1: for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                if (attribute.getNodeName().equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                    regionId = attribute.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase("availableservices") || !attribute.hasChildNodes()) continue;
                NodeList services = attribute.getChildNodes();
                for (int k = 0; k < services.getLength(); ++k) {
                    Node service = services.item(k);
                    if (service == null || !service.getNodeName().equalsIgnoreCase("availableservice") || !service.hasChildNodes()) continue;
                    String serviceName = service.getFirstChild().getNodeValue().trim();
                    if (!toService.toString().equalsIgnoreCase(serviceName)) continue;
                    subscribed = true;
                    continue block1;
                }
            }
            if (regionId == null || !regionId.equalsIgnoreCase(ctx.getRegionId())) continue;
            cache.put(ctx, Collections.singleton(subscribed));
            return subscribed;
        }
        cache.put(ctx, Collections.singleton(false));
        return false;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        Region region = this.getRegion(providerRegionId);
        if (region == null) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<DataCenter> dcs = new ArrayList<DataCenter>();
        DataCenter dc = new DataCenter();
        dc.setActive(true);
        dc.setAvailable(true);
        dc.setName(region.getName());
        dc.setProviderDataCenterId(providerRegionId);
        dc.setRegionId(providerRegionId);
        dcs.add(dc);
        return dcs;
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"regions", Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
        ArrayList<Region> regions = (ArrayList<Region>)cache.get(ctx);
        if (regions == null) {
            regions = new ArrayList<Region>();
            AzureMethod method = new AzureMethod(this.provider);
            Document doc = method.getAsXML(ctx.getAccountNumber(), LOCATIONS);
            if (doc == null) {
                return Collections.emptyList();
            }
            NodeList entries = doc.getElementsByTagName("Location");
            for (int i = 0; i < entries.getLength(); ++i) {
                Node entry = entries.item(i);
                Region region = this.toRegion(entry);
                if (region == null) continue;
                regions.add(region);
            }
            cache.put(ctx, regions);
        }
        return regions;
    }

    @Nullable
    private Region toRegion(@Nullable Node entry) {
        if (entry == null) {
            return null;
        }
        Region region = new Region();
        NodeList attributes = entry.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                region.setProviderRegionId(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!nodeName.equalsIgnoreCase("displayName") || !attribute.hasChildNodes()) continue;
            region.setName(attribute.getFirstChild().getNodeValue().trim());
        }
        if (region.getProviderRegionId() == null) {
            return null;
        }
        if (region.getName() == null) {
            region.setName(region.getProviderRegionId());
        }
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction("US");
        return region;
    }

    public Collection<ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public StoragePool getStoragePool(String providerStoragePoolId) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Collection<Folder> listVMFolders() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Folder getVMFolder(String providerVMFolderId) throws InternalException, CloudException {
        return null;
    }
}

