/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.RequestTrackingStrategy;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureException;
import org.dasein.cloud.azure.AzureSSLSocketFactory;
import org.dasein.cloud.azure.AzureX509;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureMethod {
    private static final Logger logger = Azure.getLogger(AzureMethod.class);
    private static final Logger wire = Azure.getWireLogger(AzureMethod.class);
    private String endpoint;
    private Azure provider;
    private RequestTrackingStrategy strategy;

    public AzureMethod(Azure azure) throws CloudException {
        this.provider = azure;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was provided for this request");
        }
        this.endpoint = ctx.getEndpoint();
        if (this.endpoint == null) {
            throw new AzureConfigException("No endpoint was provided for this request");
        }
        if (!this.endpoint.endsWith("/")) {
            this.endpoint = this.endpoint + "/";
        }
        this.strategy = this.provider.getContext().getRequestTrackingStrategy();
    }

    @Nullable
    public InputStream getAsStream(@Nonnull String account, @Nonnull String resource) throws CloudException, InternalException {
        try {
            return this.getAsStream(account, new URI(this.endpoint + account + resource));
        }
        catch (URISyntaxException e) {
            throw new InternalException("Endpoint misconfiguration (" + this.endpoint + account + resource + "): " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public InputStream getAsStream(@Nonnull String account, @Nonnull URI uri) throws CloudException, InternalException {
        logger.trace((Object)("enter - " + AzureMethod.class.getName() + ".get(" + account + "," + uri + ")"));
        wire.debug((Object)("--------------------------------------------------------> " + uri.toASCIIString()));
        try {
            InputStream input;
            HttpEntity entity;
            StatusLine status;
            HttpResponse response;
            HttpClient client = this.getClient();
            HttpGet get = new HttpGet(uri);
            if (uri.toString().indexOf("/services/images") > -1) {
                get.addHeader("x-ms-version", "2012-08-01");
            } else if (uri.toString().contains("/services/vmimages")) {
                get.addHeader("x-ms-version", "2014-05-01");
            } else {
                get.addHeader("x-ms-version", "2012-03-01");
            }
            if (this.strategy != null && this.strategy.getSendAsHeader()) {
                get.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
            }
            wire.debug((Object)get.getRequestLine().toString());
            for (Header header : get.getAllHeaders()) {
                wire.debug((Object)(header.getName() + ": " + header.getValue()));
            }
            try {
                response = client.execute((HttpUriRequest)get);
                status = response.getStatusLine();
            }
            catch (IOException e) {
                logger.error((Object)("get(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
            logger.debug((Object)("get(): HTTP Status " + status));
            Header[] headers = response.getAllHeaders();
            wire.debug((Object)status.toString());
            for (Header h : headers) {
                if (h.getValue() != null) {
                    wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                    continue;
                }
                wire.debug((Object)(h.getName() + ":"));
            }
            if (status.getStatusCode() == 404) {
                Header[] arr$ = null;
                return arr$;
            }
            if (status.getStatusCode() != 200 && status.getStatusCode() != 203) {
                String body;
                logger.error((Object)("get(): Expected OK for GET request, got " + status.getStatusCode()));
                entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    body = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                wire.debug((Object)body);
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), body);
                if (items == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                logger.error((Object)("get(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            entity = response.getEntity();
            if (entity == null) {
                InputStream body = null;
                return body;
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                logger.error((Object)("get(): Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
            wire.debug((Object)"---> Binary Data <---");
            InputStream inputStream = input;
            return inputStream;
        }
        finally {
            logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
            wire.debug((Object)("--------------------------------------------------------> " + uri.toASCIIString()));
        }
    }

    @Nullable
    public Document getAsXML(@Nonnull String account, @Nonnull String resource) throws CloudException, InternalException {
        try {
            return this.getAsXML(account, new URI(this.endpoint + account + resource));
        }
        catch (URISyntaxException e) {
            throw new InternalException("Endpoint misconfiguration (" + this.endpoint + account + resource + "): " + e.getMessage());
        }
    }

    @Nullable
    public <T> T get(Class<T> classType, @Nonnull String resource) throws CloudException, InternalException {
        try {
            return this.get(classType, new URI(this.endpoint + this.provider.getContext().getAccountNumber() + resource));
        }
        catch (URISyntaxException e) {
            throw new InternalException("Endpoint misconfiguration (" + this.endpoint + this.provider.getContext().getAccountNumber() + resource + "): " + e.getMessage());
        }
    }

    @Nullable
    public <T> T get(Class<T> classType, @Nonnull URI uri) throws CloudException, InternalException {
        InputStream responseAsStream = this.getAsStream(this.provider.getContext().getAccountNumber(), uri);
        if (responseAsStream == null) {
            logger.info((Object)("Unable to perform HTTP GET at following resource: " + uri.toString()));
            return null;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classType});
            Unmarshaller u = context.createUnmarshaller();
            return (T)u.unmarshal(responseAsStream);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            throw new InternalException((Throwable)ex);
        }
    }

    public <T> String post(String resource, T object) throws JAXBException, CloudException, InternalException {
        StringWriter stringWriter = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller m = jc.createMarshaller();
        m.marshal(object, (Writer)stringWriter);
        return this.post(this.provider.getContext().getAccountNumber(), resource, stringWriter.toString());
    }

    public <T> String put(String resource, T object) throws JAXBException, CloudException, InternalException {
        StringWriter stringWriter = new StringWriter();
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller m = jc.createMarshaller();
        m.marshal(object, (Writer)stringWriter);
        return this.invoke("PUT", this.provider.getContext().getAccountNumber(), resource, stringWriter.toString());
    }

    @Nullable
    public Document getAsXML(@Nonnull String account, @Nonnull URI uri) throws CloudException, InternalException {
        InputStream stream = this.getAsStream(account, uri);
        if (stream == null) {
            return null;
        }
        return this.parseResponse(stream, true);
    }

    @Nonnull
    protected HttpClient getClient() throws CloudException, InternalException {
        int targetPort;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was defined for this request");
        }
        String endpoint = ctx.getEndpoint();
        if (endpoint == null) {
            throw new AzureConfigException("No cloud endpoint was defined");
        }
        boolean ssl = endpoint.startsWith("https");
        try {
            URI uri = new URI(endpoint);
            targetPort = uri.getPort();
            if (targetPort < 1) {
                targetPort = ssl ? 443 : 80;
            }
        }
        catch (URISyntaxException e) {
            throw new AzureConfigException(e);
        }
        BasicHttpParams params = new BasicHttpParams();
        SchemeRegistry registry = new SchemeRegistry();
        try {
            registry.register(new Scheme(ssl ? "https" : "http", targetPort, (SchemeSocketFactory)new AzureSSLSocketFactory(new AzureX509(this.provider))));
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        params.setParameter("http.connection.timeout", (Object)10000);
        params.setParameter("http.socket.timeout", (Object)300000);
        HttpProxyConfig httpProxyConfig = this.getHttpProxyConfigData();
        if (httpProxyConfig != null) {
            params.setParameter("http.route.default-proxy", (Object)new HttpHost(httpProxyConfig.getHost(), httpProxyConfig.getPort().intValue()));
            registry.register(new Scheme("http", httpProxyConfig.getPort().intValue(), (SchemeSocketFactory)new PlainSocketFactory()));
        }
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager(registry);
        return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
    }

    private HttpProxyConfig getHttpProxyConfigData() {
        Properties p = this.provider.getContext().getCustomProperties();
        HttpProxyConfig httpProxyConfig = null;
        if (p != null && p.getProperty("proxyHost") != null && p.getProperty("proxyPort") != null) {
            if (p.getProperty("proxyPort").length() > 0) {
                httpProxyConfig = new HttpProxyConfig(p.getProperty("proxyHost"), Integer.parseInt(p.getProperty("proxyPort")));
            }
        } else {
            p = System.getProperties();
            if (p != null && p.getProperty("proxyHost") != null && p.getProperty("proxyPort") != null && p.getProperty("proxyPort").length() > 0) {
                httpProxyConfig = new HttpProxyConfig(p.getProperty("proxyHost"), Integer.parseInt(p.getProperty("proxyPort")));
            }
        }
        return httpProxyConfig;
    }

    @Nonnull
    public Document parseResponse(@Nonnull String responseBody, boolean withWireLogging) throws CloudException, InternalException {
        try {
            if (wire != null && wire.isDebugEnabled()) {
                String[] lines = responseBody.split("\n");
                if (lines.length < 1) {
                    lines = new String[]{responseBody};
                }
                for (String l : lines) {
                    wire.debug((Object)l);
                }
                wire.debug((Object)"");
            }
            ByteArrayInputStream bas = new ByteArrayInputStream(responseBody.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(bas);
            bas.close();
            return doc;
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Document parseResponse(@Nonnull InputStream responseBodyAsStream, boolean withWireLogging) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            return this.parseResponse(sb.toString(), withWireLogging);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(@Nonnull String account, @Nonnull String resource, @Nonnull String body) throws CloudException, InternalException {
        String requestId;
        block36: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureMethod.class.getName() + ".post(" + account + "," + resource + ")"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                wire.debug((Object)"");
            }
            requestId = null;
            try {
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                String url = this.endpoint + account + resource;
                HttpPost post = new HttpPost(url);
                if (url.toLowerCase().contains("operations")) {
                    post.addHeader("x-ms-version", "2014-02-01");
                } else if (url.toLowerCase().contains("/deployments")) {
                    post.addHeader("x-ms-version", "2014-05-01");
                } else {
                    post.addHeader("x-ms-version", "2012-03-01");
                }
                if (this.strategy != null && this.strategy.getSendAsHeader()) {
                    post.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
                }
                if (url.endsWith("/services/networking/media")) {
                    post.addHeader("Content-Type", "text/plain;charset=UTF-8");
                } else {
                    post.addHeader("Content-Type", "application/xml;charset=UTF-8");
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)post.getRequestLine().toString());
                    for (Header header : post.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (body != null) {
                        wire.debug((Object)body);
                        wire.debug((Object)"");
                    }
                }
                if (body != null) {
                    try {
                        if (url.endsWith("/services/networking/media")) {
                            post.setEntity((HttpEntity)new StringEntity(body, "text/plain", "utf-8"));
                        } else {
                            post.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new InternalException((Throwable)e);
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)post);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                }
                for (Header h : headers) {
                    if (h.getValue() != null) {
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                        }
                        if (!h.getName().equalsIgnoreCase("x-ms-request-id")) continue;
                        requestId = h.getValue().trim();
                        continue;
                    }
                    if (!wire.isDebugEnabled()) continue;
                    wire.debug((Object)(h.getName() + ":"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 200 || status.getStatusCode() == 201 || status.getStatusCode() == 202) break block36;
                logger.error((Object)("post(): Expected OK for GET request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    body = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)body);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), body);
                if (items == null) {
                    throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), "Unknown", "Unknown");
                }
                logger.error((Object)("post(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".post()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                }
            }
        }
        return requestId;
    }

    protected HttpRequestBase getMethod(String httpMethod, String url) {
        Object method = null;
        method = httpMethod.equals("GET") ? new HttpGet(url) : (httpMethod.equals("POST") ? new HttpPost(url) : (httpMethod.equals("PUT") ? new HttpPut(url) : (httpMethod.equals("DELETE") ? new HttpDelete(url) : (httpMethod.equals("HEAD") ? new HttpHead(url) : (httpMethod.equals("OPTIONS") ? new HttpOptions(url) : (httpMethod.equals("HEAD") ? new HttpTrace(url) : new HttpGet(url)))))));
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoke(@Nonnull String method, @Nonnull String account, @Nonnull String resource, @Nonnull String body) throws CloudException, InternalException {
        String requestId;
        block39: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureMethod.class.getName() + ".post(" + account + "," + resource + ")"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                wire.debug((Object)"");
            }
            requestId = null;
            try {
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                String url = this.endpoint + account + resource;
                HttpRequestBase httpMethod = this.getMethod(method, url);
                if (httpMethod instanceof HttpPut) {
                    if (url.endsWith("/services/networking/media")) {
                        httpMethod.addHeader("Content-Type", "text/plain");
                    } else {
                        httpMethod.addHeader("Content-Type", "application/xml;charset=UTF-8");
                    }
                } else {
                    httpMethod.addHeader("Content-Type", "application/xml;charset=UTF-8");
                }
                if (url.indexOf("/services/images") > -1 || httpMethod instanceof HttpDelete && url.indexOf("/services/disks") > -1) {
                    httpMethod.addHeader("x-ms-version", "2012-08-01");
                } else {
                    httpMethod.addHeader("x-ms-version", "2012-03-01");
                }
                if (this.strategy != null && this.strategy.getSendAsHeader()) {
                    httpMethod.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)httpMethod.getRequestLine().toString());
                    for (Header header : httpMethod.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (body != null) {
                        wire.debug((Object)body);
                        wire.debug((Object)"");
                    }
                }
                if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
                    HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)httpMethod;
                    if (body != null) {
                        try {
                            entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new CloudException((Throwable)e);
                        }
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)httpMethod);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                }
                for (Header h : headers) {
                    if (h.getValue() != null) {
                        if (wire.isDebugEnabled()) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                        }
                        if (!h.getName().equalsIgnoreCase("x-ms-request-id")) continue;
                        requestId = h.getValue().trim();
                        continue;
                    }
                    if (!wire.isDebugEnabled()) continue;
                    wire.debug((Object)(h.getName() + ":"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 307) {
                    logger.warn((Object)("Expected OK, got " + status.getStatusCode()));
                    String responseBody = "";
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                    }
                    try {
                        responseBody = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (IOException e) {
                        throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                    }
                    logger.debug((Object)responseBody);
                    logger.debug((Object)("https: char " + responseBody.indexOf("https://")));
                    logger.debug((Object)("account number: char " + responseBody.indexOf(account)));
                    String tempEndpoint = responseBody.substring(responseBody.indexOf("https://"), responseBody.indexOf(account) - responseBody.indexOf("https://"));
                    logger.debug((Object)("temp redirect location: " + tempEndpoint));
                    this.tempRedirectInvoke(tempEndpoint, method, account, resource, body);
                    break block39;
                }
                if (status.getStatusCode() == 200 || status.getStatusCode() == 201 || status.getStatusCode() == 202) break block39;
                logger.error((Object)("post(): Expected OK for GET request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    body = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)body);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), body);
                if (items == null) {
                    throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), "Unknown", "Unknown");
                }
                logger.error((Object)("post(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".post()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                }
            }
        }
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tempRedirectInvoke(@Nonnull String tempEndpoint, @Nonnull String method, @Nonnull String account, @Nonnull String resource, @Nonnull String body) throws CloudException, InternalException {
        block33: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureMethod.class.getName() + ".post(" + account + "," + resource + ")"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                wire.debug((Object)"");
            }
            try {
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                String url = tempEndpoint + account + resource;
                HttpRequestBase httpMethod = this.getMethod(method, url);
                if (httpMethod instanceof HttpPut) {
                    if (url.endsWith("/services/networking/media")) {
                        httpMethod.addHeader("Content-Type", "text/plain");
                    } else {
                        httpMethod.addHeader("Content-Type", "application/xml;charset=UTF-8");
                    }
                } else {
                    httpMethod.addHeader("Content-Type", "application/xml;charset=UTF-8");
                }
                if (url.indexOf("/services/images") > -1 || httpMethod instanceof HttpDelete && url.indexOf("/services/disks") > -1) {
                    httpMethod.addHeader("x-ms-version", "2012-08-01");
                } else {
                    httpMethod.addHeader("x-ms-version", "2012-03-01");
                }
                if (this.strategy != null && this.strategy.getSendAsHeader()) {
                    httpMethod.addHeader(this.strategy.getHeaderName(), this.strategy.getRequestId());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)httpMethod.getRequestLine().toString());
                    for (Header header : httpMethod.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (body != null) {
                        wire.debug((Object)body);
                        wire.debug((Object)"");
                    }
                }
                if (httpMethod instanceof HttpEntityEnclosingRequestBase) {
                    HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)httpMethod;
                    if (body != null) {
                        try {
                            entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)httpMethod);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                    for (Header h : headers) {
                        if (h.getValue() != null) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                            continue;
                        }
                        wire.debug((Object)(h.getName() + ":"));
                    }
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 200 || status.getStatusCode() == 201 || status.getStatusCode() == 202) break block33;
                logger.error((Object)("post(): Expected OK for GET request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    body = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)body);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), body);
                if (items == null) {
                    throw new CloudException(CloudErrorType.GENERAL, status.getStatusCode(), "Unknown", "Unknown");
                }
                logger.error((Object)("post(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".post()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)("POST --------------------------------------------------------> " + this.endpoint + account + resource));
                }
            }
        }
    }

    @Nonnull
    public int getOperationStatus(String requestID) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        Document doc = this.getAsXML(ctx.getAccountNumber(), "/operations/" + requestID);
        if (doc == null) {
            return -2;
        }
        NodeList entries = doc.getElementsByTagName("Operation");
        Node entry = entries.item(0);
        NodeList s = entry.getChildNodes();
        String status = "";
        String httpCode = "";
        for (int i = 0; i < s.getLength(); ++i) {
            Node attribute = s.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("status") && attribute.hasChildNodes()) {
                status = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (status.length() <= 0 || status.equalsIgnoreCase("inProgress") || !attribute.getNodeName().equalsIgnoreCase("httpstatuscode") || !attribute.hasChildNodes()) continue;
            httpCode = attribute.getFirstChild().getNodeValue().trim();
        }
        if (status.equalsIgnoreCase("succeeded")) {
            return 200;
        }
        if (status.equalsIgnoreCase("failed")) {
            String errMsg = this.checkError(s, httpCode);
            throw new CloudException(errMsg);
        }
        return -1;
    }

    private String checkError(NodeList s, String httpCode) throws CloudException, InternalException {
        String errMsg = httpCode + ": ";
        for (int i = 0; i < s.getLength(); ++i) {
            Node attribute = s.item(i);
            if (attribute.getNodeType() == 3 || !attribute.getNodeName().equalsIgnoreCase("Error") || !attribute.hasChildNodes()) continue;
            NodeList errors = attribute.getChildNodes();
            for (int error = 0; error < errors.getLength(); ++error) {
                Node node = errors.item(error);
                if (node.getNodeName().equalsIgnoreCase("code") && node.hasChildNodes()) {
                    errMsg = errMsg + node.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!node.getNodeName().equalsIgnoreCase("message") || !node.hasChildNodes()) continue;
                errMsg = errMsg + ". reason: " + node.getFirstChild().getNodeValue().trim();
            }
        }
        return errMsg;
    }

    private class HttpProxyConfig {
        private String host;
        private Integer port;

        public HttpProxyConfig(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }
    }

    public static class AzureResponse {
        public int httpCode;
        public Object body;
    }
}

