/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureException;
import org.dasein.cloud.azure.AzureMethod;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureStorageMethod {
    private static final Logger logger = Azure.getLogger(AzureStorageMethod.class);
    private static final Logger wire = Azure.getWireLogger(AzureStorageMethod.class);
    public static final String VERSION = "2009-09-19";
    private String Header_Prefix_MS = "x-ms-";
    public static final String Storage_OPERATION_DELETE = "DELETE";
    public static final String Storage_OPERATION_PUT = "PUT";
    public static final String Storage_OPERATION_GET = "GET";
    private Azure provider;

    public AzureStorageMethod(Azure azure) throws AzureConfigException {
        this.provider = azure;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was provided for this request");
        }
    }

    private void fetchKeys() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        if (ctx.getStoragePrivate() == null) {
            AzureMethod method = new AzureMethod(this.provider);
            String storageService = this.provider.getStorageService();
            if (storageService == null || storageService.isEmpty()) {
                throw new CloudException("Unable to find storage service in the current region: " + ctx.getRegionId());
            }
            Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/storageservices/" + storageService + "/keys");
            if (doc == null) {
                throw new CloudException("Unable to identify the storage keys for this account");
            }
            NodeList keys = doc.getElementsByTagName("StorageServiceKeys");
            for (int i = 0; i < keys.getLength(); ++i) {
                Node key = keys.item(i);
                if (!key.getNodeName().equalsIgnoreCase("StorageServiceKeys") || !key.hasChildNodes()) continue;
                NodeList parts = key.getChildNodes();
                String p = null;
                String s = null;
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (part.getNodeName().equalsIgnoreCase("primary") && part.hasChildNodes()) {
                        p = part.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("secondary") || !part.hasChildNodes()) continue;
                    s = part.getFirstChild().getNodeValue().trim();
                }
                if (p != null) {
                    try {
                        ctx.setStoragePrivate(p.getBytes("utf-8"));
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
                        throw new InternalException((Throwable)e);
                    }
                }
                if (s == null) continue;
                try {
                    ctx.setStoragePrivate(s.getBytes("utf-8"));
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
                    throw new InternalException((Throwable)e);
                }
            }
        }
    }

    private String getStorageAccount() throws CloudException, InternalException {
        return this.provider.getStorageService();
    }

    private String calculatedSharedKeyLiteSignature(@Nonnull HttpRequestBase method, @Nonnull Map<String, String> queryParams) throws CloudException, InternalException {
        String contentType;
        this.fetchKeys();
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        Header h = method.getFirstHeader("content-type");
        String string = contentType = h == null ? null : h.getValue();
        if (contentType == null) {
            contentType = "";
        }
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append(method.getMethod().toUpperCase()).append("\n");
        stringToSign.append("\n");
        stringToSign.append(contentType).append("\n");
        stringToSign.append(method.getFirstHeader("date").getValue()).append("\n");
        Header[] headers = method.getAllHeaders();
        TreeSet<String> keys = new TreeSet<String>();
        for (Header header : headers) {
            if (!header.getName().startsWith(this.Header_Prefix_MS)) continue;
            keys.add(header.getName().toLowerCase());
        }
        for (String key : keys) {
            Header header = method.getFirstHeader(key);
            if (header != null) {
                Header[] all = method.getHeaders(key);
                stringToSign.append(key.toLowerCase().trim()).append(":");
                if (all != null && all.length > 0) {
                    for (Header current : all) {
                        String v = current.getValue() != null ? current.getValue() : "";
                        stringToSign.append(v.trim().replaceAll("\n", " ")).append(",");
                    }
                }
                stringToSign.deleteCharAt(stringToSign.lastIndexOf(","));
            } else {
                stringToSign.append(key.toLowerCase().trim()).append(":");
            }
            stringToSign.append("\n");
        }
        stringToSign.append("/").append(this.getStorageAccount()).append(method.getURI().getPath());
        keys.clear();
        for (String key : queryParams.keySet()) {
            if (!key.equalsIgnoreCase("comp")) continue;
            key = key.toLowerCase();
            keys.add(key);
        }
        if (!keys.isEmpty()) {
            stringToSign.append("?");
            for (String key : keys) {
                String value = queryParams.get(key);
                if (value == null) {
                    value = "";
                }
                stringToSign.append(key).append("=").append(value).append("&");
            }
            stringToSign.deleteCharAt(stringToSign.lastIndexOf("&"));
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"BEGIN STRING TO SIGN");
                logger.debug((Object)stringToSign.toString());
                logger.debug((Object)"END STRING TO SIGN");
            }
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(Base64.decodeBase64((byte[])ctx.getStoragePrivate()), "HmacSHA256"));
            String signature = new String(Base64.encodeBase64((byte[])mac.doFinal(stringToSign.toString().getBytes("UTF-8"))));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("signature=" + signature));
            }
            return signature;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("No such algorithm: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("Invalid key: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }

    public static Document createDoc() throws InternalException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static String convertDomToString(Document doc) throws CloudException, InternalException {
        try {
            if (doc == null) {
                return null;
            }
            StringWriter stw = new StringWriter();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.transform(new DOMSource(doc), new StreamResult(stw));
            if (stw != null) {
                return stw.toString();
            }
            return null;
        }
        catch (TransformerConfigurationException e) {
            throw new InternalException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new InternalException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public Document getAsDoc(@Nonnull String httpVerb, @Nonnull String resource, @Nullable Map<String, String> queries, @Nullable String body, @Nullable Map<String, String> headerMap, boolean authorization) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + httpVerb + "(" + this.getStorageAccount() + "," + resource + ")"));
        }
        String endpoint = this.getStorageEnpoint();
        if (wire.isDebugEnabled()) {
            wire.debug((Object)(httpVerb + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
            wire.debug((Object)"");
        }
        try {
            InputStream input;
            HttpEntity entity;
            StatusLine status;
            HttpResponse response;
            HttpClient client = this.getClient();
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            HttpRequestBase method = this.getMethod(httpVerb, this.buildUrl(resource, queries), queries, headerMap, authorization);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)method.getRequestLine().toString());
                for (Header header : method.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                if (body != null) {
                    wire.debug((Object)body);
                    wire.debug((Object)"");
                }
            }
            if (method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                if (body != null) {
                    entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                }
            }
            try {
                response = client.execute((HttpUriRequest)method);
                status = response.getStatusLine();
            }
            catch (IOException e) {
                logger.error((Object)("GET(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("GET(): HTTP Status " + status));
            }
            Header[] headers = response.getAllHeaders();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)status.toString());
                for (Header h : headers) {
                    if (h.getValue() != null) {
                        wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                        continue;
                    }
                    wire.debug((Object)(h.getName() + ":"));
                }
                wire.debug((Object)"");
            }
            if (status.getStatusCode() == 404) {
                Header[] arr$ = null;
                return arr$;
            }
            if (status.getStatusCode() != 200 && status.getStatusCode() != 203) {
                String result;
                logger.error((Object)(httpVerb + "(): Expected OK for " + httpVerb + "request, got " + status.getStatusCode()));
                entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                if (items == null) {
                    Document document = null;
                    return document;
                }
                logger.error((Object)(httpVerb + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            entity = response.getEntity();
            if (entity == null) {
                Document result = null;
                return result;
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                logger.error((Object)(httpVerb + "(): Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            Document document = this.parseResponse(input, true);
            return document;
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)"--------------------------------------------------------> ");
            }
        }
    }

    @Nullable
    public InputStream getAsStream(@Nonnull String strMethod, @Nonnull String resource, @Nonnull Map<String, String> queries, @Nullable String body, @Nullable Map<String, String> headerMap, boolean authorization) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + strMethod + "(" + this.getStorageAccount() + "," + resource + ")"));
        }
        String endpoint = this.getStorageEnpoint();
        if (wire.isDebugEnabled()) {
            wire.debug((Object)(strMethod + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
            wire.debug((Object)"");
        }
        try {
            InputStream input;
            HttpEntity entity;
            StatusLine status;
            HttpResponse response;
            HttpClient client = this.getClient();
            String contentLength = null;
            contentLength = body != null ? String.valueOf(body.length()) : "0";
            HttpRequestBase method = this.getMethod(strMethod, this.buildUrl(resource, queries), queries, headerMap, authorization);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)method.getRequestLine().toString());
                for (Header header : method.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                if (body != null) {
                    wire.debug((Object)body);
                    wire.debug((Object)"");
                }
            }
            if (method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                if (body != null) {
                    entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                }
            }
            try {
                response = client.execute((HttpUriRequest)method);
                status = response.getStatusLine();
            }
            catch (IOException e) {
                logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("post(): HTTP Status " + status));
            }
            Header[] headers = response.getAllHeaders();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)status.toString());
                for (Header h : headers) {
                    if (h.getValue() != null) {
                        wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                        continue;
                    }
                    wire.debug((Object)(h.getName() + ":"));
                }
                wire.debug((Object)"");
            }
            if (status.getStatusCode() == 404) {
                Header[] arr$ = null;
                return arr$;
            }
            if (status.getStatusCode() != 200 && status.getStatusCode() != 203) {
                String result;
                logger.error((Object)(strMethod + "(): Expected OK for " + strMethod + "request, got " + status.getStatusCode()));
                entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                if (items == null) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                logger.error((Object)(strMethod + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            entity = response.getEntity();
            if (entity == null) {
                InputStream result = null;
                return result;
            }
            try {
                input = entity.getContent();
            }
            catch (IOException e) {
                logger.error((Object)(strMethod + "(): Failed to read response error due to a cloud I/O error: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            InputStream inputStream = input;
            return inputStream;
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)"--------------------------------------------------------> ");
            }
        }
    }

    @Nonnull
    protected HttpClient getClient() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was defined for this request");
        }
        String endpoint = this.getStorageEnpoint();
        boolean ssl = endpoint.startsWith("https");
        try {
            URI uri = new URI(endpoint);
            int targetPort = uri.getPort();
            if (targetPort < 1) {
                targetPort = ssl ? 443 : 80;
            }
        }
        catch (URISyntaxException e) {
            throw new AzureConfigException(e);
        }
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    @Nonnull
    public Document parseResponse(@Nonnull String responseBody, boolean withWireLogging) throws CloudException, InternalException {
        try {
            if (wire != null && wire.isDebugEnabled()) {
                String[] lines = responseBody.split("\n");
                if (lines.length < 1) {
                    lines = new String[]{responseBody};
                }
                for (String l : lines) {
                    wire.debug((Object)l);
                }
                wire.debug((Object)"");
            }
            ByteArrayInputStream bas = new ByteArrayInputStream(responseBody.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(bas);
            bas.close();
            return doc;
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Document parseResponse(@Nonnull InputStream responseBodyAsStream, boolean withWireLogging) throws CloudException, InternalException {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(responseBodyAsStream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            in.close();
            String strResponse = sb.toString();
            int index = strResponse.indexOf("<");
            if (index > 0) {
                return this.parseResponse(strResponse.substring(index), withWireLogging);
            }
            return this.parseResponse(strResponse, withWireLogging);
        }
        catch (IOException e) {
            throw new CloudException((Throwable)e);
        }
    }

    public String buildUrl(String resource, Map<String, String> queries) throws InternalException, CloudException {
        String endpoint = this.getStorageEnpoint();
        StringBuilder str = new StringBuilder();
        str.append(endpoint);
        if (!endpoint.endsWith("/")) {
            str.append("/");
        }
        if (resource != null && !resource.equalsIgnoreCase("null")) {
            str.append(resource);
        }
        if (queries != null && queries.size() > 0) {
            str.append("?");
        }
        boolean firstPara = true;
        if (queries != null) {
            if (queries.containsKey("comp")) {
                str.append("comp");
                str.append("=");
                str.append(queries.get("comp"));
                firstPara = false;
            }
            for (String key : queries.keySet()) {
                if (key.equals("comp")) continue;
                if (firstPara) {
                    str.append(key);
                    str.append("=");
                    str.append(queries.get(key));
                    firstPara = false;
                    continue;
                }
                str.append("&");
                str.append(key);
                str.append("=");
                str.append(queries.get(key));
            }
        }
        return str.toString();
    }

    public String getBlobProperty(@Nonnull String strMethod, @Nonnull String resource, @Nonnull Map<String, String> queries, String body, @Nullable Map<String, String> headerMap, boolean authorization, String propertyName) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + strMethod + "(" + this.getStorageAccount() + "," + resource + ")"));
        }
        String endpoint = this.getStorageEnpoint();
        if (wire.isDebugEnabled()) {
            wire.debug((Object)(strMethod + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
            wire.debug((Object)"");
        }
        try {
            String string;
            StatusLine status;
            HttpResponse response;
            HttpClient client = this.getClient();
            if (headerMap == null) {
                headerMap = new HashMap<String, String>();
            }
            HttpRequestBase method = this.getMethod(strMethod, this.buildUrl(resource, queries), queries, headerMap, authorization);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)method.getRequestLine().toString());
                for (Header header : method.getAllHeaders()) {
                    wire.debug((Object)(header.getName() + ": " + header.getValue()));
                }
                wire.debug((Object)"");
                if (body != null) {
                    wire.debug((Object)body);
                    wire.debug((Object)"");
                }
            }
            if (method instanceof HttpEntityEnclosingRequestBase) {
                HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                if (body != null) {
                    entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                }
            }
            try {
                response = client.execute((HttpUriRequest)method);
                status = response.getStatusLine();
            }
            catch (IOException e) {
                logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                if (logger.isTraceEnabled()) {
                    e.printStackTrace();
                }
                throw new CloudException((Throwable)e);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("get(): HTTP Status " + status));
            }
            if (wire.isDebugEnabled()) {
                Header[] headers = response.getAllHeaders();
                wire.debug((Object)status.toString());
                for (Header h : headers) {
                    if (h.getValue() != null) {
                        wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                        continue;
                    }
                    wire.debug((Object)(h.getName() + ":"));
                }
                wire.debug((Object)"");
            }
            if (status.getStatusCode() == 404) {
                String headers = null;
                return headers;
            }
            if (status.getStatusCode() != 201 && status.getStatusCode() != 202 && status.getStatusCode() != 200 && status.getStatusCode() != 203) {
                String result;
                logger.error((Object)(strMethod + "(): Expected OK for " + strMethod + "request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                    int index = result.indexOf("<");
                    if (index > 0) {
                        result = result.substring(index);
                    }
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                logger.error((Object)(strMethod + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            Header header = response.getFirstHeader(propertyName);
            if (header != null) {
                string = header.getValue();
                return string;
            }
            string = null;
            return string;
        }
        catch (UnsupportedEncodingException e) {
            throw new CloudException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
            }
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)"--------------------------------------------------------> ");
            }
        }
    }

    public void invoke(@Nonnull String strMethod, @Nonnull String resource, @Nonnull Map<String, String> queries, @Nullable String body, @Nullable Map<String, String> headerMap, boolean authorization) throws CloudException, InternalException {
        block27: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + strMethod + "(" + this.getStorageAccount() + "," + resource + ")"));
            }
            String endpoint = this.getStorageEnpoint();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)(strMethod + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
                wire.debug((Object)"");
            }
            try {
                String result;
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                if (headerMap == null) {
                    headerMap = new HashMap<String, String>();
                }
                HttpRequestBase method = this.getMethod(strMethod, this.buildUrl(resource, queries), queries, headerMap, authorization);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)method.getRequestLine().toString());
                    for (Header header : method.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (body != null) {
                        wire.debug((Object)body);
                        wire.debug((Object)"");
                    }
                }
                if (method instanceof HttpEntityEnclosingRequestBase) {
                    HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                    if (body != null) {
                        entityEnclosingMethod.setEntity((HttpEntity)new StringEntity(body, "application/xml", "utf-8"));
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)method);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                    for (Header h : headers) {
                        if (h.getValue() != null) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                            continue;
                        }
                        wire.debug((Object)(h.getName() + ":"));
                    }
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 201 || status.getStatusCode() == 202 || status.getStatusCode() == 200 || status.getStatusCode() == 203) break block27;
                logger.error((Object)(strMethod + "(): Expected OK for " + strMethod + "request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                if (items != null) {
                    logger.error((Object)(strMethod + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                    throw new AzureException(items);
                }
                throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), "UnknownError", result);
            }
            catch (UnsupportedEncodingException e) {
                throw new CloudException((Throwable)e);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)"--------------------------------------------------------> ");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putWithFile(@Nonnull String strMethod, @Nonnull String resource, Map<String, String> queries, File file, Map<String, String> headerMap, boolean authorization) throws CloudException, InternalException {
        block23: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + strMethod + "(" + this.getStorageAccount() + "," + resource + ")"));
            }
            String endpoint = this.getStorageEnpoint();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)(strMethod + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
                wire.debug((Object)"");
            }
            long begin = System.currentTimeMillis();
            try {
                String result;
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                String contentLength = null;
                contentLength = file != null ? String.valueOf(file.length()) : "0";
                HttpRequestBase method = this.getMethod(strMethod, this.buildUrl(resource, queries), queries, headerMap, authorization);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)method.getRequestLine().toString());
                    for (Header header : method.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (file != null) {
                        wire.debug((Object)file);
                        wire.debug((Object)"");
                    }
                }
                if (method instanceof HttpEntityEnclosingRequestBase) {
                    HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                    if (file != null) {
                        entityEnclosingMethod.setEntity((HttpEntity)new FileEntity(file, ContentType.APPLICATION_OCTET_STREAM));
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)method);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    long end = System.currentTimeMillis();
                    logger.debug((Object)("Totoal time -> " + (end - begin)));
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                    for (Header h : headers) {
                        if (h.getValue() != null) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                            continue;
                        }
                        wire.debug((Object)(h.getName() + ":"));
                    }
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 201 || status.getStatusCode() == 202 || status.getStatusCode() == 200 || status.getStatusCode() == 203) break block23;
                logger.error((Object)(strMethod + "(): Expected OK for " + strMethod + "request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                logger.error((Object)(strMethod + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)"--------------------------------------------------------> ");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putWithBytes(@Nonnull String strMethod, @Nonnull String resource, Map<String, String> queries, byte[] body, Map<String, String> headerMap, boolean authorization) throws CloudException, InternalException {
        block23: {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("enter - " + AzureStorageMethod.class.getName() + "." + strMethod + "(" + this.getStorageAccount() + "," + resource + ")"));
            }
            String endpoint = this.getStorageEnpoint();
            if (wire.isDebugEnabled()) {
                wire.debug((Object)(strMethod + "--------------------------------------------------------> " + endpoint + this.getStorageAccount() + resource));
                wire.debug((Object)"");
            }
            try {
                String result;
                StatusLine status;
                HttpResponse response;
                HttpClient client = this.getClient();
                String contentLength = null;
                contentLength = body != null ? String.valueOf(body.length) : "0";
                HttpRequestBase method = this.getMethod(strMethod, this.buildUrl(resource, queries), queries, headerMap, authorization);
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)method.getRequestLine().toString());
                    for (Header header : method.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                    if (body != null) {
                        wire.debug((Object)body);
                        wire.debug((Object)"");
                    }
                }
                if (method instanceof HttpEntityEnclosingRequestBase) {
                    HttpEntityEnclosingRequestBase entityEnclosingMethod = (HttpEntityEnclosingRequestBase)method;
                    if (body != null) {
                        entityEnclosingMethod.setEntity((HttpEntity)new ByteArrayEntity(body));
                    }
                }
                try {
                    response = client.execute((HttpUriRequest)method);
                    status = response.getStatusLine();
                }
                catch (IOException e) {
                    logger.error((Object)("post(): Failed to execute HTTP request due to a cloud I/O error: " + e.getMessage()));
                    if (logger.isTraceEnabled()) {
                        e.printStackTrace();
                    }
                    throw new CloudException((Throwable)e);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post(): HTTP Status " + status));
                }
                Header[] headers = response.getAllHeaders();
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)status.toString());
                    for (Header h : headers) {
                        if (h.getValue() != null) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                            continue;
                        }
                        wire.debug((Object)(h.getName() + ":"));
                    }
                    wire.debug((Object)"");
                }
                if (status.getStatusCode() == 201 || status.getStatusCode() == 202 || status.getStatusCode() == 200 || status.getStatusCode() == 203) break block23;
                logger.error((Object)(strMethod + "(): Expected OK for " + strMethod + "request, got " + status.getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), "An error was returned without explanation");
                }
                try {
                    result = EntityUtils.toString((HttpEntity)entity);
                }
                catch (IOException e) {
                    throw new AzureException(CloudErrorType.GENERAL, status.getStatusCode(), status.getReasonPhrase(), e.getMessage());
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)result);
                }
                wire.debug((Object)"");
                AzureException.ExceptionItems items = AzureException.parseException(status.getStatusCode(), result);
                logger.error((Object)(strMethod + "(): [" + status.getStatusCode() + " : " + items.message + "] " + items.details));
                throw new AzureException(items);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("exit - " + AzureMethod.class.getName() + ".getStream()"));
                }
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)"");
                    wire.debug((Object)"--------------------------------------------------------> ");
                }
            }
        }
    }

    protected HttpRequestBase getMethod(@Nonnull String httpMethod, @Nonnull String endpoint, @Nonnull Map<String, String> queryParams, @Nullable Map<String, String> headers, boolean authorization) throws CloudException, InternalException {
        Object method = httpMethod.equals(Storage_OPERATION_GET) ? new HttpGet(endpoint) : (httpMethod.equals("POST") ? new HttpPost(endpoint) : (httpMethod.equals(Storage_OPERATION_PUT) ? new HttpPut(endpoint) : (httpMethod.equals(Storage_OPERATION_DELETE) ? new HttpDelete(endpoint) : (httpMethod.equals("HEAD") ? new HttpHead(endpoint) : (httpMethod.equals("OPTIONS") ? new HttpOptions(endpoint) : (httpMethod.equals("HEAD") ? new HttpTrace(endpoint) : new HttpGet(endpoint)))))));
        if (!authorization) {
            return method;
        }
        if (headers == null) {
            headers = new TreeMap<String, String>();
        }
        String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
        SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN);
        rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        headers.put("Date", rfc1123Format.format(new Date()));
        headers.put(this.Header_Prefix_MS + "version", VERSION);
        for (String key : headers.keySet()) {
            method.addHeader(key, headers.get(key));
        }
        if (method.getFirstHeader("content-type") == null && !httpMethod.equals(Storage_OPERATION_GET)) {
            method.addHeader("content-type", "application/xml;charset=utf-8");
        }
        method.addHeader("Authorization", "SharedKeyLite " + this.getStorageAccount() + ":" + this.calculatedSharedKeyLiteSignature((HttpRequestBase)method, queryParams));
        return method;
    }

    private String getStorageEnpoint() throws CloudException, InternalException {
        String storageEndpoint = this.provider.getStorageEndpoint();
        if (storageEndpoint == null || storageEndpoint.isEmpty()) {
            throw new CloudException("Cannot find blob storage endpoint in the current region");
        }
        return storageEndpoint;
    }
}

