/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.Azure;

public class AzureX509 {
    public static final String ENTRY_ALIAS = "";
    public static final String PASSWORD = "memory";
    private KeyStore keystore;

    public AzureX509(Azure provider) throws InternalException {
        ProviderContext ctx = provider.getContext();
        try {
            String apiShared = ENTRY_ALIAS;
            String apiSecret = ENTRY_ALIAS;
            try {
                List fields = provider.getContextRequirements().getConfigurableValues();
                for (ContextRequirements.Field f : fields) {
                    if (!f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) continue;
                    byte[][] keyPair = (byte[][])ctx.getConfigurationValue(f);
                    apiShared = new String(keyPair[0], "utf-8");
                    apiSecret = new String(keyPair[1], "utf-8");
                }
            }
            catch (UnsupportedEncodingException ignore) {
                // empty catch block
            }
            X509Certificate certificate = this.certFromString(apiShared);
            PrivateKey privateKey = this.keyFromString(apiSecret);
            this.keystore = this.createJavaKeystore(certificate, privateKey);
        }
        catch (Exception e) {
            throw new InternalException((Throwable)e);
        }
    }

    private X509Certificate certFromString(String pem) throws IOException {
        return (X509Certificate)this.readPemObject(pem);
    }

    private KeyStore createJavaKeystore(X509Certificate cert, PrivateKey key) throws NoSuchProviderException, KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore store = KeyStore.getInstance("JKS", "SUN");
        char[] pw = PASSWORD.toCharArray();
        store.load(null, pw);
        store.setKeyEntry(ENTRY_ALIAS, key, pw, new Certificate[]{cert});
        return store;
    }

    public KeyStore getKeystore() {
        return this.keystore;
    }

    private PrivateKey keyFromString(String pem) throws IOException {
        KeyPair keypair = (KeyPair)this.readPemObject(pem);
        if (keypair == null) {
            throw new IOException("Could not parse key from string");
        }
        return keypair.getPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readPemObject(String pemString) throws IOException {
        StringReader strReader = new StringReader(pemString);
        PEMReader pemReader = new PEMReader((Reader)strReader, null, BouncyCastleProvider.PROVIDER_NAME);
        try {
            Object object = pemReader.readObject();
            return object;
        }
        finally {
            strReader.close();
            pemReader.close();
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

