/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure;

import java.util.Random;

class RandomPasswordGenerator {
    private static final String ALPHA_CAPS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String ALPHA = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUM = "0123456789";
    private static final String SPECIAL = "!@#$%^*_=+-/";

    RandomPasswordGenerator() {
    }

    public static char[] generatePassword(int minLen, int maxLen, int noOfCAPSAlpha, int noOfDigits, int noOfSpecialChars) {
        int i;
        if (minLen > maxLen) {
            throw new IllegalArgumentException("Min. Length > Max. Length!");
        }
        if (noOfCAPSAlpha + noOfDigits + noOfSpecialChars > minLen) {
            throw new IllegalArgumentException("Min. Length should be atleast sum of (CAPS, DIGITS, SPL CHARS) Length!");
        }
        Random rnd = new Random();
        int len = rnd.nextInt(maxLen - minLen + 1) + minLen;
        char[] pswd = new char[len];
        int index = 0;
        for (i = 0; i < noOfCAPSAlpha; ++i) {
            index = RandomPasswordGenerator.getNextIndex(rnd, len, pswd);
            pswd[index] = ALPHA_CAPS.charAt(rnd.nextInt(ALPHA_CAPS.length()));
        }
        for (i = 0; i < noOfDigits; ++i) {
            index = RandomPasswordGenerator.getNextIndex(rnd, len, pswd);
            pswd[index] = NUM.charAt(rnd.nextInt(NUM.length()));
        }
        for (i = 0; i < noOfSpecialChars; ++i) {
            index = RandomPasswordGenerator.getNextIndex(rnd, len, pswd);
            pswd[index] = SPECIAL.charAt(rnd.nextInt(SPECIAL.length()));
        }
        for (i = 0; i < len; ++i) {
            if (pswd[i] != '\u0000') continue;
            pswd[i] = ALPHA.charAt(rnd.nextInt(ALPHA.length()));
        }
        return pswd;
    }

    private static int getNextIndex(Random rnd, int len, char[] pswd) {
        int index = rnd.nextInt(len);
        while (pswd[index = rnd.nextInt(len)] != '\u0000') {
        }
        return index;
    }
}

