/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.compute.model.AffinityGroupModel;
import org.dasein.cloud.azure.compute.model.AffinityGroupsModel;
import org.dasein.cloud.azure.compute.model.CreateAffinityGroupModel;
import org.dasein.cloud.azure.compute.model.UpdateAffinityGroupModel;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.AffinityGroupCreateOptions;
import org.dasein.cloud.compute.AffinityGroupFilterOptions;
import org.dasein.cloud.compute.AffinityGroupSupport;
import org.dasein.cloud.identity.ServiceAction;

public class AzureAffinityGroupSupport
implements AffinityGroupSupport {
    private Azure provider;
    private static final Logger logger = Logger.getLogger(AzureAffinityGroupSupport.class);
    public static final String RESOURCE_AFFINITYGROUPS = "/affinitygroups";
    public static final String RESOURCE_AFFINITYGROUP = "/affinitygroups/%s";

    public AzureAffinityGroupSupport(@Nonnull Azure provider) {
        this.provider = provider;
    }

    @Nonnull
    public AffinityGroup create(@Nonnull AffinityGroupCreateOptions options) throws InternalException, CloudException {
        if (options == null && options.getName() == null) {
            throw new InternalException("Cannot create AffinityGroup. Create options or affinity group name cannot be null.");
        }
        CreateAffinityGroupModel createAffinityGroupModel = new CreateAffinityGroupModel();
        createAffinityGroupModel.setName(options.getName());
        createAffinityGroupModel.setDescription(options.getDescription());
        createAffinityGroupModel.setLocation(this.provider.getContext().getRegionId());
        createAffinityGroupModel.setLabel(new String(Base64.encodeBase64((byte[])options.getName().getBytes())));
        AzureMethod azureMethod = new AzureMethod(this.provider);
        try {
            azureMethod.post(RESOURCE_AFFINITYGROUPS, createAffinityGroupModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        return AffinityGroup.getInstance((String)createAffinityGroupModel.getName(), (String)createAffinityGroupModel.getName(), (String)createAffinityGroupModel.getDescription(), (String)createAffinityGroupModel.getLocation(), null);
    }

    public void delete(@Nonnull String affinityGroupId) throws InternalException, CloudException {
        if (affinityGroupId == null || affinityGroupId.isEmpty()) {
            throw new InternalException("Cannot delete affinity group. Please specify the id for the affinity group to remove");
        }
        AzureMethod method = new AzureMethod(this.provider);
        method.invoke("DELETE", this.provider.getContext().getAccountNumber(), String.format(RESOURCE_AFFINITYGROUP, affinityGroupId), null);
    }

    @Nonnull
    public AffinityGroup get(@Nonnull String affinityGroupId) throws InternalException, CloudException {
        if (affinityGroupId == null || affinityGroupId.isEmpty()) {
            throw new InternalException("Please specify the id for the affinity group you want to retrieve.");
        }
        AzureMethod method = new AzureMethod(this.provider);
        AffinityGroupModel affinityGroupModel = method.get(AffinityGroupModel.class, String.format(RESOURCE_AFFINITYGROUP, affinityGroupId));
        return AffinityGroup.getInstance((String)affinityGroupModel.getName(), (String)affinityGroupModel.getName(), (String)affinityGroupModel.getDescription(), (String)affinityGroupModel.getLocation(), null);
    }

    @Nonnull
    public Iterable<AffinityGroup> list(@Nonnull AffinityGroupFilterOptions options) throws InternalException, CloudException {
        AzureMethod method = new AzureMethod(this.provider);
        AffinityGroupsModel affinityGroupsModel = method.get(AffinityGroupsModel.class, RESOURCE_AFFINITYGROUPS);
        ArrayList<AffinityGroup> affinityGroups = new ArrayList<AffinityGroup>();
        for (AffinityGroupModel affinityGroupModel : affinityGroupsModel.getAffinityGroups()) {
            AffinityGroup affinityGroup = AffinityGroup.getInstance((String)affinityGroupModel.getName(), (String)affinityGroupModel.getName(), (String)affinityGroupModel.getDescription(), (String)affinityGroupModel.getLocation(), null);
            if (options == null || !options.matches(affinityGroup)) continue;
            affinityGroups.add(affinityGroup);
        }
        return affinityGroups;
    }

    public AffinityGroup modify(@Nonnull String affinityGroupId, @Nonnull AffinityGroupCreateOptions options) throws InternalException, CloudException {
        if (affinityGroupId == null || affinityGroupId.isEmpty()) {
            throw new InternalException("Cannot modify an affinity group: affinityGroupId cannot be null or empty");
        }
        if (options == null && options.getDescription() == null) {
            throw new InternalException("Cannot create AffinityGroup. Create options or affinity group description cannot be null.");
        }
        UpdateAffinityGroupModel updateAffinityGroupModel = new UpdateAffinityGroupModel();
        updateAffinityGroupModel.setDescription(options.getDescription());
        AzureMethod method = new AzureMethod(this.provider);
        try {
            method.put(String.format(RESOURCE_AFFINITYGROUP, affinityGroupId), updateAffinityGroupModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        return this.get(affinityGroupId);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }
}

