/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.disk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.compute.disk.AzureDiskCapabilities;
import org.dasein.cloud.compute.AbstractVolumeSupport;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFilterOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureDisk
extends AbstractVolumeSupport {
    private static final Logger logger = Azure.getLogger(AzureDisk.class);
    private static final String DISK_SERVICES = "/services/disks";
    private static final String HOSTED_SERVICES = "/services/hostedservices";
    private Azure provider;
    private volatile transient AzureDiskCapabilities capabilities;

    public AzureDisk(Azure provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String device) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureDisk.class.getName() + ".attach(" + volumeId + "," + toServer + "," + device + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            if (device != null && device.startsWith("/dev/")) {
                device = device.substring(5);
            }
            VirtualMachine server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(toServer);
            StringBuilder xml = new StringBuilder();
            if (volumeId != null) {
                Volume disk = this.getVolume(volumeId);
                if (disk == null) {
                    throw new InternalException("Can not find the source snapshot !");
                }
                xml.append("<DataVirtualHardDisk  xmlns=\"http://schemas.microsoft.com/windowsazure\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">");
                xml.append("<HostCaching>ReadWrite</HostCaching>");
                xml.append("<DiskName>" + disk.getName() + "</DiskName>");
                xml.append("<LogicalDiskSizeInGB>" + disk.getSizeInGigabytes() + "</LogicalDiskSizeInGB>");
                xml.append("<MediaLink>" + disk.getMediaLink() + "</MediaLink>");
                xml.append("</DataVirtualHardDisk>");
            } else {
                String storageEndpoint = this.provider.getStorageEndpoint();
                if (storageEndpoint == null || storageEndpoint.isEmpty()) {
                    throw new CloudException("Cannot find blob storage endpoint in the current region");
                }
                xml.append("<DataVirtualHardDisk  xmlns=\"http://schemas.microsoft.com/windowsazure\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">");
                xml.append("<HostCaching>ReadWrite</HostCaching>");
                xml.append("<LogicalDiskSizeInGB>").append("1").append("</LogicalDiskSizeInGB>");
                xml.append("<MediaLink>").append(storageEndpoint).append("vhds/").append(server.getTag("roleName")).append(System.currentTimeMillis() % 10000L).append(".vhd</MediaLink>");
                xml.append("</DataVirtualHardDisk>");
            }
            String resourceDir = "/services/hostedservices/" + server.getTag("serviceName") + "/deployments" + "/" + server.getTag("deploymentName") + "/roles" + "/" + server.getTag("roleName") + "/DataDisks";
            AzureMethod method = new AzureMethod(this.provider);
            if (logger.isDebugEnabled()) {
                try {
                    method.parseResponse(xml.toString(), false);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to parse outgoing XML locally: " + e.getMessage()));
                    logger.warn((Object)"XML:");
                    logger.warn((Object)xml.toString());
                }
            }
            method.post(ctx.getAccountNumber(), resourceDir, xml.toString());
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureDisk.class.getName() + ".attach()"));
            }
        }
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Azure does not support creating standalone volumes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureDisk.class.getName() + ".detach(" + volumeId + ")"));
        }
        try {
            Volume disk;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            if (volumeId != null) {
                disk = this.getVolume(volumeId);
                if (disk == null) {
                    throw new InternalException("Can not find the source snapshot !");
                }
            } else {
                throw new InternalException("volumeId is null !");
            }
            String providerVirtualMachineId = disk.getProviderVirtualMachineId();
            VirtualMachine vm = null;
            if (providerVirtualMachineId != null) {
                vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(providerVirtualMachineId);
            }
            if (vm == null) {
                logger.trace((Object)("Sorry, the disk is not attached to the VM with id " + providerVirtualMachineId + " or the VM id is not in the desired format !!!"));
                throw new InternalException("Sorry, the disk is not attached to the VM with id " + providerVirtualMachineId + " or the VM id is not in the desired format !!!");
            }
            String lun = this.getDiskLun(disk.getProviderVolumeId(), providerVirtualMachineId);
            if (lun == null) {
                logger.trace((Object)"Can not identify the lun number");
                throw new InternalException("logical unit number of disk is null, detach operation can not be continue!");
            }
            String resourceDir = "/services/hostedservices/" + vm.getTag("serviceName") + "/deployments" + "/" + vm.getTag("deploymentName") + "/roles" + "/" + vm.getTag("roleName") + "/DataDisks" + "/" + lun;
            AzureMethod method = new AzureMethod(this.provider);
            method.invoke("DELETE", ctx.getAccountNumber(), resourceDir, null);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureDisk.class.getName() + ".detach()"));
            }
        }
    }

    public VolumeCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new AzureDiskCapabilities(this.provider);
        }
        return this.capabilities;
    }

    private String getDiskLun(String providerVolumeId, String providerVirtualMachineId) throws InternalException, CloudException {
        AzureMethod method = new AzureMethod(this.provider);
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(providerVirtualMachineId);
        String resourceDir = "/services/hostedservices/" + vm.getTag("serviceName") + "/deployments" + "/" + vm.getTag("deploymentName");
        Document doc = method.getAsXML(this.provider.getContext().getAccountNumber(), resourceDir);
        if (doc == null) {
            return null;
        }
        NodeList entries = doc.getElementsByTagName("DataVirtualHardDisk");
        if (entries.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < entries.getLength(); ++i) {
            Node detail = entries.item(i);
            NodeList attributes = detail.getChildNodes();
            String diskName = null;
            String lunValue = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                if (attribute.getNodeType() == 3) continue;
                if (attribute.getNodeName().equalsIgnoreCase("DiskName") && attribute.hasChildNodes()) {
                    diskName = attribute.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attribute.getNodeName().equalsIgnoreCase("Lun") || !attribute.hasChildNodes() || diskName == null || !diskName.equalsIgnoreCase(providerVolumeId)) continue;
                lunValue = attribute.getFirstChild().getNodeValue().trim();
            }
            if (diskName == null || !diskName.equalsIgnoreCase(providerVolumeId)) continue;
            if (lunValue == null) {
                lunValue = "0";
            }
            return lunValue;
        }
        return null;
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return 16;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1024, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    @Nullable
    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        ArrayList list = (ArrayList)this.listVolumes();
        if (list == null) {
            return null;
        }
        for (Volume disk : list) {
            if (!disk.getProviderVolumeId().equals(volumeId)) continue;
            return disk;
        }
        return null;
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.getMaximumVolumeCount(); ++i) {
            list.add(String.valueOf(i));
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), DISK_SERVICES);
        NodeList entries = doc.getElementsByTagName("Disk");
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            ResourceStatus status = this.toStatus(ctx, entry);
            if (status == null) continue;
            list.add(status);
        }
        return list;
    }

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), DISK_SERVICES);
        NodeList entries = doc.getElementsByTagName("Disk");
        ArrayList<Volume> disks = new ArrayList<Volume>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            Volume disk = this.toVolume(ctx, entry);
            if (disk == null) continue;
            disks.add(disk);
        }
        return disks;
    }

    @Nonnull
    public Iterable<Volume> listVolumes(@Nullable VolumeFilterOptions volumeFilterOptions) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), DISK_SERVICES);
        NodeList entries = doc.getElementsByTagName("Disk");
        ArrayList<Volume> disks = new ArrayList<Volume>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            Volume disk = this.toVolume(ctx, entry);
            if (disk == null) continue;
            disks.add(disk);
        }
        return disks;
    }

    private boolean isWithinDeviceList(String device) throws InternalException, CloudException {
        ArrayList list = (ArrayList)this.listPossibleDeviceIds(Platform.UNIX);
        for (String id : list) {
            if (!id.equals(device)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureDisk.class.getName() + ".remove(" + volumeId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            AzureMethod method = new AzureMethod(this.provider);
            long timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    method.invoke("DELETE", ctx.getAccountNumber(), "/services/disks/" + volumeId + "?comp=media", null);
                    return;
                }
                catch (CloudException e) {
                    if (e.getProviderCode() != null && e.getProviderCode().equals("BadRequest")) {
                        logger.warn((Object)"Conflict error, maybe retrying in 30 seconds");
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException ignore) {}
                        continue;
                    }
                    logger.warn((Object)("Unable to delete volume " + volumeId + ": " + e.getMessage()));
                    throw e;
                    return;
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureDisk.class.getName() + ".remove()"));
            }
        }
    }

    public void removeTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private Volume toVolume(@Nonnull ProviderContext ctx, @Nullable Node volumeNode) throws InternalException, CloudException {
        if (volumeNode == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new AzureConfigException("No region ID was specified for this request");
        }
        Volume disk = new Volume();
        disk.setProviderRegionId(regionId);
        disk.setCurrentState(VolumeState.AVAILABLE);
        disk.setType(VolumeType.HDD);
        boolean mediaLocationFound = false;
        NodeList attributes = volumeNode.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("AttachedTo") && attribute.hasChildNodes()) {
                NodeList attachAttributes = attribute.getChildNodes();
                String hostedServiceName = null;
                String deploymentName = null;
                String vmRoleName = null;
                for (int k = 0; k < attachAttributes.getLength(); ++k) {
                    Node attach = attachAttributes.item(k);
                    if (attach.getNodeType() == 3) continue;
                    if (attach.getNodeName().equalsIgnoreCase("HostedServiceName") && attach.hasChildNodes()) {
                        hostedServiceName = attach.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (attach.getNodeName().equalsIgnoreCase("DeploymentName") && attach.hasChildNodes()) {
                        deploymentName = attach.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attach.getNodeName().equalsIgnoreCase("RoleName") || !attach.hasChildNodes()) continue;
                    vmRoleName = attach.getFirstChild().getNodeValue().trim();
                }
                if (hostedServiceName == null || deploymentName == null || vmRoleName == null) continue;
                disk.setProviderVirtualMachineId(hostedServiceName + ":" + deploymentName + ":" + vmRoleName);
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("OS") && attribute.hasChildNodes()) {
                disk.setGuestOperatingSystem(Platform.guess((String)attribute.getFirstChild().getNodeValue().trim()));
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("AffinityGroup") && attribute.hasChildNodes()) {
                String affinityGroup = attribute.getFirstChild().getNodeValue().trim();
                if (affinityGroup == null || affinityGroup.equals("")) continue;
                AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                if (affinityGroupModel == null) {
                    return null;
                }
                DataCenter dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
                if (dc.getRegionId().equals(disk.getProviderRegionId())) {
                    disk.setProviderDataCenterId(dc.getProviderDataCenterId());
                    mediaLocationFound = true;
                    continue;
                }
                return null;
            }
            if (attribute.getNodeName().equalsIgnoreCase("Location") && attribute.hasChildNodes()) {
                if (mediaLocationFound || regionId.equals(attribute.getFirstChild().getNodeValue().trim())) continue;
                return null;
            }
            if (attribute.getNodeName().equalsIgnoreCase("LogicalDiskSizeInGB") && attribute.hasChildNodes()) {
                disk.setSize(Storage.valueOf((Number)Integer.valueOf(attribute.getFirstChild().getNodeValue().trim()), (String)"gigabyte"));
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("MediaLink") && attribute.hasChildNodes()) {
                disk.setMediaLink(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("Name") && attribute.hasChildNodes()) {
                disk.setProviderVolumeId(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!attribute.getNodeName().equalsIgnoreCase("SourceImageName") || !attribute.hasChildNodes()) continue;
            disk.setProviderSnapshotId(attribute.getFirstChild().getNodeValue().trim());
        }
        if (disk.getProviderVirtualMachineId() != null) {
            String lun = this.getDiskLun(disk.getProviderVolumeId(), disk.getProviderVirtualMachineId());
            disk.setDeviceId(lun);
        }
        if (disk.getGuestOperatingSystem() == null) {
            disk.setGuestOperatingSystem(Platform.UNKNOWN);
        }
        if (disk.getName() == null) {
            disk.setName(disk.getProviderVolumeId());
        }
        if (disk.getDescription() == null) {
            disk.setDescription(disk.getName());
        }
        if (disk.getProviderDataCenterId() == null) {
            DataCenter dc = this.provider.getDataCenterServices().listDataCenters(regionId).iterator().next();
            disk.setProviderDataCenterId(dc.getProviderDataCenterId());
        }
        return disk;
    }

    @Nullable
    private ResourceStatus toStatus(@Nonnull ProviderContext ctx, @Nullable Node volumeNode) throws InternalException, CloudException {
        if (volumeNode == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new AzureConfigException("No region ID was specified for this request");
        }
        String id = "";
        boolean mediaLocationFound = false;
        NodeList attributes = volumeNode.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("Name") && attribute.hasChildNodes()) {
                id = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("AffinityGroup") && attribute.hasChildNodes()) {
                String affinityGroup = attribute.getFirstChild().getNodeValue().trim();
                if (affinityGroup == null || affinityGroup.equals("")) continue;
                AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                if (affinityGroupModel == null) {
                    return null;
                }
                DataCenter dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
                if (dc.getRegionId().equals(regionId)) {
                    mediaLocationFound = true;
                    continue;
                }
                return null;
            }
            if (!(attribute.getNodeName().equalsIgnoreCase("Location") && attribute.hasChildNodes() ? !mediaLocationFound && !regionId.equals(attribute.getFirstChild().getNodeValue().trim()) : attribute.getNodeName().equalsIgnoreCase("OS") && attribute.hasChildNodes())) continue;
            return null;
        }
        ResourceStatus status = new ResourceStatus(id, (Object)VolumeState.AVAILABLE);
        return status;
    }
}

