/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.disk;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class AzureDiskCapabilities
extends AbstractCapabilities<Azure>
implements VolumeCapabilities {
    public AzureDiskCapabilities(@Nonnull Azure provider) {
        super((CloudProvider)provider);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return true;
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return true;
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return 16;
    }

    public int getMaximumVolumeProductIOPS() throws InternalException, CloudException {
        return 0;
    }

    public int getMinimumVolumeProductIOPS() throws InternalException, CloudException {
        return 0;
    }

    public int getMaximumVolumeSizeIOPS() throws InternalException, CloudException {
        return 0;
    }

    public int getMinimumVolumeSizeIOPS() throws InternalException, CloudException {
        return 0;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1024, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public NamingConstraints getVolumeNamingConstraints() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "disk";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.getMaximumVolumeCount(); ++i) {
            list.add(String.valueOf(i));
        }
        return list;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.REQUIRED;
    }
}

