/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.image;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.AzureService;
import org.dasein.cloud.azure.compute.image.AzureMachineImage;
import org.dasein.cloud.azure.compute.image.OSImageCapabilities;
import org.dasein.cloud.azure.compute.image.model.OSImageModel;
import org.dasein.cloud.azure.compute.image.model.OSImagesModel;
import org.dasein.cloud.azure.compute.image.model.VMImageModel;
import org.dasein.cloud.azure.compute.image.model.VMImagesModel;
import org.dasein.cloud.azure.compute.vm.model.Operation;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ServiceAction;

public class AzureOSImage
extends AbstractImageSupport<Azure> {
    private static final Logger logger = Azure.getLogger(AzureOSImage.class);
    private static final String IMAGES = "/services/images";
    private static final String RESOURCE_VMIMAGES = "/services/vmimages?location=%s&category=%s";
    private static final String MICROSOFT = "--microsoft--";
    private Azure provider;
    private volatile transient OSImageCapabilities capabilities;

    public AzureOSImage(Azure provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public void bundleVirtualMachineAsync(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name, @Nonnull AsynchronousTask<String> trackingTask) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to bundle vms");
    }

    public ImageCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new OSImageCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        logger.debug((Object)("Capture image of " + options.getVirtualMachineId() + " with new name " + options.getName()));
        try {
            MachineImage machineImage;
            if (task != null) {
                task.setStartTime(System.currentTimeMillis());
            }
            String vmid = options.getVirtualMachineId();
            String name = options.getName();
            VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId());
            if (vm == null) {
                throw new CloudException("Virtual machine not found: " + options.getVirtualMachineId());
            }
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                logger.debug((Object)"Stopping server");
                this.provider.getComputeServices().getVirtualMachineSupport().stop(vmid, false);
                try {
                    long timeout = System.currentTimeMillis() + 600000L;
                    vm = null;
                    while (timeout > System.currentTimeMillis()) {
                        vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId());
                        if (vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                            logger.debug((Object)"Server stopped");
                            break;
                        }
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                    throw new CloudException("Server still not stopped after 10 minutes.  Please try again later");
                }
            }
            try {
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new AzureConfigException("No context was set for this request");
                }
                Operation.CaptureRoleAsVMImageOperation captureVMImageOperation = new Operation.CaptureRoleAsVMImageOperation();
                captureVMImageOperation.setOsState("Generalized");
                captureVMImageOperation.setVmImageName(name);
                captureVMImageOperation.setVmImageLabel(name);
                String operationUrl = String.format("/services/hostedservices/%s/deployments/%s/roleInstances/%s/Operations", vm.getTag("serviceName").toString(), vm.getTag("deploymentName").toString(), vm.getTag("roleName").toString());
                AzureMethod method = new AzureMethod(this.provider);
                try {
                    method.post(operationUrl, captureVMImageOperation);
                }
                catch (JAXBException e) {
                    logger.error((Object)e.getMessage());
                    throw new InternalException((Throwable)e);
                }
                MachineImage img = null;
                try {
                    long timeout = System.currentTimeMillis() + 600000L;
                    while (timeout > System.currentTimeMillis()) {
                        img = this.getImage(name);
                        if (img != null) {
                            logger.debug((Object)("Found image " + name));
                            break;
                        }
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (img == null) {
                    throw new CloudException("Drive cloning completed, but no ID was provided for clone");
                }
                if (task != null) {
                    task.completeWithResult(img);
                }
                this.provider.getComputeServices().getVirtualMachineSupport().terminateService(vm.getTag("serviceName").toString(), "Post makeImage cleanup");
                machineImage = img;
            }
            catch (Throwable throwable) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("EXIT: " + AzureOSImage.class.getName() + ".launch()"));
                }
                throw throwable;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureOSImage.class.getName() + ".launch()"));
            }
            return machineImage;
        }
        finally {
            this.provider.release();
        }
    }

    public MachineImage getImage(@Nonnull String machineImageId) throws CloudException, InternalException {
        if (machineImageId == null) {
            throw new InternalException("The parameter machineImageId cannot be null");
        }
        Iterable<MachineImage> allImages = this.getAllImages(false, true, true);
        for (MachineImage img : allImages) {
            if (!machineImageId.equals(img.getProviderMachineImageId())) continue;
            logger.debug((Object)("Found image i'm looking for " + machineImageId));
            img.setImageClass(ImageClass.MACHINE);
            return img;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return "OS image";
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "OS image";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return "OS image";
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        MachineImage img = this.getMachineImage(machineImageId);
        return img != null && (MICROSOFT.equals(img.getProviderOwnerId()) || "--public--".equals(img.getProviderOwnerId()) || "--Canonical--".equals(img.getProviderOwnerId()) || "--RightScaleLinux--".equals(img.getProviderOwnerId()) || "--RightScaleWindows--".equals(img.getProviderOwnerId()) || "--OpenLogic--".equals(img.getProviderOwnerId()) || "--SUSE--".equals(img.getProviderOwnerId()));
    }

    private boolean isImageSharedWithPublic(@Nonnull MachineImage img) {
        return img != null && !((Azure)this.getProvider()).getContext().getAccountNumber().equals(img.getProviderOwnerId());
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getDataCenterServices().isSubscribed(AzureService.COMPUTE);
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        Iterable<MachineImage> allImages = this.getAllImages(false, true, false);
        for (MachineImage image : allImages) {
            if (!"user".equalsIgnoreCase(image.getProviderOwnerId().toLowerCase()) || !ctx.getRegionId().equalsIgnoreCase(image.getProviderRegionId().toLowerCase())) continue;
            list.add(new ResourceStatus(image.getProviderMachineImageId(), (Object)MachineImageState.ACTIVE));
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions imageFilterOptions) throws CloudException, InternalException {
        if (!imageFilterOptions.getImageClass().equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        Iterable<MachineImage> allImages = imageFilterOptions.getWithAllRegions() ? this.getAllImages(true, true, false) : this.getAllImages(false, true, false);
        for (MachineImage image : allImages) {
            if (image == null) continue;
            image.setImageClass(ImageClass.MACHINE);
            if (!imageFilterOptions.matches(image)) continue;
            if (imageFilterOptions.getAccountNumber() == null) {
                if (!ctx.getAccountNumber().equals(image.getProviderOwnerId())) continue;
                images.add(image);
                continue;
            }
            if (!image.getProviderOwnerId().equalsIgnoreCase(imageFilterOptions.getAccountNumber())) continue;
            images.add(image);
        }
        return images;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        String me = ctx.getAccountNumber();
        Iterable allImages = this.listMachineImages();
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        for (MachineImage img : allImages) {
            if (!img.getProviderOwnerId().equalsIgnoreCase(me)) continue;
            img.setImageClass(ImageClass.MACHINE);
            list.add(img);
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls, @Nonnull String ownedBy) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        Iterable allImages = this.listMachineImages();
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        for (MachineImage img : allImages) {
            if (!img.getProviderOwnerId().equalsIgnoreCase(ownedBy)) continue;
            img.setImageClass(ImageClass.MACHINE);
            list.add(img);
        }
        return list;
    }

    @Nonnull
    public ArrayList<MachineImage> listMachineImages() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        Iterable<MachineImage> allImages = this.getAllImages(false, true, false);
        for (MachineImage image : allImages) {
            if (image == null || !ctx.getAccountNumber().equalsIgnoreCase(image.getProviderOwnerId())) continue;
            list.add(image);
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(String accountId) throws CloudException, InternalException {
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        Iterable<MachineImage> allImages = this.getAllImages(false, true, true);
        for (MachineImage image : allImages) {
            if (accountId == null || !accountId.equalsIgnoreCase(image.getProviderOwnerId())) continue;
            images.add(image);
        }
        return images;
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String forMachineImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No image registering is currently supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String machineImageId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureOSImage.class.getName() + ".remove(" + machineImageId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            MachineImage image = this.getMachineImage(machineImageId);
            if (image == null) {
                throw new CloudException("No such machine image: " + machineImageId);
            }
            AzureMethod method = new AzureMethod(this.provider);
            method.invoke("DELETE", ctx.getAccountNumber(), "/services/images/" + machineImageId + "?comp=media", null);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureOSImage.class.getName() + ".launch()"));
            }
        }
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
    }

    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
    }

    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to share images");
    }

    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to share images");
    }

    @Nonnull
    private Iterable<MachineImage> searchPublicMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws CloudException, InternalException {
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        Iterable<MachineImage> allImages = this.getAllImages(false, false, true);
        for (MachineImage img : allImages) {
            if (architecture != null && !architecture.equals((Object)img.getArchitecture())) continue;
            if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
                Platform p = img.getPlatform();
                if (p.equals((Object)Platform.UNKNOWN)) continue;
                if (platform.isWindows()) {
                    if (!p.isWindows()) {
                        continue;
                    }
                } else if (!platform.equals((Object)Platform.UNIX) ? !platform.equals((Object)p) : !p.isUnix()) continue;
            }
            if (keyword != null && !keyword.isEmpty() && !img.getName().matches(keyword) && !img.getDescription().matches(keyword) && !img.getProviderMachineImageId().matches(keyword)) continue;
            images.add(img);
        }
        return images;
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nonnull ImageFilterOptions imageFilterOptions) throws InternalException, CloudException {
        Platform platform = imageFilterOptions.getPlatform();
        ImageClass cls = imageFilterOptions.getImageClass();
        return this.searchPublicImages(null, platform, null, cls);
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        if (imageClasses.length < 1) {
            Iterable<MachineImage> images = this.searchPublicMachineImages(keyword, platform, architecture);
            for (MachineImage img : images) {
                if (!this.isImageSharedWithPublic(img)) continue;
                list.add(img);
            }
        } else {
            for (ImageClass cls : imageClasses) {
                if (!cls.equals((Object)ImageClass.MACHINE)) continue;
                Iterable<MachineImage> images = this.searchPublicMachineImages(keyword, platform, architecture);
                for (MachineImage img : images) {
                    if (!this.isImageSharedWithPublic(img)) continue;
                    list.add(img);
                }
            }
        }
        return list;
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    private Iterable<MachineImage> getAllImages(boolean isGlobalQuery, boolean isPrivate, boolean isPublic) throws CloudException, InternalException {
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        ArrayList<MachineImage> osImages = this.getOSImages(isGlobalQuery, isPrivate, isPublic);
        images.addAll(osImages);
        ArrayList<MachineImage> vmImages = this.getVMImages(isGlobalQuery, isPrivate, isPublic);
        images.addAll(vmImages);
        return images;
    }

    private String getCategory(String category) throws CloudException, InternalException {
        if (category == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        if (category.equalsIgnoreCase("user")) {
            return ctx.getAccountNumber();
        }
        if (category.toLowerCase().contains("microsoft")) {
            return MICROSOFT;
        }
        if (category.toLowerCase().contains("partner")) {
            return "--public--";
        }
        if (category.toLowerCase().contains("canonical")) {
            return "--Canonical--";
        }
        if (category.toLowerCase().contains("rightscale with linux")) {
            return "--RightScaleLinux--";
        }
        if (category.toLowerCase().contains("rightscale with windows")) {
            return "--RightScaleWindows--";
        }
        if (category.toLowerCase().contains("openlogic")) {
            return "--OpenLogic--";
        }
        if (category.toLowerCase().contains("suse")) {
            return "--SUSE--";
        }
        if (category.toLowerCase().contains("oracle")) {
            return "--Oracle--";
        }
        if (category.toLowerCase().contains("public")) {
            return "--Public--";
        }
        return "--" + category + "--";
    }

    private ArrayList<MachineImage> getOSImages(boolean isGlobalQuery, boolean isPrivate, boolean isPublic) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        AzureMethod azureMethod = new AzureMethod(this.provider);
        OSImagesModel osImagesModel = azureMethod.get(OSImagesModel.class, IMAGES);
        if (osImagesModel.getImages() == null) {
            return images;
        }
        for (OSImageModel osImageModel : osImagesModel.getImages()) {
            if (osImageModel.getLocation() == null) continue;
            List<String> locations = Arrays.asList(osImageModel.getLocation().trim().toLowerCase().split(";"));
            if (!isGlobalQuery) {
                if (!locations.contains(ctx.getRegionId().toLowerCase())) continue;
                if (osImageModel.getCategory().equalsIgnoreCase("user") && isPrivate) {
                    images.add(this.azureImageFrom(osImageModel, ctx.getRegionId()));
                    continue;
                }
                if (osImageModel.getCategory().equalsIgnoreCase("user") || !isPublic) continue;
                images.add(this.azureImageFrom(osImageModel, ctx.getRegionId()));
                continue;
            }
            if (osImageModel.getCategory().equalsIgnoreCase("user") && isPrivate) {
                for (String location : locations) {
                    images.add(this.azureImageFrom(osImageModel, location));
                }
                continue;
            }
            if (osImageModel.getCategory().equalsIgnoreCase("user") || !isPublic) continue;
            for (String location : locations) {
                images.add(this.azureImageFrom(osImageModel, location));
            }
        }
        return images;
    }

    private ArrayList<MachineImage> getVMImages(boolean isGloabalQuery, boolean isPrivate, boolean isPublic) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        String region = isGloabalQuery ? "" : URLEncoder.encode(ctx.getRegionId());
        String category = "";
        if (isPrivate) {
            category = "user";
        } else if (isPublic) {
            category = "public";
        }
        ArrayList<MachineImage> images = new ArrayList<MachineImage>();
        AzureMethod azureMethod = new AzureMethod(this.provider);
        VMImagesModel vmImagesModel = azureMethod.get(VMImagesModel.class, String.format(RESOURCE_VMIMAGES, region, category));
        if (vmImagesModel.getVmImages() == null) {
            return images;
        }
        for (VMImageModel vmImageModel : vmImagesModel.getVmImages()) {
            if (vmImageModel.getLocation() == null) continue;
            if (!isGloabalQuery) {
                images.add(this.azureImageFrom(vmImageModel, ctx.getRegionId()));
                continue;
            }
            List<String> locations = Arrays.asList(vmImageModel.getLocation().trim().toLowerCase().split(";"));
            for (String location : locations) {
                images.add(this.azureImageFrom(vmImageModel, location));
            }
        }
        return images;
    }

    private AzureMachineImage azureImageFrom(VMImageModel vmImageModel, String regionId) throws CloudException, InternalException {
        String descriptor;
        AzureMachineImage azureMachineImage = new AzureMachineImage();
        azureMachineImage.setProviderOwnerId(this.getCategory(vmImageModel.getCategory()));
        azureMachineImage.setProviderRegionId(regionId);
        azureMachineImage.setProviderMachineImageId(vmImageModel.getName());
        azureMachineImage.setName(vmImageModel.getLabel());
        azureMachineImage.setDescription(vmImageModel.getDescription());
        azureMachineImage.setArchitecture(Architecture.I64);
        azureMachineImage.setPlatform(vmImageModel.getOsDiskConfiguration().getOs().equalsIgnoreCase("windows") ? Platform.WINDOWS : Platform.UNIX);
        azureMachineImage.setCurrentState(MachineImageState.ACTIVE);
        azureMachineImage.setImageClass(ImageClass.MACHINE);
        azureMachineImage.setType(MachineImageType.VOLUME);
        azureMachineImage.setDescription(vmImageModel.getDescription() != null ? vmImageModel.getDescription() : vmImageModel.getName());
        if (vmImageModel.getOsDiskConfiguration() != null && vmImageModel.getOsDiskConfiguration().getOsState() != null) {
            azureMachineImage.setTag("OSState", vmImageModel.getOsDiskConfiguration().getOsState());
        }
        if (vmImageModel.getOsDiskConfiguration().getMediaLink() != null) {
            azureMachineImage.setMediaLink(vmImageModel.getOsDiskConfiguration().getMediaLink());
        }
        azureMachineImage.setSoftware((descriptor = azureMachineImage.getProviderMachineImageId() + " " + azureMachineImage.getName() + " " + azureMachineImage.getDescription()).contains("SQL Server") ? "SQL Server" : "");
        azureMachineImage.setAzureImageType("VMImage");
        azureMachineImage.setMediaLink(vmImageModel.getOsDiskConfiguration().getMediaLink());
        return azureMachineImage;
    }

    private AzureMachineImage azureImageFrom(OSImageModel osImageModel, String regionId) throws CloudException, InternalException {
        AzureMachineImage azureMachineImage = new AzureMachineImage();
        azureMachineImage.setCurrentState(MachineImageState.ACTIVE);
        azureMachineImage.setProviderRegionId(regionId);
        azureMachineImage.setArchitecture(Architecture.I64);
        azureMachineImage.setProviderMachineImageId(osImageModel.getName());
        azureMachineImage.setProviderOwnerId(this.getCategory(osImageModel.getCategory()));
        azureMachineImage.setName(osImageModel.getLabel());
        azureMachineImage.setDescription(osImageModel.getDescription());
        azureMachineImage.setMediaLink(osImageModel.getMediaLink());
        azureMachineImage.setPlatform(osImageModel.getOs().equalsIgnoreCase("windows") ? Platform.WINDOWS : Platform.UNIX);
        azureMachineImage.setTags(new HashMap());
        azureMachineImage.setType(MachineImageType.VOLUME);
        azureMachineImage.setImageClass(ImageClass.MACHINE);
        if (azureMachineImage.getName() == null) {
            azureMachineImage.setName(azureMachineImage.getProviderMachineImageId());
        } else {
            int versionIdx = azureMachineImage.getProviderMachineImageId().indexOf("__");
            if (versionIdx > 0) {
                String fullName = null;
                try {
                    fullName = azureMachineImage.getProviderMachineImageId().substring(versionIdx + 2);
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                if (fullName != null) {
                    azureMachineImage.setName(fullName);
                }
            }
        }
        if (azureMachineImage.getDescription() == null) {
            azureMachineImage.setDescription(azureMachineImage.getName());
        }
        String descriptor = azureMachineImage.getProviderMachineImageId() + " " + azureMachineImage.getName() + " " + azureMachineImage.getDescription();
        if (azureMachineImage.getPlatform() == null || azureMachineImage.getPlatform().equals((Object)Platform.UNIX)) {
            Platform p = Platform.guess((String)descriptor);
            if (azureMachineImage.getPlatform() == null || !Platform.UNKNOWN.equals((Object)p)) {
                azureMachineImage.setPlatform(p);
            }
        }
        azureMachineImage.setSoftware(descriptor.contains("SQL Server") ? "SQL Server" : "");
        azureMachineImage.setAzureImageType("OSImage");
        return azureMachineImage;
    }
}

