/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.image;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.VmState;

public class OSImageCapabilities
extends AbstractCapabilities<Azure>
implements ImageCapabilities {
    public OSImageCapabilities(@Nonnull Azure provider) {
        super((CloudProvider)provider);
    }

    public boolean canBundle(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canImage(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.STOPPED);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        if (cls.equals((Object)ImageClass.MACHINE)) {
            return "OS Image";
        }
        return "image";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        if (cls.equals((Object)ImageClass.MACHINE)) {
            return "OS Image";
        }
        return "image";
    }

    @Nullable
    public VisibleScope getImageVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VHD);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return type.equals((Object)MachineImageType.VOLUME);
    }

    public boolean supportsImageCopy() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageSharing() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageSharingWithPublic() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsListingAllRegions() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }
}

