/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.vm;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.AzureService;
import org.dasein.cloud.azure.compute.image.AzureMachineImage;
import org.dasein.cloud.azure.compute.vm.VMCapabilities;
import org.dasein.cloud.azure.compute.vm.model.ConfigurationSetModel;
import org.dasein.cloud.azure.compute.vm.model.CreateHostedServiceModel;
import org.dasein.cloud.azure.compute.vm.model.DeploymentModel;
import org.dasein.cloud.azure.compute.vm.model.Operation;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMFilterOptions;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureVM
extends AbstractVMSupport {
    private static final Logger logger = Azure.getLogger(AzureVM.class);
    public static final String HOSTED_SERVICES = "/services/hostedservices";
    public static final String OPERATIONS_RESOURCES = "/services/hostedservices/%s/deployments/%s/roleInstances/%s/Operations";
    private Azure provider;
    private volatile transient VMCapabilities capabilities;

    public AzureVM(Azure provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        if (vmId == null) {
            throw new InternalException("The id of the Virtual Machine to start cannot be null.");
        }
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        String resourceUrl = String.format(OPERATIONS_RESOURCES, vm.getTag("serviceName").toString(), vm.getTag("deploymentName").toString(), vm.getTag("roleName").toString());
        AzureMethod azureMethod = new AzureMethod(this.provider);
        try {
            azureMethod.post(resourceUrl, new Operation.StartRoleOperation());
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVM.class.getName() + ".alterVM()"));
        }
        if (vmId == null || options.getProviderProductId() == null) {
            throw new AzureConfigException("No vmid and/or product id set for this operation");
        }
        String[] parts = options.getProviderProductId().split(":");
        String productId = null;
        String disks = "";
        if (parts.length == 1) {
            productId = parts[0];
        } else if (parts.length == 2) {
            productId = parts[0];
            disks = parts[1].replace("[", "").replace("]", "");
        } else {
            throw new InternalException("Invalid product id string. Product id format is PRODUCT_NAME or PRODUCT_NAME:[disk_0_size,disk_1_size,disk_n_size]");
        }
        boolean found = false;
        Iterable products = this.listProducts(Architecture.I64);
        for (VirtualMachineProduct p : products) {
            if (!p.getProviderProductId().equals(productId)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new InternalException("Product id invalid: should be one of ExtraSmall, Small, Medium, Large, ExtraLarge");
        }
        String[] diskSizes = disks.split(",");
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        String serviceName = vm.getTag("serviceName").toString();
        String deploymentName = vm.getTag("deploymentName").toString();
        String roleName = vm.getTag("roleName").toString();
        String resourceDir = "/services/hostedservices/" + serviceName + "/deployments/" + deploymentName + "/roles/" + roleName;
        try {
            AzureMethod method = new AzureMethod(this.provider);
            Document doc = method.getAsXML(ctx.getAccountNumber(), resourceDir);
            StringBuilder xml = new StringBuilder();
            NodeList roles = doc.getElementsByTagName("PersistentVMRole");
            Node role = roles.item(0);
            NodeList entries = role.getChildNodes();
            boolean changeProduct = false;
            for (int i = 0; i < entries.getLength(); ++i) {
                Node vn = entries.item(i);
                String vnName = vn.getNodeName();
                if (!vnName.equalsIgnoreCase("RoleSize") || !vn.hasChildNodes()) continue;
                if (!productId.equals(vn.getFirstChild().getNodeValue())) {
                    vn.getFirstChild().setNodeValue(productId);
                    changeProduct = true;
                    break;
                }
                logger.info((Object)"No product change required");
                break;
            }
            String requestId = null;
            if (changeProduct) {
                String output = "";
                try {
                    TransformerFactory tf = TransformerFactory.newInstance();
                    Transformer transformer = tf.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    StringWriter writer = new StringWriter();
                    transformer.transform(new DOMSource(doc), new StreamResult(writer));
                    output = writer.getBuffer().toString().replaceAll("\n|\r", "");
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                xml.append(output);
                logger.debug((Object)xml);
                logger.debug((Object)"___________________________________________________");
                resourceDir = "/services/hostedservices/" + serviceName + "/deployments/" + deploymentName + "/roles/" + roleName;
                requestId = method.invoke("PUT", ctx.getAccountNumber(), resourceDir, xml.toString());
            } else {
                requestId = "noChange";
            }
            if (requestId != null) {
                int httpCode = -1;
                if (!requestId.equals("noChange")) {
                    httpCode = method.getOperationStatus(requestId);
                    while (httpCode == -1) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                        httpCode = method.getOperationStatus(requestId);
                    }
                }
                if (httpCode == 200 || requestId.equals("noChange")) {
                    String storageEndpoint = this.provider.getStorageEndpoint();
                    if (storageEndpoint == null || storageEndpoint.isEmpty()) {
                        throw new CloudException("Cannot find blob storage endpoint in the current region");
                    }
                    for (int i = 0; i < diskSizes.length; ++i) {
                        if (diskSizes[i].equals("")) continue;
                        xml = new StringBuilder();
                        xml.append("<DataVirtualHardDisk  xmlns=\"http://schemas.microsoft.com/windowsazure\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">");
                        xml.append("<HostCaching>ReadWrite</HostCaching>");
                        xml.append("<LogicalDiskSizeInGB>").append(diskSizes[i]).append("</LogicalDiskSizeInGB>");
                        xml.append("<MediaLink>").append(storageEndpoint).append("vhds/").append(roleName).append(System.currentTimeMillis() % 10000L).append(".vhd</MediaLink>");
                        xml.append("</DataVirtualHardDisk>");
                        logger.debug((Object)xml);
                        resourceDir = "/services/hostedservices/" + serviceName + "/deployments" + "/" + deploymentName + "/roles" + "/" + roleName + "/DataDisks";
                        requestId = method.post(ctx.getAccountNumber(), resourceDir, xml.toString());
                        if (requestId == null) continue;
                        httpCode = method.getOperationStatus(requestId);
                        while (httpCode == -1) {
                            try {
                                Thread.sleep(15000L);
                            }
                            catch (InterruptedException ignored) {
                                // empty catch block
                            }
                            httpCode = method.getOperationStatus(requestId);
                        }
                    }
                }
            }
            VirtualMachine virtualMachine = this.getVirtualMachine(vmId);
            return virtualMachine;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVM.class.getName() + ".alterVM()"));
            }
        }
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Not supported in Microsoft Azure");
    }

    public void disableAnalytics(String vmId) throws InternalException, CloudException {
    }

    public void enableAnalytics(String vmId) throws InternalException, CloudException {
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new VMCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String vmId) throws InternalException, CloudException {
        return "";
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        for (VirtualMachineProduct product : this.listProducts(null, Architecture.I64)) {
            if (!product.getProviderProductId().equals(productId)) continue;
            return product;
        }
        return null;
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        String roleName;
        String deploymentName;
        String sName;
        String[] parts = vmId.split(":");
        if (parts.length == 3) {
            sName = parts[0];
            deploymentName = parts[1];
            roleName = parts[2];
        } else if (parts.length == 2) {
            sName = parts[0];
            deploymentName = parts[1];
            roleName = sName;
        } else {
            sName = vmId;
            deploymentName = vmId;
            roleName = vmId;
        }
        DataCenter dc = null;
        AffinityGroup ag = null;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/hostedservices/" + sName + "?embed-detail=true");
        if (doc == null) {
            return null;
        }
        NodeList entries = doc.getElementsByTagName("HostedService");
        for (int h = 0; h < entries.getLength(); ++h) {
            Node entry = entries.item(h);
            NodeList attributes = entry.getChildNodes();
            boolean mediaLocationFound = false;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (attribute.getNodeType() == 3 || !attribute.getNodeName().equalsIgnoreCase("hostedserviceproperties") || !attribute.hasChildNodes()) continue;
                NodeList properties = attribute.getChildNodes();
                for (int j = 0; j < properties.getLength(); ++j) {
                    Node property = properties.item(j);
                    if (property.getNodeType() == 3) continue;
                    if (property.getNodeName().equalsIgnoreCase("AffinityGroup") && property.hasChildNodes()) {
                        String affinityGroup = property.getFirstChild().getNodeValue().trim();
                        if (affinityGroup == null || affinityGroup.equals("")) continue;
                        ag = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                        if (ag == null) {
                            return null;
                        }
                        dc = this.provider.getDataCenterServices().getDataCenter(ag.getDataCenterId());
                        if (dc != null && dc.getRegionId().equals(ctx.getRegionId())) {
                            mediaLocationFound = true;
                            continue;
                        }
                        return null;
                    }
                    if (!property.getNodeName().equalsIgnoreCase("location") || !property.hasChildNodes() || mediaLocationFound || ctx.getRegionId().equals(property.getFirstChild().getNodeValue().trim())) continue;
                    return null;
                }
            }
        }
        ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
        NodeList deployments = doc.getElementsByTagName("Deployments");
        for (int i = 0; i < deployments.getLength(); ++i) {
            Node deployNode = deployments.item(i);
            NodeList deployAttributes = deployNode.getChildNodes();
            String depName = "";
            for (int j = 0; j < deployAttributes.getLength(); ++j) {
                Node deployment = deployAttributes.item(j);
                if (deployment.getNodeType() == 3 || !deployment.getNodeName().equalsIgnoreCase("Deployment") || !deployment.hasChildNodes()) continue;
                NodeList dAttribs = deployment.getChildNodes();
                for (int k = 0; k < dAttribs.getLength(); ++k) {
                    Node mynode = dAttribs.item(k);
                    if (!mynode.getNodeName().equalsIgnoreCase("name") || !mynode.hasChildNodes() || !(depName = mynode.getFirstChild().getNodeValue().trim()).equals(deploymentName)) continue;
                    this.parseDeployment(ctx, ctx.getRegionId(), sName + ":" + deploymentName, deployment, list);
                    if (list == null || list.size() <= 0) continue;
                    VirtualMachine vm = list.get(0);
                    if (dc != null) {
                        vm.setProviderDataCenterId(dc.getProviderDataCenterId());
                    } else {
                        Collection<DataCenter> dcs = this.provider.getDataCenterServices().listDataCenters(ctx.getRegionId());
                        vm.setProviderDataCenterId(dcs.iterator().next().getProviderDataCenterId());
                    }
                    if (ag != null) {
                        vm.setAffinityGroupId(ag.getAffinityGroupId());
                    }
                    return vm;
                }
            }
        }
        return null;
    }

    @Nullable
    public VmStatistics getVMStatistics(String vmId, long from, long to) throws InternalException, CloudException {
        return new VmStatistics();
    }

    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String vmId, @Nonnegative long from, @Nonnegative long to) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getDataCenterServices().isSubscribed(AzureService.PERSISTENT_VM_ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public VirtualMachine launch(VMLaunchOptions options) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVM.class.getName() + ".launch(" + options + ")"));
        }
        try {
            VirtualMachine vm;
            block33: {
                long timeout;
                String password;
                String hostName;
                block32: {
                    String label;
                    String storageEndpoint = this.provider.getStorageEndpoint();
                    if (storageEndpoint == null || storageEndpoint.isEmpty()) {
                        this.provider.createDefaultStorageService();
                        storageEndpoint = this.provider.getStorageEndpoint();
                    }
                    logger.debug((Object)"----------------------------------------------------------");
                    logger.debug((Object)("launching vm " + options.getHostName() + " with machine image id: " + options.getMachineImageId()));
                    AzureMachineImage image = (AzureMachineImage)this.provider.getComputeServices().getImageSupport().getMachineImage(options.getMachineImageId());
                    if (image == null) {
                        throw new CloudException("No such image: " + options.getMachineImageId());
                    }
                    logger.debug((Object)"----------------------------------------------------------");
                    ProviderContext ctx = this.provider.getContext();
                    if (ctx == null) {
                        throw new AzureConfigException("No context was specified for this request");
                    }
                    try {
                        label = new String(Base64.encodeBase64((byte[])options.getFriendlyName().getBytes("utf-8")));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new InternalException((Throwable)e);
                    }
                    AzureMethod method = new AzureMethod(this.provider);
                    hostName = this.toUniqueId(options.getHostName(), method, ctx);
                    String deploymentSlot = (String)options.getMetaData().get("environment");
                    String affinityGroupId = options.getAffinityGroupId();
                    if (deploymentSlot == null) {
                        deploymentSlot = "Production";
                    } else if (!deploymentSlot.equalsIgnoreCase("Production") && !deploymentSlot.equalsIgnoreCase("Staging")) {
                        deploymentSlot = "Production";
                    }
                    this.CreateHostedService(options.getDescription(), ctx.getRegionId(), label, hostName, affinityGroupId);
                    password = options.getBootstrapPassword() == null ? this.provider.generateToken(8, 15) : options.getBootstrapPassword();
                    Subnet subnet = null;
                    String vlanName = null;
                    if (options.getVlanId() != null) {
                        subnet = this.provider.getNetworkServices().getVlanSupport().getSubnet(options.getSubnetId());
                        if (subnet != null) {
                            vlanName = (String)subnet.getTags().get("vlanName");
                        } else {
                            VLAN vlan = this.provider.getNetworkServices().getVlanSupport().getVlan(options.getVlanId());
                            if (vlan != null) {
                                vlanName = vlan.getName();
                            }
                        }
                    }
                    String requestId = null;
                    try {
                        requestId = this.CreateDeployment(options, storageEndpoint, image, label, hostName, deploymentSlot, subnet, vlanName, password);
                    }
                    catch (CloudException e) {
                        logger.error((Object)"Launch server failed - now cleaning up service");
                        this.DeleteHostedService(hostName);
                        throw e;
                    }
                    timeout = System.currentTimeMillis() + 600000L;
                    vm = null;
                    if (requestId == null) break block32;
                    int httpCode = method.getOperationStatus(requestId);
                    while (httpCode == -1) {
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                        httpCode = method.getOperationStatus(requestId);
                    }
                    if (httpCode != 200) break block33;
                    try {
                        vm = this.getVirtualMachine(hostName + ":" + hostName + ":" + hostName);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (vm == null) break block33;
                    vm.setRootUser("dasein");
                    vm.setRootPassword(password);
                    break block33;
                }
                while (timeout > System.currentTimeMillis()) {
                    try {
                        vm = this.getVirtualMachine(hostName + ":" + hostName + ":" + hostName);
                    }
                    catch (Throwable ignore) {
                        // empty catch block
                    }
                    if (vm != null) {
                        vm.setRootUser("dasein");
                        vm.setRootPassword(password);
                        break;
                    }
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            if (vm == null) {
                throw new CloudException("System timed out waiting for virtual machine to appear");
            }
            if (VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                this.start(vm.getProviderVirtualMachineId());
            }
            VirtualMachine virtualMachine = vm;
            return virtualMachine;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVM.class.getName() + ".launch()"));
            }
        }
    }

    private void DeleteHostedService(String hostName) throws InternalException {
        String resourceDir = "/services/hostedservices/" + hostName;
        long timeout = System.currentTimeMillis() + 600000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Deleting hosted service " + hostName));
                }
                AzureMethod method = new AzureMethod(this.provider);
                method.invoke("DELETE", this.provider.getContext().getAccountNumber(), resourceDir, "");
                break;
            }
            catch (CloudException err) {
                logger.error((Object)("Unable to delete hosted service for " + hostName + ": " + err.getMessage()));
                logger.error((Object)"Retrying...");
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
    }

    private String CreateDeployment(VMLaunchOptions options, String storageEndpoint, AzureMachineImage image, String label, String hostName, String deploymentSlot, Subnet subnet, String vlanName, String password) throws CloudException, InternalException {
        ConfigurationSetModel.InputEndpointModel inputEndpointModel;
        DeploymentModel deploymentModel = new DeploymentModel();
        deploymentModel.setName(hostName);
        deploymentModel.setDeploymentSlot(deploymentSlot);
        deploymentModel.setLabel(label);
        DeploymentModel.RoleModel roleModel = new DeploymentModel.RoleModel();
        roleModel.setRoleName(hostName);
        roleModel.setRoleType("PersistentVMRole");
        ArrayList<ConfigurationSetModel> configurations = new ArrayList<ConfigurationSetModel>();
        if (image.getPlatform().isWindows()) {
            ConfigurationSetModel windowsConfigurationSetModel = new ConfigurationSetModel();
            windowsConfigurationSetModel.setConfigurationSetType("WindowsProvisioningConfiguration");
            windowsConfigurationSetModel.setType("WindowsProvisioningConfigurationSet");
            windowsConfigurationSetModel.setComputerName(hostName);
            windowsConfigurationSetModel.setAdminPassword(password);
            windowsConfigurationSetModel.setEnableAutomaticUpdates("true");
            windowsConfigurationSetModel.setTimeZone("UTC");
            windowsConfigurationSetModel.setAdminUsername(options.getBootstrapUser() == null || options.getBootstrapUser().trim().length() == 0 || options.getBootstrapUser().equalsIgnoreCase("root") || options.getBootstrapUser().equalsIgnoreCase("admin") || options.getBootstrapUser().equalsIgnoreCase("administrator") ? "dasein" : options.getBootstrapUser());
            configurations.add(windowsConfigurationSetModel);
        } else {
            ConfigurationSetModel unixConfigurationSetModel = new ConfigurationSetModel();
            unixConfigurationSetModel.setConfigurationSetType("LinuxProvisioningConfiguration");
            unixConfigurationSetModel.setType("LinuxProvisioningConfigurationSet");
            unixConfigurationSetModel.setHostName(hostName);
            unixConfigurationSetModel.setUserName(options.getBootstrapUser() == null || options.getBootstrapUser().trim().length() == 0 || options.getBootstrapUser().equals("root") ? "dasein" : options.getBootstrapUser());
            unixConfigurationSetModel.setUserPassword(password);
            unixConfigurationSetModel.setDisableSshPasswordAuthentication("false");
            configurations.add(unixConfigurationSetModel);
        }
        ConfigurationSetModel networkConfigurationSetModel = new ConfigurationSetModel();
        networkConfigurationSetModel.setConfigurationSetType("NetworkConfiguration");
        ArrayList<ConfigurationSetModel.InputEndpointModel> inputEndpointModels = new ArrayList<ConfigurationSetModel.InputEndpointModel>();
        if (image.getPlatform().isWindows()) {
            inputEndpointModel = new ConfigurationSetModel.InputEndpointModel();
            inputEndpointModel.setLocalPort("3389");
            inputEndpointModel.setName("RemoteDesktop");
            inputEndpointModel.setPort("58622");
            inputEndpointModel.setProtocol("TCP");
            inputEndpointModels.add(inputEndpointModel);
        } else {
            inputEndpointModel = new ConfigurationSetModel.InputEndpointModel();
            inputEndpointModel.setLocalPort("22");
            inputEndpointModel.setName("SSH");
            inputEndpointModel.setPort("22");
            inputEndpointModel.setProtocol("TCP");
            inputEndpointModels.add(inputEndpointModel);
        }
        networkConfigurationSetModel.setInputEndpoints(inputEndpointModels);
        if (subnet != null) {
            ArrayList<String> subnets = new ArrayList<String>();
            subnets.add(subnet.getName());
            networkConfigurationSetModel.setSubnetNames(subnets);
        }
        configurations.add(networkConfigurationSetModel);
        roleModel.setConfigurationsSets(configurations);
        if (image.getAzureImageType().equalsIgnoreCase("osimage")) {
            DeploymentModel.OSVirtualHardDiskModel osVirtualHardDiskModel = new DeploymentModel.OSVirtualHardDiskModel();
            osVirtualHardDiskModel.setHostCaching("ReadWrite");
            osVirtualHardDiskModel.setDiskLabel("OS");
            osVirtualHardDiskModel.setMediaLink(storageEndpoint + "vhds/" + hostName + ".vhd");
            osVirtualHardDiskModel.setSourceImageName(options.getMachineImageId());
            roleModel.setOsVirtualDisk(osVirtualHardDiskModel);
        } else if (image.getAzureImageType().equalsIgnoreCase("vmimage")) {
            roleModel.setVmImageName(image.getProviderMachineImageId());
        }
        roleModel.setRoleSize(options.getStandardProductId());
        ArrayList<DeploymentModel.RoleModel> roles = new ArrayList<DeploymentModel.RoleModel>();
        roles.add(roleModel);
        deploymentModel.setRoles(roles);
        if (options.getVlanId() != null) {
            deploymentModel.setVirtualNetworkName(vlanName);
        }
        try {
            AzureMethod method = new AzureMethod(this.provider);
            return method.post("/services/hostedservices/" + hostName + "/deployments", deploymentModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
    }

    private void CreateHostedService(String description, String regionId, String label, String hostName, String affinityGroupId) throws CloudException, InternalException {
        CreateHostedServiceModel createHostedServiceModel = new CreateHostedServiceModel();
        createHostedServiceModel.setServiceName(hostName);
        createHostedServiceModel.setLabel(label);
        createHostedServiceModel.setDescription(description);
        if (affinityGroupId != null) {
            createHostedServiceModel.setAffinityGroup(affinityGroupId);
        } else {
            createHostedServiceModel.setLocation(regionId);
        }
        try {
            AzureMethod method = new AzureMethod(this.provider);
            method.post(HOSTED_SERVICES, createHostedServiceModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new CloudException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nullable VirtualMachineProductFilterOptions options, @Nonnull Architecture architecture) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"listVMProducts");
        try {
            block18: {
                block17: {
                    cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)("products" + architecture.name()), VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
                    products = cache.get(this.getContext());
                    if (products != null) break block18;
                    list = new ArrayList<VirtualMachineProduct>();
                    resource = ((Azure)this.getProvider()).getVMProductsResource();
                    input = AzureVM.class.getResourceAsStream(resource);
                    if (input == null) ** GOTO lbl68
                    reader = new BufferedReader(new InputStreamReader(input));
                    json = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        json.append(line);
                        json.append("\n");
                    }
                    arr = new JSONArray(json.toString());
                    toCache = null;
                    for (i = 0; i < arr.length(); ++i) {
                        productSet = arr.getJSONObject(i);
                        if (!productSet.has("cloud")) continue;
                        cloud = productSet.getString("cloud");
                        if (!productSet.has("provider")) continue;
                        provider = productSet.getString("provider");
                        if (!productSet.has("products")) continue;
                        if (toCache == null || provider.equals("default") && cloud.equals("default")) {
                            toCache = productSet;
                        }
                        if (!provider.equalsIgnoreCase(this.getProvider().getProviderName()) || !cloud.equalsIgnoreCase(this.getProvider().getCloudName())) continue;
                        toCache = productSet;
                        break;
                    }
                    if (toCache != null) break block17;
                    AzureVM.logger.warn((Object)"No products were defined");
                    i = Collections.emptyList();
                    return i;
                }
                try {
                    block19: {
                        plist = toCache.getJSONArray("products");
                        for (i = 0; i < plist.length(); ++i) {
                            product = plist.getJSONObject(i);
                            supported = false;
                            if (product.has("architectures")) {
                                architectures = product.getJSONArray("architectures");
                                for (j = 0; j < architectures.length(); ++j) {
                                    a = architectures.getString(j);
                                    if (!architecture.name().equals(a)) continue;
                                    supported = true;
                                    break;
                                }
                            }
                            if (!supported) continue;
                            if (product.has("excludesRegions")) {
                                regions = product.getJSONArray("excludesRegions");
                                for (j = 0; j < regions.length(); ++j) {
                                    r = regions.getString(j);
                                    if (!r.equals(this.getContext().getRegionId())) continue;
                                    supported = false;
                                    break;
                                }
                            }
                            if (!supported || (prd = this.toProduct(product)) == null) continue;
                            if (options != null) {
                                if (!options.matches(prd)) continue;
                                list.add(prd);
                                continue;
                            }
                            list.add(prd);
                        }
                        break block19;
lbl68:
                        // 1 sources

                        AzureVM.logger.warn((Object)("No standard products resource exists for " + resource));
                    }
                    products = list;
                    cache.put(this.getContext(), products);
                }
                catch (IOException e) {
                    throw new InternalException((Throwable)e);
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            var5_5 = products;
            return var5_5;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), HOSTED_SERVICES);
        if (doc == null) {
            return Collections.emptyList();
        }
        NodeList entries = doc.getElementsByTagName("HostedService");
        ArrayList<ResourceStatus> status = new ArrayList<ResourceStatus>();
        for (int i = 0; i < entries.getLength(); ++i) {
            this.parseHostedServiceForStatus(ctx, entries.item(i), null, status);
        }
        return status;
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), HOSTED_SERVICES);
        if (doc == null) {
            return Collections.emptyList();
        }
        NodeList entries = doc.getElementsByTagName("HostedService");
        ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
        for (int i = 0; i < entries.getLength(); ++i) {
            this.parseHostedService(ctx, entries.item(i), null, vms);
        }
        return vms;
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines(@Nullable VMFilterOptions vmFilterOptions) throws InternalException, CloudException {
        Iterable<VirtualMachine> vms = this.listVirtualMachines();
        ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
        for (VirtualMachine vm : vms) {
            if (!vm.getName().matches(vmFilterOptions.getRegex())) continue;
            list.add(vm);
        }
        return list;
    }

    private void parseDeployment(@Nonnull ProviderContext ctx, @Nonnull String regionId, @Nonnull String serviceName, @Nonnull Node node, @Nonnull List<VirtualMachine> virtualMachines) {
        ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
        NodeList attributes = node.getChildNodes();
        String deploymentSlot = null;
        String deploymentId = null;
        String dnsName = null;
        String vmRoleName = null;
        String imageId = null;
        String mediaLink = null;
        String vlan = null;
        String subnetName = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("deploymentslot") && attribute.hasChildNodes()) {
                deploymentSlot = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("privateid") && attribute.hasChildNodes()) {
                deploymentId = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("url") && attribute.hasChildNodes()) {
                try {
                    URI u = new URI(attribute.getFirstChild().getNodeValue().trim());
                    dnsName = u.getHost();
                }
                catch (URISyntaxException e) {}
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("roleinstancelist") && attribute.hasChildNodes()) {
                NodeList roleInstances = attribute.getChildNodes();
                for (int j = 0; j < roleInstances.getLength(); ++j) {
                    String descriptor;
                    Platform p;
                    Node roleInstance = roleInstances.item(j);
                    if (roleInstance.getNodeType() == 3 || !roleInstance.getNodeName().equalsIgnoreCase("roleinstance") || !roleInstance.hasChildNodes()) continue;
                    VirtualMachine role = new VirtualMachine();
                    role.setArchitecture(Architecture.I64);
                    role.setClonable(false);
                    role.setCurrentState(VmState.TERMINATED);
                    role.setImagable(false);
                    role.setPersistent(true);
                    role.setPlatform(Platform.UNKNOWN);
                    role.setProviderOwnerId(ctx.getAccountNumber());
                    role.setProviderRegionId(regionId);
                    role.setProviderDataCenterId(regionId);
                    NodeList roleAttributes = roleInstance.getChildNodes();
                    for (int l = 0; l < roleAttributes.getLength(); ++l) {
                        Node roleAttribute = roleAttributes.item(l);
                        if (roleAttribute.getNodeType() == 3) continue;
                        if (roleAttribute.getNodeName().equalsIgnoreCase("RoleName") && roleAttribute.hasChildNodes()) {
                            String vmId = roleAttribute.getFirstChild().getNodeValue().trim();
                            role.setProviderVirtualMachineId(serviceName + ":" + vmId);
                            role.setName(vmId);
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("instancesize") && roleAttribute.hasChildNodes()) {
                            role.setProductId(roleAttribute.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("instanceupgradedomain") && roleAttribute.hasChildNodes()) {
                            role.setTag("UpgradeDomain", roleAttribute.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("instanceerrorcode") && roleAttribute.hasChildNodes()) {
                            role.setTag("ErrorCode", roleAttribute.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("instancefaultdomain") && roleAttribute.hasChildNodes()) {
                            role.setTag("FaultDomain", roleAttribute.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("fqdn") && roleAttribute.hasChildNodes()) {
                            role.setPrivateDnsAddress(roleAttribute.getFirstChild().getNodeValue().trim());
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("ipaddress") && roleAttribute.hasChildNodes()) {
                            role.setPrivateAddresses(new RawAddress[]{new RawAddress(roleAttribute.getFirstChild().getNodeValue().trim())});
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("instanceendpoints") && roleAttribute.hasChildNodes()) {
                            NodeList endpoints = roleAttribute.getChildNodes();
                            for (int m = 0; m < endpoints.getLength(); ++m) {
                                Node endpoint = endpoints.item(m);
                                if (!endpoint.hasChildNodes()) continue;
                                NodeList ea = endpoint.getChildNodes();
                                for (int n = 0; n < ea.getLength(); ++n) {
                                    Node a = ea.item(n);
                                    if (!a.getNodeName().equalsIgnoreCase("vip") || !a.hasChildNodes()) continue;
                                    String addr = a.getFirstChild().getNodeValue().trim();
                                    RawAddress[] ips = role.getPublicAddresses();
                                    if (ips == null || ips.length < 1) {
                                        role.setPublicAddresses(new RawAddress[]{new RawAddress(addr)});
                                        continue;
                                    }
                                    boolean found = false;
                                    for (RawAddress ip : ips) {
                                        if (!ip.getIpAddress().equals(addr)) continue;
                                        found = true;
                                        break;
                                    }
                                    if (found) continue;
                                    RawAddress[] tmp = new RawAddress[ips.length + 1];
                                    System.arraycopy(ips, 0, tmp, 0, ips.length);
                                    tmp[tmp.length - 1] = new RawAddress(addr);
                                    role.setPublicAddresses(tmp);
                                }
                            }
                            continue;
                        }
                        if (!roleAttribute.getNodeName().equalsIgnoreCase("PowerState") || !roleAttribute.hasChildNodes()) continue;
                        String powerStatus = roleAttribute.getFirstChild().getNodeValue().trim();
                        if ("Started".equalsIgnoreCase(powerStatus)) {
                            role.setCurrentState(VmState.RUNNING);
                            continue;
                        }
                        if ("Stopped".equalsIgnoreCase(powerStatus)) {
                            role.setCurrentState(VmState.STOPPED);
                            role.setImagable(true);
                            continue;
                        }
                        if ("Stopping".equalsIgnoreCase(powerStatus)) {
                            role.setCurrentState(VmState.STOPPING);
                            continue;
                        }
                        if ("Starting".equalsIgnoreCase(powerStatus)) {
                            role.setCurrentState(VmState.PENDING);
                            continue;
                        }
                        logger.warn((Object)("DEBUG: Unknown Azure status: " + powerStatus));
                    }
                    if (role.getProviderVirtualMachineId() == null) continue;
                    if (role.getName() == null) {
                        role.setName(role.getProviderVirtualMachineId());
                    }
                    if (role.getDescription() == null) {
                        role.setDescription(role.getName());
                    }
                    if (role.getPlatform().equals((Object)Platform.UNKNOWN)) {
                        String descriptor2 = (role.getProviderVirtualMachineId() + " " + role.getName() + " " + role.getDescription() + " " + role.getProviderMachineImageId()).replaceAll("_", " ");
                        role.setPlatform(Platform.guess((String)descriptor2));
                    } else if (role.getPlatform().equals((Object)Platform.UNIX) && (p = Platform.guess((String)(descriptor = (role.getProviderVirtualMachineId() + " " + role.getName() + " " + role.getDescription() + " " + role.getProviderMachineImageId()).replaceAll("_", " ")))).isUnix()) {
                        role.setPlatform(p);
                    }
                    list.add(role);
                }
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("rolelist") && attribute.hasChildNodes()) {
                NodeList roles = attribute.getChildNodes();
                for (int k = 0; k < roles.getLength(); ++k) {
                    String val;
                    Node n;
                    Node role = roles.item(k);
                    if (!role.getNodeName().equalsIgnoreCase("role") || !role.hasChildNodes() || role.hasAttributes() && (n = role.getAttributes().getNamedItem("i:type")) != null && !"PersistentVMRole".equalsIgnoreCase(val = n.getNodeValue())) continue;
                    NodeList roleAttributes = role.getChildNodes();
                    for (int l = 0; l < roleAttributes.getLength(); ++l) {
                        Node roleAttribute = roleAttributes.item(l);
                        if (roleAttribute.getNodeType() == 3) continue;
                        if (roleAttribute.getNodeName().equalsIgnoreCase("osvirtualharddisk") && roleAttribute.hasChildNodes()) {
                            NodeList diskAttributes = roleAttribute.getChildNodes();
                            for (int m = 0; m < diskAttributes.getLength(); ++m) {
                                Node diskAttribute = diskAttributes.item(m);
                                if (diskAttribute.getNodeName().equalsIgnoreCase("SourceImageName") && diskAttribute.hasChildNodes()) {
                                    imageId = diskAttribute.getFirstChild().getNodeValue().trim();
                                    continue;
                                }
                                if (!diskAttribute.getNodeName().equalsIgnoreCase("medialink") || !diskAttribute.hasChildNodes()) continue;
                                mediaLink = diskAttribute.getFirstChild().getNodeValue().trim();
                            }
                            continue;
                        }
                        if (roleAttribute.getNodeName().equalsIgnoreCase("RoleName") && roleAttribute.hasChildNodes()) {
                            vmRoleName = roleAttribute.getFirstChild().getNodeValue().trim();
                            continue;
                        }
                        if (!roleAttribute.getNodeName().equalsIgnoreCase("ConfigurationSets") || !roleAttribute.hasChildNodes()) continue;
                        NodeList configs = ((Element)roleAttribute).getElementsByTagName("ConfigurationSet");
                        for (int n2 = 0; n2 < configs.getLength(); ++n2) {
                            String val2;
                            Node c;
                            boolean foundNetConfig = false;
                            Node config = configs.item(n2);
                            if (config.hasAttributes() && (c = config.getAttributes().getNamedItem("i:type")) != null && !"NetworkConfigurationSet".equalsIgnoreCase(val2 = c.getNodeValue()) || !config.hasChildNodes()) continue;
                            NodeList configAttribs = config.getChildNodes();
                            for (int o = 0; o < configAttribs.getLength(); ++o) {
                                Node attrib = configAttribs.item(o);
                                if (!attrib.getNodeName().equalsIgnoreCase("SubnetNames") || !attrib.hasChildNodes()) continue;
                                NodeList subnets = attrib.getChildNodes();
                                for (int p = 0; p < subnets.getLength(); ++p) {
                                    Node subnet = subnets.item(p);
                                    if (!subnet.getNodeName().equalsIgnoreCase("SubnetName") || !subnet.hasChildNodes()) continue;
                                    subnetName = subnet.getFirstChild().getNodeValue().trim();
                                }
                            }
                        }
                    }
                }
                continue;
            }
            if (!attribute.getNodeName().equalsIgnoreCase("virtualnetworkname") || !attribute.hasChildNodes()) continue;
            vlan = attribute.getFirstChild().getNodeValue().trim();
        }
        if (vmRoleName != null) {
            for (VirtualMachine vm : list) {
                String roleName;
                String deploymentName;
                String sName;
                String[] parts;
                if (deploymentSlot != null) {
                    vm.setTag("environment", deploymentSlot);
                }
                if (deploymentId != null) {
                    vm.setTag("deploymentId", deploymentId);
                }
                if (dnsName != null) {
                    vm.setPublicDnsAddress(dnsName);
                }
                if (imageId != null) {
                    Platform fallback = vm.getPlatform();
                    vm.setProviderMachineImageId(imageId);
                    vm.setPlatform(Platform.guess((String)vm.getProviderMachineImageId()));
                    if (vm.getPlatform().equals((Object)Platform.UNKNOWN)) {
                        try {
                            MachineImage img = this.provider.getComputeServices().getImageSupport().getMachineImage(vm.getProviderMachineImageId());
                            if (img != null) {
                                vm.setPlatform(img.getPlatform());
                            }
                        }
                        catch (Throwable t) {
                            logger.warn((Object)("Error loading machine image: " + t.getMessage()));
                        }
                        if (vm.getPlatform().equals((Object)Platform.UNKNOWN)) {
                            vm.setPlatform(fallback);
                        }
                    }
                }
                if (vlan != null) {
                    String providerVlanId = null;
                    try {
                        providerVlanId = this.provider.getNetworkServices().getVlanSupport().getVlan(vlan).getProviderVlanId();
                        vm.setProviderVlanId(providerVlanId);
                    }
                    catch (CloudException e) {
                        logger.error((Object)("Error getting vlan id for vlan " + vlan));
                        continue;
                    }
                    catch (InternalException ie) {
                        logger.error((Object)("Error getting vlan id for vlan " + vlan));
                        continue;
                    }
                    if (subnetName != null) {
                        vm.setProviderSubnetId(subnetName + "_" + providerVlanId);
                    }
                }
                if ((parts = vm.getProviderVirtualMachineId().split(":")).length == 3) {
                    sName = parts[0];
                    deploymentName = parts[1];
                    roleName = parts[2];
                } else if (parts.length == 2) {
                    sName = parts[0];
                    roleName = deploymentName = parts[1];
                } else {
                    sName = serviceName;
                    deploymentName = serviceName;
                    roleName = serviceName;
                }
                vm.setTag("serviceName", sName);
                vm.setTag("deploymentName", deploymentName);
                vm.setTag("roleName", roleName);
                if (mediaLink != null) {
                    vm.setTag("mediaLink", mediaLink);
                }
                virtualMachines.add(vm);
            }
        }
    }

    private void parseStatus(@Nonnull ProviderContext ctx, @Nonnull String regionId, @Nonnull String serviceName, @Nonnull Node node, @Nonnull List<ResourceStatus> status) {
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        NodeList attributes = node.getChildNodes();
        String id = "";
        ResourceStatus s = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3 || !attribute.getNodeName().equalsIgnoreCase("roleinstancelist") || !attribute.hasChildNodes()) continue;
            NodeList roleInstances = attribute.getChildNodes();
            for (int j = 0; j < roleInstances.getLength(); ++j) {
                Node roleInstance = roleInstances.item(j);
                if (roleInstance.getNodeType() == 3 || !roleInstance.getNodeName().equalsIgnoreCase("roleinstance") || !roleInstance.hasChildNodes()) continue;
                NodeList roleAttributes = roleInstance.getChildNodes();
                for (int l = 0; l < roleAttributes.getLength(); ++l) {
                    Node roleAttribute = roleAttributes.item(l);
                    if (roleAttribute.getNodeType() == 3) continue;
                    if (roleAttribute.getNodeName().equalsIgnoreCase("RoleName") && roleAttribute.hasChildNodes()) {
                        String vmId = roleAttribute.getFirstChild().getNodeValue().trim();
                        id = serviceName + ":" + vmId;
                        continue;
                    }
                    if (!roleAttribute.getNodeName().equalsIgnoreCase("PowerState") || !roleAttribute.hasChildNodes()) continue;
                    String powerStatus = roleAttribute.getFirstChild().getNodeValue().trim();
                    if ("Started".equalsIgnoreCase(powerStatus)) {
                        s = new ResourceStatus(id, (Object)VmState.RUNNING);
                        continue;
                    }
                    if ("Stopped".equalsIgnoreCase(powerStatus)) {
                        s = new ResourceStatus(id, (Object)VmState.STOPPED);
                        continue;
                    }
                    if ("Stopping".equalsIgnoreCase(powerStatus)) {
                        s = new ResourceStatus(id, (Object)VmState.STOPPING);
                        continue;
                    }
                    if ("Starting".equalsIgnoreCase(powerStatus)) {
                        s = new ResourceStatus(id, (Object)VmState.PENDING);
                        continue;
                    }
                    logger.warn((Object)("DEBUG: Unknown Azure status: " + powerStatus));
                }
                if (id == null || s == null) continue;
                list.add(s);
                s = null;
            }
        }
        for (ResourceStatus rs : list) {
            status.add(rs);
        }
    }

    private void parseHostedService(@Nonnull ProviderContext ctx, @Nonnull Node entry, @Nullable String serviceName, @Nonnull List<VirtualMachine> virtualMachines) throws CloudException, InternalException {
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new AzureConfigException("No region ID was specified for this request");
        }
        NodeList attributes = entry.getChildNodes();
        String uri = null;
        long created = 0L;
        String service = null;
        boolean mediaLocationFound = false;
        DataCenter dc = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("url") && attribute.hasChildNodes()) {
                uri = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("servicename") && attribute.hasChildNodes()) {
                service = attribute.getFirstChild().getNodeValue().trim();
                if (serviceName == null || service.equals(serviceName)) continue;
                return;
            }
            if (!attribute.getNodeName().equalsIgnoreCase("hostedserviceproperties") || !attribute.hasChildNodes()) continue;
            NodeList properties = attribute.getChildNodes();
            for (int j = 0; j < properties.getLength(); ++j) {
                Node property = properties.item(j);
                if (property.getNodeType() == 3) continue;
                if (property.getNodeName().equalsIgnoreCase("AffinityGroup") && property.hasChildNodes()) {
                    String affinityGroup = property.getFirstChild().getNodeValue().trim();
                    if (affinityGroup == null || affinityGroup.equals("")) continue;
                    AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                    if (affinityGroupModel == null) {
                        return;
                    }
                    dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
                    if (dc != null && dc.getRegionId().equals(regionId)) {
                        mediaLocationFound = true;
                        continue;
                    }
                    return;
                }
                if (property.getNodeName().equalsIgnoreCase("location") && property.hasChildNodes()) {
                    if (mediaLocationFound || regionId.equals(property.getFirstChild().getNodeValue().trim())) continue;
                    return;
                }
                if (!property.getNodeName().equalsIgnoreCase("datecreated") || !property.hasChildNodes()) continue;
                created = this.provider.parseTimestamp(property.getFirstChild().getNodeValue().trim());
            }
        }
        if (uri == null || service == null) {
            return;
        }
        AzureMethod method = new AzureMethod(this.provider);
        String deployURL = "/services/hostedservices/" + service + "?embed-detail=true";
        Document deployDoc = method.getAsXML(ctx.getAccountNumber(), deployURL);
        if (deployDoc == null) {
            return;
        }
        NodeList deployments = deployDoc.getElementsByTagName("Deployments");
        for (int i = 0; i < deployments.getLength(); ++i) {
            Node deployNode = deployments.item(i);
            NodeList deployAttributes = deployNode.getChildNodes();
            String deploymentName = "";
            for (int j = 0; j < deployAttributes.getLength(); ++j) {
                Node deployment = deployAttributes.item(j);
                if (deployment.getNodeType() == 3 || !deployment.getNodeName().equalsIgnoreCase("Deployment") || !deployment.hasChildNodes()) continue;
                NodeList dAttribs = deployment.getChildNodes();
                for (int k = 0; k < dAttribs.getLength(); ++k) {
                    Node mynode = dAttribs.item(k);
                    if (!mynode.getNodeName().equalsIgnoreCase("name") || !mynode.hasChildNodes()) continue;
                    deploymentName = mynode.getFirstChild().getNodeValue().trim();
                    this.parseDeployment(ctx, regionId, service + ":" + deploymentName, deployment, virtualMachines);
                    for (VirtualMachine vm : virtualMachines) {
                        if (vm.getCreationTimestamp() < 1L) {
                            vm.setCreationTimestamp(created);
                        }
                        if (dc != null) {
                            vm.setProviderDataCenterId(dc.getProviderDataCenterId());
                            continue;
                        }
                        Collection<DataCenter> dcs = this.provider.getDataCenterServices().listDataCenters(regionId);
                        vm.setProviderDataCenterId(dcs.iterator().next().getProviderDataCenterId());
                    }
                }
            }
        }
    }

    private void parseHostedServiceForStatus(@Nonnull ProviderContext ctx, @Nonnull Node entry, @Nullable String serviceName, @Nonnull List<ResourceStatus> status) throws CloudException, InternalException {
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new AzureConfigException("No region ID was specified for this request");
        }
        NodeList attributes = entry.getChildNodes();
        String uri = null;
        String service = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            if (attribute.getNodeName().equalsIgnoreCase("url") && attribute.hasChildNodes()) {
                uri = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (attribute.getNodeName().equalsIgnoreCase("servicename") && attribute.hasChildNodes()) {
                service = attribute.getFirstChild().getNodeValue().trim();
                if (serviceName == null || service.equals(serviceName)) continue;
                return;
            }
            if (!attribute.getNodeName().equalsIgnoreCase("hostedserviceproperties") || !attribute.hasChildNodes()) continue;
            NodeList properties = attribute.getChildNodes();
            boolean mediaLocationFound = false;
            for (int j = 0; j < properties.getLength(); ++j) {
                Node property = properties.item(j);
                if (property.getNodeType() == 3) continue;
                if (property.getNodeName().equalsIgnoreCase("AffinityGroup") && property.hasChildNodes()) {
                    String affinityGroup = property.getFirstChild().getNodeValue().trim();
                    if (affinityGroup == null || affinityGroup.equals("")) continue;
                    AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                    if (affinityGroupModel == null) {
                        return;
                    }
                    DataCenter dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
                    if (dc != null && dc.getRegionId().equals(regionId)) {
                        mediaLocationFound = true;
                        continue;
                    }
                    return;
                }
                if (!property.getNodeName().equalsIgnoreCase("location") || !property.hasChildNodes() || mediaLocationFound || regionId.equals(property.getFirstChild().getNodeValue().trim())) continue;
                return;
            }
        }
        if (uri == null || service == null) {
            return;
        }
        AzureMethod method = new AzureMethod(this.provider);
        String deployURL = "/services/hostedservices/" + service + "?embed-detail=true";
        Document deployDoc = method.getAsXML(ctx.getAccountNumber(), deployURL);
        if (deployDoc == null) {
            return;
        }
        NodeList deployments = deployDoc.getElementsByTagName("Deployments");
        for (int i = 0; i < deployments.getLength(); ++i) {
            Node deployNode = deployments.item(i);
            NodeList deployAttributes = deployNode.getChildNodes();
            String deploymentName = "";
            for (int j = 0; j < deployAttributes.getLength(); ++j) {
                Node deployment = deployAttributes.item(j);
                if (deployment.getNodeType() == 3 || !deployment.getNodeName().equalsIgnoreCase("Deployment") || !deployment.hasChildNodes()) continue;
                NodeList dAttribs = deployment.getChildNodes();
                for (int k = 0; k < dAttribs.getLength(); ++k) {
                    Node mynode = dAttribs.item(k);
                    if (!mynode.getNodeName().equalsIgnoreCase("name") || !mynode.hasChildNodes()) continue;
                    deploymentName = mynode.getFirstChild().getNodeValue().trim();
                    this.parseStatus(ctx, regionId, service + ":" + deploymentName, deployment, status);
                }
            }
        }
    }

    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        if (vmId == null) {
            throw new InternalException("The id of the Virtual Machine to reboot cannot be null.");
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        String resourceUrl = String.format(OPERATIONS_RESOURCES, vm.getTag("serviceName").toString(), vm.getTag("deploymentName").toString(), vm.getTag("roleName").toString());
        AzureMethod azureMethod = new AzureMethod(this.provider);
        try {
            azureMethod.post(resourceUrl, new Operation.RestartRoleOperation());
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        this.start(vmId);
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Pause/unpause is not supported in Microsoft Azure");
    }

    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        if (vmId == null) {
            throw new InternalException("The id of the Virtual Machine to stop cannot be null.");
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        String resourceUrl = String.format(OPERATIONS_RESOURCES, vm.getTag("serviceName").toString(), vm.getTag("deploymentName").toString(), vm.getTag("roleName").toString());
        AzureMethod azureMethod = new AzureMethod(this.provider);
        Operation.ShutdownRoleOperation shutdownRoleOperation = new Operation.ShutdownRoleOperation();
        shutdownRoleOperation.setPostShutdownAction("Stopped");
        try {
            azureMethod.post(resourceUrl, shutdownRoleOperation);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        if (vmId == null) {
            throw new InternalException("The id of the Virtual Machine to suspend cannot be null.");
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        String resourceUrl = String.format(OPERATIONS_RESOURCES, vm.getTag("serviceName").toString(), vm.getTag("deploymentName").toString(), vm.getTag("roleName").toString());
        AzureMethod azureMethod = new AzureMethod(this.provider);
        Operation.ShutdownRoleOperation shutdownRoleOperation = new Operation.ShutdownRoleOperation();
        shutdownRoleOperation.setPostShutdownAction("StoppedDeallocated");
        try {
            azureMethod.post(resourceUrl, shutdownRoleOperation);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String vmId, @Nullable String explanation) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVM.class.getName() + ".terminate()"));
        }
        try {
            ProviderContext ctx;
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + vmId);
            }
            ArrayList<String> disks = this.getAttachedDisks(vm);
            long timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis()) {
                if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                    return;
                }
                if (!VmState.PENDING.equals((Object)vm.getCurrentState()) && !VmState.STOPPING.equals((Object)vm.getCurrentState())) break;
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    vm = this.getVirtualMachine(vmId);
                }
                catch (Throwable ignore) {}
            }
            if ((ctx = this.provider.getContext()) == null) {
                throw new AzureConfigException("No context was set for this request");
            }
            String serviceName = vm.getTag("serviceName").toString();
            String deploymentName = vm.getTag("deploymentName").toString();
            String resourceDir = "/services/hostedservices/" + serviceName + "/deployments/" + deploymentName;
            AzureMethod method = new AzureMethod(this.provider);
            timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis()) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Deleting deployments for " + serviceName));
                }
                try {
                    method.invoke("DELETE", ctx.getAccountNumber(), resourceDir, "");
                    break;
                }
                catch (CloudException e) {
                    if (e.getProviderCode() != null && e.getProviderCode().equals("ConflictError")) {
                        logger.warn((Object)"Conflict error, maybe retrying in 30 seconds");
                        try {
                            Thread.sleep(30000L);
                        }
                        catch (InterruptedException ignore) {}
                        continue;
                    }
                    throw e;
                }
            }
            timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis() && vm != null && !VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    vm = this.getVirtualMachine(vmId);
                }
                catch (Throwable ignore) {}
            }
            this.terminateService(serviceName, explanation);
            for (String disk : disks) {
                this.provider.getComputeServices().getVolumeSupport().remove(disk);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVM.class.getName() + ".terminate()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void terminateService(String serviceName, String explanation) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.terminateService");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was set for this request");
            }
            AzureMethod method = new AzureMethod(this.provider);
            String resourceDir = "/services/hostedservices/" + serviceName;
            long timeout = System.currentTimeMillis() + 600000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Deleting hosted service " + serviceName + ": " + explanation));
                    }
                    method.invoke("DELETE", ctx.getAccountNumber(), resourceDir, "");
                    return;
                }
                catch (CloudException e) {
                    logger.error((Object)("Unable to delete hosted service for " + serviceName + ": " + e.getMessage()));
                    logger.error((Object)"Retrying...");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                catch (Throwable t) {
                    logger.warn((Object)("Unable to delete hosted service for " + serviceName + ": " + t.getMessage()));
                    APITrace.end();
                    return;
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    private ArrayList<String> getAttachedDisks(VirtualMachine vm) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was set for this request");
        }
        ArrayList<String> list = new ArrayList<String>();
        boolean diskFound = false;
        String serviceName = vm.getTag("serviceName").toString();
        String deploymentName = vm.getTag("deploymentName").toString();
        String resourceDir = "/services/hostedservices/" + serviceName + "/deployments/" + deploymentName;
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), resourceDir);
        NodeList entries = doc.getElementsByTagName("Deployment");
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            NodeList attributes = entry.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                if (!attribute.getNodeName().equalsIgnoreCase("RoleList") || !attribute.hasChildNodes()) continue;
                NodeList instances = attribute.getChildNodes();
                block2: for (int k = 0; k < instances.getLength(); ++k) {
                    Node instance = instances.item(k);
                    if (!instance.getNodeName().equalsIgnoreCase("Role") || !instance.hasChildNodes()) continue;
                    NodeList roles = instance.getChildNodes();
                    for (int l = 0; l < roles.getLength(); ++l) {
                        Node role = roles.item(l);
                        if (role.getNodeName().equalsIgnoreCase("OSVirtualHardDisk") && role.hasChildNodes()) {
                            NodeList disks = role.getChildNodes();
                            for (int m = 0; m < disks.getLength(); ++m) {
                                Node disk = disks.item(m);
                                if (!disk.getNodeName().equalsIgnoreCase("DiskName") || !disk.hasChildNodes()) continue;
                                String name = disk.getFirstChild().getNodeValue();
                                list.add(name);
                                diskFound = true;
                                break;
                            }
                        }
                        if (!diskFound) continue;
                        diskFound = false;
                        continue block2;
                    }
                }
            }
        }
        return list;
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Pause/unpause is not supported in Microsoft Azure");
    }

    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nonnull
    private String toUniqueId(@Nonnull String name, @Nonnull AzureMethod method, ProviderContext ctx) throws CloudException, InternalException {
        String id = name = name.toLowerCase().replaceAll(" ", "");
        int i = 0;
        while (method.getAsXML(ctx.getAccountNumber(), "/services/hostedservices/" + id) != null) {
            id = name + "-" + ++i;
        }
        return id;
    }

    @Nullable
    private VirtualMachineProduct toProduct(@Nonnull JSONObject json) throws InternalException {
        VirtualMachineProduct prd = new VirtualMachineProduct();
        try {
            if (!json.has("id")) {
                return null;
            }
            prd.setProviderProductId(json.getString("id"));
            if (json.has("name")) {
                prd.setName(json.getString("name"));
            } else {
                prd.setName(prd.getProviderProductId());
            }
            if (json.has("description")) {
                prd.setDescription(json.getString("description"));
            } else {
                prd.setDescription(prd.getName());
            }
            if (json.has("cpuCount")) {
                prd.setCpuCount(json.getInt("cpuCount"));
            } else {
                prd.setCpuCount(1);
            }
            if (json.has("rootVolumeSizeInGb")) {
                prd.setRootVolumeSize(new Storage((Number)json.getInt("rootVolumeSizeInGb"), (StorageUnit)Storage.GIGABYTE));
            } else {
                prd.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            }
            if (json.has("ramSizeInMb")) {
                prd.setRamSize(new Storage((Number)json.getInt("ramSizeInMb"), (StorageUnit)Storage.MEGABYTE));
            } else {
                prd.setRamSize(new Storage((Number)512, (StorageUnit)Storage.MEGABYTE));
            }
            if (json.has("standardHourlyRates")) {
                JSONArray rates = json.getJSONArray("standardHourlyRates");
                for (int i = 0; i < rates.length(); ++i) {
                    JSONObject rate = rates.getJSONObject(i);
                    if (!rate.has("rate")) continue;
                    prd.setStandardHourlyRate((float)rate.getDouble("rate"));
                }
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return prd;
    }
}

