/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.compute.vm;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.NamingConstraints;

public class VMCapabilities
extends AbstractCapabilities<Azure>
implements VirtualMachineCapabilities {
    public VMCapabilities(@Nonnull Azure provider) {
        super((CloudProvider)provider);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.STOPPED);
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.TERMINATED);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        return !state.equals((Object)VmState.TERMINATED) ? 100 : 0;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "virtual machine";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)true, (Requirement)Requirement.REQUIRED, (Requirement)Requirement.NONE);
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getStrictInstance((int)3, (int)15).constrainedBy(new char[]{'-'});
    }

    @Nullable
    public VisibleScope getVirtualMachineVisibleScope() {
        return null;
    }

    @Nullable
    public VisibleScope getVirtualMachineProductVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDefinedPrivateIPSupported() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        return Collections.singletonList(Architecture.I64);
    }

    public boolean supportsSpotVirtualMachines() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsAlterVM() {
        return true;
    }

    public boolean supportsClone() {
        return false;
    }

    public boolean supportsPause() {
        return false;
    }

    public boolean supportsReboot() {
        return true;
    }

    public boolean supportsResume() {
        return false;
    }

    public boolean supportsStart() {
        return true;
    }

    public boolean supportsStop() {
        return true;
    }

    public boolean supportsSuspend() {
        return false;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsUnPause() {
        return false;
    }
}

