/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.network.AzureIpAddressCapabilities;
import org.dasein.cloud.azure.network.model.PersistentVMRoleModel;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPAddressCapabilities;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;

public class AzureIpAddressSupport
implements IpAddressSupport {
    private static final Logger logger = Logger.getLogger(AzureIpAddressSupport.class);
    private static final Logger wire = Azure.getWireLogger(AzureIpAddressSupport.class);
    private Azure provider;
    public static final String RESOURCE_ROLE = "/services/hostedservices/%s/deployments/%s/roles/%s";

    public AzureIpAddressSupport(Azure provider) {
        this.provider = provider;
    }

    public void assign(@Nonnull String addressId, @Nonnull String serverId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#assign not supported");
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#assignToNetworkInterface not supported");
    }

    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        String roleName;
        String deploymentName;
        String sName;
        VirtualMachine server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(onServerId);
        if (server == null) {
            throw new InternalException("Cannot find Azure virtual machine with id: " + onServerId);
        }
        String[] parts = server.getProviderVirtualMachineId().split(":");
        if (parts.length == 3) {
            sName = parts[0];
            deploymentName = parts[1];
            roleName = parts[2];
        } else if (parts.length == 2) {
            sName = parts[0];
            deploymentName = parts[1];
            roleName = sName;
        } else {
            sName = server.getProviderVirtualMachineId();
            deploymentName = server.getProviderVirtualMachineId();
            roleName = server.getProviderVirtualMachineId();
        }
        AzureMethod azureMethod = new AzureMethod(this.provider);
        PersistentVMRoleModel persistentVMRoleModel = azureMethod.get(PersistentVMRoleModel.class, String.format(RESOURCE_ROLE, sName, deploymentName, roleName));
        PersistentVMRoleModel.InputEndpoint inputEndpoint = new PersistentVMRoleModel.InputEndpoint();
        inputEndpoint.setLocalPort(String.valueOf(privatePort));
        inputEndpoint.setPort(String.valueOf(publicPort));
        inputEndpoint.setProtocol(protocol.toString());
        inputEndpoint.setName(protocol.toString() + String.valueOf(publicPort));
        if (persistentVMRoleModel.getConfigurationSets().get(0).getInputEndpoints() == null) {
            persistentVMRoleModel.getConfigurationSets().get(0).setInputEndpoints(new ArrayList<PersistentVMRoleModel.InputEndpoint>());
        }
        persistentVMRoleModel.getConfigurationSets().get(0).getInputEndpoints().add(inputEndpoint);
        try {
            azureMethod.put(String.format(RESOURCE_ROLE, sName, deploymentName, roleName), persistentVMRoleModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        return inputEndpoint.getName();
    }

    @Nonnull
    public IPAddressCapabilities getCapabilities() throws CloudException, InternalException {
        return new AzureIpAddressCapabilities(this.provider);
    }

    @Nullable
    public IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#getIpAddress not supported");
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#identifyVlanForVlanIPRequirement not supported");
    }

    public boolean isAssigned(@Nonnull AddressType type) {
        return false;
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isForwarding() {
        return true;
    }

    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return true;
    }

    public boolean isRequestable(@Nonnull AddressType type) {
        return false;
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Future<Iterable<IpAddress>> listIpPoolConcurrently(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#releaseFromPool not supported");
    }

    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#releaseFromServer not supported");
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        return "";
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        return "";
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        return "";
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        return "";
    }

    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("AzureIpAddressSupport#stopForward not supported");
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }
}

