/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.network;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;

public class AzureLoadBalancerCapabilities
extends AbstractCapabilities<Azure>
implements LoadBalancerCapabilities {
    public AzureLoadBalancerCapabilities(@Nonnull Azure provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.DNS;
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 0;
    }

    @Nonnull
    public String getProviderTermForLoadBalancer(@Nonnull Locale locale) {
        return "Traffic Manager";
    }

    @Nullable
    public VisibleScope getLoadBalancerVisibleScope() {
        return VisibleScope.ACCOUNT_GLOBAL;
    }

    public boolean healthCheckRequiresLoadBalancer() throws CloudException, InternalException {
        return true;
    }

    public Requirement healthCheckRequiresName() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement identifyEndpointsOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyListenersOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public Requirement identifyVlanOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return true;
    }

    public boolean isDataCenterLimited() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<LbAlgorithm> listSupportedAlgorithms() throws CloudException, InternalException {
        return Collections.unmodifiableList(Arrays.asList(LbAlgorithm.LEAST_CONN, LbAlgorithm.ROUND_ROBIN, LbAlgorithm.SOURCE));
    }

    @Nonnull
    public Iterable<LbEndpointType> listSupportedEndpointTypes() throws CloudException, InternalException {
        return Collections.unmodifiableList(Arrays.asList(LbEndpointType.VM));
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Iterable<LbPersistence> listSupportedPersistenceOptions() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Iterable<LbProtocol> listSupportedProtocols() throws CloudException, InternalException {
        return Collections.unmodifiableList(Arrays.asList(LbProtocol.HTTP, LbProtocol.HTTPS));
    }

    public boolean supportsAddingEndpoints() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMonitoring() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMultipleTrafficTypes() throws CloudException, InternalException {
        return false;
    }
}

