/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.network;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.network.AzureLoadBalancerCapabilities;
import org.dasein.cloud.azure.network.model.DefinitionModel;
import org.dasein.cloud.azure.network.model.ProfileModel;
import org.dasein.cloud.azure.network.model.ProfilesModel;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.network.AbstractLoadBalancerSupport;
import org.dasein.cloud.network.HealthCheckFilterOptions;
import org.dasein.cloud.network.HealthCheckOptions;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointState;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;
import org.dasein.cloud.network.LoadBalancerCreateOptions;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;

public class AzureLoadBalancerSupport
extends AbstractLoadBalancerSupport<Azure> {
    private static final Logger logger = Logger.getLogger(AzureLoadBalancerSupport.class);
    private static final Logger wire = Azure.getWireLogger(AzureLoadBalancerSupport.class);
    public static final String RESOURCE_PROFILES = "/services/WATM/profiles";
    public static final String RESOURCE_PROFILE = "/services/WATM/profiles/%s";
    public static final String RESOURCE_DEFINITIONS = "/services/WATM/profiles/%s/definitions";
    public static final String RESOURCE_DEFINITION = "/services/WATM/profiles/%s/definitions/1";
    private volatile transient AzureLoadBalancerCapabilities capabilities;
    public static final String TRAFFIC_MANAGER_DNS_NAME = "trafficmanager.net";

    public AzureLoadBalancerSupport(@Nonnull Azure provider) {
        super((CloudProvider)provider);
        this.capabilities = new AzureLoadBalancerCapabilities(provider);
    }

    @Nonnull
    public LoadBalancerCapabilities getCapabilities() throws CloudException, InternalException {
        return this.capabilities;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    public LoadBalancerHealthCheck createLoadBalancerHealthCheck(@Nullable String name, @Nullable String description, @Nullable String host, @Nullable LoadBalancerHealthCheck.HCProtocol protocol, int port, @Nullable String path, int interval, int timeout, int healthyCount, int unhealthyCount) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Health check should be created only when creating the load balancer for Microsoft Azure cloud");
    }

    public LoadBalancerHealthCheck createLoadBalancerHealthCheck(@Nonnull HealthCheckOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Health check should be created only when creating the load balancer for Microsoft Azure cloud");
    }

    @Nonnull
    public String createLoadBalancer(@Nonnull LoadBalancerCreateOptions options) throws CloudException, InternalException {
        if (options.getHealthCheckOptions() == null) {
            throw new InternalException("Cannot create load balancer without health check options");
        }
        if (options.getName() == null || options.getName().isEmpty()) {
            throw new InternalException("Cannot create load balancer without a name");
        }
        if (options.getHealthCheckOptions().getProtocol() != LoadBalancerHealthCheck.HCProtocol.HTTP && options.getHealthCheckOptions().getProtocol() != LoadBalancerHealthCheck.HCProtocol.HTTPS) {
            throw new InternalException("Azure only supports HTTP and HTTPS protocol for HealthCheckOptions");
        }
        ProfileModel profileModel = new ProfileModel();
        profileModel.setDomainName(String.format("%s.%s", options.getName(), TRAFFIC_MANAGER_DNS_NAME));
        profileModel.setName(options.getName());
        AzureMethod azureMethod = new AzureMethod((Azure)this.getProvider());
        try {
            azureMethod.post(RESOURCE_PROFILES, profileModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        DefinitionModel definition = new DefinitionModel();
        DefinitionModel.DnsOptions dnsOptions = new DefinitionModel.DnsOptions();
        dnsOptions.setTimeToLiveInSeconds("300");
        definition.setDnsOptions(dnsOptions);
        DefinitionModel.MonitorModel monitor = new DefinitionModel.MonitorModel();
        monitor.setIntervalInSeconds("30");
        monitor.setTimeoutInSeconds("10");
        monitor.setToleratedNumberOfFailures("3");
        monitor.setProtocol(options.getHealthCheckOptions().getProtocol().toString());
        monitor.setPort(String.valueOf(options.getHealthCheckOptions().getPort()));
        DefinitionModel.HttpOptionsModel httpOptions = new DefinitionModel.HttpOptionsModel();
        httpOptions.setVerb("GET");
        httpOptions.setRelativePath(options.getHealthCheckOptions().getPath());
        httpOptions.setExpectedStatusCode("200");
        monitor.setHttpOptions(httpOptions);
        ArrayList<DefinitionModel.MonitorModel> monitors = new ArrayList<DefinitionModel.MonitorModel>();
        monitors.add(monitor);
        definition.setMonitors(monitors);
        DefinitionModel.PolicyModel policy = new DefinitionModel.PolicyModel();
        String loadBalancingMethod = "RoundRobin";
        LbListener lbListener = options.getListeners()[0];
        if (lbListener != null) {
            if (lbListener.getAlgorithm() != null && lbListener.getAlgorithm() == LbAlgorithm.SOURCE) {
                loadBalancingMethod = "Performance";
            } else if (lbListener.getAlgorithm() != null && lbListener.getAlgorithm() == LbAlgorithm.LEAST_CONN) {
                loadBalancingMethod = "Failover";
            }
        }
        policy.setLoadBalancingMethod(loadBalancingMethod);
        ArrayList<DefinitionModel.EndPointModel> endPointsToAdd = new ArrayList<DefinitionModel.EndPointModel>();
        for (LoadBalancerEndpoint endPoint : options.getEndpoints()) {
            DefinitionModel.EndPointModel endPointModel = new DefinitionModel.EndPointModel();
            endPointModel.setDomainName(endPoint.getEndpointValue());
            endPointModel.setStatus("Enabled");
            endPointModel.setType("CloudService");
            endPointsToAdd.add(endPointModel);
        }
        policy.setEndPoints(endPointsToAdd);
        definition.setPolicy(policy);
        try {
            azureMethod.post(String.format(RESOURCE_DEFINITIONS, options.getName()), definition);
        }
        catch (Exception ex) {
            try {
                azureMethod.invoke("DELETE", this.getContext().getAccountNumber(), String.format(RESOURCE_PROFILE, options.getName()), null);
                logger.error((Object)ex.getMessage());
                throw new CloudException((Throwable)ex);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                throw new CloudException((Throwable)e);
            }
        }
        return options.getName();
    }

    public void removeLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        if (loadBalancerId == null || loadBalancerId.isEmpty()) {
            throw new InternalException("Cannot remove load balancer. Please specify the id for load balancer to remove");
        }
        AzureMethod method = new AzureMethod((Azure)this.getProvider());
        method.invoke("DELETE", this.getContext().getAccountNumber(), String.format(RESOURCE_PROFILE, loadBalancerId), null);
    }

    @Nonnull
    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        ProviderContext ctx = ((Azure)this.getProvider()).getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ArrayList<LoadBalancer> loadBalancers = new ArrayList<LoadBalancer>();
        ProfilesModel profileResponseModels = this.getProfiles();
        if (profileResponseModels == null) {
            return Collections.emptyList();
        }
        if (profileResponseModels.getProfiles() == null) {
            return Collections.emptyList();
        }
        for (ProfileModel profile : profileResponseModels.getProfiles()) {
            DefinitionModel definitionModel = this.getDefinition(profile.getName());
            LoadBalancer loadBalancer = this.toLoadBalancer(ctx, profile, definitionModel);
            loadBalancers.add(loadBalancer);
        }
        return loadBalancers;
    }

    public LoadBalancer getLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        ProviderContext ctx = ((Azure)this.getProvider()).getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ProfileModel profileModel = this.getProfile(loadBalancerId);
        if (profileModel == null) {
            return null;
        }
        DefinitionModel definitionModel = this.getDefinition(loadBalancerId);
        return this.toLoadBalancer(ctx, profileModel, definitionModel);
    }

    private LoadBalancer toLoadBalancer(ProviderContext ctx, ProfileModel profileModel, DefinitionModel definitionModel) {
        LoadBalancerState lbState = definitionModel.getStatus().equalsIgnoreCase("enabled") ? LoadBalancerState.ACTIVE : LoadBalancerState.TERMINATED;
        String lbId = profileModel.getDomainName().substring(0, profileModel.getDomainName().indexOf("."));
        LoadBalancer loadBalancer = LoadBalancer.getInstance((String)ctx.getAccountNumber(), null, (String)lbId, (LoadBalancerState)lbState, (String)profileModel.getName(), (String)profileModel.getName(), (LoadBalancerAddressType)LoadBalancerAddressType.DNS, (String)profileModel.getDomainName(), (int[])new int[0]);
        loadBalancer.setProviderLBHealthCheckId(lbId);
        LbAlgorithm lbAlgorithm = LbAlgorithm.ROUND_ROBIN;
        if (definitionModel.getPolicy().getLoadBalancingMethod().equalsIgnoreCase("performance")) {
            lbAlgorithm = LbAlgorithm.SOURCE;
        } else if (definitionModel.getPolicy().getLoadBalancingMethod().equalsIgnoreCase("failover")) {
            lbAlgorithm = LbAlgorithm.LEAST_CONN;
        }
        LbListener lbListener = LbListener.getInstance((LbAlgorithm)lbAlgorithm, (String)"", null, (int)0, (int)0);
        loadBalancer.withListeners(new LbListener[]{lbListener});
        return loadBalancer;
    }

    public void addIPEndpoints(@Nonnull String toLoadBalancerId, String ... ipAddresses) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Adding IP endpoints to an existing load balancer is not currently supported by Microsoft Azure cloud");
    }

    public void addServers(@Nonnull String toLoadBalancerId, String ... serverIdsToAdd) throws CloudException, InternalException {
        DefinitionModel definitionModel = this.getDefinition(toLoadBalancerId);
        for (String serverToAddId : serverIdsToAdd) {
            String[] parts = serverToAddId.split(":");
            DefinitionModel.EndPointModel endPointModel = new DefinitionModel.EndPointModel();
            endPointModel.setDomainName(parts[0] + ".cloudapp.net");
            endPointModel.setStatus("Enabled");
            endPointModel.setType("CloudService");
            if (definitionModel.getPolicy().getEndPoints() == null) {
                definitionModel.getPolicy().setEndPoints(new ArrayList<DefinitionModel.EndPointModel>());
            }
            definitionModel.getPolicy().getEndPoints().add(endPointModel);
        }
        try {
            AzureMethod method = new AzureMethod((Azure)this.getProvider());
            method.post(String.format(RESOURCE_DEFINITIONS, toLoadBalancerId), definitionModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public Iterable<LoadBalancerEndpoint> listEndpoints(@Nonnull String forLoadBalancerId) throws CloudException, InternalException {
        Azure provider = (Azure)this.getProvider();
        Cache cache = Cache.getInstance((CloudProvider)provider, (String)"LoadBalancerVMs", VirtualMachine.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.MINUTE));
        ArrayList<VirtualMachine> virtualMachines = (ArrayList<VirtualMachine>)cache.get(provider.getContext());
        if (virtualMachines == null) {
            virtualMachines = new ArrayList<VirtualMachine>();
            for (VirtualMachine vm : provider.getComputeServices().getVirtualMachineSupport().listVirtualMachines()) {
                virtualMachines.add(vm);
            }
            cache.put(provider.getContext(), virtualMachines);
        }
        DefinitionModel definitionModel = this.getDefinition(forLoadBalancerId);
        ArrayList<LoadBalancerEndpoint> endpoints = new ArrayList<LoadBalancerEndpoint>();
        for (DefinitionModel.EndPointModel endPoint : definitionModel.getPolicy().getEndPoints()) {
            LbEndpointState lbState = endPoint.getStatus().equalsIgnoreCase("enabled") ? LbEndpointState.ACTIVE : LbEndpointState.INACTIVE;
            ArrayList<VirtualMachine> vmsWithEndpointDNS = this.findVMsForDNS(virtualMachines, endPoint.getDomainName());
            for (VirtualMachine vm : vmsWithEndpointDNS) {
                LoadBalancerEndpoint lbEndpoint = LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.VM, (String)vm.getProviderVirtualMachineId(), (LbEndpointState)lbState);
                endpoints.add(lbEndpoint);
            }
        }
        return endpoints;
    }

    private ArrayList<VirtualMachine> findVMsForDNS(Iterable<VirtualMachine> virtualMachines, String dnsName) {
        ArrayList<VirtualMachine> virtualMachinesFound = new ArrayList<VirtualMachine>();
        for (VirtualMachine virtualMachine : virtualMachines) {
            if (!virtualMachine.getPublicDnsAddress().equalsIgnoreCase(dnsName)) continue;
            virtualMachinesFound.add(virtualMachine);
        }
        return virtualMachinesFound;
    }

    public void removeServers(@Nonnull String fromLoadBalancerId, String ... serverIdsToRemove) throws CloudException, InternalException {
        DefinitionModel definitionModel = this.getDefinition(fromLoadBalancerId);
        ArrayList<DefinitionModel.EndPointModel> itemsToRemove = new ArrayList<DefinitionModel.EndPointModel>();
        for (String serverToRemoveId : serverIdsToRemove) {
            String[] parts = serverToRemoveId.split(":");
            for (DefinitionModel.EndPointModel endPoint : definitionModel.getPolicy().getEndPoints()) {
                if (!endPoint.getDomainName().startsWith(parts[0] + ".")) continue;
                itemsToRemove.add(endPoint);
            }
        }
        definitionModel.getPolicy().getEndPoints().removeAll(itemsToRemove);
        try {
            AzureMethod method = new AzureMethod((Azure)this.getProvider());
            method.post(String.format(RESOURCE_DEFINITIONS, fromLoadBalancerId), definitionModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
    }

    public Iterable<LoadBalancerHealthCheck> listLBHealthChecks(@Nullable HealthCheckFilterOptions opts) throws CloudException, InternalException {
        ProviderContext ctx = ((Azure)this.getProvider()).getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        ProfilesModel profilesModel = this.getProfiles();
        if (profilesModel == null) {
            return Collections.emptyList();
        }
        if (profilesModel.getProfiles() == null) {
            return Collections.emptyList();
        }
        ArrayList<LoadBalancerHealthCheck> loadBalancerHealthChecks = new ArrayList<LoadBalancerHealthCheck>();
        for (ProfileModel profile : profilesModel.getProfiles()) {
            DefinitionModel definitionModel = this.getDefinition(profile.getName());
            DefinitionModel.MonitorModel currentMonitor = definitionModel.getMonitors().get(0);
            LoadBalancerHealthCheck.HCProtocol protocol = currentMonitor.getProtocol().equalsIgnoreCase("http") ? LoadBalancerHealthCheck.HCProtocol.HTTP : LoadBalancerHealthCheck.HCProtocol.HTTPS;
            LoadBalancerHealthCheck loadBalancerHealthCheck = LoadBalancerHealthCheck.getInstance((String)profile.getName(), (LoadBalancerHealthCheck.HCProtocol)protocol, (int)Integer.parseInt(currentMonitor.getPort()), (String)currentMonitor.getHttpOptions().getRelativePath(), (int)Integer.parseInt(currentMonitor.getIntervalInSeconds()), (int)Integer.parseInt(currentMonitor.getTimeoutInSeconds()), (int)1, (int)Integer.parseInt(currentMonitor.getToleratedNumberOfFailures()));
            loadBalancerHealthCheck.addProviderLoadBalancerId(profile.getName());
            if (opts != null && !opts.matches(loadBalancerHealthCheck)) continue;
            loadBalancerHealthChecks.add(loadBalancerHealthCheck);
        }
        return loadBalancerHealthChecks;
    }

    public LoadBalancerHealthCheck getLoadBalancerHealthCheck(@Nonnull String providerLBHealthCheckId, @Nullable String providerLoadBalancerId) throws CloudException, InternalException {
        if (providerLBHealthCheckId == null) {
            throw new InternalException("Cannot retrieve Load Balancer Health Check when providerLBHealthCheckId is not provided");
        }
        String profileId = providerLoadBalancerId != null ? providerLoadBalancerId : providerLBHealthCheckId;
        DefinitionModel definitionModel = this.getDefinition(profileId);
        DefinitionModel.MonitorModel currentMonitor = definitionModel.getMonitors().get(0);
        LoadBalancerHealthCheck.HCProtocol protocol = currentMonitor.getProtocol().equalsIgnoreCase("http") ? LoadBalancerHealthCheck.HCProtocol.HTTP : LoadBalancerHealthCheck.HCProtocol.HTTPS;
        LoadBalancerHealthCheck loadBalancerHealthCheck = LoadBalancerHealthCheck.getInstance((String)profileId, (LoadBalancerHealthCheck.HCProtocol)protocol, (int)Integer.parseInt(currentMonitor.getPort()), (String)currentMonitor.getHttpOptions().getRelativePath(), (int)Integer.parseInt(currentMonitor.getIntervalInSeconds()), (int)Integer.parseInt(currentMonitor.getTimeoutInSeconds()), (int)1, (int)Integer.parseInt(currentMonitor.getToleratedNumberOfFailures()));
        loadBalancerHealthCheck.addProviderLoadBalancerId(profileId);
        return loadBalancerHealthCheck;
    }

    public LoadBalancerHealthCheck modifyHealthCheck(@Nonnull String providerLBHealthCheckId, @Nonnull HealthCheckOptions options) throws InternalException, CloudException {
        if (options == null) {
            throw new InternalException("Cannot modify Health Check definition when HealthCheckOptions are not provided");
        }
        String loadBalancerId = providerLBHealthCheckId;
        if (options.getProviderLoadBalancerId() != null) {
            loadBalancerId = options.getProviderLoadBalancerId();
        }
        if (loadBalancerId == null) {
            throw new InternalException("Load balancer id not provided");
        }
        if (options.getProtocol() != LoadBalancerHealthCheck.HCProtocol.HTTP && options.getProtocol() != LoadBalancerHealthCheck.HCProtocol.HTTPS) {
            throw new InternalException("Azure health check monitor supports only HTTP and HTTPS protocols");
        }
        DefinitionModel.MonitorModel monitorModel = new DefinitionModel.MonitorModel();
        monitorModel.setProtocol(options.getProtocol().toString());
        monitorModel.setPort(String.valueOf(options.getPort()));
        monitorModel.setIntervalInSeconds("30");
        monitorModel.setTimeoutInSeconds("10");
        monitorModel.setToleratedNumberOfFailures("3");
        DefinitionModel.HttpOptionsModel httpOptions = new DefinitionModel.HttpOptionsModel();
        httpOptions.setVerb("GET");
        httpOptions.setRelativePath(options.getPath());
        httpOptions.setExpectedStatusCode("200");
        monitorModel.setHttpOptions(httpOptions);
        DefinitionModel definitionModel = this.getDefinition(loadBalancerId);
        definitionModel.getMonitors().set(0, monitorModel);
        try {
            AzureMethod method = new AzureMethod((Azure)this.getProvider());
            method.post(String.format(RESOURCE_DEFINITIONS, loadBalancerId), definitionModel);
        }
        catch (JAXBException e) {
            logger.error((Object)e.getMessage());
            throw new InternalException((Throwable)e);
        }
        return this.getLoadBalancerHealthCheck(loadBalancerId, null);
    }

    private DefinitionModel getDefinition(String profileName) throws CloudException, InternalException {
        AzureMethod method = new AzureMethod((Azure)this.getProvider());
        return method.get(DefinitionModel.class, String.format(RESOURCE_DEFINITION, profileName));
    }

    private ProfileModel getProfile(String profileName) throws CloudException, InternalException {
        AzureMethod method = new AzureMethod((Azure)this.getProvider());
        return method.get(ProfileModel.class, String.format(RESOURCE_PROFILE, profileName));
    }

    private ProfilesModel getProfiles() throws CloudException, InternalException {
        AzureMethod method = new AzureMethod((Azure)this.getProvider());
        return method.get(ProfilesModel.class, RESOURCE_PROFILES);
    }
}

