/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.network;

import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.compute.disk.AzureDisk;
import org.dasein.cloud.azure.network.AzureVPNCapabilities;
import org.dasein.cloud.azure.network.AzureVlanSupport;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.VPN;
import org.dasein.cloud.network.VPNCapabilities;
import org.dasein.cloud.network.VPNConnection;
import org.dasein.cloud.network.VPNGateway;
import org.dasein.cloud.network.VPNGatewayState;
import org.dasein.cloud.network.VPNProtocol;
import org.dasein.cloud.network.VPNState;
import org.dasein.cloud.network.VPNSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureVPNSupport
implements VPNSupport {
    private static final Logger logger = Azure.getLogger(AzureVPNSupport.class);
    private static final String NETWORKING_SERVICES = "/services/networking";
    private static final String OBJECT_NAME_SPLIT = "_&_";
    public static final String VPN_ID_KEY = "VPNID";
    public static final String ENSTRATUS_DEFAULT_VPN = "Enstratus_VPN";
    private Azure provider;
    private volatile transient AzureVPNCapabilities capabilities;

    public AzureVPNSupport(Azure provider) {
        this.provider = provider;
    }

    public String[] mapServiceAction(ServiceAction action) {
        return new String[0];
    }

    public void attachToVLAN(String providerVpnId, String providerVlanId) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectToGateway(String providerVpnId, String toGatewayId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVPNSupport.class.getName() + ".connectToGateway()"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            AzureMethod method = new AzureMethod(this.provider);
            String resourceDir = "/services/networking/" + providerVpnId + "/gateway";
            method.post(ctx.getAccountNumber(), resourceDir, null);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVPNSupport.class.getName() + ".connectToGateway()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VPN createVPN(String inProviderDataCenterId, String name, String description, VPNProtocol protocol) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVPNSupport.class.getName() + ".createVPN()"));
        }
        String cidr = "10.0.0.0/8";
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            AzureMethod method = new AzureMethod(this.provider);
            StringBuilder xml = new StringBuilder();
            xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            xml.append("<NetworkConfiguration xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://schemas.microsoft.com/ServiceHosting/2011/07/NetworkConfiguration\">");
            xml.append("<VirtualNetworkConfiguration>");
            xml.append("<VirtualNetworkSites>");
            xml.append("VirtualNetworkSite name=\"" + name + "\" Location=\"" + ctx.getRegionId() + "\">");
            xml.append("<AddressSpace>");
            xml.append("<AddressPrefix>" + cidr + "</AddressPrefix>");
            xml.append("</AddressSpace>");
            xml.append("</VirtualNetworkSite>");
            xml.append("</VirtualNetworkSites>");
            xml.append("</VirtualNetworkConfiguration>");
            xml.append("</NetworkConfiguration>");
            if (logger.isDebugEnabled()) {
                try {
                    method.parseResponse(xml.toString(), false);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to parse outgoing XML locally: " + e.getMessage()));
                    logger.warn((Object)"XML:");
                    logger.warn((Object)xml.toString());
                }
            }
            String resourceDir = "/services/networking/media";
            method.post(ctx.getAccountNumber(), resourceDir, xml.toString());
            VPN vPN = null;
            return vPN;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVlanSupport.class.getName() + ".createVlan()"));
            }
        }
    }

    private String getAffinityGroup(String vlanName) {
        return "Group1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VPNGateway createVPNGateway(String endpoint, String name, String description, VPNProtocol protocol, String bgpAsn) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVPNSupport.class.getName() + ".createVPNGateway()"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            AzureMethod method = new AzureMethod(this.provider);
            StringBuilder xml = new StringBuilder();
            xml.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            xml.append("<NetworkConfiguration  xmlns=\"http://schemas.microsoft.com/windowsazure\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\">");
            xml.append("<VirtualNetworkConfiguration>");
            xml.append("<LocalNetworkSites>");
            xml.append("<LocalNetworkSite name=\"" + name + "\">");
            xml.append("<AddressSpace>");
            xml.append("<AddressPrefix>" + endpoint + "/32" + "</AddressPrefix>");
            xml.append("</AddressSpace>");
            xml.append("<VPNGatewayAddress>" + endpoint + "</VPNGatewayAddress>");
            xml.append("</LocalNetworkSite>");
            xml.append("</LocalNetworkSites>");
            xml.append("</VirtualNetworkConfiguration>");
            xml.append("</NetworkConfiguration>");
            if (logger.isDebugEnabled()) {
                try {
                    method.parseResponse(xml.toString(), false);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to parse outgoing XML locally: " + e.getMessage()));
                    logger.warn((Object)"XML:");
                    logger.warn((Object)xml.toString());
                }
            }
            String resourceDir = "/services/networking/media";
            method.post(ctx.getAccountNumber(), resourceDir, xml.toString());
            VPNGateway vPNGateway = null;
            return vPNGateway;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVPNSupport.class.getName() + ".createVPNGateway()"));
            }
        }
    }

    public void deleteVPN(String providerVpnId) throws CloudException, InternalException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVPNGateway(String providerVPNGatewayId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVPNSupport.class.getName() + ".deleteVPNGateway(" + providerVPNGatewayId + ")"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            if (!providerVPNGatewayId.contains(OBJECT_NAME_SPLIT)) {
                logger.trace((Object)" The GateWay ID does not have the patern ->_&_");
                return;
            }
            String[] VPNAndGatewayName = providerVPNGatewayId.split(OBJECT_NAME_SPLIT);
            String resourceDir = "/services/networking/" + VPNAndGatewayName[0] + "/gateway";
            AzureMethod method = new AzureMethod(this.provider);
            method.invoke("DELETE", ctx.getAccountNumber(), resourceDir, null);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureDisk.class.getName() + ".deattach()"));
            }
        }
    }

    public void detachFromVLAN(String providerVpnId, String providerVlanId) throws CloudException, InternalException {
    }

    public void disconnectFromGateway(String providerVpnId, String fromGatewayId) throws CloudException, InternalException {
    }

    @Nonnull
    public VPNCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new AzureVPNCapabilities(this.provider);
        }
        return this.capabilities;
    }

    public VPNGateway getGateway(String gatewayId) throws CloudException, InternalException {
        ArrayList list = (ArrayList)this.listGateways();
        if (list != null) {
            for (VPNGateway gateway : list) {
                if (!gateway.getProviderVpnGatewayId().equals(gatewayId)) continue;
                return gateway;
            }
        }
        return null;
    }

    public VPN getVPN(String providerVpnId) throws CloudException, InternalException {
        ArrayList list = (ArrayList)this.listVPNs();
        if (list != null) {
            for (VPN vpn : list) {
                if (!vpn.getProviderVpnId().equals(providerVpnId)) continue;
                return vpn;
            }
        }
        return null;
    }

    public Requirement getVPNDataCenterConstraint() throws CloudException, InternalException {
        return null;
    }

    public Iterable<VPNConnection> listGatewayConnections(String toGatewayId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Iterable<ResourceStatus> listGatewayStatus() throws CloudException, InternalException {
        return null;
    }

    public Iterable<VPNGateway> listGateways() throws CloudException, InternalException {
        ArrayList<VPNGateway> gateways = new ArrayList<VPNGateway>();
        ArrayList list = (ArrayList)this.listVPNs();
        if (list != null) {
            for (VPN vpn : list) {
                ArrayList items = (ArrayList)this.listGateways(vpn.getProviderVpnId());
                if (items == null) continue;
                gateways.addAll(items);
            }
        }
        return gateways;
    }

    private Iterable<VPNGateway> listGateways(String vpnId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        String resourceDir = "/services/networking/" + vpnId + "/gateway";
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), resourceDir);
        NodeList entries = doc.getElementsByTagName("Gateway");
        ArrayList<VPNGateway> list = new ArrayList<VPNGateway>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            VPNGateway gateway = this.toVPNGateway(ctx, entry, vpnId);
            if (gateway == null) continue;
            list.add(gateway);
        }
        return list;
    }

    public Iterable<VPNGateway> listGatewaysWithBgpAsn(String bgpAsn) throws CloudException, InternalException {
        return null;
    }

    public Iterable<VPNConnection> listVPNConnections(String toVpnId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVPNStatus() throws CloudException, InternalException {
        return null;
    }

    public Iterable<VPN> listVPNs() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/virtualnetwork");
        NodeList entries = doc.getElementsByTagName("VirtualNetworkSite");
        ArrayList<VPN> list = new ArrayList<VPN>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            VPN vpn = this.toVPN(ctx, entry);
            if (vpn == null) continue;
            list.add(vpn);
        }
        return list;
    }

    public Iterable<VPNProtocol> listSupportedVPNProtocols() throws CloudException, InternalException {
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    @Nullable
    private VPN toVPN(@Nonnull ProviderContext ctx, @Nullable Node entry) throws CloudException, InternalException {
        if (entry == null) {
            return null;
        }
        VPN vpn = new VPN();
        vpn.setCurrentState(VPNState.AVAILABLE);
        HashMap<String, String> tags = new HashMap<String, String>();
        NodeList attributes = entry.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                vpn.setProviderVpnId(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("label") && attribute.hasChildNodes()) {
                vpn.setDescription(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("Id") && attribute.hasChildNodes()) continue;
            if (nodeName.equalsIgnoreCase("State") && attribute.hasChildNodes()) {
                String status = attribute.getFirstChild().getNodeValue().trim();
                if (!"Created".equalsIgnoreCase(status)) continue;
                vpn.setCurrentState(VPNState.AVAILABLE);
                continue;
            }
            if (nodeName.equalsIgnoreCase("AffinityGroup") && attribute.hasChildNodes()) {
                tags.put("AffinityGroup", attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!nodeName.equalsIgnoreCase("AddressSpace") || !attribute.hasChildNodes()) continue;
            NodeList addressSpaces = attribute.getChildNodes();
            for (int k = 0; k < addressSpaces.getLength(); ++k) {
                Node addressSpace = addressSpaces.item(k);
                if (!addressSpace.getNodeName().equalsIgnoreCase("AddressPrefixes") || !addressSpace.hasChildNodes()) continue;
                NodeList addressPrefixes = addressSpace.getChildNodes();
                ArrayList<String> vlanIds = new ArrayList<String>();
                for (int l = 0; l < addressPrefixes.getLength(); ++l) {
                    Node addressPrefix = addressPrefixes.item(l);
                    if (!addressPrefix.getNodeName().equalsIgnoreCase("AddressPrefix") || !addressPrefix.hasChildNodes()) continue;
                    vlanIds.add(addressPrefix.getFirstChild().getNodeValue().trim());
                }
                vpn.setProviderVlanIds(vlanIds.toArray(new String[vlanIds.size()]));
            }
        }
        if (vpn.getProviderVpnId() == null) {
            return null;
        }
        if (vpn.getName() == null) {
            vpn.setName(vpn.getProviderVpnId());
        }
        if (vpn.getDescription() == null) {
            vpn.setDescription(vpn.getName());
        }
        vpn.setTags(tags);
        return vpn;
    }

    @Nullable
    private VPNGateway toVPNGateway(@Nonnull ProviderContext ctx, @Nullable Node entry, String vpnId) throws CloudException, InternalException {
        if (entry == null) {
            return null;
        }
        VPNGateway gateway = new VPNGateway();
        gateway.setCurrentState(VPNGatewayState.PENDING);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(VPN_ID_KEY, vpnId);
        NodeList attributes = entry.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("State") && attribute.hasChildNodes()) {
                String status = attribute.getFirstChild().getNodeValue().trim();
                if ("Provisioning".equalsIgnoreCase(status) || "Provisioned".equalsIgnoreCase(status)) {
                    gateway.setCurrentState(VPNGatewayState.AVAILABLE);
                    continue;
                }
                if ("Deprovisioning".equalsIgnoreCase(status)) {
                    gateway.setCurrentState(VPNGatewayState.DELETING);
                    continue;
                }
                if (!"NotProvisioned".equalsIgnoreCase(status)) continue;
                gateway.setCurrentState(VPNGatewayState.DELETED);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("VIPAddress") || !attribute.hasChildNodes()) continue;
            gateway.setEndpoint(attribute.getFirstChild().getNodeValue().trim());
        }
        if (vpnId == null || gateway.getEndpoint() == null) {
            return null;
        }
        gateway.setProviderVpnGatewayId(vpnId + OBJECT_NAME_SPLIT + gateway.getEndpoint());
        if (gateway.getName() == null) {
            gateway.setName(gateway.getEndpoint());
        }
        if (gateway.getDescription() == null) {
            gateway.setDescription(gateway.getName());
        }
        gateway.setTags(tags);
        return gateway;
    }
}

