/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.network;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureMethod;
import org.dasein.cloud.azure.network.VlanCapabilities;
import org.dasein.cloud.compute.AffinityGroup;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.SubnetCreateOptions;
import org.dasein.cloud.network.SubnetState;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AzureVlanSupport
extends AbstractVLANSupport {
    private static final Logger logger = Azure.getLogger(AzureVlanSupport.class);
    private static final String NETWORKING_SERVICES = "/services/networking";
    private Azure provider;
    private volatile transient VlanCapabilities capabilities;

    public AzureVlanSupport(Azure provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public String[] mapServiceAction(ServiceAction action) {
        return new String[0];
    }

    public void assignRoutingTableToSubnet(String subnetId, String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public void assignRoutingTableToVlan(String vlanId, String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public void attachNetworkInterface(String nicId, String vmId, int index) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Network interfaces not supported");
    }

    public String createInternetGateway(String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways not supported");
    }

    public String createRoutingTable(String forVlanId, String name, String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public NetworkInterface createNetworkInterface(NICCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Network interfaces not supported");
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public Subnet createSubnet(@Nonnull SubnetCreateOptions subnetCreateOptions) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public VLAN createVlan(String cidr, String name, String description, String domainName, String[] dnsServers, String[] ntpServers) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void detachNetworkInterface(String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Network interfaces not supported");
    }

    public VLANCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new VlanCapabilities(this.provider);
        }
        return this.capabilities;
    }

    public String getProviderTermForNetworkInterface(Locale locale) {
        return "network interface";
    }

    public String getProviderTermForSubnet(Locale locale) {
        return "Subnet";
    }

    public String getProviderTermForVlan(Locale locale) {
        return "Address Space";
    }

    public NetworkInterface getNetworkInterface(String nicId) throws CloudException, InternalException {
        return null;
    }

    private Document getNetworkConfig() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/media");
        return doc;
    }

    public RoutingTable getRoutingTableForSubnet(String subnetId) throws CloudException, InternalException {
        return null;
    }

    public RoutingTable getRoutingTableForVlan(String vlanId) throws CloudException, InternalException {
        return null;
    }

    public Subnet getSubnet(String subnetId) throws CloudException, InternalException {
        logger.debug((Object)"Enter getSubnet");
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/virtualnetwork");
        NodeList entries = doc.getElementsByTagName("VirtualNetworkSite");
        for (int i = 0; i < entries.getLength(); ++i) {
            logger.debug((Object)"Searching vlans");
            Node entry = entries.item(i);
            NodeList attributes = entry.getChildNodes();
            String vlanId = "";
            String vlanName = "";
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                if (attribute.getNodeType() == 3) continue;
                String nodeName = attribute.getNodeName();
                if (nodeName.equalsIgnoreCase("id") && attribute.hasChildNodes()) {
                    vlanId = attribute.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                    vlanName = attribute.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!nodeName.equalsIgnoreCase("subnets") || !attribute.hasChildNodes()) continue;
                NodeList sNets = attribute.getChildNodes();
                for (int k = 0; k < sNets.getLength(); ++k) {
                    Node sAttrib = sNets.item(k);
                    Subnet subnet = this.toSubnet(ctx, sAttrib, vlanId);
                    if (subnet == null || !subnet.getProviderSubnetId().equalsIgnoreCase(subnetId)) continue;
                    subnet.setTag("vlanName", vlanName);
                    return subnet;
                }
            }
        }
        return null;
    }

    public VLAN getVlan(String vlanId) throws CloudException, InternalException {
        ArrayList list = (ArrayList)this.listVlans();
        if (list != null) {
            for (VLAN vlan : list) {
                if (!vlan.getProviderVlanId().equals(vlanId) && !vlan.getName().equalsIgnoreCase(vlanId)) continue;
                return vlan;
            }
        }
        return null;
    }

    public boolean isConnectedViaInternetGateway(@Nonnull String s) throws CloudException, InternalException {
        return false;
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    public Collection<String> listFirewallIdsForNIC(String nicId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Iterable<ResourceStatus> listNetworkInterfaceStatus() throws CloudException, InternalException {
        return null;
    }

    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<NetworkInterface> listNetworkInterfacesForVM(String forVmId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(String subnetId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<RoutingTable> listRoutingTables(String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public Iterable<Subnet> listSubnets(String inVlanId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/virtualnetwork");
        NodeList entries = doc.getElementsByTagName("VirtualNetworkSite");
        ArrayList<Subnet> list = new ArrayList<Subnet>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            NodeList attributes = entry.getChildNodes();
            boolean found = false;
            for (int j = 0; j < attributes.getLength(); ++j) {
                String vlanId;
                Node attribute = attributes.item(j);
                if (attribute.getNodeType() == 3) continue;
                String nodeName = attribute.getNodeName();
                if (nodeName.equalsIgnoreCase("id") && attribute.hasChildNodes() && (vlanId = attribute.getFirstChild().getNodeValue().trim()).equalsIgnoreCase(inVlanId)) {
                    found = true;
                    continue;
                }
                if (!found || !nodeName.equalsIgnoreCase("subnets") || !attribute.hasChildNodes()) continue;
                NodeList sNets = attribute.getChildNodes();
                for (int k = 0; k < sNets.getLength(); ++k) {
                    Node sAttrib = sNets.item(k);
                    Subnet subnet = this.toSubnet(ctx, sAttrib, inVlanId);
                    if (subnet == null) continue;
                    list.add(subnet);
                }
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/virtualnetwork");
        NodeList entries = doc.getElementsByTagName("VirtualNetworkSite");
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            ResourceStatus status = this.toVLANStatus(ctx, entry);
            if (status == null) continue;
            list.add(status);
        }
        return list;
    }

    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new AzureConfigException("No context was specified for this request");
        }
        AzureMethod method = new AzureMethod(this.provider);
        Document doc = method.getAsXML(ctx.getAccountNumber(), "/services/networking/virtualnetwork");
        NodeList entries = doc.getElementsByTagName("VirtualNetworkSite");
        ArrayList<VLAN> list = new ArrayList<VLAN>();
        for (int i = 0; i < entries.getLength(); ++i) {
            Node entry = entries.item(i);
            ArrayList vlans = (ArrayList)this.toVLAN(ctx, entry);
            if (vlans == null) continue;
            list.addAll(vlans);
        }
        return list;
    }

    public void removeInternetGateway(String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways not supported");
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
    }

    public void removeNetworkInterface(String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Network interfaces not supported");
    }

    public void removeRoute(String inRoutingTableId, String destinationCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    public void removeRoutingTable(String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubnet(String providerSubnetId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVlanSupport.class.getName() + ".removeSubnet()"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            Subnet subnet = this.getSubnet(providerSubnetId);
            String vlanId = subnet.getProviderVlanId();
            VLAN vlan = this.getVlan(vlanId);
            String vlanName = vlan.getName();
            AzureMethod method = new AzureMethod(this.provider);
            StringBuilder xml = new StringBuilder();
            Document doc = this.getNetworkConfig();
            NodeList entries = doc.getElementsByTagName("VirtualNetworkConfiguration");
            Element element = (Element)entries.item(0);
            NodeList virtualNetworkSites = element.getElementsByTagName("VirtualNetworkSites");
            Element elItem = (Element)virtualNetworkSites.item(0);
            NodeList vns = elItem.getElementsByTagName("VirtualNetworkSite");
            for (int i = 0; i < vns.getLength(); ++i) {
                Element elVN;
                String siteName;
                Node vn = vns.item(i);
                String vnName = vn.getNodeName();
                if (!vnName.equalsIgnoreCase("VirtualNetworkSite") || !vn.hasChildNodes() || !(siteName = (elVN = (Element)vn).getAttribute("name")).equalsIgnoreCase(vlanName)) continue;
                NodeList subnetsNodes = elVN.getElementsByTagName("Subnets");
                Element subnetsEl = (Element)subnetsNodes.item(0);
                NodeList subnetNodes = subnetsEl.getElementsByTagName("Subnet");
                for (int j = 0; j < subnetNodes.getLength(); ++j) {
                    Element sub;
                    String subName;
                    Node subnetNode = subnetNodes.item(j);
                    String subnetName = subnetNode.getNodeName();
                    if (!subnetName.equalsIgnoreCase("Subnet") || !vn.hasChildNodes() || !(subName = (sub = (Element)subnetNode).getAttribute("name")).equalsIgnoreCase(subnet.getName())) continue;
                    subnetsEl.removeChild(subnetNode);
                }
            }
            String output = "";
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                output = writer.getBuffer().toString().replaceAll("\n|\r", "");
            }
            catch (Exception e) {
                System.err.println(e);
            }
            xml.append(output);
            if (logger.isDebugEnabled()) {
                try {
                    method.parseResponse(xml.toString(), false);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to parse outgoing XML locally: " + e.getMessage()));
                    logger.warn((Object)"XML:");
                    logger.warn((Object)xml.toString());
                }
            }
            String resourceDir = "/services/networking/media";
            method.invoke("PUT", ctx.getAccountNumber(), resourceDir, xml.toString());
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVlanSupport.class.getName() + ".removeSubnet()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String vlanId) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER: " + AzureVlanSupport.class.getName() + ".removeVlan()"));
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was specified for this request");
            }
            VLAN vlan = this.getVlan(vlanId);
            String vlanName = vlan.getName();
            AzureMethod method = new AzureMethod(this.provider);
            StringBuilder xml = new StringBuilder();
            Document doc = this.getNetworkConfig();
            NodeList entries = doc.getElementsByTagName("VirtualNetworkConfiguration");
            Element element = (Element)entries.item(0);
            NodeList virtualNetworkSites = element.getElementsByTagName("VirtualNetworkSites");
            Element elItem = (Element)virtualNetworkSites.item(0);
            NodeList vns = elItem.getElementsByTagName("VirtualNetworkSite");
            for (int i = 0; i < vns.getLength(); ++i) {
                Element elVN;
                String siteName;
                Node vn = vns.item(i);
                String vnName = vn.getNodeName();
                if (!vnName.equalsIgnoreCase("VirtualNetworkSite") || !vn.hasChildNodes() || !(siteName = (elVN = (Element)vn).getAttribute("name")).equalsIgnoreCase(vlanName)) continue;
                elItem.removeChild(vn);
            }
            String output = "";
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(doc), new StreamResult(writer));
                output = writer.getBuffer().toString().replaceAll("\n|\r", "");
            }
            catch (Exception e) {
                System.err.println(e);
            }
            xml.append(output);
            if (logger.isDebugEnabled()) {
                try {
                    method.parseResponse(xml.toString(), false);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to parse outgoing XML locally: " + e.getMessage()));
                    logger.warn((Object)"XML:");
                    logger.warn((Object)xml.toString());
                }
            }
            String resourceDir = "/services/networking/media";
            method.invoke("PUT", ctx.getAccountNumber(), resourceDir, xml.toString());
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT: " + AzureVlanSupport.class.getName() + ".removeVlan()"));
            }
        }
    }

    public void removeVLANTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void removeVLANTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateVLANTags(@Nonnull String s, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateVLANTags(@Nonnull String[] strings, Tag ... tags) throws CloudException, InternalException {
    }

    public void updateInternetGatewayTags(@Nonnull String internetGatewayId, Tag ... tags) throws CloudException, InternalException {
    }

    @Nullable
    private Iterable<VLAN> toVLAN(@Nonnull ProviderContext ctx, @Nullable Node entry) throws CloudException, InternalException {
        if (entry == null) {
            return null;
        }
        ArrayList<VLAN> list = new ArrayList<VLAN>();
        VLAN vlan = new VLAN();
        vlan.setProviderOwnerId(ctx.getAccountNumber());
        vlan.setProviderRegionId(ctx.getRegionId());
        vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        HashMap<String, String> tags = new HashMap<String, String>();
        NodeList attributes = entry.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            DataCenter dc;
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                vlan.setName(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("label") && attribute.hasChildNodes()) {
                vlan.setDescription(attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("id") && attribute.hasChildNodes()) {
                String id = attribute.getFirstChild().getNodeValue().trim();
                tags.put("VPNID", id);
                vlan.setProviderVlanId(id);
                continue;
            }
            if (nodeName.equalsIgnoreCase("affinitygroup") && attribute.hasChildNodes()) {
                String affinityGroup = attribute.getFirstChild().getNodeValue().trim();
                if (affinityGroup != null && !affinityGroup.equals("")) {
                    AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
                    if (affinityGroupModel == null) {
                        return null;
                    }
                    dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
                    if (dc != null && dc.getRegionId().equals(ctx.getRegionId())) {
                        vlan.setProviderDataCenterId(dc.getProviderDataCenterId());
                    } else {
                        return null;
                    }
                }
                tags.put("AffinityGroup", attribute.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (nodeName.equalsIgnoreCase("location") && attribute.hasChildNodes()) {
                String location = attribute.getFirstChild().getNodeValue().trim();
                if (location == null || location.equals("")) continue;
                Region region = this.provider.getDataCenterServices().getRegion(location);
                if (region != null && !region.getProviderRegionId().equals(ctx.getRegionId())) {
                    return null;
                }
                dc = this.provider.getDataCenterServices().getDataCenter(region.getProviderRegionId());
                if (dc != null && dc.getRegionId().equals(ctx.getRegionId())) {
                    vlan.setProviderDataCenterId(dc.getProviderDataCenterId());
                    continue;
                }
                return null;
            }
            if (nodeName.equalsIgnoreCase("state") && attribute.hasChildNodes()) {
                VLANState state;
                String value = attribute.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("created") || value.equalsIgnoreCase("updating")) {
                    state = VLANState.AVAILABLE;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VLANState.PENDING;
                } else {
                    logger.warn((Object)("Unknown VLAN state: " + value));
                    state = null;
                }
                vlan.setCurrentState(state);
                continue;
            }
            if (!nodeName.equalsIgnoreCase("AddressSpace") || !attribute.hasChildNodes()) continue;
            NodeList addressSpaces = attribute.getChildNodes();
            for (int k = 0; k < addressSpaces.getLength(); ++k) {
                Node addressSpace = addressSpaces.item(k);
                if (!addressSpace.getNodeName().equalsIgnoreCase("AddressPrefixes") || !addressSpace.hasChildNodes()) continue;
                NodeList addressPrefixes = addressSpace.getChildNodes();
                for (int l = 0; l < addressPrefixes.getLength(); ++l) {
                    Node addressPrefix = addressPrefixes.item(l);
                    if (!addressPrefix.getNodeName().equalsIgnoreCase("AddressPrefix") || !addressPrefix.hasChildNodes()) continue;
                    vlan.setCidr(addressPrefix.getFirstChild().getNodeValue().trim());
                    if (vlan.getName() == null) {
                        vlan.setName(vlan.getProviderVlanId());
                    }
                    if (vlan.getDescription() == null) {
                        vlan.setDescription(vlan.getName());
                    }
                    vlan.setTags(tags);
                    list.add(vlan);
                }
            }
        }
        return list;
    }

    @Nullable
    private ResourceStatus toVLANStatus(@Nonnull ProviderContext ctx, @Nullable Node entry) throws CloudException, InternalException {
        if (entry == null) {
            return null;
        }
        String id = null;
        String value = null;
        VLANState state = null;
        NodeList attributes = entry.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String affinityGroup;
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("id") && attribute.hasChildNodes()) {
                id = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (nodeName.equalsIgnoreCase("state") && attribute.hasChildNodes()) {
                value = attribute.getFirstChild().getNodeValue().trim();
                if (value.equalsIgnoreCase("created") || value.equalsIgnoreCase("updating")) {
                    state = VLANState.AVAILABLE;
                    continue;
                }
                if (value.equalsIgnoreCase("creating")) {
                    state = VLANState.PENDING;
                    continue;
                }
                logger.warn((Object)("Unknown VLAN state: " + value));
                state = null;
                continue;
            }
            if (!nodeName.equalsIgnoreCase("affinitygroup") || !attribute.hasChildNodes() || (affinityGroup = attribute.getFirstChild().getNodeValue().trim()) == null || affinityGroup.equals("")) continue;
            AffinityGroup affinityGroupModel = this.provider.getComputeServices().getAffinityGroupSupport().get(affinityGroup);
            if (affinityGroupModel == null) {
                return null;
            }
            DataCenter dc = this.provider.getDataCenterServices().getDataCenter(affinityGroupModel.getDataCenterId());
            if (dc != null && dc.getRegionId().equals(ctx.getRegionId())) continue;
            return null;
        }
        ResourceStatus status = new ResourceStatus(id, state);
        return status;
    }

    @Nullable
    private Subnet toSubnet(@Nonnull ProviderContext ctx, @Nullable Node entry, @Nonnull String vlanId) throws CloudException, InternalException {
        if (entry == null) {
            return null;
        }
        NodeList attributes = entry.getChildNodes();
        String name = null;
        String cidr = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                name = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("AddressPrefix") || !attribute.hasChildNodes()) continue;
            cidr = attribute.getFirstChild().getNodeValue().trim();
        }
        Subnet subnet = Subnet.getInstance((String)ctx.getAccountNumber(), (String)ctx.getRegionId(), (String)vlanId, (String)(name + "_" + vlanId), (SubnetState)SubnetState.AVAILABLE, name, name, cidr);
        DataCenter dc = this.provider.getDataCenterServices().listDataCenters(ctx.getRegionId()).iterator().next();
        subnet.constrainedToDataCenter(dc.getProviderDataCenterId());
        return subnet;
    }
}

