/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.azure.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.azure.Azure;
import org.dasein.cloud.azure.AzureConfigException;
import org.dasein.cloud.azure.AzureStorageMethod;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.storage.AbstractBlobStoreSupport;
import org.dasein.cloud.storage.Blob;
import org.dasein.cloud.storage.FileTransfer;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.dasein.util.uom.storage.Byte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlobStore
extends AbstractBlobStoreSupport<Azure> {
    private static final Logger logger = Azure.getLogger(BlobStore.class);
    public static final int MAX_BUCKETS = 100;
    public static final int MAX_OBJECTS = -1;
    public static final Storage<Byte> MAX_OBJECT_SIZE = new Storage((Number)5000000000L, (StorageUnit)Storage.BYTE);
    private Azure provider = null;

    public BlobStore(Azure provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    public boolean allowsNestedBuckets() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsRootObjects() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsPublicSharing() throws CloudException, InternalException {
        return false;
    }

    private void commitBlocks(@Nonnull String bucket, @Nonnull String object, @Nonnull Collection<String> blockIds) throws InternalException, CloudException {
        String resource = bucket + "/" + object;
        TreeMap<String, String> headers = new TreeMap<String, String>();
        TreeMap<String, String> queries = new TreeMap<String, String>();
        queries.put("comp", "blocklist");
        Document doc = AzureStorageMethod.createDoc();
        Element blockList = doc.createElement("BlockList");
        for (String id : blockIds) {
            Element uncommitted = doc.createElement("Uncommitted");
            uncommitted.setTextContent(id);
            blockList.appendChild(uncommitted);
        }
        doc.appendChild(blockList);
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        method.invoke("PUT", resource, queries, AzureStorageMethod.convertDomToString(doc), headers, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(@Nullable String sourceBucket, @Nonnull String sourceObject, @Nullable String targetBucket, @Nonnull String targetObject) throws InternalException, CloudException {
        logger.debug((Object)("ENTER - " + BlobStore.class.getName() + ".copyFile(" + sourceBucket + "," + sourceObject + "," + targetBucket + "," + targetObject + ")"));
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new AzureConfigException("No region ID was specified for this request");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            String storageService = this.provider.getStorageService();
            if (storageService == null || storageService.isEmpty()) {
                throw new CloudException("Unable to find storage service in the current region: " + ctx.getRegionId());
            }
            headers.put("x-ms-copy-source", "/" + storageService + "/" + sourceBucket + "/" + sourceObject);
            TreeMap<String, String> queryParams = new TreeMap<String, String>();
            AzureStorageMethod method = new AzureStorageMethod(this.provider);
            method.invoke("PUT", targetBucket + "/" + targetObject, queryParams, null, headers, true);
            long timeout = System.currentTimeMillis() + 1800000L;
            while (timeout > System.currentTimeMillis()) {
                try {
                    Blob blob = this.getObject(targetBucket, targetObject);
                    if (blob != null) {
                        return;
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ignore) {}
            }
        }
        finally {
            logger.debug((Object)("EXIT - " + BlobStore.class.getName() + ".copyFile()"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Blob createBucket(@Nonnull String bucketName, boolean findFreeName) throws InternalException, CloudException {
        logger.debug((Object)("ENTER - " + BlobStore.class.getName() + ".createBucket(" + bucketName + "," + findFreeName));
        if (bucketName.contains("/")) {
            throw new OperationNotSupportedException("Nested buckets not supported");
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new AzureConfigException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new AzureConfigException("No region ID was specified for this request");
            }
            TreeMap<String, String> queries = new TreeMap<String, String>();
            AzureStorageMethod method = new AzureStorageMethod(this.provider);
            queries.put("restype", "container");
            if (findFreeName) {
                String name = bucketName;
                int idx = 1;
                while (this.exists(name)) {
                    name = bucketName + "-" + idx++;
                }
                bucketName = name;
            }
            method.invoke("PUT", bucketName, queries, null, null, true);
            Blob bucket = this.getBucket(bucketName);
            if (bucket == null) {
                logger.error((Object)("Unable to find newly created bucket: " + bucket));
                throw new CloudException("Unable to find newly created bucket: " + bucket);
            }
            Blob blob = bucket;
            return blob;
        }
        finally {
            logger.debug((Object)"exit - createRootContainer(String)");
        }
    }

    public boolean exists(@Nonnull String bucketName) throws InternalException, CloudException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        queries.put("comp", "list");
        Document doc = method.getAsDoc("GET", "", queries, null, null, true);
        NodeList matches = doc.getElementsByTagName("Container");
        if (matches != null) {
            for (int i = 0; i < matches.getLength(); ++i) {
                Node bucket = matches.item(i);
                if (!bucket.hasChildNodes()) continue;
                NodeList attributes = bucket.getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attr = attributes.item(j);
                    if (!attr.getNodeName().equalsIgnoreCase("name") || !attr.hasChildNodes() || !attr.getFirstChild().getNodeValue().trim().equals(bucketName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nonnull
    private Collection<String> getBlocks(@Nonnull String bucket, @Nonnull String object, @Nonnull String blocklistType, @Nonnull String blockTypeTag) throws InternalException, CloudException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        ArrayList<String> idList = new ArrayList<String>();
        String resource = bucket + "/" + object;
        queries.put("comp", "blocklist");
        queries.put("blocklisttype", blocklistType);
        try {
            AzureStorageMethod method = new AzureStorageMethod(this.provider);
            Document doc = method.getAsDoc("GET", resource, queries, null, null, true);
            NodeList matches = doc.getElementsByTagName(blockTypeTag);
            if (matches != null) {
                Node block = matches.item(0);
                NodeList blockAttributes = block.getChildNodes();
                for (int i = 0; i < blockAttributes.getLength(); ++i) {
                    Node node = blockAttributes.item(i);
                    if (node.getNodeType() == 3 || !node.getNodeName().equals("Block")) continue;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attribute = attributes.item(j);
                        if (!attribute.getNodeName().equalsIgnoreCase("Name")) continue;
                        idList.add(attribute.getFirstChild().getNodeValue());
                    }
                }
            }
        }
        catch (AzureConfigException e) {
            e.printStackTrace();
        }
        catch (InternalException e) {
            e.printStackTrace();
        }
        return idList;
    }

    public Blob getBucket(@Nonnull String bucketName) throws InternalException, CloudException {
        for (Blob blob : this.list(null)) {
            String name;
            if (!blob.isContainer() || (name = blob.getBucketName()) == null || !name.equals(bucketName)) continue;
            return blob;
        }
        return null;
    }

    public Blob getObject(@Nullable String bucketName, @Nonnull String objectName) throws InternalException, CloudException {
        if (bucketName == null) {
            return null;
        }
        for (Blob blob : this.list(bucketName)) {
            String name = blob.getObjectName();
            if (name == null || !name.equals(objectName)) continue;
            return blob;
        }
        return null;
    }

    @Nullable
    public String getSignedObjectUrl(@Nonnull String bucket, @Nonnull String object, @Nonnull String expiresEpochInSeconds) throws InternalException, CloudException {
        return null;
    }

    @Nullable
    public Storage<Byte> getObjectSize(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        String blobProperty;
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        String resource = bucket + "/" + object;
        String result = method.getBlobProperty("GET", resource, new HashMap<String, String>(), null, null, true, blobProperty = "Content-Length");
        if (result != null) {
            return new Storage((Number)Long.valueOf(result), (StorageUnit)Storage.BYTE);
        }
        return null;
    }

    public int getMaxBuckets() throws CloudException, InternalException {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void get(@Nullable String bucket, @Nonnull String object, @Nonnull File toFile, @Nullable FileTransfer transfer) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + BlobStore.class.getName() + ".get(" + bucket + "," + object + "," + toFile + "," + transfer + ")"));
        }
        try {
            if (bucket == null) {
                throw new CloudException("No bucket was specified");
            }
            StringBuilder resource = new StringBuilder();
            resource.append(bucket);
            resource.append("/");
            resource.append(object);
            AzureStorageMethod method = new AzureStorageMethod(this.provider);
            InputStream input = method.getAsStream("GET", resource.toString(), new HashMap<String, String>(), null, null, true);
            if (input == null) {
                throw new CloudException("No such file: " + bucket + "/" + object);
            }
            try {
                this.copy(input, new FileOutputStream(toFile), transfer);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("Could not find target file to fetch to " + toFile + ": " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Could not fetch file to " + toFile + ": " + e.getMessage()));
                throw new CloudException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + BlobStore.class.getName() + ".get()"));
            }
        }
    }

    public Storage<Byte> getMaxObjectSize() {
        return MAX_OBJECT_SIZE;
    }

    public int getMaxObjectsPerBucket() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public String getProviderTermForBucket(@Nonnull Locale locale) {
        return "bucket";
    }

    @Nonnull
    public String getProviderTermForObject(@Nonnull Locale locale) {
        return "object";
    }

    public boolean isPublic(@Nullable String bucket, @Nullable String object) throws CloudException, InternalException {
        String resource;
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        TreeMap<String, String> queries = new TreeMap<String, String>();
        if (object != null) {
            if (bucket == null) {
                return false;
            }
            resource = bucket + "/" + object;
        } else {
            if (bucket == null) {
                return false;
            }
            queries.put("restype", "container");
            resource = bucket;
        }
        InputStream input = method.getAsStream("GET", resource, queries, null, null, false);
        return input != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + BlobStore.class.getName() + ".isSubscribed()"));
        }
        try {
            boolean bl = this.provider.getStorageService() != null;
            return bl;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + BlobStore.class.getName() + ".isSubscribed()"));
            }
        }
    }

    @Nonnull
    public Collection<Blob> list(final @Nullable String bucket) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        final String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region ID was specified");
        }
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<Blob>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
                try {
                    BlobStore.this.list(regionId, bucket, (Jiterator<Blob>)iterator);
                }
                finally {
                    BlobStore.this.provider.release();
                }
            }
        });
        populator.populate();
        return populator.getResult();
    }

    private void list(@Nonnull String regionId, @Nullable String bucket, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        if (bucket == null) {
            this.loadBuckets(regionId, iterator);
        } else {
            this.loadObjects(regionId, bucket, iterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBuckets(@Nonnull String regionId, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + BlobStore.class.getName() + ".listBuckets()"));
        }
        try {
            TreeMap<String, String> queries = new TreeMap<String, String>();
            AzureStorageMethod method = new AzureStorageMethod(this.provider);
            queries.put("comp", "list");
            Document doc = method.getAsDoc("GET", "", queries, null, null, true);
            NodeList matches = doc.getElementsByTagName("Container");
            if (matches != null) {
                for (int i = 0; i < matches.getLength(); ++i) {
                    Blob bucket = this.toBlob(regionId, matches.item(i), "/", true);
                    if (bucket == null) continue;
                    iterator.push((Object)bucket);
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + BlobStore.class.getName() + ".listBuckets()"));
            }
        }
    }

    private void loadObjects(@Nonnull String regionId, @Nonnull String bucket, @Nonnull Jiterator<Blob> iterator) throws CloudException, InternalException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        queries.put("restype", "container");
        queries.put("comp", "list");
        Document doc = method.getAsDoc("GET", bucket, queries, null, null, true);
        if (doc == null) {
            return;
        }
        NodeList matches = doc.getElementsByTagName("Blob");
        if (matches != null) {
            for (int i = 0; i < matches.getLength(); ++i) {
                Blob file = this.toBlob(regionId, matches.item(i), bucket, false);
                if (file == null) continue;
                iterator.push((Object)file);
            }
        }
    }

    public void makePublic(@Nonnull String bucket) throws InternalException, CloudException {
        this.makePublic(bucket, null);
    }

    public void makePublic(@Nullable String bucket, @Nullable String object) throws InternalException, CloudException {
        if (bucket == null && object == null) {
            throw new CloudException("No such object: null/null");
        }
        TreeMap<String, String> queries = new TreeMap<String, String>();
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String resource = object == null ? bucket : bucket + "/" + object;
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        queries.put("restype", "container");
        queries.put("comp", "acl");
        headers.put("x-ms-blob-public-access", "container");
        method.invoke("PUT", resource, queries, null, headers, true);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void move(@Nullable String sourceBucket, @Nullable String object, @Nullable String targetBucket) throws InternalException, CloudException {
        if (sourceBucket == null) {
            throw new CloudException("No source bucket was specified");
        }
        if (targetBucket == null) {
            throw new CloudException("No target bucket was specified");
        }
        if (object == null) {
            throw new CloudException("No source object was specified");
        }
        this.copy(sourceBucket, object, targetBucket, object);
        this.removeObject(sourceBucket, object);
    }

    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull File file) throws CloudException, InternalException {
        if (bucket == null) {
            throw new CloudException("No bucket was specified");
        }
        try {
            FileInputStream input;
            try {
                input = new FileInputStream(file);
            }
            catch (IOException e) {
                logger.error((Object)("Error reading input file " + file + ": " + e.getMessage()));
                throw new InternalException((Throwable)e);
            }
            int fileSize = ((InputStream)input).available();
            if (fileSize > 0x3F00000) {
                this.putBlocks(bucket, object, input);
            } else {
                TreeMap<String, String> queries = new TreeMap<String, String>();
                TreeMap<String, String> headers = new TreeMap<String, String>();
                AzureStorageMethod method = new AzureStorageMethod(this.provider);
                String resource = bucket + "/" + object;
                queries.put("timeout", "600");
                headers.put("x-ms-blob-type", "BlockBlob");
                headers.put("content-type", "application/octet-stream");
                method.putWithFile("PUT", resource, queries, file, headers, true);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Error uploading file " + file + ": " + e.getMessage()));
            throw new CloudException((Throwable)e);
        }
    }

    protected void put(@Nullable String bucket, @Nonnull String object, @Nonnull String content) throws CloudException, InternalException {
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("x-ms-blob-type", "BlockBlob");
        headers.put("content-type", "application/octet-stream");
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        method.invoke("PUT", bucket + "/" + object, new HashMap<String, String>(), content, headers, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putBlocks(@Nonnull String bucket, @Nonnull String object, @Nonnull InputStream input) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + BlobStore.class.getName() + ".putBlocks(" + bucket + "," + object + ",<<INPUT STREAM>>)"));
        }
        try {
            int basicId = 1000;
            int blockSize = 0x400000;
            byte[] bytes = new byte[blockSize];
            try {
                try {
                    int read;
                    while ((read = input.read(bytes)) != -1) {
                        String blockId = Base64.encodeBase64String((byte[])String.valueOf(basicId).getBytes());
                        if (read < blockSize) {
                            byte[] subArray = Arrays.copyOfRange(bytes, 0, read);
                            this.putBlocks(bucket, object, subArray, blockId);
                        } else {
                            this.putBlocks(bucket, object, bytes, blockId);
                        }
                        ++basicId;
                    }
                }
                catch (IOException e) {
                    throw new CloudException((Throwable)e);
                }
            }
            finally {
                try {
                    input.close();
                }
                catch (Throwable ignore) {}
                ArrayList blockIds = (ArrayList)this.getBlocks(object, bucket, "all", "UncommittedBlocks");
                this.commitBlocks(object, bucket, blockIds);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + BlobStore.class.getName() + ".putBlocks()"));
            }
        }
    }

    private void putBlocks(@Nonnull String bucket, @Nonnull String object, @Nonnull byte[] content, @Nonnull String blockId) throws InternalException, CloudException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        TreeMap<String, String> headers = new TreeMap<String, String>();
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        String resource = bucket + "/" + object;
        queries.put("blockid", blockId);
        queries.put("comp", "block");
        headers.put("x-ms-blob-type", "BlockBlob");
        headers.put("content-type", "text/plain");
        method.putWithBytes("PUT", resource, queries, content, headers, true);
    }

    public void removeBucket(@Nonnull String bucket) throws CloudException, InternalException {
        TreeMap<String, String> queries = new TreeMap<String, String>();
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        queries.put("restype", "container");
        method.invoke("DELETE", bucket, queries, null, null, true);
    }

    public void removeObject(@Nullable String bucket, @Nonnull String name) throws CloudException, InternalException {
        if (bucket == null) {
            throw new CloudException("No bucket was specified for this request");
        }
        AzureStorageMethod method = new AzureStorageMethod(this.provider);
        String resource = bucket + "/" + name;
        method.invoke("DELETE", resource, new HashMap<String, String>(), null, null, true);
    }

    @Nonnull
    public String renameBucket(@Nonnull String oldName, @Nonnull String newName, boolean findFreeName) throws CloudException, InternalException {
        Blob bucket = this.createBucket(newName, findFreeName);
        block4: for (Blob file : this.list(oldName)) {
            int retries = 10;
            while (true) {
                --retries;
                try {
                    this.move(oldName, file.getObjectName(), bucket.getBucketName());
                    continue block4;
                }
                catch (CloudException e) {
                    if (retries < 1) {
                        throw e;
                    }
                    try {
                        Thread.sleep((long)retries * 10000L);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                break;
            }
        }
        boolean ok = true;
        for (Blob file : this.list(oldName)) {
            if (file == null) continue;
            ok = false;
        }
        if (ok) {
            this.removeBucket(oldName);
        }
        return newName;
    }

    public void renameObject(@Nullable String bucket, @Nonnull String object, @Nonnull String newName) throws CloudException, InternalException {
        if (bucket == null) {
            throw new CloudException("No bucket was specified");
        }
        this.copy(bucket, object, bucket, newName);
        this.removeObject(bucket, object);
    }

    @Nonnull
    public Blob upload(@Nonnull File source, @Nullable String bucket, @Nonnull String fileName) throws CloudException, InternalException {
        if (bucket == null) {
            throw new OperationNotSupportedException("Root objects not supported in cloud");
        }
        if (!this.exists(bucket)) {
            this.createBucket(bucket, false);
        }
        this.put(bucket, fileName, source);
        return this.getObject(bucket, fileName);
    }

    @Nonnull
    public NamingConstraints getBucketNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).constrainedBy(new char[]{'-', '.'}).limitedToLatin1().lowerCaseOnly();
    }

    @Nonnull
    public NamingConstraints getObjectNameRules() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255).constrainedBy(new char[]{'-', '.', ',', '#', '+'}).limitedToLatin1().lowerCaseOnly();
    }

    @Nullable
    private Blob toBlob(@Nonnull String regionId, @Nullable Node node, @Nonnull String bucket, boolean isContainer) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String object = null;
        String location = null;
        long size = -1L;
        long creationDate = 0L;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() == 3) continue;
            String aname = attribute.getNodeName().toLowerCase();
            if (attribute.getChildNodes().getLength() <= 0) continue;
            String value = attribute.getFirstChild().getNodeValue();
            if (aname.equalsIgnoreCase("Name")) {
                object = value;
                continue;
            }
            if (aname.equalsIgnoreCase("Url")) {
                location = value;
                continue;
            }
            if (!aname.equalsIgnoreCase("Properties")) continue;
            NodeList propertyAttributes = attribute.getChildNodes();
            for (int j = 0; j < propertyAttributes.getLength(); ++j) {
                Node property = propertyAttributes.item(j);
                String propertyName = property.getNodeName();
                if (property.getChildNodes().getLength() <= 0) continue;
                String propertyValue = property.getFirstChild().getNodeValue();
                if (propertyName.equalsIgnoreCase("Content-Length")) {
                    size = Long.valueOf(propertyValue);
                    continue;
                }
                if (!propertyName.equalsIgnoreCase("Last-Modified")) continue;
                String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
                SimpleDateFormat rfc1123Format = new SimpleDateFormat(RFC1123_PATTERN);
                rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    creationDate = rfc1123Format.parse(propertyValue).getTime();
                    continue;
                }
                catch (ParseException e) {
                    logger.warn((Object)("Invalid date: " + propertyValue));
                }
            }
        }
        if (isContainer) {
            return Blob.getInstance((String)regionId, location, object, (long)creationDate);
        }
        return Blob.getInstance((String)regionId, location, (String)bucket, object, (long)creationDate, (Storage)new Storage((Number)size, (StorageUnit)Storage.BYTE));
    }
}

