/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudsigma.CloudSigmaDataCenterServices;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.compute.CloudSigmaComputeServices;
import org.dasein.cloud.cloudsigma.network.CloudSigmaNetworkServices;

public class CloudSigma
extends AbstractCloud {
    private static final Logger logger = CloudSigma.getLogger(CloudSigma.class);

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls) {
        String pkg = CloudSigma.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("cloudsigma") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.cloudsigma.std." + pkg + CloudSigma.getLastItem(cls.getName())));
    }

    @Nonnull
    public static Logger getWireLogger(@Nonnull Class<?> cls) {
        return Logger.getLogger((String)("dasein.cloud.cloudsigma.wire." + CloudSigma.getLastItem(cls.getPackage().getName()) + "." + CloudSigma.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getCloudName();
        return name == null ? "CloudSigma2" : name;
    }

    @Nonnull
    public CloudSigmaComputeServices getComputeServices() {
        return new CloudSigmaComputeServices(this);
    }

    @Nonnull
    public CloudSigmaDataCenterServices getDataCenterServices() {
        return new CloudSigmaDataCenterServices(this);
    }

    @Nonnull
    public CloudSigmaNetworkServices getNetworkServices() {
        return new CloudSigmaNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        String name = ctx == null ? null : ctx.getProviderName();
        return name == null ? "CloudSigma2" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + CloudSigma.class.getName() + ".testContext()"));
        }
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                logger.warn((Object)"No context was provided for testing");
                String string = null;
                return string;
            }
            CloudSigmaMethod method = new CloudSigmaMethod(this);
            String body = method.getString("profile/");
            if (body == null) {
                String string = null;
                return string;
            }
            String uuid = CloudSigmaMethod.seekValue(body, "uuid");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("UUID=" + uuid));
            }
            if (uuid == null) {
                logger.warn((Object)"No valid UUID was provided in the response during context testing");
                String string = null;
                return string;
            }
            String string = uuid;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + CloudSigma.class.getName() + ".textContext()"));
            }
        }
    }
}

