/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;

public class CloudSigmaDataCenterServices
implements DataCenterServices {
    private CloudSigma provider;

    CloudSigmaDataCenterServices(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String dataCenterId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            for (DataCenter dc : this.listDataCenters(region.getProviderRegionId())) {
                if (!dataCenterId.equals(dc.getProviderDataCenterId())) continue;
                return dc;
            }
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "data center";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public Region getRegion(@Nonnull String providerRegionId) throws InternalException, CloudException {
        for (Region r : this.listRegions()) {
            if (!providerRegionId.equals(r.getProviderRegionId())) continue;
            return r;
        }
        return null;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String providerRegionId) throws InternalException, CloudException {
        Region r = this.getRegion(providerRegionId);
        if (r == null) {
            return Collections.emptyList();
        }
        DataCenter dc = new DataCenter();
        dc.setActive(r.isActive());
        dc.setAvailable(r.isAvailable());
        if (providerRegionId.equals("eu-ch1")) {
            dc.setActive(true);
            dc.setAvailable(true);
            dc.setName("Zurich");
            dc.setProviderDataCenterId(providerRegionId + "-a");
            dc.setRegionId(providerRegionId);
        } else if (providerRegionId.equals("us-nv1")) {
            dc.setActive(true);
            dc.setAvailable(true);
            dc.setName("Las Vegas");
            dc.setProviderDataCenterId(providerRegionId + "-a");
            dc.setRegionId(providerRegionId);
        }
        return Collections.singletonList(dc);
    }

    public Collection<Region> listRegions() throws InternalException, CloudException {
        URI uri;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was defined for this request");
        }
        String endpoint = ctx.getEndpoint();
        Region region = new Region();
        try {
            uri = endpoint == null || endpoint.trim().equals("") || endpoint.contains("api.cloudsigma.com") ? new URI("https://zrh.cloudsigma.com") : new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new CloudException("Unknown region endpoint: " + endpoint);
        }
        if (uri.getHost().endsWith("zrh.cloudsigma.com")) {
            region.setActive(true);
            region.setAvailable(true);
            region.setName("Switzerland 1");
            region.setProviderRegionId("eu-ch1");
            region.setJurisdiction("CH");
        } else if (uri.getHost().endsWith("lvs.cloudsigma.com")) {
            region.setActive(true);
            region.setAvailable(true);
            region.setName("Nevada 1");
            region.setProviderRegionId("us-nv1");
            region.setJurisdiction("US");
        } else {
            String[] parts = uri.getHost().split("\\.");
            if (parts.length == 4 && parts[0].equals("api") && parts[2].equals("cloudsigma") && parts[3].equals("com")) {
                region.setActive(true);
                region.setAvailable(true);
                region.setName(parts[1]);
                region.setProviderRegionId(parts[1]);
                region.setJurisdiction("EU");
            } else {
                throw new CloudException("Unknown region endpoint: " + endpoint);
            }
        }
        return Collections.singletonList(region);
    }
}

