/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.compute.block;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DataDriveSupport
implements VolumeSupport {
    private static final Logger logger = CloudSigma.getLogger(DataDriveSupport.class);
    private CloudSigma provider;
    private static Collection<String> deviceIds;

    public DataDriveSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    public void attach(@Nonnull String volumeId, @Nonnull String toServer, @Nonnull String deviceId) throws InternalException, CloudException {
        logger.debug((Object)("device: " + deviceId));
        Volume v = this.getVolume(volumeId);
        if (v == null) {
            throw new CloudException("No such volume: " + volumeId);
        }
        this.provider.getComputeServices().getVirtualMachineSupport().attach(v, toServer, deviceId);
    }

    @Nonnull
    public final String create(@Nullable String fromSnapshot, @Nonnegative int sizeInGb, @Nonnull String inZone) throws InternalException, CloudException {
        String description;
        String name;
        Storage storage = new Storage((Number)sizeInGb, (StorageUnit)Storage.GIGABYTE);
        if (this.getVolumeProductRequirement().equals((Object)Requirement.REQUIRED)) {
            VolumeProduct lastChance = null;
            VolumeProduct closest = null;
            for (VolumeProduct product : this.listVolumeProducts()) {
                Float t;
                if (lastChance == null) {
                    lastChance = product;
                } else {
                    Float l = lastChance.getMonthlyGigabyteCost();
                    t = product.getMonthlyGigabyteCost();
                    if (l != null && t != null && t.floatValue() < l.floatValue()) {
                        lastChance = product;
                    }
                }
                if (this.isVolumeSizeDeterminedByProduct()) {
                    Storage size = product.getVolumeSize();
                    int sz = size == null ? 0 : size.intValue();
                    if (sz < sizeInGb) continue;
                    if (closest == null) {
                        closest = product;
                        continue;
                    }
                    size = closest.getVolumeSize();
                    if (size != null && size.intValue() <= sz) continue;
                    closest = product;
                    continue;
                }
                if (closest == null) {
                    closest = product;
                    continue;
                }
                Float c = closest.getMonthlyGigabyteCost();
                t = product.getMonthlyGigabyteCost();
                if (c == null || t == null || !(t.floatValue() < c.floatValue())) continue;
                closest = product;
            }
            if (closest == null) {
                closest = lastChance;
            }
            if (closest != null) {
                String description2;
                String name2;
                if (fromSnapshot != null) {
                    name2 = "Volume from Snapshot " + fromSnapshot;
                    description2 = "Volume created from snapshot #" + fromSnapshot + " on " + new Date();
                    return this.createVolume(VolumeCreateOptions.getInstanceForSnapshot((String)closest.getProviderProductId(), (String)fromSnapshot, (Storage)storage, (String)name2, (String)description2, (int)0));
                }
                name2 = "New Volume " + System.currentTimeMillis();
                description2 = "New Volume (created " + new Date() + ")";
                return this.createVolume(VolumeCreateOptions.getInstance((String)closest.getProviderProductId(), (Storage)storage, (String)name2, (String)description2, (int)0));
            }
        }
        if (fromSnapshot != null) {
            name = "Volume from Snapshot " + fromSnapshot;
            description = "Volume created from snapshot #" + fromSnapshot + " on " + new Date();
            return this.createVolume(VolumeCreateOptions.getInstanceForSnapshot((String)fromSnapshot, (Storage)storage, (String)name, (String)description));
        }
        name = "New Volume " + System.currentTimeMillis();
        description = "New Volume (created " + new Date() + ")";
        return this.createVolume(VolumeCreateOptions.getInstance((Storage)storage, (String)name, (String)description));
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        if (options.getSnapshotId() != null) {
            throw new OperationNotSupportedException("CloudSigma does not support snapshots");
        }
        if (!VolumeFormat.BLOCK.equals((Object)options.getFormat())) {
            throw new OperationNotSupportedException("Only block volumes are supported");
        }
        try {
            logger.debug((Object)("Creating volume: " + options.getName() + ", (" + options.getDescription() + ")"));
            JSONObject newDrive = new JSONObject();
            newDrive.put("name", (Object)options.getName().replaceAll("\n", " "));
            newDrive.put("size", (Object)String.valueOf(options.getVolumeSize().convertTo((UnitOfMeasure)Storage.BYTE).longValue()));
            newDrive.put("encryption", (Object)"aes-xts-plain");
            newDrive.put("media", (Object)"disk");
            if (options.getVolumeProductId() != null && "ssd".equals(options.getVolumeProductId())) {
                JSONArray affinities = new JSONArray();
                affinities.put((Object)"ssd");
                newDrive.put("affinities", (Object)affinities);
            }
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            Volume volume = null;
            JSONObject obj = new JSONObject(method.postString("/drives/", newDrive.toString()));
            if (obj != null) {
                JSONObject json = obj;
                JSONArray objects = json.getJSONArray("objects");
                volume = this.toVolume(objects.getJSONObject(0));
            }
            if (volume == null) {
                throw new CloudException("Volume created but no volume information was provided");
            }
            return volume.getProviderVolumeId();
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public final void detach(@Nonnull String volumeId) throws InternalException, CloudException {
        this.detach(volumeId, false);
    }

    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        Volume v = this.getVolume(volumeId);
        if (v == null) {
            throw new CloudException("No such volume: " + volumeId);
        }
        this.provider.getComputeServices().getVirtualMachineSupport().detach(v);
    }

    @Nullable
    public String getDrive(String driveId) throws CloudException, InternalException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        return method.getString(this.toDriveURL(driveId, ""));
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return null;
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "drive";
    }

    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        try {
            String jDrive = this.getDrive(volumeId);
            if (jDrive != null) {
                return this.toVolume(new JSONObject(jDrive));
            }
            return null;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.OPTIONAL;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        if (deviceIds == null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (int i = 0; i <= 9; ++i) {
                for (int j = 0; j <= 3; ++j) {
                    ids.add(String.valueOf(i).concat(":").concat(String.valueOf(j)));
                }
            }
            deviceIds = Collections.unmodifiableList(ids);
        }
        return deviceIds;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        ArrayList<VolumeProduct> products = new ArrayList<VolumeProduct>();
        products.add(VolumeProduct.getInstance((String)"hdd", (String)"HDD", (String)"HDD Affinity", (VolumeType)VolumeType.HDD));
        products.add(VolumeProduct.getInstance((String)"ssd", (String)"SSD", (String)"SSD Affinity", (VolumeType)VolumeType.SSD));
        return products;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/drives";
        String target = "/?fields=uuid,meta,name,status";
        while (moreData) {
            target = baseTarget + target;
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("Could not identify drive endpoint for CloudSigma");
                }
                if (json.has("objects")) {
                    JSONArray objects = json.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        ResourceStatus volume;
                        JSONObject jVolume = objects.getJSONObject(i);
                        JSONObject metadata = jVolume.getJSONObject("meta");
                        String name = jVolume.getString("name");
                        if (metadata.has("image_type") || name.startsWith("esimg-") || (volume = this.toStatus(jVolume)) == null) continue;
                        list.add(volume);
                    }
                }
                if (!json.has("meta")) continue;
                JSONObject meta = json.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        ArrayList<Volume> list = new ArrayList<Volume>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/drives/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("Could not identify drive endpoint for CloudSigma");
                }
                if (json.has("objects")) {
                    JSONArray objects = json.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        Volume volume;
                        JSONObject jVolume = objects.getJSONObject(i);
                        JSONObject metadata = jVolume.getJSONObject("meta");
                        String name = jVolume.getString("name");
                        if (metadata.has("image_type") || name.startsWith("esimg-") || (volume = this.toVolume(jVolume)) == null) continue;
                        list.add(volume);
                    }
                }
                if (!json.has("meta")) continue;
                JSONObject meta = json.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        CloudSigmaMethod method;
        Volume v = this.getVolume(volumeId);
        long timeout = System.currentTimeMillis() + 300000L;
        while (timeout > System.currentTimeMillis()) {
            if (v == null) {
                return;
            }
            if (!VolumeState.PENDING.equals((Object)v.getCurrentState())) break;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                v = this.getVolume(volumeId);
            }
            catch (Throwable ignore) {}
        }
        if ((method = new CloudSigmaMethod(this.provider)).deleteString(this.toDriveURL(volumeId, ""), "") == null) {
            throw new CloudException("Unable to identify drives endpoint for removal");
        }
    }

    @Nullable
    private Volume toVolume(@Nullable JSONObject drive) throws CloudException, InternalException {
        if (drive == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        Volume volume = new Volume();
        volume.setProviderDataCenterId(regionId + "-a");
        volume.setProviderRegionId(regionId);
        try {
            Platform p;
            JSONArray affinities;
            String s;
            String size;
            String name;
            String id = drive.getString("uuid");
            if (id != null && !id.equals("")) {
                volume.setProviderVolumeId(id);
            }
            boolean found = false;
            if (drive.has("mounted_on")) {
                JSONArray servers = drive.getJSONArray("mounted_on");
                for (int i = 0; i < servers.length(); ++i) {
                    String deviceId;
                    JSONObject server = servers.getJSONObject(i);
                    String host = server.getString("uuid");
                    if (host == null || host.equals("")) continue;
                    VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(host);
                    if (vm != null && !found) {
                        found = true;
                        volume.setProviderVirtualMachineId(host);
                        deviceId = this.provider.getComputeServices().getVirtualMachineSupport().getDeviceId(vm, id);
                        if (deviceId != null) {
                            volume.setDeviceId(deviceId);
                        }
                    }
                    if (vm == null || !vm.getCurrentState().equals((Object)VmState.RUNNING)) continue;
                    volume.setProviderVirtualMachineId(host);
                    deviceId = this.provider.getComputeServices().getVirtualMachineSupport().getDeviceId(vm, id);
                    if (deviceId == null) break;
                    volume.setDeviceId(deviceId);
                    break;
                }
            }
            if ((name = drive.getString("name")) != null && name.length() > 0) {
                volume.setName(name);
            }
            if ((size = drive.getString("size")) != null && size.length() > 0) {
                try {
                    volume.setSize(new Storage((Number)Long.parseLong(size), (StorageUnit)Storage.BYTE));
                }
                catch (NumberFormatException e) {
                    logger.warn((Object)("Invalid drive size: " + size));
                }
            }
            if (volume.getSize() == null) {
                volume.setSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            }
            if ((s = drive.getString("status")) != null) {
                if (s.equalsIgnoreCase("mounted") || s.equalsIgnoreCase("unmounted")) {
                    volume.setCurrentState(VolumeState.AVAILABLE);
                } else if (s.equalsIgnoreCase("unavailable")) {
                    volume.setCurrentState(VolumeState.DELETED);
                } else if (s.startsWith("copying")) {
                    volume.setCurrentState(VolumeState.PENDING);
                } else {
                    logger.warn((Object)("DEBUG: Unknown drive state for CloudSigma: " + s));
                }
            }
            if (VolumeState.AVAILABLE.equals((Object)volume.getCurrentState()) && drive.has("imaging") && (s = drive.getString("imaging")) != null) {
                volume.setCurrentState(VolumeState.PENDING);
            }
            volume.setType(VolumeType.HDD);
            volume.setProviderProductId("hdd");
            if (drive.has("affinities") && (affinities = drive.getJSONArray("affinities")) != null && affinities.length() > 0) {
                volume.setType(VolumeType.SSD);
                volume.setProviderProductId("ssd");
            }
            if (volume.getProviderVolumeId() == null) {
                return null;
            }
            if (volume.getName() == null) {
                volume.setName(volume.getProviderVolumeId());
            }
            if (volume.getDescription() == null) {
                volume.setDescription(volume.getName());
            }
            String description = null;
            String install_notes = null;
            String os = null;
            if (drive.has("meta")) {
                JSONObject meta = drive.getJSONObject("meta");
                if (meta != null) {
                    if (meta.has("os")) {
                        os = meta.getString("os");
                    }
                    if (meta.has("description")) {
                        description = meta.getString("description");
                    }
                    if (meta.has("install_notes")) {
                        install_notes = meta.getString("install_notes");
                    }
                }
                if (description != null && !description.equals("")) {
                    volume.setDescription(description);
                } else if (install_notes != null && !install_notes.equals("")) {
                    volume.setDescription(install_notes);
                }
            }
            Platform platform = Platform.UNKNOWN;
            if (os != null && !os.equals("")) {
                platform = Platform.guess((String)os);
            }
            if (platform.equals((Object)Platform.UNKNOWN)) {
                platform = Platform.guess((String)volume.getName());
                if (platform.equals((Object)Platform.UNKNOWN) && (platform = Platform.guess((String)volume.getDescription())).equals((Object)Platform.UNKNOWN)) {
                    platform = Platform.guess((String)install_notes);
                }
            } else if (platform.equals((Object)Platform.UNIX) && !(p = Platform.guess((String)volume.getName())).equals((Object)Platform.UNKNOWN)) {
                platform = p;
            }
            volume.setGuestOperatingSystem(platform);
            volume.setRootVolume(true);
            return volume;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject drive) throws CloudException, InternalException {
        if (drive == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        try {
            String id = drive.getString("uuid");
            if (id == null || id.equals("")) {
                return null;
            }
            VolumeState state = VolumeState.PENDING;
            String s = drive.getString("status");
            if (s != null) {
                if (s.equalsIgnoreCase("mounted") || s.equalsIgnoreCase("unmounted")) {
                    state = VolumeState.AVAILABLE;
                } else if (s.equalsIgnoreCase("unavailable")) {
                    state = VolumeState.DELETED;
                } else if (s.startsWith("copying")) {
                    state = VolumeState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown drive state for CloudSigma: " + s));
                }
            }
            return new ResourceStatus(id, (Object)state);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    private String toDriveURL(@Nonnull String vmId, @Nonnull String action) throws InternalException {
        try {
            return "/drives/" + URLEncoder.encode(vmId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }
}

