/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.compute.image;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.cloudsigma.compute.CloudSigmaComputeServices;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BootDriveSupport
implements MachineImageSupport {
    private static final Logger logger = CloudSigma.getLogger(BootDriveSupport.class);
    private CloudSigma provider;

    public BootDriveSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    private CloudSigma getProvider() {
        return this.provider;
    }

    @Nonnull
    public JSONObject cloneDrive(@Nonnull String driveId, @Nonnull String name, Platform os) throws CloudException, InternalException {
        JSONObject currentDrive = this.getDrive(driveId);
        if (currentDrive == null) {
            throw new CloudException("No such drive: " + driveId);
        }
        try {
            JSONObject obj;
            logger.debug((Object)("Cloning volume: " + driveId + " with new name " + name));
            JSONObject newDrive = new JSONObject();
            newDrive.put("name", (Object)name.replaceAll("\n", " "));
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            JSONObject jDrive = null;
            boolean publicImage = false;
            if (currentDrive.has("image_type")) {
                publicImage = true;
                if (currentDrive.has("media") && !currentDrive.isNull("media")) {
                    String media = currentDrive.getString("media");
                    if (media.equalsIgnoreCase("cdrom")) {
                        logger.info((Object)"Can't clone drive as image is cdrom");
                        throw new InternalException("Can't clone drive as image is cdrom");
                    }
                } else {
                    throw new CloudException("Can't clone drive: unknown media " + driveId);
                }
            }
            if ((obj = publicImage ? new JSONObject(method.postString(this.toPublicImageURL(driveId, "action/?do=clone"), newDrive.toString())) : new JSONObject(method.postString(this.toDriveURL(driveId, "action/?do=clone"), newDrive.toString()))) != null) {
                jDrive = obj;
            }
            if (jDrive == null) {
                throw new CloudException("Clone supposedly succeeded, but no drive information was provided");
            }
            return jDrive;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    public JSONObject getDrive(String driveId) throws CloudException, InternalException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        String body = method.getString(this.toDriveURL(driveId, ""));
        try {
            JSONObject jDrive = null;
            if (body != null && (!(jDrive = new JSONObject(body)).has("owner") || jDrive.isNull("owner"))) {
                jDrive = null;
            }
            if (jDrive == null) {
                logger.debug((Object)("Failed " + driveId + ", looking at library..."));
                body = method.getString(this.toPublicImageURL(driveId, ""));
                if (body != null) {
                    jDrive = new JSONObject(body);
                }
                logger.debug((Object)("SUCCESS: " + (jDrive != null)));
            }
            return jDrive;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to share images");
    }

    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No ability to make images public");
    }

    @Nonnull
    public String bundleVirtualMachine(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Bundling of virtual machines not supported");
    }

    public void bundleVirtualMachineAsync(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name, @Nonnull AsynchronousTask<String> trackingTask) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Bundling of virtual machines not supported");
    }

    @Nonnull
    public final MachineImage captureImage(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        boolean supported = false;
        for (MachineImageType type : MachineImageType.values()) {
            if (!this.supportsImageCapture(type)) continue;
            supported = true;
        }
        if (!supported) {
            throw new OperationNotSupportedException("Image capture is not supported in " + this.getProvider().getCloudName());
        }
        return this.capture(options, null);
    }

    public final void captureImageAsync(final @Nonnull ImageCreateOptions options, final @Nonnull AsynchronousTask<MachineImage> taskTracker) throws CloudException, InternalException {
        boolean supported = false;
        for (MachineImageType type : MachineImageType.values()) {
            if (!this.supportsImageCapture(type)) continue;
            supported = true;
        }
        if (!supported) {
            throw new OperationNotSupportedException("Image capture is not supported in " + this.getProvider().getCloudName());
        }
        this.getProvider().hold();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    MachineImage img = BootDriveSupport.this.capture(options, (AsynchronousTask<MachineImage>)taskTracker);
                    if (!taskTracker.isComplete()) {
                        taskTracker.completeWithResult((Object)img);
                    }
                }
                catch (Throwable t) {
                    taskTracker.complete(t);
                }
                finally {
                    BootDriveSupport.this.getProvider().release();
                }
            }
        };
        t.setName("Capture of " + options.getVirtualMachineId() + " in " + this.getProvider().getCloudName());
        t.setDaemon(true);
        t.start();
    }

    @Nonnull
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        try {
            block14: {
                VirtualMachine vm;
                if (task != null) {
                    task.setStartTime(System.currentTimeMillis());
                }
                if ((vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(options.getVirtualMachineId())) == null) {
                    throw new CloudException("Virtual machine not found: " + options.getVirtualMachineId());
                }
                if (!VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                    throw new CloudException("Server must be stopped before making an image of it");
                }
                String driveId = vm.getProviderMachineImageId();
                try {
                    if (driveId == null) break block14;
                    JSONObject object = this.cloneDrive(driveId, options.getName(), vm.getPlatform());
                    String id = null;
                    if (object.has("objects")) {
                        JSONArray jDrives = object.getJSONArray("objects");
                        JSONObject actualDrive = (JSONObject)jDrives.get(0);
                        id = actualDrive.getString("uuid");
                    }
                    MachineImage img = null;
                    if (id != null) {
                        img = this.getImage(id);
                    }
                    if (img == null) {
                        throw new CloudException("Drive cloning completed, but no ID was provided for clone");
                    }
                    if (task != null) {
                        task.completeWithResult((Object)img);
                    }
                    MachineImage machineImage = img;
                    return machineImage;
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            throw new InternalException("Drive id for cloning is null");
        }
        finally {
            this.provider.release();
        }
    }

    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        return this.toMachineImage(this.getDrive(providerImageId));
    }

    @Nullable
    public final MachineImage getMachineImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        return this.getImage(providerImageId);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return this.getProviderTermForImage(locale, ImageClass.MACHINE);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        switch (cls) {
            case KERNEL: {
                return "kernel image";
            }
            case RAMDISK: {
                return "ramdisk image";
            }
        }
        return "boot drive";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return this.getProviderTermForImage(locale, cls);
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public final AsynchronousTask<String> imageVirtualMachine(@Nonnull String vmId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        CloudSigmaComputeServices services = this.getProvider().getComputeServices();
        VirtualMachineSupport support = services.getVirtualMachineSupport();
        if (support == null) {
            throw new CloudException("No virtual machine " + vmId + " exists to image in this cloud");
        }
        VirtualMachine vm = support.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No virtual machine " + vmId + " exists to image in this cloud");
        }
        final ImageCreateOptions options = ImageCreateOptions.getInstance((VirtualMachine)vm, (String)name, (String)description);
        final AsynchronousTask task = new AsynchronousTask();
        this.getProvider().hold();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    task.completeWithResult((Object)BootDriveSupport.this.capture(options, null).getProviderMachineImageId());
                }
                catch (Throwable t) {
                    task.complete(t);
                }
                finally {
                    BootDriveSupport.this.getProvider().release();
                }
            }
        };
        t.setName("Capture Image from " + vm.getProviderVirtualMachineId() + " in " + this.getProvider().getCloudName());
        t.setDaemon(true);
        t.start();
        return task;
    }

    public boolean isImageSharedWithPublic(@Nonnull String machineImageId) throws CloudException, InternalException {
        MachineImage img = this.getImage(machineImageId);
        if (img == null) {
            return false;
        }
        String owner = img.getProviderOwnerId();
        return owner.equals("--public--") || owner.equals("00000000-0000-0000-0000-000000000001");
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String me = ctx.getAccountNumber();
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/drives";
        String target = "/?fields=uuid,meta,name,status,owner";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObject = method.list(target);
            if (jObject == null) {
                throw new CloudException("Could not identify drive endpoint for CloudSigma");
            }
            try {
                JSONArray objects = jObject.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    ResourceStatus img;
                    JSONObject jImage = objects.getJSONObject(i);
                    JSONObject metadata = jImage.getJSONObject("meta");
                    String name = jImage.getString("name");
                    if (!metadata.has("image_type") && !name.startsWith("esimg-")) continue;
                    JSONObject owner = jImage.getJSONObject("owner");
                    String id = owner.getString("uuid");
                    if (id != null && id.trim().equals("")) {
                        id = null;
                    }
                    if (!me.equals(id) || (img = this.toStatus(jImage)) == null) continue;
                    list.add(img);
                }
                if (!jObject.has("meta")) continue;
                JSONObject meta = jObject.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return this.listImages(cls, this.getProvider().getContext().getAccountNumber());
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls, @Nonnull String ownedBy) throws CloudException, InternalException {
        if (!ImageClass.MACHINE.equals((Object)cls)) {
            return Collections.emptyList();
        }
        ArrayList<MachineImage> matches = new ArrayList<MachineImage>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/drives/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObject = method.list(target);
            try {
                if (jObject == null) {
                    throw new CloudException("Could not identify drive endpoint for CloudSigma");
                }
                if (jObject.has("objects")) {
                    JSONArray objects = jObject.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        MachineImage img;
                        JSONObject owner;
                        JSONObject jImage = objects.getJSONObject(i);
                        JSONObject metadata = jImage.getJSONObject("meta");
                        String name = jImage.getString("name");
                        if (!metadata.has("image_type") && !name.startsWith("esimg-")) continue;
                        String id = null;
                        if (jImage.has("owner") && (owner = jImage.getJSONObject("owner")) != null && owner.has("uuid")) {
                            id = owner.getString("uuid");
                        }
                        if (id != null && id.trim().equals("")) {
                            id = null;
                        }
                        if (!ownedBy.equals(id) || (img = this.toMachineImage(jImage)) == null) continue;
                        matches.add(img);
                    }
                }
                if (!jObject.has("meta")) continue;
                JSONObject meta = jObject.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return matches;
    }

    @Nonnull
    private Iterable<MachineImage> listImagesComplete(@Nullable String accountId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String me = ctx.getAccountNumber();
        if (me.equals(accountId)) {
            return this.listImages(ImageClass.MACHINE);
        }
        if (accountId == null || accountId.equals("")) {
            accountId = "00000000-0000-0000-0000-000000000001";
        }
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/libdrives/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObj = method.list(target);
            try {
                if (jObj == null) {
                    throw new CloudException("Could not identify drive endpoint for CloudSigma");
                }
                if (jObj.has("objects")) {
                    JSONArray objects = jObj.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        MachineImage img;
                        JSONObject jImage = objects.getJSONObject(i);
                        String id = null;
                        if (jImage.has("owner") && jImage.isNull("owner")) {
                            id = "00000000-0000-0000-0000-000000000001";
                        }
                        if (!accountId.equals(id) || (img = this.toPublicMachineImage(jImage)) == null) continue;
                        list.add(img);
                    }
                }
                if (!jObj.has("meta")) continue;
                JSONObject meta = jObj.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.OVF);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImages() throws CloudException, InternalException {
        return this.listImages(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(@Nullable String accountId) throws CloudException, InternalException {
        if (accountId == null) {
            return this.listImages(ImageClass.MACHINE);
        }
        return this.listImages(ImageClass.MACHINE, accountId);
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No image registering is currently supported");
    }

    public void remove(@Nonnull String machineImageId) throws CloudException, InternalException {
        this.remove(machineImageId, false);
    }

    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        if (method.deleteString(this.toDriveURL(providerImageId, ""), "") == null) {
            throw new CloudException("Unable to identify drives endpoint for removal");
        }
    }

    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
    }

    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not currently implemented");
    }

    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Image sharing is not currently supported");
    }

    @Deprecated
    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws CloudException, InternalException {
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        for (MachineImage img : this.listImagesComplete(null)) {
            if (img == null || !this.matches(img, keyword, platform, architecture, new ImageClass[0])) continue;
            list.add(img);
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> searchImages(@Nullable String accountNumber, @Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        ArrayList<MachineImage> list = new ArrayList<MachineImage>();
        if (accountNumber == null) {
            for (MachineImage img : this.listImages(ImageClass.MACHINE)) {
                if (img == null || !this.matches(img, keyword, platform, architecture, new ImageClass[0])) continue;
                list.add(img);
            }
            for (MachineImage img : this.listImagesComplete(null)) {
                if (img == null || !this.matches(img, keyword, platform, architecture, new ImageClass[0])) continue;
                list.add(img);
            }
        } else {
            for (MachineImage img : this.listImages(ImageClass.MACHINE, accountNumber)) {
                if (img == null || !this.matches(img, keyword, platform, architecture, new ImageClass[0])) continue;
                list.add(img);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        if (imageClasses != null && imageClasses.length < 1) {
            boolean ok = false;
            for (ImageClass c : imageClasses) {
                if (!ImageClass.MACHINE.equals((Object)c)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                return Collections.emptyList();
            }
        }
        ArrayList<MachineImage> matches = new ArrayList<MachineImage>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/libdrives/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObject = method.list(target);
            try {
                if (jObject == null) {
                    throw new CloudException("Could not identify drive endpoint for CloudSigma");
                }
                if (jObject.has("objects")) {
                    JSONArray objects = jObject.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        MachineImage img;
                        JSONObject jImage = objects.getJSONObject(i);
                        String id = null;
                        if (jImage.has("owner") && jImage.isNull("owner")) {
                            id = "00000000-0000-0000-0000-000000000001";
                        }
                        if (id != null && !id.equals("00000000-0000-0000-0000-000000000001") || (img = this.toPublicMachineImage(jImage)) == null || !this.matches(img, keyword, platform, architecture, imageClasses)) continue;
                        matches.add(img);
                    }
                }
                if (!jObject.has("meta")) continue;
                JSONObject meta = jObject.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return matches;
    }

    public void shareMachineImage(@Nonnull String providerImageId, @Nullable String withAccountId, boolean allow) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No supported");
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return true;
    }

    public boolean supportsImageSharing() {
        return false;
    }

    public boolean supportsImageSharingWithPublic() {
        return false;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
    }

    @Nullable
    private MachineImage toMachineImage(@Nullable JSONObject drive) throws CloudException, InternalException {
        if (drive == null) {
            logger.debug((Object)"drive is null");
            return null;
        }
        try {
            Platform p;
            JSONObject owner;
            String name;
            if (drive.has("image_type")) {
                return this.toPublicMachineImage(drive);
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudSigmaConfigurationException("No region was specified for this request");
            }
            MachineImage image = new MachineImage();
            image.setProviderRegionId(regionId);
            image.setCurrentState(MachineImageState.PENDING);
            image.setType(MachineImageType.VOLUME);
            image.setImageClass(ImageClass.MACHINE);
            String id = drive.getString("uuid");
            if (id != null && !id.equals("")) {
                image.setProviderMachineImageId(id);
            }
            if ((name = drive.getString("name")) != null && !name.equals("")) {
                image.setName(name);
            }
            String description = null;
            String os = null;
            String install_notes = null;
            if (drive.has("meta")) {
                JSONObject meta = drive.getJSONObject("meta");
                if (meta != null) {
                    if (meta.has("description")) {
                        description = meta.getString("description");
                    }
                    if ((description == null || description.length() == 0) && meta.has("install_notes")) {
                        install_notes = meta.getString("install_notes");
                    }
                    if (meta.has("os")) {
                        os = meta.getString("os");
                    }
                    String bits = null;
                    if (meta.has("arch")) {
                        bits = meta.getString("arch");
                    }
                    if (bits != null && bits.contains("32")) {
                        image.setArchitecture(Architecture.I32);
                    } else {
                        image.setArchitecture(Architecture.I64);
                    }
                }
                if (description != null && !description.equals("")) {
                    image.setDescription(description);
                } else if (install_notes != null && !install_notes.equals("")) {
                    image.setDescription(install_notes);
                }
            }
            String user = null;
            if (drive.has("owner") && !drive.isNull("owner") && (owner = drive.getJSONObject("owner")) != null && owner.has("uuid")) {
                user = owner.getString("uuid");
            }
            if (user != null && !user.equals("")) {
                image.setProviderOwnerId(user);
            } else {
                image.setProviderOwnerId("00000000-0000-0000-0000-000000000001");
            }
            String s = drive.getString("status");
            if (s != null) {
                if (s.equalsIgnoreCase("mounted") || s.equalsIgnoreCase("copying")) {
                    image.setCurrentState(MachineImageState.PENDING);
                } else if (s.equalsIgnoreCase("unmounted")) {
                    image.setCurrentState(MachineImageState.ACTIVE);
                } else if (s.equalsIgnoreCase("unavailable")) {
                    image.setCurrentState(MachineImageState.DELETED);
                } else {
                    logger.warn((Object)("WARN: Unknown drive state for CloudSigma: " + s));
                }
            }
            if (MachineImageState.ACTIVE.equals((Object)image.getCurrentState())) {
                s = null;
                if (drive.has("imaging")) {
                    s = drive.getString("imaging");
                }
                if (s != null) {
                    image.setCurrentState(MachineImageState.PENDING);
                }
            }
            String size = null;
            size = drive.getString("size");
            if (size != null) {
                try {
                    image.setTag("size", new Storage((Number)Long.parseLong(size), (StorageUnit)Storage.BYTE).toString());
                }
                catch (NumberFormatException ignore) {
                    logger.warn((Object)("Unknown size value: " + size));
                }
            }
            String media = drive.getString("media");
            image.setTag("media", media);
            String software = null;
            if (drive.has("licenses")) {
                JSONArray licences = drive.getJSONArray("licenses");
                for (int i = 0; i < licences.length(); ++i) {
                    JSONObject jlicense = licences.getJSONObject(i);
                    if (jlicense.has("licenses")) {
                        software = jlicense.getString("licenses");
                    }
                    if (software != null) {
                        image.setSoftware(software);
                        break;
                    }
                    image.setSoftware("");
                }
            }
            if (image.getSoftware() == null) {
                image.setSoftware("");
            }
            Platform platform = Platform.UNKNOWN;
            if (os != null && !os.equals("")) {
                platform = Platform.guess((String)os);
            }
            if (platform.equals((Object)Platform.UNKNOWN)) {
                platform = Platform.guess((String)image.getName());
                if (platform.equals((Object)Platform.UNKNOWN) && (platform = Platform.guess((String)image.getDescription())).equals((Object)Platform.UNKNOWN)) {
                    platform = Platform.guess((String)install_notes);
                }
            } else if (platform.equals((Object)Platform.UNIX) && !(p = Platform.guess((String)image.getName())).equals((Object)Platform.UNKNOWN)) {
                platform = p;
            }
            image.setPlatform(platform);
            if (image.getProviderOwnerId() == null) {
                image.setProviderOwnerId(ctx.getAccountNumber());
            }
            if (image.getProviderMachineImageId() == null) {
                return null;
            }
            if (image.getName() == null) {
                image.setName(image.getProviderMachineImageId());
            }
            if (image.getDescription() == null) {
                image.setDescription(image.getName());
            }
            return image;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private MachineImage toPublicMachineImage(@Nullable JSONObject drive) throws CloudException, InternalException {
        if (drive == null) {
            logger.debug((Object)"drive is null");
            return null;
        }
        try {
            Platform p;
            JSONObject owner;
            String name;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudSigmaConfigurationException("No region was specified for this request");
            }
            MachineImage image = new MachineImage();
            image.setProviderRegionId(regionId);
            image.setCurrentState(MachineImageState.PENDING);
            image.setType(MachineImageType.VOLUME);
            image.setImageClass(ImageClass.MACHINE);
            String id = drive.getString("uuid");
            if (id != null && !id.equals("")) {
                image.setProviderMachineImageId(id);
            }
            if ((name = drive.getString("name")) != null && !name.equals("")) {
                image.setName(name);
            }
            String description = null;
            String os = null;
            String install_notes = null;
            if (drive.has("description")) {
                description = drive.getString("description");
            }
            if (drive.has("install_notes")) {
                install_notes = drive.getString("install_notes");
            }
            if (drive.has("os")) {
                os = drive.getString("os");
            }
            String bits = null;
            if (drive.has("arch")) {
                bits = drive.getString("arch");
            }
            if (bits != null && bits.contains("32")) {
                image.setArchitecture(Architecture.I32);
            } else {
                image.setArchitecture(Architecture.I64);
            }
            if (description != null && !description.equals("")) {
                image.setDescription(description);
            } else if (install_notes != null && !install_notes.equals("")) {
                image.setDescription(install_notes);
            }
            String user = null;
            if (drive.has("owner") && !drive.isNull("owner") && (owner = drive.getJSONObject("owner")) != null && owner.has("uuid")) {
                user = owner.getString("uuid");
            }
            if (user != null && !user.equals("")) {
                image.setProviderOwnerId(user);
            } else {
                image.setProviderOwnerId("00000000-0000-0000-0000-000000000001");
            }
            String s = drive.getString("status");
            if (s != null) {
                if (s.equalsIgnoreCase("copying") || s.equalsIgnoreCase("mounted")) {
                    image.setCurrentState(MachineImageState.PENDING);
                } else if (s.equalsIgnoreCase("unmounted")) {
                    image.setCurrentState(MachineImageState.ACTIVE);
                } else if (s.equalsIgnoreCase("unavailable")) {
                    image.setCurrentState(MachineImageState.DELETED);
                } else {
                    logger.warn((Object)("WARN: Unknown drive state for CloudSigma: " + s));
                }
            }
            String size = null;
            size = drive.getString("size");
            if (size != null) {
                try {
                    image.setTag("size", new Storage((Number)Long.parseLong(size), (StorageUnit)Storage.BYTE).toString());
                }
                catch (NumberFormatException ignore) {
                    logger.warn((Object)("Unknown size value: " + size));
                }
            }
            String media = drive.getString("media");
            image.setTag("media", media);
            String software = null;
            if (drive.has("licenses") && !drive.isNull("licenses")) {
                JSONArray licences = drive.getJSONArray("licenses");
                for (int i = 0; i < licences.length(); ++i) {
                    JSONObject li;
                    JSONObject jlicense = licences.getJSONObject(i);
                    if (jlicense.has("license") && !jlicense.isNull("license") && (li = jlicense.getJSONObject("license")).has("long_name") && !li.isNull("long_name")) {
                        software = li.getString("long_name");
                    }
                    if (software != null) {
                        image.setSoftware(software);
                        break;
                    }
                    image.setSoftware("");
                }
            }
            if (image.getSoftware() == null) {
                image.setSoftware("");
            }
            Platform platform = Platform.UNKNOWN;
            if (os != null && !os.equals("")) {
                platform = Platform.guess((String)os);
            }
            if (platform.equals((Object)Platform.UNKNOWN)) {
                platform = Platform.guess((String)image.getName());
                if (platform.equals((Object)Platform.UNKNOWN) && (platform = Platform.guess((String)image.getDescription())).equals((Object)Platform.UNKNOWN)) {
                    platform = Platform.guess((String)install_notes);
                }
            } else if (platform.equals((Object)Platform.UNIX) && !(p = Platform.guess((String)image.getName())).equals((Object)Platform.UNKNOWN)) {
                platform = p;
            }
            image.setPlatform(platform);
            if (image.getProviderOwnerId() == null) {
                image.setProviderOwnerId(ctx.getAccountNumber());
            }
            if (image.getProviderMachineImageId() == null) {
                return null;
            }
            if (image.getName() == null) {
                image.setName(image.getProviderMachineImageId());
            }
            if (image.getDescription() == null) {
                image.setDescription(image.getName());
            }
            return image;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject drive) throws CloudException, InternalException {
        if (drive == null) {
            return null;
        }
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new NoContextException();
            }
            String id = drive.getString("uuid");
            if (id == null || id.equals("")) {
                return null;
            }
            MachineImageState state = MachineImageState.PENDING;
            String s = drive.getString("status");
            if (s != null) {
                if (s.equalsIgnoreCase("mounted") || s.equalsIgnoreCase("unmounted")) {
                    state = MachineImageState.ACTIVE;
                } else if (s.equalsIgnoreCase("unavailable")) {
                    state = MachineImageState.DELETED;
                } else if (s.startsWith("copying")) {
                    state = MachineImageState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown drive state for CloudSigma: " + s));
                }
            }
            return new ResourceStatus(id, (Object)state);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    private String toDriveURL(@Nonnull String vmId, @Nonnull String action) throws InternalException {
        try {
            return "/drives/" + URLEncoder.encode(vmId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    private String toPublicImageURL(@Nonnull String vmId, @Nonnull String action) throws InternalException {
        try {
            return "/libdrives/" + URLEncoder.encode(vmId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }

    protected boolean matches(@Nonnull MachineImage image, @Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... classes) {
        if (architecture != null && !architecture.equals((Object)image.getArchitecture())) {
            return false;
        }
        if (classes != null && classes.length > 0) {
            boolean matches = false;
            for (ImageClass cls : classes) {
                if (!cls.equals((Object)image.getImageClass())) continue;
                matches = true;
                break;
            }
            if (!matches) {
                return false;
            }
        }
        if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
            Platform mine = image.getPlatform();
            if (platform.isWindows() && !mine.isWindows()) {
                return false;
            }
            if (platform.isUnix() && !mine.isUnix()) {
                return false;
            }
            if (platform.isBsd() && !mine.isBsd()) {
                return false;
            }
            if (platform.isLinux() && !mine.isLinux()) {
                return false;
            }
            if (platform.equals((Object)Platform.UNIX) ? !mine.isUnix() : !platform.equals((Object)mine)) {
                return false;
            }
        }
        if (keyword != null) {
            keyword = keyword.toLowerCase();
            if (!(image.getDescription().toLowerCase().contains(keyword) || image.getName().toLowerCase().contains(keyword) || image.getProviderMachineImageId().toLowerCase().contains(keyword))) {
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }
}

