/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.compute.vm;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerSupport
implements VirtualMachineSupport {
    private static final Logger logger = CloudSigma.getLogger(ServerSupport.class);
    private CloudSigma provider;
    private static final Random random = new Random();
    private transient ArrayList<VirtualMachineProduct> cachedProducts;
    private static volatile Collection<Architecture> architectures;

    public ServerSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    public void assignIP(@Nonnull String serverId, @Nonnull IpAddress address) throws CloudException, InternalException {
        VirtualMachine vm = null;
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String obj = method.getString(this.toServerURL(serverId, ""));
            if (obj != null) {
                vm = this.toVirtualMachine(new JSONObject(obj));
            }
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + serverId);
            }
            JSONObject server = new JSONObject(obj);
            JSONArray nics = server.getJSONArray("nics");
            JSONObject newNic = new JSONObject();
            JSONObject newIP = new JSONObject();
            newIP.put("ip", (Object)address.getProviderIpAddressId());
            newIP.put("conf", (Object)"static");
            newNic.put("ip_v4_conf", (Object)newIP);
            nics.put((Object)newNic);
            server.put("nics", (Object)nics);
            this.change(vm, server.toString());
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void attach(@Nonnull Volume volume, @Nonnull String serverId, @Nonnull String deviceId) throws CloudException, InternalException {
        logger.debug((Object)("Device " + deviceId));
        if (deviceId.contains("/dev/")) {
            logger.debug((Object)("Stripping extra text /dev/: " + deviceId.substring(deviceId.indexOf("/dev/") + 5)));
            deviceId = deviceId.substring(deviceId.indexOf("/dev/") + 5);
        }
        if (volume.getProviderVirtualMachineId() != null) {
            throw new CloudException("Volume is already attached to " + volume.getProviderVirtualMachineId());
        }
        VirtualMachine vm = null;
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String obj = method.getString(this.toServerURL(serverId, ""));
            if (obj != null) {
                vm = this.toVirtualMachine(new JSONObject(obj));
            }
            if (vm == null) {
                throw new CloudException("Virtual machine " + serverId + " does not exist");
            }
            JSONObject server = new JSONObject(obj);
            JSONArray drives = server.getJSONArray("drives");
            JSONObject newDrive = new JSONObject();
            newDrive.put("boot_order", drives.length() + 1);
            newDrive.put("device", (Object)"virtio");
            newDrive.put("dev_channel", (Object)deviceId);
            newDrive.put("drive", (Object)volume.getProviderVolumeId());
            drives.put((Object)newDrive);
            server.put("drives", (Object)drives);
            this.change(vm, server.toString());
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void change(@Nonnull VirtualMachine vm, @Nonnull String body) throws CloudException, InternalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + ServerSupport.class.getName() + ".change(" + vm + "," + body + ")"));
        }
        try {
            if (!VmState.STOPPED.equals((Object)vm.getCurrentState())) {
                throw new CloudException("Server must be stopped before making change");
            }
            VirtualMachine workingVm = vm;
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("PUTing changes to " + vm.getProviderVirtualMachineId()));
            }
            if (method.putString(this.toServerURL(vm.getProviderVirtualMachineId(), ""), body) == null) {
                throw new CloudException("Unable to locate servers endpoint in CloudSigma");
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Change to " + vm.getProviderVirtualMachineId() + " succeeded"));
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + ServerSupport.class.getName() + ".change()"));
            }
        }
    }

    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("VM alteration not yet supported");
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String vmId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        VirtualMachine virtualMachine;
        Thread t;
        logger.debug((Object)("Name: " + name + ", description: " + description));
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
            throw new CloudException("No such virtual machine to clone: " + vmId);
        }
        long timeout = System.currentTimeMillis() + 1200000L;
        if (!VmState.STOPPED.equals((Object)vm.getCurrentState())) {
            throw new CloudException("Server must be stopped before making change");
        }
        try {
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            vm = null;
            JSONObject object = new JSONObject(method.postString(this.toServerURL(vmId, "action/?do=clone"), ""));
            if (object != null) {
                vm = this.toVirtualMachine(object);
            }
            if (vm == null) {
                throw new CloudException("No virtual machine was provided in the response");
            }
            if (powerOn) {
                if ((vm = this.waitForState(vm, 900000L, VmState.STOPPED, VmState.RUNNING)) == null) {
                    throw new CloudException("New VM disappeared");
                }
                if (!VmState.RUNNING.equals((Object)vm.getCurrentState())) {
                    final String id = vm.getProviderVirtualMachineId();
                    t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                try {
                                    ServerSupport.this.start(id);
                                    try {
                                        Thread.sleep(2000L);
                                    }
                                    catch (InterruptedException ignore) {
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Failed to start VM post-create: " + e.getMessage()));
                                }
                            }
                            finally {
                                ServerSupport.this.provider.release();
                            }
                        }
                    };
                    this.provider.hold();
                    t.setName("Start CloudSigma VM " + id);
                    t.setDaemon(true);
                    t.start();
                }
            }
            virtualMachine = vm;
        }
        catch (JSONException e) {
            try {
                throw new InternalException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.provider.hold();
                Thread t2 = new Thread(vmId){
                    final /* synthetic */ String val$vmId;
                    {
                        this.val$vmId = string;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            try {
                                ServerSupport.this.start(this.val$vmId);
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException ignore) {
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        finally {
                            ServerSupport.this.provider.release();
                        }
                    }
                };
                t2.setName("CloudSigma Clone Restarted " + vmId);
                t2.setDaemon(true);
                t2.start();
                throw throwable;
            }
        }
        this.provider.hold();
        t = new /* invalid duplicate definition of identical inner class */;
        t.setName("CloudSigma Clone Restarted " + vmId);
        t.setDaemon(true);
        t.start();
        return virtualMachine;
    }

    @Nullable
    public VMScalingCapabilities describeVerticalScalingCapabilities() throws CloudException, InternalException {
        return null;
    }

    public void detach(@Nonnull Volume volume) throws CloudException, InternalException {
        String serverId = volume.getProviderVirtualMachineId();
        if (serverId == null) {
            throw new CloudException("No server is attached to " + volume.getProviderVolumeId());
        }
        VirtualMachine vm = null;
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String obj = method.getString(this.toServerURL(serverId, ""));
            if (obj != null) {
                vm = this.toVirtualMachine(new JSONObject(obj));
            }
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + serverId);
            }
            String driveId = volume.getProviderVolumeId();
            JSONObject json = new JSONObject(obj);
            JSONArray drives = json.getJSONArray("drives");
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < drives.length(); ++i) {
                JSONObject drive = drives.getJSONObject(i);
                JSONObject driveObj = drive.getJSONObject("drive");
                if (driveObj.getString("uuid").equals(driveId)) continue;
                newArray.put((Object)drives.getJSONObject(i));
            }
            json.put("drives", (Object)newArray);
            String jsonBody = json.toString();
            this.change(vm, jsonBody);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void disableAnalytics(String vmId) throws InternalException, CloudException {
    }

    public void enableAnalytics(String vmId) throws InternalException, CloudException {
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String vmId) throws InternalException, CloudException {
        return "";
    }

    public int getCostFactor(@Nonnull VmState state) throws InternalException, CloudException {
        return 100;
    }

    @Nullable
    public String getDeviceId(@Nonnull VirtualMachine vm, @Nonnull String volumeId) throws CloudException, InternalException {
        for (int i = 0; i <= 9; ++i) {
            for (int j = 0; j <= 9; ++j) {
                String id = (String)vm.getTag("virtio:" + i + ":" + j);
                if (id == null || !id.equals(volumeId)) continue;
                return String.valueOf(i).concat(":").concat(String.valueOf(j));
            }
        }
        return null;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        int cpuSpeed;
        int ramInMb;
        int cpuCount;
        String[] parts = productId.split(":");
        if (parts.length < 2) {
            return null;
        }
        try {
            cpuCount = parts.length == 2 ? 1 : Integer.parseInt(parts[2]);
            ramInMb = Integer.parseInt(parts[0]);
            cpuSpeed = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        VirtualMachineProduct product = new VirtualMachineProduct();
        product.setProviderProductId(productId);
        product.setName(ramInMb + "MB - " + cpuCount + "x" + cpuSpeed + "MHz");
        product.setRamSize(new Storage((Number)ramInMb, (StorageUnit)Storage.MEGABYTE));
        product.setCpuCount(cpuCount);
        product.setDescription(product.getName());
        product.setRootVolumeSize(new Storage((Number)10, (StorageUnit)Storage.GIGABYTE));
        return product;
    }

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale locale) {
        return "server";
    }

    public VirtualMachine getVirtualMachine(@Nonnull String vmId) throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String obj = method.getString(this.toServerURL(vmId, ""));
            if (obj != null) {
                return this.toVirtualMachine(new JSONObject(obj));
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return null;
    }

    public VmStatistics getVMStatistics(String vmId, long from, long to) throws InternalException, CloudException {
        return new VmStatistics();
    }

    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String vmId, @Nonnegative long from, @Nonnegative long to) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement() throws CloudException, InternalException {
        return this.identifyPasswordRequirement(Platform.UNKNOWN);
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement() throws CloudException, InternalException {
        return this.identifyShellKeyRequirement(Platform.UNKNOWN);
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        this.listVirtualMachines();
        return true;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    private String generatePassword() {
        int len = 8 + random.nextInt(5);
        StringBuilder password = new StringBuilder();
        while (password.length() < len) {
            char c = (char)random.nextInt(255);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                if (c == 'I' || c == 'i' || c == 'o' || c == 'O' || c == 'l') continue;
                password.append(c);
                continue;
            }
            if (c >= '2' && c <= '9') {
                password.append(c);
                continue;
            }
            if (c != '%' && c != '@' && c != '#' && c != '$' && c != '[' && c != ']') continue;
            password.append(c);
        }
        return password.toString();
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        logger.debug((Object)("Name: " + withLaunchOptions.getHostName() + ", description: " + withLaunchOptions.getDescription() + "friendly name: " + withLaunchOptions.getFriendlyName()));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + ServerSupport.class.getName() + ".launch(" + withLaunchOptions + ")"));
        }
        try {
            MachineImage img = this.provider.getComputeServices().getImageSupport().getImage(withLaunchOptions.getMachineImageId());
            if (img == null) {
                throw new CloudException("No such machine image: " + withLaunchOptions.getMachineImageId());
            }
            String media = img.getTag("media").toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Cloning drive from machine image " + img.getProviderMachineImageId() + "..."));
            }
            String imageDriveId = null;
            if (!media.equals("cdrom")) {
                JSONObject drive = this.provider.getComputeServices().getImageSupport().cloneDrive(withLaunchOptions.getMachineImageId(), withLaunchOptions.getHostName(), null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("drive=" + drive));
                }
                String driveId = null;
                try {
                    JSONObject actualDrive = null;
                    if (drive.has("objects")) {
                        JSONArray objects = drive.getJSONArray("objects");
                        actualDrive = (JSONObject)objects.get(0);
                        driveId = actualDrive.getString("uuid");
                    }
                    if (driveId == null) {
                        throw new CloudException("No drive was cloned to support the machine launch process");
                    }
                    long timeout = System.currentTimeMillis() + 2400000L;
                    String status = actualDrive.getString("status");
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Waiting for new drive " + driveId + " to become active..."));
                    }
                    while (timeout > System.currentTimeMillis()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("status.drive." + driveId + "=" + status));
                        }
                        if (status != null && (status.equals("mounted") || status.equals("unmounted"))) {
                            if (!logger.isInfoEnabled()) break;
                            logger.info((Object)"Drive is now ready for launching");
                            break;
                        }
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        try {
                            actualDrive = this.provider.getComputeServices().getImageSupport().getDrive(driveId);
                        }
                        catch (Throwable ignore) {
                            // empty catch block
                        }
                        if (actualDrive == null) {
                            throw new CloudException("Cloned drive has disappeared");
                        }
                        status = actualDrive.getString("status");
                    }
                    imageDriveId = actualDrive.getString("uuid");
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            imageDriveId = img.getProviderMachineImageId();
            try {
                JSONObject newServer = new JSONObject();
                JSONObject newDrive = new JSONObject();
                JSONObject newNic = new JSONObject();
                JSONObject newVlan = new JSONObject();
                JSONArray drives = new JSONArray();
                JSONArray nics = new JSONArray();
                newServer.put("name", (Object)withLaunchOptions.getHostName().replaceAll("\n", " "));
                String password = withLaunchOptions.getBootstrapPassword();
                if (password == null) {
                    password = this.generatePassword();
                }
                newServer.put("vnc_password", (Object)password);
                newDrive.put("boot_order", 1);
                newDrive.put("device", (Object)"virtio");
                newDrive.put("dev_channel", (Object)"0:0");
                newDrive.put("drive", (Object)imageDriveId);
                drives.put((Object)newDrive);
                newServer.put("drives", (Object)drives);
                String productId = withLaunchOptions.getStandardProductId();
                int cpuCount = 1;
                int cpuSpeed = 1000;
                long ramInBytes = 0x20000000L;
                String[] parts = productId.replaceAll("\n", " ").split(":");
                if (parts.length > 1) {
                    cpuCount = 1;
                    try {
                        int ramInMb = Integer.parseInt(parts[0]);
                        ramInBytes = (long)ramInMb * 1024L * 1024L;
                        cpuSpeed = Integer.parseInt(parts[1]);
                        if (parts.length == 3) {
                            cpuCount = Integer.parseInt(parts[2]);
                            cpuSpeed *= cpuCount;
                        }
                    }
                    catch (NumberFormatException ignore) {
                        // empty catch block
                    }
                }
                newServer.put("cpu", (Object)String.valueOf(cpuSpeed));
                newServer.put("mem", (Object)String.valueOf(ramInBytes));
                newServer.put("smp", (Object)String.valueOf(cpuCount));
                if (withLaunchOptions.getVlanId() != null) {
                    newVlan.put("uuid", (Object)withLaunchOptions.getVlanId().replaceAll("\n", " "));
                    newNic.put("vlan", (Object)newVlan);
                    nics.put((Object)newNic);
                    newServer.put("nics", (Object)nics);
                } else {
                    JSONObject newIP = new JSONObject();
                    newIP.put("conf", (Object)"dhcp");
                    newNic.put("ip_v4_conf", (Object)newIP);
                    if (withLaunchOptions.getFirewallIds() != null) {
                        if (withLaunchOptions.getFirewallIds().length == 1) {
                            newNic.put("firewall_policy", (Object)withLaunchOptions.getFirewallIds()[0]);
                        } else {
                            logger.warn((Object)("Firewall not applied to server as there is more than one - current list has " + withLaunchOptions.getFirewallIds().length));
                        }
                    }
                    nics.put((Object)newNic);
                    newServer.put("nics", (Object)nics);
                }
                CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Creating server....");
                }
                VirtualMachine vm = null;
                JSONObject obj = new JSONObject(method.postString("/servers/", newServer.toString()));
                if (obj != null) {
                    JSONArray arr = obj.getJSONArray("objects");
                    JSONObject server = arr.getJSONObject(0);
                    vm = this.toVirtualMachine(server);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("vm=" + vm));
                }
                if (vm == null) {
                    throw new CloudException("No virtual machine was provided in the response");
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Waiting for " + vm.getProviderVirtualMachineId() + " to be STOPPED or RUNNING..."));
                }
                vm = this.waitForState(vm, 900000L, VmState.STOPPED, VmState.RUNNING);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("post wait vm=" + vm));
                }
                if (vm == null) {
                    throw new CloudException("Virtual machine disappeared waiting for startup state");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("status.vm." + vm.getProviderVirtualMachineId() + "=" + vm.getCurrentState()));
                }
                if (!VmState.RUNNING.equals((Object)vm.getCurrentState())) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Setting up a separate thread to start " + vm.getProviderVirtualMachineId() + "..."));
                    }
                    final String id = vm.getProviderVirtualMachineId();
                    Thread t = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            VirtualMachine vm = null;
                            for (int i = 0; i < 5; ++i) {
                                block18: {
                                    try {
                                        if (vm == null) {
                                            try {
                                                vm = ServerSupport.this.getVirtualMachine(id);
                                            }
                                            catch (Throwable ignore) {
                                                // empty catch block
                                            }
                                        }
                                        if (vm == null) break block18;
                                        if (logger.isInfoEnabled()) {
                                            logger.info((Object)("Verifying the state of " + id));
                                        }
                                        if ((vm = ServerSupport.this.waitForState(vm, 900000L, new VmState[]{VmState.STOPPED, VmState.RUNNING})) != null && !VmState.TERMINATED.equals((Object)vm.getCurrentState()) && !VmState.RUNNING.equals((Object)vm.getCurrentState())) break block18;
                                        if (!logger.isInfoEnabled()) return;
                                        logger.info((Object)("Pre-emptive return due to non-existence or true running: " + id));
                                        return;
                                    }
                                    catch (Exception e) {
                                        logger.warn((Object)("Failed to start virtual machine " + id + " post-create: " + e.getMessage()));
                                        try {
                                            Thread.sleep(60000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        continue;
                                    }
                                }
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)("Start attempt " + (i + 1) + " on " + id));
                                }
                                ServerSupport.this.start(id);
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)("VM " + id + " started"));
                                }
                                try {
                                    Thread.sleep(2000L);
                                    return;
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                                return;
                            }
                            if (!logger.isInfoEnabled()) return;
                            logger.info((Object)("VM " + id + " never started"));
                            if (vm == null) return;
                            logger.debug((Object)("status.vm." + id + " (not started)=" + vm.getCurrentState()));
                            return;
                            finally {
                                ServerSupport.this.provider.release();
                            }
                        }
                    };
                    this.provider.hold();
                    t.setName("Start CloudSigma VM " + id);
                    t.setDaemon(true);
                    t.start();
                }
                VirtualMachine virtualMachine = vm;
                return virtualMachine;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + ServerSupport.class.getName() + ".launch()"));
            }
        }
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String fromMachineImageId, @Nonnull VirtualMachineProduct product, @Nonnull String dataCenterId, @Nonnull String name, @Nonnull String description, @Nullable String withKeypairId, @Nullable String inVlanId, boolean withAnalytics, boolean asSandbox, String ... firewallIds) throws InternalException, CloudException {
        VMLaunchOptions options = VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)name, (String)description);
        options.inDataCenter(dataCenterId);
        if (withKeypairId != null) {
            options.withBoostrapKey(withKeypairId);
        }
        if (inVlanId != null) {
            options.inVlan(null, dataCenterId, inVlanId);
        }
        if (withAnalytics) {
            options.withExtendedAnalytics();
        }
        if (firewallIds != null) {
            options.behindFirewalls(firewallIds);
        }
        return this.launch(options);
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull String fromMachineImageId, @Nonnull VirtualMachineProduct product, @Nonnull String dataCenterId, @Nonnull String name, @Nonnull String description, @Nullable String withKeypairId, @Nullable String inVlanId, boolean withAnalytics, boolean asSandbox, @Nullable String[] firewallIds, Tag ... tags) throws InternalException, CloudException {
        VMLaunchOptions options = VMLaunchOptions.getInstance((String)product.getProviderProductId(), (String)fromMachineImageId, (String)name, (String)name, (String)description);
        options.inDataCenter(dataCenterId);
        if (withKeypairId != null) {
            options.withBoostrapKey(withKeypairId);
        }
        if (inVlanId != null) {
            options.inVlan(null, dataCenterId, inVlanId);
        }
        if (withAnalytics) {
            options.withExtendedAnalytics();
        }
        if (firewallIds != null) {
            options.behindFirewalls(firewallIds);
        }
        if (tags != null) {
            HashMap<String, String> metaData = new HashMap<String, String>();
            for (Tag tag : tags) {
                metaData.put(tag.getKey(), tag.getValue());
            }
            options.withMetaData(metaData);
        }
        return this.launch(options);
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        VirtualMachine vm = this.getVirtualMachine(vmId);
        String[] firewalls = vm.getProviderFirewallIds();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < firewalls.length; ++i) {
            list.add(firewalls[i]);
        }
        return list;
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        ArrayList<Object> products = this.cachedProducts;
        if (products == null) {
            products = new ArrayList();
            for (int ram : new int[]{512, 1024, 2048, 4096, 8192, 12288, 16384, 20480, 24576, 28668, 32768}) {
                for (int cpu : new int[]{1000, 1200, 1500, 2000, 2500, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000, 12000, 14000, 16000, 18000, 20000}) {
                    for (int cpuCount : new int[]{1, 2, 4, 8}) {
                        if (cpuCount == 1) {
                            products.add(this.getProduct(ram + ":" + cpu));
                            continue;
                        }
                        products.add(this.getProduct(ram + ":" + cpu + ":" + cpuCount));
                    }
                }
            }
            this.cachedProducts = products;
        }
        return products;
    }

    public Iterable<Architecture> listSupportedArchitectures() {
        if (architectures == null) {
            ArrayList<Architecture> list = new ArrayList<Architecture>();
            list.add(Architecture.I64);
            list.add(Architecture.I32);
            architectures = Collections.unmodifiableCollection(list);
        }
        return architectures;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        boolean moreData = true;
        String baseTarget = "/servers/";
        String target = "?fields=uuid,status";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObject = method.list(target);
            if (jObject == null) {
                throw new CloudException("No servers endpoint found");
            }
            try {
                JSONArray objects = jObject.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    ResourceStatus vm = this.toStatus(objects.getJSONObject(i));
                    if (vm == null) continue;
                    list.add(vm);
                }
                if (!jObject.has("meta")) continue;
                JSONObject meta = jObject.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        ArrayList<VirtualMachine> list = new ArrayList<VirtualMachine>();
        boolean moreData = true;
        String baseTarget = "/servers/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            JSONObject jObject = method.list(target);
            if (jObject == null) {
                throw new CloudException("No servers endpoint found");
            }
            try {
                JSONArray objects = jObject.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    VirtualMachine vm = this.toVirtualMachine(objects.getJSONObject(i));
                    if (vm == null) continue;
                    list.add(vm);
                }
                if (!jObject.has("meta")) continue;
                JSONObject meta = jObject.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("CloudSigma does not support pause/unpause");
    }

    public void reboot(@Nonnull String vmId) throws CloudException, InternalException {
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        this.stop(vmId);
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            try {
                vm = this.getVirtualMachine(vmId);
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                throw new CloudException("Server disappeared during reboot");
            }
            if (VmState.STOPPED.equals((Object)vm.getCurrentState())) break;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {}
        }
        this.start(vmId);
    }

    public void releaseIP(@Nonnull IpAddress address) throws CloudException, InternalException {
        String serverId = address.getServerId();
        if (serverId == null) {
            throw new CloudException("No server is assigned to " + address.getProviderIpAddressId());
        }
        VirtualMachine vm = null;
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String obj = method.getString(this.toServerURL(serverId, ""));
            if (obj != null) {
                vm = this.toVirtualMachine(new JSONObject(obj));
            }
            if (vm == null) {
                throw new CloudException("No such virtual machine: " + serverId);
            }
            JSONObject json = new JSONObject(obj);
            JSONArray nics = json.getJSONArray("nics");
            JSONArray newArray = new JSONArray();
            for (int i = 0; i < nics.length(); ++i) {
                JSONObject ip;
                JSONObject nic = (JSONObject)nics.get(i);
                if (!address.getVersion().equals((Object)IPVersion.IPV4)) continue;
                JSONObject nicObj = nic.getJSONObject("ip_v4_conf");
                if (nicObj.isNull("ip") && nicObj.getString("conf").equalsIgnoreCase("dhcp")) {
                    newArray.put((Object)nics.getJSONObject(i));
                    continue;
                }
                if (nicObj.isNull("ip") || (ip = nicObj.getJSONObject("ip")).getString("uuid").equals(address.getProviderIpAddressId())) continue;
                newArray.put((Object)nics.getJSONObject(i));
            }
            json.put("nics", (Object)newArray);
            String jsonBody = json.toString();
            this.change(vm, jsonBody);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("CloudSigma does not support suspend/resume");
    }

    public void start(@Nonnull String vmId) throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            method.postString(this.toServerURL(vmId, "action/?do=start"), "");
        }
        catch (CloudSigmaException e) {
            if (e.getMessage().contains("Cannot start guest in state")) {
                return;
            }
            if (e.getHttpCode() == 402) {
                VirtualMachine vm = this.getVirtualMachine(vmId);
                MachineImage image = this.provider.getComputeServices().getImageSupport().getImage(vm.getProviderMachineImageId());
                if (image.getSoftware() != null) {
                    throw new CloudException("Unable to start server - it is associated with a software license which does not have a paid subscription.");
                }
                throw new CloudException("Unable to start server - payment required./nPlease check your account subscription and balance");
            }
            throw e;
        }
    }

    public void stop(@Nonnull String vmId) throws InternalException, CloudException {
        this.stop(vmId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ENTER - " + ServerSupport.class.getName() + ".stop(" + vmId + "," + force + ")"));
        }
        try {
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            if (force) {
                method.postString(this.toServerURL(vmId, "action/?do=stop"), "");
            } else {
                method.postString(this.toServerURL(vmId, "action/?do=shutdown"), "");
                VirtualMachine v = this.waitForState(this.getVirtualMachine(vmId), 300000L, VmState.STOPPED, VmState.RUNNING);
                if (!v.getCurrentState().equals((Object)VmState.STOPPED)) {
                    this.stop(vmId, true);
                }
            }
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("EXIT - " + ServerSupport.class.getName() + ".stop()"));
            }
        }
    }

    public boolean supportsAnalytics() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        return true;
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        return false;
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("CloudSigma does not support suspend/resume");
    }

    public void terminate(@Nonnull String vmId) throws InternalException, CloudException {
        VirtualMachine vm = this.getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
            try {
                this.stop(vmId, true);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        long timeout = System.currentTimeMillis() + 300000L;
        while (timeout > System.currentTimeMillis()) {
            if (vm == null) {
                return;
            }
            if (vm.getCurrentState().equals((Object)VmState.STOPPED)) break;
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                vm = this.getVirtualMachine(vmId);
            }
            catch (Throwable ignore) {}
        }
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        method.deleteString(this.toServerURL(vmId, ""), "");
        timeout = System.currentTimeMillis() + 300000L;
        try {
            vm = this.getVirtualMachine(vmId);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        while (timeout > System.currentTimeMillis()) {
            if (vm == null || VmState.TERMINATED.equals((Object)vm.getCurrentState())) {
                return;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {}
        }
        logger.warn((Object)"System timed out waiting for the VM termination to complete");
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("CloudSigma does not support pause/unpause");
    }

    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    private boolean isPublic(@Nonnull String ip) {
        if (ip.startsWith("127.0.0.")) {
            return false;
        }
        if (ip.startsWith("10.")) {
            return false;
        }
        if (ip.startsWith("192.168.")) {
            return false;
        }
        if (ip.startsWith("172.")) {
            String[] parts = ip.split("\\.");
            if (parts.length != 4) {
                return true;
            }
            try {
                int x = Integer.parseInt(parts[1]);
                if (x >= 16 && x < 33) {
                    return false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return true;
    }

    private void setIP(@Nonnull VirtualMachine vm, @Nonnull TreeSet<String> ips) {
        ArrayList<String> pub = new ArrayList<String>();
        ArrayList<String> priv = new ArrayList<String>();
        for (String ip : ips) {
            if (this.isPublic(ip)) {
                pub.add(ip);
                continue;
            }
            priv.add(ip);
        }
        vm.setPrivateIpAddresses(priv.toArray(new String[priv.size()]));
        vm.setPublicIpAddresses(pub.toArray(new String[pub.size()]));
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject object) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        try {
            String id = object.getString("uuid");
            if (id == null || id.equals("")) {
                return null;
            }
            VmState state = VmState.PENDING;
            String status = object.getString("status");
            if (status != null) {
                if (status.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                } else if (status.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (status.equalsIgnoreCase("started") || status.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (status.equalsIgnoreCase("paused")) {
                    state = VmState.PAUSED;
                } else if (status.equalsIgnoreCase("dead") || status.equalsIgnoreCase("dumped") || status.equalsIgnoreCase("unavailable")) {
                    state = VmState.TERMINATED;
                } else if (status.startsWith("imaging")) {
                    state = VmState.PENDING;
                } else {
                    logger.warn((Object)("DEBUG: Unknown CloudSigma server status: " + status));
                }
            }
            return new ResourceStatus(id, (Object)state);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable JSONObject object) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        VirtualMachine vm = new VirtualMachine();
        vm.setPersistent(true);
        vm.setCurrentState(VmState.PENDING);
        vm.setImagable(false);
        vm.setPausable(false);
        vm.setRebootable(false);
        vm.setPlatform(Platform.UNKNOWN);
        vm.setProviderDataCenterId(regionId + "-a");
        vm.setProviderRegionId(regionId);
        vm.setArchitecture(Architecture.I64);
        try {
            String tmp;
            String description;
            String value;
            String id = object.getString("uuid");
            vm.setProviderVirtualMachineId(id);
            String imageId = "";
            JSONArray drives = null;
            if (object.has("drives")) {
                drives = object.getJSONArray("drives");
                for (int i = 0; i < drives.length(); ++i) {
                    String boot_order;
                    JSONObject jdrive = drives.getJSONObject(i);
                    if (!jdrive.has("boot_order") || !(boot_order = jdrive.getString("boot_order")).equals("1")) continue;
                    JSONObject driveTag = jdrive.getJSONObject("drive");
                    imageId = driveTag.getString("uuid");
                    break;
                }
            }
            if (imageId != null && !imageId.equals("")) {
                vm.setProviderMachineImageId(imageId);
                logger.debug((Object)("Trying to establish the platform for " + imageId));
                MachineImage image = this.provider.getComputeServices().getImageSupport().getImage(imageId);
                Platform os = image.getPlatform();
                vm.setPlatform(os);
                logger.debug((Object)("Server os is " + vm.getPlatform()));
            }
            String vlanId = null;
            JSONArray nics = null;
            if (object.has("nics")) {
                nics = object.getJSONArray("nics");
                for (int i = 0; i < nics.length(); ++i) {
                    JSONObject vlan;
                    JSONObject jnic = nics.getJSONObject(i);
                    if (!jnic.has("vlan") || jnic.isNull("vlan") || (vlan = jnic.getJSONObject("vlan")) == null) continue;
                    vlanId = vlan.getString("uuid");
                    break;
                }
            }
            if (vlanId != null) {
                vm.setProviderVlanId(vlanId);
            }
            if (drives != null) {
                for (int i = 0; i < drives.length(); ++i) {
                    JSONObject jDrive = drives.getJSONObject(i);
                    String devChannel = jDrive.getString("dev_channel");
                    JSONObject driveTag = jDrive.getJSONObject("drive");
                    value = driveTag.getString("uuid");
                    if (value == null) continue;
                    String key = "virtio:" + devChannel;
                    vm.setTag(key, value);
                }
            }
            TreeSet<String> allIps = new TreeSet<String>();
            ArrayList<String> firewallIds = new ArrayList<String>();
            if (nics != null) {
                for (int i = 0; i < nics.length(); ++i) {
                    JSONObject fw;
                    JSONObject ipv6;
                    JSONObject ipv4;
                    JSONObject jnic = nics.getJSONObject(i);
                    if (jnic.has("ip_v4_conf") && !jnic.isNull("ip_v4_conf") && (ipv4 = jnic.getJSONObject("ip_v4_conf")) != null) {
                        String conf4;
                        JSONObject ipObj;
                        String ip4 = null;
                        if (ipv4.has("ip") && !ipv4.isNull("ip") && (ipObj = ipv4.getJSONObject("ip")) != null && (ip4 = ipObj.getString("uuid")) != null && !ip4.equalsIgnoreCase("")) {
                            allIps.add(ip4);
                        }
                        if (ipv4.has("conf") && (conf4 = ipv4.getString("conf")).equalsIgnoreCase("static") && ip4 != null && !ip4.equals("") && !ip4.equals("auto") && vm.getProviderAssignedIpAddressId() == null) {
                            vm.setProviderAssignedIpAddressId(ip4);
                        }
                    }
                    if (jnic.has("ip_v6_conf") && !jnic.isNull("ip_v6_conf") && (ipv6 = jnic.getJSONObject("ip_v6_conf")) != null) {
                        String conf6;
                        JSONObject ip6Obj;
                        String ip6 = null;
                        if (ipv6.has("ip") && !ipv6.isNull("ip") && (ip6Obj = ipv6.getJSONObject("ip")) != null && (ip6 = ip6Obj.getString("uuid")) != null && !ip6.equalsIgnoreCase("")) {
                            allIps.add(ip6);
                        }
                        if (ipv6.has("conf") && (conf6 = ipv6.getString("conf")).equalsIgnoreCase("static") && ip6 != null && !ip6.equals("") && !ip6.equals("auto") && vm.getProviderAssignedIpAddressId() == null) {
                            vm.setProviderAssignedIpAddressId(ip6);
                        }
                    }
                    logger.debug((Object)"Trying to get runtime ip info");
                    if (jnic.has("runtime") && !jnic.isNull("runtime")) {
                        JSONObject ipRun;
                        String ip;
                        JSONObject jRun = jnic.getJSONObject("runtime");
                        if (jRun.has("ip_v4") && !jRun.isNull("ip_v4") && (ip = (ipRun = jRun.getJSONObject("ip_v4")).getString("uuid")) != null && !ip.equalsIgnoreCase("")) {
                            allIps.add(ip);
                        }
                        if (jRun.has("ip_v6") && !jRun.isNull("ip_v6") && (ip = (ipRun = jRun.getJSONObject("ip_v6")).getString("uuid")) != null && !ip.equalsIgnoreCase("")) {
                            allIps.add(ip);
                        }
                    }
                    if (!jnic.has("firewall_policy") || jnic.isNull("firewall_policy") || !(fw = jnic.getJSONObject("firewall_policy")).has("uuid") || fw.isNull("uuid")) continue;
                    String firewall = fw.getString("uuid");
                    logger.debug((Object)("adding firewall policy " + firewall + " to server " + vm.getProviderVirtualMachineId()));
                    firewallIds.add(firewall);
                }
            }
            if (!allIps.isEmpty()) {
                this.setIP(vm, allIps);
            }
            if (!firewallIds.isEmpty()) {
                String[] vmFirewalls = new String[firewallIds.size()];
                for (int i = 0; i < firewallIds.size(); ++i) {
                    vmFirewalls[i] = (String)firewallIds.get(i);
                }
                vm.setProviderFirewallIds(vmFirewalls);
            }
            JSONObject owner = object.getJSONObject("owner");
            String user = owner.getString("uuid");
            vm.setProviderOwnerId(user);
            value = object.getString("name");
            vm.setName(value);
            JSONObject meta = object.getJSONObject("meta");
            if (meta != null && meta.has("description") && (description = meta.getString("description")) != null && !description.equals("")) {
                vm.setDescription(description);
            }
            value = object.getString("vnc_password");
            vm.setRootUser("root");
            vm.setRootPassword(value);
            String status = object.getString("status");
            if (status != null) {
                if (status.equalsIgnoreCase("stopped")) {
                    vm.setCurrentState(VmState.STOPPED);
                } else if (status.equalsIgnoreCase("stopping")) {
                    vm.setCurrentState(VmState.STOPPING);
                } else if (status.equalsIgnoreCase("started") || status.equalsIgnoreCase("running")) {
                    vm.setCurrentState(VmState.RUNNING);
                } else if (status.equalsIgnoreCase("paused")) {
                    vm.setCurrentState(VmState.PAUSED);
                } else if (status.equalsIgnoreCase("dead") || status.equalsIgnoreCase("dumped") || status.equalsIgnoreCase("unavailable")) {
                    vm.setCurrentState(VmState.TERMINATED);
                } else if (status.startsWith("imaging")) {
                    vm.setCurrentState(VmState.PENDING);
                } else {
                    logger.warn((Object)("DEBUG: Unknown CloudSigma server status: " + status));
                }
            } else {
                vm.setCurrentState(VmState.PENDING);
            }
            String cpuCount = "1";
            String cpuSpeed = "1000";
            String ramInMB = "512";
            try {
                tmp = object.getString("smp");
                if (tmp != null) {
                    cpuCount = String.valueOf(Integer.parseInt(tmp));
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            try {
                tmp = object.getString("cpu");
                if (tmp != null) {
                    cpuSpeed = String.valueOf(Integer.parseInt(tmp));
                }
                cpuSpeed = String.valueOf(Integer.parseInt(cpuSpeed) / Integer.parseInt(cpuCount));
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            try {
                tmp = object.getString("mem");
                if (tmp != null) {
                    String ramInBytes = String.valueOf(Long.parseLong(tmp));
                    ramInMB = String.valueOf(Long.parseLong(ramInBytes) / 1024L / 1024L);
                }
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
            if (cpuCount.equals("1")) {
                vm.setProductId(ramInMB + ":" + cpuSpeed);
            } else {
                vm.setProductId(ramInMB + ":" + cpuSpeed + ":" + cpuCount);
            }
            if (vm.getProviderVirtualMachineId() == null) {
                return null;
            }
            if (vm.getName() == null) {
                vm.setName(vm.getProviderVirtualMachineId());
            }
            if (vm.getDescription() == null) {
                vm.setDescription(vm.getName());
            }
            vm.setClonable(VmState.PAUSED.equals((Object)vm.getCurrentState()));
            return vm;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    private String toServerURL(@Nonnull String vmId, @Nonnull String action) throws InternalException {
        try {
            return "/servers/" + URLEncoder.encode(vmId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private VirtualMachine waitForState(@Nonnull VirtualMachine vm, long timeoutPeriod, VmState ... states) {
        long timeout = System.currentTimeMillis() + timeoutPeriod;
        VirtualMachine newVm = vm;
        while (timeout > System.currentTimeMillis()) {
            if (newVm == null) {
                return null;
            }
            for (VmState state : states) {
                if (!state.equals((Object)newVm.getCurrentState())) continue;
                return newVm;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                newVm = this.getVirtualMachine(vm.getProviderVirtualMachineId());
            }
            catch (Exception ignore) {}
        }
        return newVm;
    }
}

