/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.network.firewall;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerFirewallSupport
implements FirewallSupport {
    private static final Logger logger = CloudSigma.getLogger(ServerFirewallSupport.class);
    private CloudSigma provider;

    public ServerFirewallSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int startPort, int endPort) throws CloudException, InternalException {
        return this.authorize(firewallId, Direction.INGRESS, Permission.ALLOW, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)firewallId), startPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, Permission.ALLOW, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, Permission.ALLOW, RuleTarget.getGlobal((String)firewallId), protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, permission, RuleTarget.getCIDR((String)cidr), protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, permission, RuleTarget.getGlobal((String)firewallId), protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, @Nonnull RuleTarget destination, int beginPort, int endPort) throws CloudException, InternalException {
        if (direction.equals((Object)Direction.INGRESS)) {
            return this.authorize(firewallId, direction, permission, RuleTarget.getCIDR((String)cidr), protocol, destination, beginPort, endPort, 0);
        }
        return this.authorize(firewallId, direction, permission, destination, protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort, 0);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort, @Nonnegative int precedence) throws CloudException, InternalException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            JSONObject fw = new JSONObject(method.getString(this.toFirewallURL(firewallId, "")));
            JSONArray rules = fw.getJSONArray("rules");
            JSONObject rule = new JSONObject();
            rule.put("action", (Object)(permission == Permission.ALLOW ? "accept" : "drop"));
            rule.put("direction", (Object)(direction == Direction.INGRESS ? "in" : "out"));
            rule.put("dst_ip", (Object)destinationEndpoint.getCidr());
            rule.put("dst_port", (Object)(String.valueOf(beginPort) + (endPort >= 0 && endPort != beginPort ? ":" + String.valueOf(endPort) : "")));
            rule.put("ip_proto", (Object)(protocol == Protocol.TCP ? "tcp" : "udp"));
            rule.put("src_ip", (Object)sourceEndpoint.getCidr());
            rules.put((Object)rule);
            String firewallObj = method.putString(this.toFirewallURL(firewallId, ""), fw.toString());
            if (firewallObj != null) {
                FirewallRule newRule = FirewallRule.getInstance(null, (String)firewallId, (RuleTarget)sourceEndpoint, (Direction)direction, (Protocol)protocol, (Permission)permission, (RuleTarget)destinationEndpoint, (int)beginPort, (int)endPort);
                return newRule.getProviderRuleId();
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        throw new CloudException("Firewall rule created but not found in response");
    }

    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description) throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            JSONObject body = new JSONObject();
            JSONObject fwName = new JSONObject();
            JSONArray objects = new JSONArray();
            fwName.put("name", (Object)name);
            objects.put((Object)fwName);
            body.put("objects", (Object)objects);
            JSONObject fwObj = new JSONObject(method.postString("/fwpolicies/", body.toString()));
            Firewall firewall = null;
            if (fwObj != null) {
                JSONArray arr = fwObj.getJSONArray("objects");
                JSONObject fw = arr.getJSONObject(0);
                firewall = this.toFirewall(fw);
            }
            if (firewall == null) {
                throw new CloudException("Firewall created but no information was provided");
            }
            return firewall.getProviderFirewallId();
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    public String createInVLAN(@Nonnull String name, @Nonnull String description, @Nonnull String providerVlanId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Firewall policies are only applied when attached to public network interfaces");
    }

    public void delete(@Nonnull String firewallId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Deleting firewalls is not supported in CloudSigma api");
    }

    @Nullable
    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        if (firewallId.length() > 0) {
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            try {
                String fwObj = method.getString(this.toFirewallURL(firewallId, ""));
                if (fwObj != null) {
                    return this.toFirewall(new JSONObject(fwObj));
                }
                return null;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        throw new InternalException("Firewall id is null/empty!");
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "firewall policy";
    }

    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        ArrayList<FirewallRule> list = new ArrayList<FirewallRule>();
        if (firewallId.length() > 0) {
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            try {
                String fwObj = method.getString(this.toFirewallURL(firewallId, ""));
                if (fwObj != null) {
                    JSONObject firewall = new JSONObject(fwObj);
                    JSONArray matches = firewall.getJSONArray("rules");
                    for (int i = 0; i < matches.length(); ++i) {
                        FirewallRule rule = this.toFirewallRule(matches.getJSONObject(i), firewallId);
                        if (rule == null) continue;
                        list.add(rule);
                    }
                }
                return list;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        throw new InternalException("Firewall id is null/empty!");
    }

    @Nonnull
    public Requirement identifyPrecedenceRequirement(boolean inVlan) throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return true;
    }

    public boolean isZeroPrecedenceHighest() throws InternalException, CloudException {
        return true;
    }

    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        ArrayList<Firewall> list = new ArrayList<Firewall>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/fwpolicies/detail/";
        String target = "";
        while (moreData) {
            target = baseTarget + target;
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("No firewall endpoint was found");
                }
                JSONArray objects = json.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    JSONObject jObj = objects.getJSONObject(i);
                    Firewall fw = this.toFirewall(jObj);
                    if (fw == null) continue;
                    list.add(fw);
                }
                if (!json.has("meta")) continue;
                JSONObject meta = json.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        ArrayList<ResourceStatus> list = new ArrayList<ResourceStatus>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/fwpolicies/";
        String target = "?fields=uuid";
        while (moreData) {
            target = baseTarget + target;
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("No firewall endpoint was found");
                }
                JSONArray objects = json.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    JSONObject jObj = objects.getJSONObject(i);
                    ResourceStatus fw = this.toFirewallStatus(jObj);
                    if (fw == null) continue;
                    list.add(fw);
                }
                if (!json.has("meta")) continue;
                JSONObject meta = json.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return list;
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        if (!inVlan) {
            ArrayList<RuleTargetType> destTypes = new ArrayList<RuleTargetType>();
            destTypes.add(RuleTargetType.CIDR);
            destTypes.add(RuleTargetType.GLOBAL);
            return destTypes;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (!inVlan) {
            ArrayList<Direction> list = new ArrayList<Direction>();
            list.add(Direction.EGRESS);
            list.add(Direction.INGRESS);
            return list;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        if (!inVlan) {
            ArrayList<Permission> list = new ArrayList<Permission>();
            list.add(Permission.ALLOW);
            list.add(Permission.DENY);
            return list;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        if (!inVlan) {
            ArrayList<RuleTargetType> sourceTypes = new ArrayList<RuleTargetType>();
            sourceTypes.add(RuleTargetType.CIDR);
            sourceTypes.add(RuleTargetType.GLOBAL);
            return sourceTypes;
        }
        return Collections.emptyList();
    }

    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        FirewallRule rule = null;
        block0: for (Firewall f : this.list()) {
            String fwId = f.getProviderFirewallId();
            if (fwId == null) continue;
            for (FirewallRule r : this.getRules(fwId)) {
                if (!providerFirewallRuleId.equals(r.getProviderRuleId())) continue;
                rule = r;
                continue block0;
            }
        }
        if (rule == null) {
            throw new CloudException("Unable to parse rule ID: " + providerFirewallRuleId);
        }
        this.revoke(providerFirewallRuleId, rule.getFirewallId());
    }

    public void revoke(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int startPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), startPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, permission, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, @Nonnull RuleTarget destination, int beginPort, int endPort) throws CloudException, InternalException {
        String tmpRuleId = FirewallRule.getRuleId((String)firewallId, (RuleTarget)RuleTarget.getCIDR((String)cidr), (Direction)direction, (Protocol)protocol, (Permission)permission, (RuleTarget)destination, (int)beginPort, (int)endPort);
        this.revoke(tmpRuleId, firewallId);
    }

    private void revoke(@Nonnull String ruleId, @Nonnull String firewallId) throws CloudException, InternalException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        JSONArray newArray = new JSONArray();
        try {
            JSONObject fw = new JSONObject(method.getString(this.toFirewallURL(firewallId, "")));
            JSONArray rules = fw.getJSONArray("rules");
            for (int i = 0; i < rules.length(); ++i) {
                JSONObject rule = rules.getJSONObject(i);
                FirewallRule r = this.toFirewallRule(rule, firewallId);
                if (r.getProviderRuleId().equalsIgnoreCase(ruleId)) continue;
                newArray.put((Object)rule);
            }
            fw.put("rules", (Object)newArray);
            String jsonBody = fw.toString();
            if (method.putString(this.toFirewallURL(firewallId, ""), jsonBody) == null) {
                throw new CloudException("Unable to locate firewall endpoint in CloudSigma");
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return !inVlan;
    }

    public boolean supportsFirewallSources() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction serviceAction) {
        return new String[0];
    }

    private Firewall toFirewall(JSONObject fw) throws CloudException, InternalException {
        if (fw == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        Firewall firewall = new Firewall();
        try {
            String name;
            String fwId = fw.getString("uuid");
            firewall.setProviderFirewallId(fwId);
            if (fw.has("name") && !fw.isNull("name") && (name = fw.getString("name")) != null) {
                firewall.setName(name);
                firewall.setDescription(name);
            }
            firewall.setActive(true);
            firewall.setAvailable(true);
            firewall.setRegionId(regionId);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return firewall;
    }

    private ResourceStatus toFirewallStatus(JSONObject fw) throws CloudException, InternalException {
        String fwId;
        if (fw == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        try {
            fwId = fw.getString("uuid");
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return new ResourceStatus(fwId, (Object)true);
    }

    private FirewallRule toFirewallRule(JSONObject fwRule, String fwID) throws CloudException, InternalException {
        if (fwRule == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        String providerFirewallId = fwID;
        RuleTarget sourceEndpoint = null;
        Direction direction = null;
        Protocol protocol = null;
        Permission permission = null;
        RuleTarget destEndpoint = null;
        int startPort = -1;
        int endPort = -1;
        try {
            if (fwRule.has("src_ip") && !fwRule.isNull("src_ip")) {
                String sourceIP = fwRule.getString("src_ip");
                sourceEndpoint = RuleTarget.getCIDR((String)sourceIP);
            }
            if (fwRule.has("direction")) {
                String dir = fwRule.getString("direction");
                Direction direction2 = direction = dir.equalsIgnoreCase("in") ? Direction.INGRESS : Direction.EGRESS;
            }
            if (fwRule.has("ip_proto") && !fwRule.isNull("ip_proto")) {
                String proto = fwRule.getString("ip_proto");
                if (proto.equalsIgnoreCase("tcp")) {
                    protocol = Protocol.TCP;
                } else if (proto.equalsIgnoreCase("udp")) {
                    protocol = Protocol.UDP;
                }
            }
            if (fwRule.has("action")) {
                String action = fwRule.getString("action");
                if (action.equalsIgnoreCase("accept")) {
                    permission = Permission.ALLOW;
                } else if (action.equalsIgnoreCase("drop")) {
                    permission = Permission.DENY;
                }
            }
            if (fwRule.has("dst_ip") && !fwRule.isNull("dst_ip")) {
                String destIP = fwRule.getString("dst_ip");
                destEndpoint = RuleTarget.getCIDR((String)destIP);
            }
            if (fwRule.has("dst_port") && !fwRule.isNull("dst_port")) {
                String destPort = fwRule.getString("dst_port");
                if (destPort.indexOf(":") > -1) {
                    startPort = Integer.parseInt(destPort.substring(0, destPort.indexOf(":")));
                    endPort = Integer.parseInt(destPort.substring(destPort.indexOf(":") + 1, destPort.length()));
                } else {
                    endPort = startPort = Integer.parseInt(destPort);
                }
            }
            if (sourceEndpoint == null) {
                sourceEndpoint = RuleTarget.getGlobal((String)providerFirewallId);
            }
            if (destEndpoint == null) {
                destEndpoint = RuleTarget.getGlobal((String)providerFirewallId);
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        FirewallRule newRule = FirewallRule.getInstance(null, (String)providerFirewallId, (RuleTarget)sourceEndpoint, (Direction)direction, (Protocol)protocol, (Permission)permission, (RuleTarget)destEndpoint, (int)startPort, (int)endPort);
        return newRule;
    }

    @Nonnull
    private String toFirewallURL(@Nonnull String firewallId, @Nonnull String action) throws InternalException {
        try {
            return "/fwpolicies/" + URLEncoder.encode(firewallId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }
}

