/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.network.ip;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StaticIPSupport
implements IpAddressSupport {
    private static final Logger logger = CloudSigma.getLogger(StaticIPSupport.class);
    private CloudSigma provider;

    public StaticIPSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    public void assign(@Nonnull String addressId, @Nonnull String serverId) throws InternalException, CloudException {
        IpAddress address = this.getIpAddress(addressId);
        if (address == null) {
            throw new CloudException("No such IP address: " + address);
        }
        this.provider.getComputeServices().getVirtualMachineSupport().assignIP(serverId, address);
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("NICs are not supported");
    }

    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP forwarding not supported");
    }

    public IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        try {
            String object = method.getString(this.toAddressURL(addressId, ""));
            if (object != null) {
                return this.toIP(new JSONObject(object), false);
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "static IP";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAssigned(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC);
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isForwarding() {
        return false;
    }

    public boolean isForwarding(IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isRequestable(@Nonnull AddressType type) {
        return false;
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return this.listIpPool(IPVersion.IPV4, unassignedOnly);
    }

    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        logger.info((Object)("Getting ip pool (unassigned only? " + unassignedOnly + ")"));
        if (version.equals((Object)IPVersion.IPV4)) {
            ArrayList<IpAddress> addresses = new ArrayList<IpAddress>();
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            boolean moreData = true;
            String baseTarget = "/ips/detail/";
            String target = "";
            while (moreData) {
                target = baseTarget + target;
                JSONObject pool = method.list(target);
                if (pool == null) {
                    throw new CloudException("Unable to communicate with CloudSigma endpoint");
                }
                try {
                    JSONArray objects = pool.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        JSONObject jObj = objects.getJSONObject(i);
                        IpAddress address = this.toIP(jObj, unassignedOnly);
                        if (address == null) continue;
                        addresses.add(address);
                    }
                    if (!pool.has("meta")) continue;
                    JSONObject meta = pool.getJSONObject("meta");
                    if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                        target = meta.getString("next");
                        target = target.substring(target.indexOf("?"));
                        moreData = true;
                        continue;
                    }
                    moreData = false;
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            return addresses;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        if (version.equals((Object)IPVersion.IPV4)) {
            ArrayList<ResourceStatus> addresses = new ArrayList<ResourceStatus>();
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            boolean moreData = true;
            String baseTarget = "/ips/";
            String target = "?fields=uuid,server";
            while (moreData) {
                target = baseTarget + target;
                JSONObject pool = method.list(target);
                if (pool == null) {
                    throw new CloudException("Unable to communicate with CloudSigma endpoint");
                }
                try {
                    JSONArray objects = pool.getJSONArray("objects");
                    for (int i = 0; i < objects.length(); ++i) {
                        JSONObject jObj = objects.getJSONObject(i);
                        ResourceStatus address = this.toStatus(jObj);
                        if (address == null) continue;
                        addresses.add(address);
                    }
                    if (!pool.has("meta")) continue;
                    JSONObject meta = pool.getJSONObject("meta");
                    if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                        target = meta.getString("next");
                        target = target.substring(target.indexOf("?"));
                        moreData = true;
                        continue;
                    }
                    moreData = false;
                }
                catch (JSONException e) {
                    throw new InternalException((Throwable)e);
                }
            }
            return addresses;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP deletion handled through subscriptions");
    }

    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        IpAddress address = this.getIpAddress(addressId);
        if (address == null) {
            throw new CloudException("No such IP address: " + address);
        }
        this.provider.getComputeServices().getVirtualMachineSupport().releaseIP(address);
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP request handled through subscriptions");
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP request handled through subscriptions");
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Requesting for VLANs is not supported");
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Requesting for VLANs is not supported");
    }

    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("IP forwarding is not supported");
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private IpAddress toIP(@Nullable JSONObject object, boolean unassignedOnly) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        IpAddress address = new IpAddress();
        address.setForVlan(false);
        address.setProviderLoadBalancerId(null);
        address.setProviderNetworkInterfaceId(null);
        address.setRegionId(regionId);
        address.setVersion(IPVersion.IPV4);
        address.setAddressType(AddressType.PUBLIC);
        try {
            JSONObject server;
            String id = object.getString("uuid");
            if (id != null && !id.equals("")) {
                address.setIpAddressId(id);
                address.setAddress(id);
            }
            String host = null;
            if (object.has("server") && !object.isNull("server") && (server = object.getJSONObject("server")) != null) {
                host = server.getString("uuid");
            }
            if (host != null && !host.equals("")) {
                address.setServerId(host);
            }
            if (object.has("owner")) {
                JSONObject owner = object.getJSONObject("owner");
                String user = null;
                if (owner != null && owner.has("uuid")) {
                    user = owner.getString("uuid");
                }
                if (user != null && !user.equals("") && !user.equals(ctx.getAccountNumber())) {
                    return null;
                }
            }
            if (address.getServerId() != null && unassignedOnly) {
                return null;
            }
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
        logger.info((Object)("Returning ip: " + address.getProviderIpAddressId()));
        return address;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject object) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        try {
            String id = object.getString("uuid");
            if (id != null && !id.equals("")) {
                JSONObject server;
                String host = null;
                if (object.has("server") && !object.isNull("server") && (server = object.getJSONObject("server")) != null) {
                    host = server.getString("uuid");
                }
                boolean available = host != null && !host.equals("");
                return new ResourceStatus(id, (Object)available);
            }
        }
        catch (JSONException e) {
            throw new InternalException((Object)((Object)e) + " -> " + object);
        }
        return null;
    }

    @Nonnull
    private String toAddressURL(@Nonnull String addressId, @Nonnull String action) throws InternalException {
        try {
            return "/ips/" + URLEncoder.encode(addressId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }
}

