/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudsigma.network.vlan;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudsigma.CloudSigma;
import org.dasein.cloud.cloudsigma.CloudSigmaConfigurationException;
import org.dasein.cloud.cloudsigma.CloudSigmaMethod;
import org.dasein.cloud.cloudsigma.NoContextException;
import org.dasein.cloud.cloudsigma.compute.CloudSigmaComputeServices;
import org.dasein.cloud.cloudsigma.compute.vm.ServerSupport;
import org.dasein.cloud.cloudsigma.network.CloudSigmaNetworkServices;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerVLANSupport
implements VLANSupport {
    private static final Logger logger = CloudSigma.getLogger(ServerVLANSupport.class);
    private CloudSigma provider;

    public ServerVLANSupport(@Nonnull CloudSigma provider) {
        this.provider = provider;
    }

    public void addRouteToAddress(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String address) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void addRouteToGateway(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String gatewayId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void addRouteToNetworkInterface(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void addRouteToVirtualMachine(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        return false;
    }

    public void assignRoutingTableToSubnet(@Nonnull String subnetId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void assignRoutingTableToVlan(@Nonnull String vlanId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void attachNetworkInterface(@Nonnull String nicId, @Nonnull String vmId, int index) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs are not supported");
    }

    public String createInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways are not supported");
    }

    @Nonnull
    public String createRoutingTable(@Nonnull String forVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    @Nonnull
    public NetworkInterface createNetworkInterface(@Nonnull NICCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs are not supported");
    }

    @Nonnull
    public Subnet createSubnet(@Nonnull String cidr, @Nonnull String inProviderVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nonnull String domainName, @Nonnull String[] dnsServers, @Nonnull String[] ntpServers) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Not supported");
    }

    public void detachNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs are not supported");
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return 0;
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "subnet";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "VLAN";
    }

    @Nullable
    public NetworkInterface getNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public RoutingTable getRoutingTableForSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public RoutingTable getRoutingTableForVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    public Subnet getSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        if (vlanId.length() > 0) {
            CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
            try {
                String obj = method.getString(this.toNetworkURL(vlanId, ""));
                if (obj != null) {
                    return this.toVLAN(new JSONObject(obj));
                }
                return null;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        throw new InternalException("Vlan id is null/empty!");
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return false;
    }

    public Collection<String> listFirewallIdsForNIC(@Nonnull String nicId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listNetworkInterfaceStatus() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String forVmId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        ArrayList<Networkable> resources = new ArrayList<Networkable>();
        CloudSigmaNetworkServices network = this.provider.getNetworkServices();
        IpAddressSupport ipSupport = network.getIpAddressSupport();
        if (ipSupport != null) {
            for (IPVersion version : ipSupport.listSupportedIPVersions()) {
                for (IpAddress addr : ipSupport.listIpPool(version, false)) {
                    if (!inVlanId.equals(addr.getProviderVlanId())) continue;
                    resources.add((Networkable)addr);
                }
            }
        }
        for (RoutingTable table : this.listRoutingTables(inVlanId)) {
            resources.add((Networkable)table);
        }
        CloudSigmaComputeServices compute = this.provider.getComputeServices();
        ServerSupport vmSupport = this.provider.getComputeServices().getVirtualMachineSupport();
        Iterable vms = vmSupport.listVirtualMachines();
        for (VirtualMachine vm : vms) {
            if (!inVlanId.equals(vm.getProviderVlanId())) continue;
            resources.add((Networkable)vm);
        }
        return resources;
    }

    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        ArrayList<ResourceStatus> networks = new ArrayList<ResourceStatus>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/vlans/";
        String target = "?fields=uuid";
        while (moreData) {
            target = baseTarget + target;
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("No VLAN endpoint was found");
                }
                JSONArray objects = json.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    JSONObject jObj = objects.getJSONObject(i);
                    ResourceStatus status = this.toStatus(jObj);
                    if (status == null) continue;
                    networks.add(status);
                }
                if (!json.has("meta")) continue;
                JSONObject meta = json.getJSONObject("meta");
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    target = meta.getString("next");
                    target = target.substring(target.indexOf("?"));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return networks;
    }

    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        ArrayList<VLAN> networks = new ArrayList<VLAN>();
        CloudSigmaMethod method = new CloudSigmaMethod(this.provider);
        boolean moreData = true;
        String baseTarget = "/vlans/detail/";
        String target = "";
        while (moreData) {
            logger.debug((Object)("Target " + target));
            target = baseTarget + target;
            logger.debug((Object)("final target " + target));
            try {
                JSONObject json = method.list(target);
                if (json == null) {
                    throw new CloudException("No VLAN endpoint was found");
                }
                JSONArray objects = json.getJSONArray("objects");
                for (int i = 0; i < objects.length(); ++i) {
                    JSONObject jObj = objects.getJSONObject(i);
                    VLAN vlan = this.toVLAN(jObj);
                    if (vlan == null) continue;
                    networks.add(vlan);
                }
                if (!json.has("meta")) continue;
                logger.debug((Object)"Found meta tag");
                JSONObject meta = json.getJSONObject("meta");
                logger.debug((Object)("Number of objects " + networks.size() + " out of " + meta.getString("total_count")));
                if (meta.has("next") && !meta.isNull("next") && !meta.getString("next").equals("")) {
                    logger.debug((Object)("Found new page " + meta.getString("next")));
                    target = meta.getString("next");
                    logger.debug((Object)("target " + target));
                    target = target.substring(target.indexOf("?"));
                    logger.debug((Object)("new target " + target));
                    moreData = true;
                    continue;
                }
                moreData = false;
            }
            catch (JSONException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return networks;
    }

    public void removeInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Internet gateways are not supported");
    }

    public void removeNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("NICs are not supported");
    }

    public void removeRoute(@Nonnull String inRoutingTableId, @Nonnull String destinationCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void removeRoutingTable(@Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Routing tables are not supported");
    }

    public void removeSubnet(String providerSubnetId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Subnets are not supported");
    }

    public void removeVlan(String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Vlan deletion handled through subscriptions");
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable JSONObject object) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        try {
            String id = object.getString("uuid");
            if (id == null || id.equals("")) {
                return null;
            }
            return new ResourceStatus(id, (Object)VLANState.AVAILABLE);
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nullable
    private VLAN toVLAN(@Nullable JSONObject object) throws CloudException, InternalException {
        if (object == null) {
            return null;
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new NoContextException();
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudSigmaConfigurationException("No region was specified for this request");
        }
        VLAN vlan = new VLAN();
        vlan.setDnsServers(new String[0]);
        vlan.setNtpServers(new String[0]);
        vlan.setProviderDataCenterId(regionId + "-a");
        vlan.setProviderRegionId(regionId);
        vlan.setProviderOwnerId(ctx.getAccountNumber());
        vlan.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        vlan.setCidr("0.0.0.0/0");
        vlan.setCurrentState(VLANState.AVAILABLE);
        try {
            String id = object.getString("uuid");
            if (id != null && !id.equals("")) {
                vlan.setProviderVlanId(id);
            }
            if (object.has("owner")) {
                JSONObject owner = object.getJSONObject("owner");
                String user = null;
                if (owner != null && owner.has("uuid")) {
                    user = owner.getString("uuid");
                }
                if (user != null && !user.equals("") && !user.equals(ctx.getAccountNumber())) {
                    return null;
                }
            }
            if (object.has("meta")) {
                JSONObject meta = object.getJSONObject("meta");
                if (meta != null && meta.has("name")) {
                    String name = meta.getString("name");
                    vlan.setName(name);
                }
                if (meta != null && meta.has("description")) {
                    String description = meta.getString("description");
                    vlan.setDescription(description);
                }
            }
            if (vlan.getProviderVlanId() == null) {
                return null;
            }
            if (vlan.getName() == null) {
                vlan.setName(vlan.getProviderVlanId());
            }
            if (vlan.getDescription() == null) {
                vlan.setDescription(vlan.getName());
            }
            return vlan;
        }
        catch (JSONException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Nonnull
    private String toNetworkURL(@Nonnull String vlanId, @Nonnull String action) throws InternalException {
        try {
            return "/vlans/" + URLEncoder.encode(vlanId, "utf-8") + "/" + action;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("UTF-8 not supported: " + e.getMessage()));
            throw new InternalException((Throwable)e);
        }
    }
}

