/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSTopology
implements DataCenterServices {
    public static final String LIST_ZONES = "listZones";
    private CSCloud provider;

    public CSTopology(@Nonnull CSCloud provider) {
        this.provider = provider;
    }

    @Nullable
    public DataCenter getDataCenter(@Nonnull String zoneId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            for (DataCenter dc : this.listDataCenters(region.getProviderRegionId())) {
                if (!dc.getProviderDataCenterId().equals(zoneId)) continue;
                return dc;
            }
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "zone";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    @Nullable
    public Region getRegion(@Nonnull String regionId) throws InternalException, CloudException {
        for (Region region : this.listRegions()) {
            if (!region.getProviderRegionId().equals(regionId)) continue;
            return region;
        }
        return null;
    }

    public boolean requiresNetwork(@Nonnull String zoneId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
        Document doc = method.get(url);
        NodeList matches = doc.getElementsByTagName("zone");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node zone = matches.item(i);
            if (!zone.hasChildNodes()) continue;
            NodeList attrs = zone.getChildNodes();
            String networkType = null;
            String id = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equalsIgnoreCase("id")) {
                    id = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("networkType")) continue;
                networkType = attr.getFirstChild().getNodeValue().trim();
            }
            if (!zoneId.equals(id)) continue;
            return !"basic".equalsIgnoreCase(networkType);
        }
        return true;
    }

    public boolean supportsSecurityGroups(@Nonnull String zoneId, boolean basicOnly) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
        Document doc = method.get(url);
        boolean sg = false;
        boolean basic = false;
        NodeList matches = doc.getElementsByTagName("zone");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node zone = matches.item(i);
            if (!zone.hasChildNodes()) continue;
            NodeList attrs = zone.getChildNodes();
            boolean groups = false;
            String networkType = null;
            String id = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equalsIgnoreCase("id")) {
                    id = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (attr.getNodeName().equalsIgnoreCase("networkType")) {
                    networkType = attr.getFirstChild().getNodeValue().trim();
                    continue;
                }
                if (!attr.getNodeName().equalsIgnoreCase("securitygroupsenabled")) continue;
                groups = attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
            }
            if (!zoneId.equals(id)) continue;
            basic = "basic".equalsIgnoreCase(networkType);
            sg = groups;
            break;
        }
        return (!basicOnly || basic) && sg;
    }

    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String regionId) throws InternalException, CloudException {
        Region region = this.getRegion(regionId);
        if (region == null) {
            throw new CloudException("No such region: " + regionId);
        }
        DataCenter zone = new DataCenter();
        zone.setActive(true);
        zone.setAvailable(true);
        zone.setName(region.getName() + " (DC)");
        zone.setProviderDataCenterId(regionId);
        zone.setRegionId(regionId);
        return Collections.singletonList(zone);
    }

    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
        Document doc = method.get(url);
        ArrayList<Region> regions = new ArrayList<Region>();
        NodeList matches = doc.getElementsByTagName("zone");
        for (int i = 0; i < matches.getLength(); ++i) {
            Region r = this.toRegion(matches.item(i));
            if (r == null) continue;
            regions.add(r);
        }
        return regions;
    }

    @Nullable
    private Region toRegion(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        Region region = new Region();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                region.setProviderRegionId(value);
                continue;
            }
            if (!name.equals("name")) continue;
            region.setName(value);
        }
        if (region.getProviderRegionId() == null) {
            return null;
        }
        if (region.getName() == null) {
            region.setName(region.getProviderRegionId());
        }
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction(this.getJurisdiction(region.getName()));
        return region;
    }

    private String getJurisdiction(String name) {
        if (name.contains("New York")) {
            return "US";
        }
        if (name.contains("Hong Kong")) {
            return "HK";
        }
        if (name.contains("India")) {
            return "IN";
        }
        if (name.contains("London")) {
            return "EU";
        }
        ProviderContext ctx = this.provider.getContext();
        Properties p = ctx == null ? null : ctx.getCustomProperties();
        return p == null ? "US" : p.getProperty("locale." + name, "US");
    }
}

