/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageSupport;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Templates
implements MachineImageSupport {
    private static final String CREATE_TEMPLATE = "createTemplate";
    private static final String DELETE_TEMPLATE = "deleteTemplate";
    private static final String LIST_OS_TYPES = "listOsTypes";
    private static final String LIST_TEMPLATES = "listTemplates";
    private static final String REGISTER_TEMPLATE = "registerTemplate";
    private static final String UPDATE_TEMPLATE_PERMISSIONS = "updateTemplatePermissions";
    private CSCloud provider;

    public Templates(CSCloud provider) {
        this.provider = provider;
    }

    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        MachineImage img = this.getImage(providerImageId);
        if (img == null) {
            return;
        }
        if (!ctx.getAccountNumber().equals(img.getProviderOwnerId())) {
            return;
        }
        Param[] params = new Param[]{new Param("id", providerImageId), new Param("accounts", accountNumber), new Param("op", "add")};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params));
        this.provider.waitForJob(doc, "Share Template");
    }

    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        MachineImage img = this.getImage(providerImageId);
        if (img == null) {
            return;
        }
        if (!ctx.getAccountNumber().equals(img.getProviderOwnerId())) {
            return;
        }
        Param[] params = new Param[]{new Param("id", providerImageId), new Param("isPublic", "true")};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params));
        this.provider.waitForJob(doc, "Share Template");
    }

    @Nonnull
    public String bundleVirtualMachine(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No image bundling in CloudStack");
    }

    public void bundleVirtualMachineAsync(@Nonnull String virtualMachineId, @Nonnull MachineImageFormat format, @Nonnull String bucket, @Nonnull String name, @Nonnull AsynchronousTask<String> trackingTask) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No image bundling in CloudStack");
    }

    @Nonnull
    public MachineImage captureImage(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        return this.imageVirtualMachine(options);
    }

    public void captureImageAsync(final @Nonnull ImageCreateOptions options, final @Nonnull AsynchronousTask<MachineImage> taskTracker) throws CloudException, InternalException {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    taskTracker.completeWithResult((Object)Templates.this.imageVirtualMachine(options));
                }
                catch (Throwable t) {
                    taskTracker.complete(t);
                }
                finally {
                    Templates.this.provider.release();
                }
            }
        };
        this.provider.hold();
        t.setName("Imaging " + options.getVirtualMachineId() + " as " + options.getName());
        t.setDaemon(true);
        t.start();
    }

    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        Document doc;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_TEMPLATES, new Param("id", providerImageId), new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()));
        try {
            doc = method.get(url);
            if (doc == null) {
                return null;
            }
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            if (e.getMessage() != null && e.getMessage().contains("specify a valid template ID")) {
                return null;
            }
            throw e;
        }
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            MachineImage image = this.toImage(node, ctx, false);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    @Deprecated
    @Nullable
    public MachineImage getMachineImage(@Nonnull String templateId) throws InternalException, CloudException {
        return this.getImage(templateId);
    }

    @Deprecated
    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale) {
        return this.getProviderTermForImage(locale, ImageClass.MACHINE);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        switch (cls) {
            case KERNEL: {
                return "kernel template";
            }
            case RAMDISK: {
                return "ramdisk template";
            }
        }
        return "template";
    }

    @Nullable
    private String getRootVolume(@Nonnull String serverId) throws InternalException, CloudException {
        return this.provider.getComputeServices().getVolumeSupport().getRootVolumeId(serverId);
    }

    private Architecture guess(String desc) {
        Architecture arch = Architecture.I64;
        if (desc.contains("x64")) {
            arch = Architecture.I64;
        } else if (desc.contains("x32")) {
            arch = Architecture.I32;
        } else if (desc.contains("64 bit")) {
            arch = Architecture.I64;
        } else if (desc.contains("32 bit")) {
            arch = Architecture.I32;
        } else if (desc.contains("i386")) {
            arch = Architecture.I32;
        } else if (desc.contains("64")) {
            arch = Architecture.I64;
        } else if (desc.contains("32")) {
            arch = Architecture.I32;
        }
        return arch;
    }

    private void guessSoftware(@Nonnull MachineImage image) {
        String[] components = (image.getName() + " " + image.getDescription()).toLowerCase().split(",");
        StringBuilder software = new StringBuilder();
        boolean comma = false;
        if (components == null || components.length < 0) {
            components = new String[]{(image.getName() + " " + image.getDescription()).toLowerCase()};
        }
        for (String str : components) {
            if (!str.contains("sql server")) continue;
            if (comma) {
                software.append(",");
            }
            if (str.contains("sql server 2008")) {
                software.append("SQL Server 2008");
            } else if (str.contains("sql server 2005")) {
                software.append("SQL Server 2005");
            } else {
                software.append("SQL Server 2008");
            }
            comma = true;
        }
        image.setSoftware(software.toString());
    }

    public boolean hasPublicLibrary() {
        return true;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Deprecated
    @Nonnull
    public AsynchronousTask<String> imageVirtualMachine(@Nonnull String vmId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        VirtualMachine vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
        if (vm == null) {
            throw new CloudException("No such virtual machine: " + vmId);
        }
        final AsynchronousTask task = new AsynchronousTask();
        final AsynchronousTask oldTask = new AsynchronousTask();
        this.captureImageAsync(ImageCreateOptions.getInstance((VirtualMachine)vm, (String)name, (String)description), (AsynchronousTask<MachineImage>)task);
        final long timeout = System.currentTimeMillis() + 0x6DDD00L;
        Thread t = new Thread(){

            @Override
            public void run() {
                while (timeout > System.currentTimeMillis()) {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    oldTask.setPercentComplete(task.getPercentComplete());
                    Throwable error = task.getTaskError();
                    MachineImage img = (MachineImage)task.getResult();
                    if (error != null) {
                        oldTask.complete(error);
                        return;
                    }
                    if (img != null) {
                        oldTask.completeWithResult((Object)img.getProviderMachineImageId());
                        return;
                    }
                    if (!task.isComplete()) continue;
                    oldTask.complete((Throwable)new CloudException("Task completed without info"));
                    return;
                }
                oldTask.complete((Throwable)new CloudException("Image creation task timed out"));
            }
        };
        t.setDaemon(true);
        t.start();
        return oldTask;
    }

    @Nonnull
    private MachineImage imageVirtualMachine(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String vmId = options.getVirtualMachineId();
        if (vmId == null) {
            throw new OperationNotSupportedException("Only options based off of servers are supported");
        }
        VirtualMachine server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
        if (server == null) {
            throw new CloudException("No such server: " + vmId);
        }
        CSMethod method = new CSMethod(this.provider);
        String rootVolumeId = this.getRootVolume(vmId);
        if (rootVolumeId == null) {
            throw new CloudException("No root volume is attached to the target server.");
        }
        Snapshot baseSnapshot = this.provider.getComputeServices().getSnapshotSupport().snapshot(rootVolumeId, "Template Builder " + new Date(), "Template Builder from " + server.getProviderVirtualMachineId(), new Tag[0]);
        long timeout = System.currentTimeMillis() + 1800000L;
        while (!baseSnapshot.getCurrentState().equals((Object)SnapshotState.AVAILABLE)) {
            if (System.currentTimeMillis() > timeout) {
                throw new CloudException("Timeout in snapshotting root volume.");
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if ((baseSnapshot = this.provider.getComputeServices().getSnapshotSupport().getSnapshot(baseSnapshot.getProviderSnapshotId())) != null) continue;
            throw new CloudException("Snapshot disappeared while waiting for it to become available");
        }
        MachineImage img = this.getImage(server.getProviderMachineImageId());
        String osId = img == null ? null : (String)img.getTag("cloud.com.os.typeId");
        String name = this.validateName(options.getName());
        Param[] params = new Param[]{new Param("name", name), new Param("displayText", name), new Param("osTypeId", osId == null ? this.toOs(server.getPlatform(), server.getArchitecture()) : osId), new Param("zoneId", ctx.getRegionId()), new Param("isPublic", "false"), new Param("isFeatured", "false"), new Param("snapshotId", baseSnapshot.getProviderSnapshotId()), new Param("passwordEnabled", String.valueOf(this.isPasswordEnabled(server.getProviderMachineImageId())))};
        Document doc = method.get(method.buildUrl(CREATE_TEMPLATE, params));
        NodeList matches = doc.getElementsByTagName("templateid");
        String templateId = null;
        if (matches.getLength() > 0) {
            templateId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (templateId == null && (matches = doc.getElementsByTagName("id")).getLength() > 0) {
            templateId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (templateId == null) {
            throw new CloudException("Failed to provide a template ID.");
        }
        this.provider.waitForJob(doc, "Create Template");
        img = this.getImage(templateId);
        if (img == null) {
            throw new CloudException("Machine image job completed successfully, but no image " + templateId + " exists.");
        }
        return img;
    }

    public boolean isImageSharedWithPublic(@Nonnull String templateId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "self"));
        Document doc = method.get(url);
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            MachineImage image = this.toImage(node, ctx, true);
            if (image == null || !image.getProviderMachineImageId().equals(templateId)) continue;
            return true;
        }
        return false;
    }

    private boolean isPasswordEnabled(@Nonnull String templateId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "executable"));
        Document doc = method.get(url);
        NodeList matches = doc.getElementsByTagName("template");
        if (matches.getLength() > 0) {
            Node node = matches.item(0);
            Boolean val = this.isPasswordEnabled(templateId, node);
            return val != null && val != false;
        }
        return false;
    }

    @Nullable
    private Boolean isPasswordEnabled(@Nonnull String templateId, @Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        boolean enabled = false;
        String id = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id")) {
                id = value;
            } else if (name.equalsIgnoreCase("passwordenabled")) {
                boolean bl = enabled = value != null && value.equalsIgnoreCase("true");
            }
            if (id != null && enabled) break;
        }
        if (id == null || !id.equals(templateId)) {
            return null;
        }
        return enabled;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        try {
            method.get(method.buildUrl("listZones", new Param("available", "true")));
            return true;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                return false;
            }
            throw e;
        }
    }

    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "self"), new Param("zoneId", ctx.getRegionId())));
        ArrayList<ResourceStatus> templates = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus status = this.toStatus(matches.item(i), false);
            if (status == null) continue;
            templates.add(status);
        }
        return templates;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "self"), new Param("zoneId", ctx.getRegionId())));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            MachineImage image = this.toImage(node, ctx, false);
            if (image == null) continue;
            templates.add(image);
        }
        return templates;
    }

    @Nonnull
    public Iterable<MachineImage> listImages(@Nonnull ImageClass cls, @Nonnull String ownedBy) throws CloudException, InternalException {
        if (!cls.equals((Object)ImageClass.MACHINE)) {
            return Collections.emptyList();
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "executable"), new Param("account", ownedBy), new Param("zoneId", ctx.getRegionId())));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            MachineImage image = this.toImage(node, ctx, false);
            if (image == null) continue;
            templates.add(image);
        }
        return templates;
    }

    @Deprecated
    @Nonnull
    public Iterable<MachineImage> listMachineImages() throws InternalException, CloudException {
        return this.listImages(ImageClass.MACHINE);
    }

    @Deprecated
    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(@Nullable String accountId) throws CloudException, InternalException {
        if (accountId != null) {
            return this.listImages(ImageClass.MACHINE, accountId);
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "featured"), new Param("zoneId", ctx.getRegionId())));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            MachineImage image = this.toImage(node, ctx, false);
            if (image == null) continue;
            templates.add(image);
        }
        return templates;
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String templateId) throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("id", templateId)));
        TreeSet<String> accounts = new TreeSet<String>();
        NodeList matches = doc.getElementsByTagName("account");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            accounts.add(node.getFirstChild().getNodeValue());
        }
        return accounts;
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String atStorageLocation = options.getBundleLocation();
        if (atStorageLocation == null) {
            throw new OperationNotSupportedException("Cannot register a machine image without a location");
        }
        String name = this.validateName(options.getName());
        Platform platform = Platform.guess((String)name);
        Architecture architecture = this.guess(name);
        Param[] params = new Param[8];
        params[0] = new Param("name", name);
        params[1] = new Param("displayText", name);
        params[2] = new Param("url", atStorageLocation);
        if (!MachineImageFormat.VHD.equals((Object)options.getBundleFormat())) {
            throw new CloudException("Unsupported bundle format: " + options.getBundleFormat());
        }
        params[3] = new Param("format", "VHD");
        params[4] = new Param("osTypeId", this.toOs(platform, architecture));
        params[5] = new Param("zoneId", ctx.getRegionId());
        params[6] = new Param("isPublic", "false");
        params[7] = new Param("isFeatured", "false");
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(REGISTER_TEMPLATE, params));
        NodeList matches = doc.getElementsByTagName("templateid");
        String templateId = null;
        if (matches.getLength() > 0) {
            templateId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (templateId == null) {
            throw new CloudException("No error was encountered during registration, but no templateId was returned");
        }
        this.provider.waitForJob(doc, "Create Template");
        MachineImage img = this.getImage(templateId);
        if (img == null) {
            throw new CloudException("Machine image " + templateId + " was created, but it does not exist");
        }
        return img;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageFormat.VHD);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void remove(@Nonnull String templateId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for the request");
        }
        String accountNumber = ctx.getAccountNumber();
        MachineImage img = this.getImage(templateId);
        if (img == null) {
            throw new CloudException("No such machine image: " + templateId);
        }
        if (!accountNumber.equals(img.getProviderOwnerId())) {
            throw new CloudException(accountNumber + " cannot remove images belonging to " + img.getProviderOwnerId());
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DELETE_TEMPLATE, new Param("id", templateId)));
        this.provider.waitForJob(doc, "Delete Template");
    }

    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        for (String account : this.listShares(providerImageId)) {
            this.removeImageShare(providerImageId, account);
        }
        this.removePublicShare(providerImageId);
    }

    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        MachineImage img = this.getImage(providerImageId);
        if (img == null) {
            return;
        }
        if (!ctx.getAccountNumber().equals(img.getProviderOwnerId())) {
            return;
        }
        Param[] params = new Param[]{new Param("id", providerImageId), new Param("accounts", accountNumber), new Param("op", "remove")};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params));
        this.provider.waitForJob(doc, "Share Template");
    }

    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        MachineImage img = this.getImage(providerImageId);
        if (img == null) {
            return;
        }
        if (!ctx.getAccountNumber().equals(img.getProviderOwnerId())) {
            return;
        }
        Param[] params = new Param[]{new Param("id", providerImageId), new Param("isPublic", "false")};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params));
        this.provider.waitForJob(doc, "Share Template");
    }

    @Deprecated
    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Param[] params = keyword == null ? new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId())} : new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()), new Param("keyword", keyword)};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, params));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            MachineImage img = this.toImage(matches.item(i), ctx, false);
            if (img == null || architecture != null && !architecture.equals((Object)img.getArchitecture())) continue;
            if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
                Platform mine = img.getPlatform();
                if (platform.isWindows() && !mine.isWindows() || platform.isUnix() && !mine.isUnix() || platform.isBsd() && !mine.isBsd() || platform.isLinux() && !mine.isLinux() || (!platform.equals((Object)Platform.UNIX) ? !platform.equals((Object)mine) : !mine.isUnix())) continue;
            }
            if (keyword != null && !keyword.equals("")) {
                keyword = keyword.toLowerCase();
                if (!img.getProviderMachineImageId().toLowerCase().contains(keyword) && !img.getName().toLowerCase().contains(keyword) && !img.getDescription().toLowerCase().contains(keyword)) continue;
            }
            templates.add(img);
        }
        return templates;
    }

    @Nonnull
    public Iterable<MachineImage> searchImages(@Nullable String accountNumber, @Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Param[] params = keyword == null && accountNumber == null ? new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId())} : (accountNumber == null ? new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()), new Param("keyword", keyword)} : (keyword == null ? new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()), new Param("account", accountNumber)} : new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()), new Param("keyword", keyword), new Param("account", accountNumber)}));
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, params));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            MachineImage img = this.toImage(matches.item(i), ctx, false);
            if (img == null || architecture != null && !architecture.equals((Object)img.getArchitecture())) continue;
            if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
                Platform mine = img.getPlatform();
                if (platform.isWindows() && !mine.isWindows() || platform.isUnix() && !mine.isUnix() || platform.isBsd() && !mine.isBsd() || platform.isLinux() && !mine.isLinux() || (!platform.equals((Object)Platform.UNIX) ? !platform.equals((Object)mine) : !mine.isUnix())) continue;
            }
            if (keyword != null && !keyword.equals("")) {
                keyword = keyword.toLowerCase();
                if (!img.getProviderMachineImageId().toLowerCase().contains(keyword) && !img.getName().toLowerCase().contains(keyword) && !img.getDescription().toLowerCase().contains(keyword)) continue;
            }
            templates.add(img);
        }
        return templates;
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(@Nullable String keyword, @Nullable Platform platform, @Nullable Architecture architecture, ImageClass ... imageClasses) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Param[] params = keyword == null ? new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId())} : new Param[]{new Param("templateFilter", "executable"), new Param("zoneId", ctx.getRegionId()), new Param("keyword", keyword)};
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_TEMPLATES, params));
        ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
        NodeList matches = doc.getElementsByTagName("template");
        for (int i = 0; i < matches.getLength(); ++i) {
            MachineImage img = this.toImage(matches.item(i), ctx, false);
            if (img == null || architecture != null && !architecture.equals((Object)img.getArchitecture())) continue;
            if (platform != null && !platform.equals((Object)Platform.UNKNOWN)) {
                Platform mine = img.getPlatform();
                if (platform.isWindows() && !mine.isWindows() || platform.isUnix() && !mine.isUnix() || platform.isBsd() && !mine.isBsd() || platform.isLinux() && !mine.isLinux() || (!platform.equals((Object)Platform.UNIX) ? !platform.equals((Object)mine) : !mine.isUnix())) continue;
            }
            if (keyword != null && !keyword.equals("")) {
                keyword = keyword.toLowerCase();
                if (!img.getProviderMachineImageId().toLowerCase().contains(keyword) && !img.getName().toLowerCase().contains(keyword) && !img.getDescription().toLowerCase().contains(keyword)) continue;
            }
            templates.add(img);
        }
        return templates;
    }

    @Deprecated
    public void shareMachineImage(@Nonnull String templateId, @Nullable String withAccountId, boolean allow) throws CloudException, InternalException {
        if (allow) {
            if (withAccountId == null) {
                this.addPublicShare(templateId);
            } else {
                this.addImageShare(templateId, withAccountId);
            }
        } else if (withAccountId == null) {
            this.removePublicShare(templateId);
        } else {
            this.removeImageShare(templateId, withAccountId);
        }
    }

    public boolean supportsCustomImages() {
        return true;
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return true;
    }

    public boolean supportsImageSharing() {
        return true;
    }

    public boolean supportsImageSharingWithPublic() {
        return true;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }

    public void updateTags(@Nonnull String imageId, Tag ... tags) throws CloudException, InternalException {
    }

    @Nullable
    private MachineImage toImage(@Nullable Node node, @Nonnull ProviderContext ctx, boolean onlyIfPublic) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        Architecture bestArchitectureGuess = Architecture.I64;
        HashMap properties = new HashMap();
        NodeList attributes = node.getChildNodes();
        MachineImage image = new MachineImage();
        boolean isPublic = false;
        image.setProviderOwnerId(ctx.getAccountNumber());
        image.setType(MachineImageType.VOLUME);
        image.setCurrentState(MachineImageState.PENDING);
        image.setProviderRegionId(ctx.getRegionId());
        image.setTags(properties);
        image.setImageClass(ImageClass.MACHINE);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                image.setProviderMachineImageId(value);
                continue;
            }
            if (name.equals("zoneid")) {
                if (value != null && value.equals(ctx.getRegionId())) continue;
                return null;
            }
            if (name.equalsIgnoreCase("account")) {
                if (value != null && value.startsWith("Customer [")) {
                    value = value.substring("Customer [".length());
                    value = value.substring(0, value.length() - 1);
                }
                image.setProviderOwnerId(value);
                continue;
            }
            if (name.equals("name")) {
                image.setName(value);
                if (value != null && value.contains("x64")) {
                    bestArchitectureGuess = Architecture.I64;
                    continue;
                }
                if (value == null || !value.contains("x32")) continue;
                bestArchitectureGuess = Architecture.I32;
                continue;
            }
            if (name.equals("displaytext")) {
                image.setDescription(value);
                if (value != null && value.contains("x64")) {
                    bestArchitectureGuess = Architecture.I64;
                    continue;
                }
                if (value == null || !value.contains("x32")) continue;
                bestArchitectureGuess = Architecture.I32;
                continue;
            }
            if (name.equals("ispublic")) {
                isPublic = value != null && value.equalsIgnoreCase("true");
                continue;
            }
            if (name.equals("ostypename")) {
                if (value != null && value.contains("64")) {
                    bestArchitectureGuess = Architecture.I64;
                } else if (value != null && value.contains("32")) {
                    bestArchitectureGuess = Architecture.I32;
                }
                if (value == null) continue;
                image.setPlatform(Platform.guess((String)value));
                continue;
            }
            if (name.equals("ostypeid") && value != null) {
                image.getTags().put("cloud.com.os.typeId", value);
                continue;
            }
            if (name.equals("bits")) {
                if (value == null || value.equals("64")) {
                    image.setArchitecture(Architecture.I64);
                    continue;
                }
                image.setArchitecture(Architecture.I32);
                continue;
            }
            if (name.equals("created")) continue;
            if (name.equals("isready")) {
                if (value == null || !value.equalsIgnoreCase("true")) continue;
                image.setCurrentState(MachineImageState.ACTIVE);
                continue;
            }
            if (!name.equals("status") || value != null && value.equalsIgnoreCase("Download Complete")) continue;
            System.out.println("Template status=" + value);
        }
        if (image.getPlatform() == null && image.getName() != null) {
            image.setPlatform(Platform.guess((String)image.getName()));
        }
        if (image.getPlatform() == null) {
            image.setPlatform(Platform.UNKNOWN);
        }
        if (image.getArchitecture() == null) {
            image.setArchitecture(bestArchitectureGuess);
        }
        if (!onlyIfPublic || isPublic) {
            this.guessSoftware(image);
            return image;
        }
        return null;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node, boolean onlyIfPublic) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        MachineImageState imageState = null;
        String imageId = null;
        Boolean isPublic = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                imageId = value;
                continue;
            }
            if (name.equals("ispublic")) {
                isPublic = value != null && value.equalsIgnoreCase("true");
                continue;
            }
            if (!name.equals("isready") || value == null || !value.equalsIgnoreCase("true")) continue;
            imageState = MachineImageState.ACTIVE;
        }
        if (isPublic == null) {
            isPublic = false;
        }
        if (imageId != null && (!onlyIfPublic || isPublic.booleanValue())) {
            if (imageState == null) {
                imageState = MachineImageState.PENDING;
            }
            return new ResourceStatus(imageId, (Object)imageState);
        }
        return null;
    }

    private String toOs(Platform platform, Architecture architecture) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_OS_TYPES, new Param[0]));
        NodeList matches = doc.getElementsByTagName("ostype");
        for (int i = 0; i < matches.getLength(); ++i) {
            NodeList attrs = matches.item(i).getChildNodes();
            Architecture arch = Architecture.I64;
            Platform pf = null;
            String id = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equals("id")) {
                    id = attr.getFirstChild().getNodeValue();
                    continue;
                }
                if (!attr.getNodeName().equals("description")) continue;
                String desc = attr.getFirstChild().getNodeValue();
                pf = Platform.guess((String)desc);
                arch = this.guess(desc);
            }
            if (!platform.equals(pf) || !architecture.equals((Object)arch)) continue;
            return id;
        }
        return null;
    }

    private String validateName(String name) throws InternalException, CloudException {
        boolean found;
        if (name.length() < 32) {
            return name;
        }
        name = name.substring(0, 32);
        int i = 0;
        do {
            found = false;
            for (MachineImage vm : this.listImages(ImageClass.MACHINE)) {
                if (!vm.getName().equals(name)) continue;
                found = true;
                break;
            }
            if (!found) continue;
            name = ++i < 10 ? name.substring(0, 31) + i : (i < 100 ? name.substring(0, 30) + i : name.substring(0, 29) + i);
        } while (found);
        return name;
    }
}

