/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.Network;
import org.dasein.cloud.cloudstack.network.SecurityGroup;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineSupport;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualMachines
implements VirtualMachineSupport {
    public static final Logger logger = Logger.getLogger(VirtualMachines.class);
    private static final String DEPLOY_VIRTUAL_MACHINE = "deployVirtualMachine";
    private static final String DESTROY_VIRTUAL_MACHINE = "destroyVirtualMachine";
    private static final String LIST_VIRTUAL_MACHINES = "listVirtualMachines";
    private static final String LIST_SERVICE_OFFERINGS = "listServiceOfferings";
    private static final String REBOOT_VIRTUAL_MACHINE = "rebootVirtualMachine";
    private static final String START_VIRTUAL_MACHINE = "startVirtualMachine";
    private static final String STOP_VIRTUAL_MACHINE = "stopVirtualMachine";
    private static Properties cloudMappings;
    private static Map<String, Map<String, String>> customNetworkMappings;
    private static Map<String, Map<String, Set<String>>> customServiceMappings;
    private static Map<String, Map<Architecture, Collection<VirtualMachineProduct>>> productCache;
    private CSCloud provider;
    private transient Collection<Architecture> architectures;

    public VirtualMachines(CSCloud provider) {
        this.provider = provider;
    }

    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Vertical scaling is not supported");
    }

    @Nonnull
    public VirtualMachine clone(@Nonnull String serverId, @Nonnull String intoDcId, @Nonnull String name, @Nonnull String description, boolean powerOn, String ... firewallIds) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Instances cannot be cloned.");
    }

    public VMScalingCapabilities describeVerticalScalingCapabilities() throws CloudException, InternalException {
        return null;
    }

    public void disableAnalytics(@Nonnull String vmId) throws InternalException, CloudException {
    }

    public void enableAnalytics(@Nonnull String vmId) throws InternalException, CloudException {
    }

    @Nonnull
    public String getConsoleOutput(@Nonnull String serverId) throws InternalException, CloudException {
        return "";
    }

    public int getCostFactor(@Nonnull VmState state) throws InternalException, CloudException {
        return 100;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        for (Architecture architecture : Architecture.values()) {
            for (VirtualMachineProduct product : this.listProducts(architecture)) {
                if (!product.getProviderProductId().equals(productId)) continue;
                return product;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unknown product ID for cloud.com: " + productId));
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale locale) {
        return "virtual machine";
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String serverId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId())));
        NodeList matches = doc.getElementsByTagName("virtualmachine");
        if (matches.getLength() < 1) {
            return null;
        }
        for (int i = 0; i < matches.getLength(); ++i) {
            VirtualMachine s = this.toVirtualMachine(matches.item(i));
            if (s == null || !s.getProviderVirtualMachineId().equals(serverId)) continue;
            return s;
        }
        return null;
    }

    @Nonnull
    public VmStatistics getVMStatistics(@Nonnull String serverId, @Nonnegative long startTimestamp, @Nonnegative long endTimestamp) throws InternalException, CloudException {
        return new VmStatistics();
    }

    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String serverId, @Nonnegative long arg1, @Nonnegative long arg2) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement() throws CloudException, InternalException {
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        if (this.provider.getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE)) {
            return Requirement.NONE;
        }
        if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            return this.provider.getDataCenterServices().requiresNetwork(regionId) ? Requirement.REQUIRED : Requirement.OPTIONAL;
        }
        return Requirement.OPTIONAL;
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        try {
            method.get(method.buildUrl("listZones", new Param("available", "true")));
            return true;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                return false;
            }
            throw e;
        }
        catch (CloudException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401) {
                return false;
            }
            throw e;
        }
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        String id = withLaunchOptions.getStandardProductId();
        VirtualMachineProduct product = this.getProduct(id);
        if (product == null) {
            throw new CloudException("Invalid product ID: " + id);
        }
        if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
            return this.launch22(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName(), withLaunchOptions.getBootstrapKey(), withLaunchOptions.getVlanId(), withLaunchOptions.getFirewallIds(), withLaunchOptions.getUserData());
        }
        return this.launch21(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName());
    }

    @Deprecated
    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nonnull String inZoneId, @Nonnull String name, @Nonnull String description, @Nullable String usingKey, @Nullable String withVlanId, boolean withMonitoring, boolean asSandbox, String ... protectedByFirewalls) throws InternalException, CloudException {
        return this.launch(imageId, product, inZoneId, name, description, usingKey, withVlanId, withMonitoring, asSandbox, protectedByFirewalls, new Tag[0]);
    }

    @Deprecated
    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nonnull String inZoneId, @Nonnull String name, @Nonnull String description, @Nullable String usingKey, @Nullable String withVlanId, boolean withMonitoring, boolean asSandbox, @Nullable String[] protectedByFirewalls, Tag ... tags) throws InternalException, CloudException {
        if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
            StringBuilder userData = new StringBuilder();
            if (tags != null && tags.length > 0) {
                for (Tag tag : tags) {
                    userData.append(tag.getKey());
                    userData.append("=");
                    userData.append(tag.getValue());
                    userData.append("\n");
                }
            } else {
                userData.append("created=Dasein Cloud\n");
            }
            return this.launch22(imageId, product, inZoneId, name, usingKey, withVlanId, protectedByFirewalls, userData.toString());
        }
        return this.launch21(imageId, product, inZoneId, name);
    }

    private VirtualMachine launch21(String imageId, VirtualMachineProduct product, String inZoneId, String name) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, new Param("zoneId", this.translateZone(inZoneId)), new Param("serviceOfferingId", product.getProviderProductId()), new Param("templateId", imageId), new Param("displayName", name))));
    }

    private void load() {
        HashMap<String, Map<String, String>> mapping;
        Properties properties;
        InputStream input;
        try {
            String line;
            input = VirtualMachines.class.getResourceAsStream("/cloudMappings.cfg");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            properties = new Properties();
            while ((line = reader.readLine()) != null) {
                int idx;
                if (line.startsWith("#") || (idx = line.indexOf(61)) < 0 || line.endsWith("=")) continue;
                String cloudUrl = line.substring(0, idx);
                String cloudId = line.substring(idx + 1);
                properties.put(cloudUrl, cloudId);
            }
            cloudMappings = properties;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            input = VirtualMachines.class.getResourceAsStream("/customNetworkMappings.cfg");
            mapping = new HashMap<String, Map<String, String>>();
            properties = new Properties();
            properties.load(input);
            for (Object key : properties.keySet()) {
                String[] trueKey = ((String)key).split(",");
                Map<String, String> current = mapping.get(trueKey[0]);
                if (current == null) {
                    current = new HashMap<String, String>();
                    mapping.put(trueKey[0], current);
                }
                current.put(trueKey[1], (String)properties.get(key));
            }
            customNetworkMappings = mapping;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            input = VirtualMachines.class.getResourceAsStream("/customServiceMappings.cfg");
            mapping = new HashMap();
            properties = new Properties();
            properties.load(input);
            for (Object key : properties.keySet()) {
                String value = (String)properties.get(key);
                if (value == null) continue;
                String[] trueKey = ((String)key).split(",");
                Map<String, String> tmp = mapping.get(trueKey[0]);
                if (tmp == null) {
                    tmp = new HashMap<String, String>();
                    mapping.put(trueKey[0], tmp);
                }
                TreeSet<String> m = new TreeSet<String>();
                String[] offerings = value.split(",");
                if (offerings == null || offerings.length < 1) {
                    m.add(value);
                } else {
                    Collections.addAll(m, offerings);
                }
                tmp.put(trueKey[1], (String)((Object)m));
            }
            customServiceMappings = mapping;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private VirtualMachine launch22(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nullable String inZoneId, @Nonnull String name, @Nullable String withKeypair, @Nullable String targetVlanId, @Nullable String[] protectedByFirewalls, @Nullable String userData) throws InternalException, CloudException {
        String id;
        Map<String, String> map;
        String cloudId;
        ProviderContext ctx = this.provider.getContext();
        List<Object> vlans = null;
        if (ctx == null) {
            throw new InternalException("No context was provided for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new InternalException("No region is established for this request");
        }
        inZoneId = this.translateZone(inZoneId);
        String prdId = product.getProviderProductId();
        if (customNetworkMappings == null) {
            this.load();
        }
        if (customNetworkMappings != null && (cloudId = cloudMappings.getProperty(ctx.getEndpoint())) != null && (map = customNetworkMappings.get(cloudId)) != null && (id = map.get(prdId)) != null) {
            targetVlanId = id;
        }
        if (targetVlanId != null && targetVlanId.length() < 1) {
            targetVlanId = null;
        }
        if (userData == null) {
            userData = "";
        }
        String securityGroupIds = null;
        if (protectedByFirewalls != null && protectedByFirewalls.length > 0) {
            void var19_25;
            StringBuilder str = new StringBuilder();
            int idx = 0;
            String[] arr$ = protectedByFirewalls;
            int len$ = arr$.length;
            boolean bl = false;
            while (var19_25 < len$) {
                String fw = arr$[var19_25];
                if (!(fw = fw.trim()).equals("")) {
                    str.append(fw);
                    if (idx++ < protectedByFirewalls.length - 1) {
                        str.append(",");
                    }
                }
                ++var19_25;
            }
            securityGroupIds = str.toString();
        }
        int count = 4;
        if (userData != null && userData.length() > 0) {
            ++count;
        }
        if (withKeypair != null) {
            ++count;
        }
        if (targetVlanId == null) {
            Network vlan = this.provider.getNetworkServices().getVlanSupport();
            if (vlan != null && vlan.isSubscribed() && this.provider.getDataCenterServices().requiresNetwork(regionId)) {
                vlans = vlan.findFreeNetworks();
            }
        } else {
            vlans = new ArrayList<String>();
            vlans.add(targetVlanId);
        }
        if (vlans != null && vlans.size() > 0) {
            ++count;
        }
        if (securityGroupIds != null && securityGroupIds.length() > 0) {
            if (!this.provider.getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.size() < 1)) {
                securityGroupIds = null;
            } else {
                ++count;
            }
        } else if (this.provider.getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.size() < 1)) {
            // empty if block
        }
        Param[] params = new Param[count];
        params[0] = new Param("zoneId", inZoneId);
        params[1] = new Param("serviceOfferingId", prdId);
        params[2] = new Param("templateId", imageId);
        params[3] = new Param("displayName", name);
        int i = 4;
        if (userData != null && userData.length() > 0) {
            try {
                params[i++] = new Param("userdata", new String(Base64.encodeBase64((byte[])userData.getBytes("utf-8")), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (withKeypair != null) {
            params[i++] = new Param("keypair", withKeypair);
        }
        if (securityGroupIds != null && securityGroupIds.length() > 0) {
            params[i++] = new Param("securitygroupids", securityGroupIds);
        }
        if (vlans != null && vlans.size() > 0) {
            CloudException lastError = null;
            for (String string : vlans) {
                params[i] = new Param("networkIds", string);
                try {
                    CSMethod method = new CSMethod(this.provider);
                    return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, params)));
                }
                catch (CloudException e) {
                    if (e.getMessage().contains("sufficient address capacity")) {
                        lastError = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (lastError == null) {
                throw lastError;
            }
            throw new CloudException("Unable to identify a network into which a VM can be launched");
        }
        CSMethod method = new CSMethod(this.provider);
        return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, params)));
    }

    @Nonnull
    private VirtualMachine launch(@Nonnull Document doc) throws InternalException, CloudException {
        NodeList matches = doc.getElementsByTagName("deployvirtualmachineresponse");
        String serverId = null;
        for (int i = 0; i < matches.getLength(); ++i) {
            NodeList attrs = matches.item(i).getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node node = attrs.item(j);
                if (node == null || !node.getNodeName().equalsIgnoreCase("virtualmachineid") && !node.getNodeName().equalsIgnoreCase("id")) continue;
                serverId = node.getFirstChild().getNodeValue();
                break;
            }
            if (serverId != null) break;
        }
        if (serverId == null) {
            throw new CloudException("Could not launch server");
        }
        long timeout = System.currentTimeMillis() + 1200000L;
        VirtualMachine vm = null;
        while (System.currentTimeMillis() < timeout) {
            try {
                vm = this.getVirtualMachine(serverId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (vm != null) {
                return vm;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ignore) {}
        }
        this.provider.waitForJob(doc, "Launch Server");
        vm = this.getVirtualMachine(serverId);
        if (vm == null) {
            throw new CloudException("No virtual machine provided: " + serverId);
        }
        return vm;
    }

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        SecurityGroup support = this.provider.getNetworkServices().getFirewallSupport();
        if (support == null) {
            return Collections.emptyList();
        }
        return support.listFirewallsForVM(vmId);
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        Map<String, Set<String>> map;
        String cloudId;
        ArrayList<VirtualMachineProduct> products;
        Map<Object, Object> cached;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured for this request");
        }
        String accountId = this.provider.getContext().getAccountNumber();
        if (productCache.containsKey(accountId)) {
            cached = productCache.get(accountId);
            if (cached.containsKey(architecture) && (products = (ArrayList<VirtualMachineProduct>)cached.get(architecture)) != null) {
                return products;
            }
        } else {
            cached = new HashMap();
            productCache.put(accountId, cached);
        }
        Set<String> mapping = null;
        if (customServiceMappings == null) {
            this.load();
        }
        if (customServiceMappings != null && (cloudId = cloudMappings.getProperty(this.provider.getContext().getEndpoint())) != null && (map = customServiceMappings.get(cloudId)) != null) {
            mapping = map.get(this.provider.getContext().getRegionId());
        }
        products = new ArrayList<VirtualMachineProduct>();
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_SERVICE_OFFERINGS, new Param("zoneId", ctx.getRegionId())));
        NodeList matches = doc.getElementsByTagName("serviceoffering");
        for (int i = 0; i < matches.getLength(); ++i) {
            String id = null;
            String name = null;
            Node node = matches.item(i);
            int memory = 0;
            int cpu = 0;
            NodeList attributes = node.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (n.getNodeName().equals("id")) {
                    id = value;
                } else if (n.getNodeName().equals("name")) {
                    name = value;
                } else if (n.getNodeName().equals("cpunumber")) {
                    cpu = Integer.parseInt(value);
                } else if (n.getNodeName().equals("memory")) {
                    memory = Integer.parseInt(value);
                }
                if (id != null && name != null && cpu > 0 && memory > 0) break;
            }
            if (id == null || mapping != null && !mapping.contains(id)) continue;
            VirtualMachineProduct product = new VirtualMachineProduct();
            product.setProviderProductId(id);
            product.setName(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
            product.setDescription(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
            product.setRamSize(new Storage((Number)memory, (StorageUnit)Storage.MEGABYTE));
            product.setCpuCount(cpu);
            product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
            products.add(product);
        }
        cached.put(architecture, products);
        return products;
    }

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (this.architectures == null) {
            ArrayList<Architecture> a = new ArrayList<Architecture>();
            a.add(Architecture.I32);
            a.add(Architecture.I64);
            this.architectures = Collections.unmodifiableList(a);
        }
        return this.architectures;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId())));
        ArrayList<ResourceStatus> servers = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("virtualmachine");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus vm;
            Node node = matches.item(i);
            if (node == null || (vm = this.toStatus(node)) == null) continue;
            servers.add(vm);
        }
        return servers;
    }

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId())));
        ArrayList<VirtualMachine> servers = new ArrayList<VirtualMachine>();
        NodeList matches = doc.getElementsByTagName("virtualmachine");
        for (int i = 0; i < matches.getLength(); ++i) {
            VirtualMachine vm;
            Node node = matches.item(i);
            if (node == null || (vm = this.toVirtualMachine(node)) == null) continue;
            servers.add(vm);
        }
        return servers;
    }

    public void pause(@Nonnull String vmId) throws InternalException, CloudException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support pause/unpause operations");
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void reboot(@Nonnull String serverId) throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        method.get(method.buildUrl(REBOOT_VIRTUAL_MACHINE, new Param("id", serverId)));
    }

    public void resume(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support suspend/resume operations");
    }

    public void start(@Nonnull String serverId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        method.get(method.buildUrl(START_VIRTUAL_MACHINE, new Param("id", serverId)));
    }

    public void stop(@Nonnull String serverId) throws InternalException, CloudException {
        this.stop(serverId, false);
        VirtualMachine vm = this.getVirtualMachine(serverId);
        if (vm == null) {
            return;
        }
        if (VmState.STOPPED.equals((Object)vm.getCurrentState())) {
            return;
        }
        this.stop(serverId, true);
    }

    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        method.get(method.buildUrl(STOP_VIRTUAL_MACHINE, new Param("id", vmId), new Param("forced", String.valueOf(force))));
    }

    public boolean supportsAnalytics() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPauseUnpause(@Nonnull VirtualMachine vm) {
        return false;
    }

    public boolean supportsStartStop(@Nonnull VirtualMachine vm) {
        return true;
    }

    public boolean supportsSuspendResume(@Nonnull VirtualMachine vm) {
        return false;
    }

    public void suspend(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support suspend/resume operations");
    }

    public void terminate(@Nonnull String serverId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        method.get(method.buildUrl(DESTROY_VIRTUAL_MACHINE, new Param("id", serverId)));
    }

    public void unpause(@Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException(this.provider.getCloudName() + " does not support pause/unpause operations");
    }

    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
    }

    @Nullable
    private String translateZone(@Nullable String zoneId) throws InternalException, CloudException {
        block3: {
            block2: {
                if (zoneId != null) break block2;
                Collection<Region> regions = this.provider.getDataCenterServices().listRegions();
                if (!regions.iterator().hasNext()) break block3;
                zoneId = ((Region)regions.iterator().next()).getProviderRegionId();
                break block3;
            }
            boolean found = false;
            for (Region r : this.provider.getDataCenterServices().listRegions()) {
                for (DataCenter dc : this.provider.getDataCenterServices().listDataCenters(r.getProviderRegionId())) {
                    if (!zoneId.equals(dc.getProviderDataCenterId())) continue;
                    zoneId = r.getProviderRegionId();
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
        }
        return zoneId;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VmState state = null;
        String serverId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                serverId = value;
            } else if (name.equals("state")) {
                if (value == null) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("starting")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("migrating")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed")) {
                    state = VmState.TERMINATED;
                } else {
                    if (value.equalsIgnoreCase("error")) {
                        logger.warn((Object)"VM is in an error state.");
                        return null;
                    }
                    if (value.equalsIgnoreCase("expunging")) {
                        state = VmState.TERMINATED;
                    } else if (value.equalsIgnoreCase("ha")) {
                        state = VmState.REBOOTING;
                    } else {
                        throw new CloudException("Unexpected server state: " + value);
                    }
                }
            }
            if (serverId != null && state != null) break;
        }
        if (serverId == null) {
            return null;
        }
        if (state == null) {
            state = VmState.PENDING;
        }
        return new ResourceStatus(serverId, (Object)state);
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        VirtualMachine server = new VirtualMachine();
        NodeList attributes = node.getChildNodes();
        String productId = null;
        server.setTags(properties);
        server.setArchitecture(Architecture.I64);
        server.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        server.setClonable(false);
        server.setImagable(false);
        server.setPausable(true);
        server.setPersistent(true);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                server.setProviderVirtualMachineId(value);
                continue;
            }
            if (name.equals("name")) {
                server.setDescription(value);
                continue;
            }
            if (name.equals("displayname")) {
                server.setName(value);
                continue;
            }
            if (name.equals("ipaddress")) {
                if (value != null) {
                    server.setPrivateIpAddresses(new String[]{value});
                } else {
                    server.setPrivateIpAddresses(new String[0]);
                }
                server.setPrivateDnsAddress(value);
                continue;
            }
            if (name.equals("password")) {
                server.setRootPassword(value);
                continue;
            }
            if (name.equals("nic")) {
                if (!attribute.hasChildNodes()) continue;
                NodeList parts = attribute.getChildNodes();
                String addr = null;
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (part.getNodeName().equalsIgnoreCase("ipaddress")) {
                        if (!part.hasChildNodes() || (addr = part.getFirstChild().getNodeValue()) == null) continue;
                        addr = addr.trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("networkid")) continue;
                    server.setProviderVlanId(part.getFirstChild().getNodeValue().trim());
                }
                if (addr == null) continue;
                boolean pub = false;
                if (!addr.startsWith("10.") && !addr.startsWith("192.168.")) {
                    if (addr.startsWith("172.")) {
                        String[] nums = addr.split("\\.");
                        if (nums.length != 4) {
                            pub = true;
                        } else {
                            try {
                                int x = Integer.parseInt(nums[1]);
                                if (x < 16 || x > 31) {
                                    pub = true;
                                }
                            }
                            catch (NumberFormatException ignore) {}
                        }
                    } else {
                        pub = true;
                    }
                }
                if (pub) {
                    server.setPublicIpAddresses(new String[]{addr});
                    if (server.getPublicDnsAddress() != null) continue;
                    server.setPublicDnsAddress(addr);
                    continue;
                }
                server.setPrivateIpAddresses(new String[]{addr});
                if (server.getPrivateDnsAddress() != null) continue;
                server.setPrivateDnsAddress(addr);
                continue;
            }
            if (name.equals("osarchitecture")) {
                if (value != null && value.equals("32")) {
                    server.setArchitecture(Architecture.I32);
                    continue;
                }
                server.setArchitecture(Architecture.I64);
                continue;
            }
            if (name.equals("created")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                try {
                    server.setCreationTimestamp(df.parse(value).getTime());
                }
                catch (ParseException e) {
                    logger.warn((Object)("Invalid date: " + value));
                    server.setLastBootTimestamp(0L);
                }
                continue;
            }
            if (name.equals("state")) {
                VmState state;
                if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                    server.setImagable(true);
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("starting")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("migrating")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed")) {
                    state = VmState.TERMINATED;
                } else {
                    if (value.equalsIgnoreCase("error")) {
                        logger.warn((Object)"VM is in an error state.");
                        return null;
                    }
                    if (value.equalsIgnoreCase("expunging")) {
                        state = VmState.TERMINATED;
                    } else if (value.equalsIgnoreCase("ha")) {
                        state = VmState.REBOOTING;
                    } else {
                        throw new CloudException("Unexpected server state: " + value);
                    }
                }
                server.setCurrentState(state);
                continue;
            }
            if (name.equals("zoneid")) {
                server.setProviderRegionId(value);
                server.setProviderDataCenterId(value);
                continue;
            }
            if (name.equals("templateid")) {
                server.setProviderMachineImageId(value);
                continue;
            }
            if (name.equals("templatename")) {
                server.setPlatform(Platform.guess((String)value));
                continue;
            }
            if (name.equals("serviceofferingid")) {
                productId = value;
                continue;
            }
            if (value == null) continue;
            properties.put(name, value);
        }
        if (server.getName() == null) {
            server.setName(server.getProviderVirtualMachineId());
        }
        if (server.getDescription() == null) {
            server.setDescription(server.getName());
        }
        server.setProviderAssignedIpAddressId(null);
        if (server.getProviderRegionId() == null) {
            server.setProviderRegionId(this.provider.getContext().getRegionId());
        }
        if (server.getProviderDataCenterId() == null) {
            server.setProviderDataCenterId(this.provider.getContext().getRegionId());
        }
        if (productId != null) {
            server.setProductId(productId);
        }
        return server;
    }

    static {
        productCache = new HashMap<String, Map<Architecture, Collection<VirtualMachineProduct>>>();
    }
}

