/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeSupport;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Volumes
implements VolumeSupport {
    private static final Logger logger = Logger.getLogger(Volumes.class);
    private static final String ATTACH_VOLUME = "attachVolume";
    private static final String CREATE_VOLUME = "createVolume";
    private static final String DELETE_VOLUME = "deleteVolume";
    private static final String DETACH_VOLUME = "detachVolume";
    private static final String LIST_DISK_OFFERINGS = "listDiskOfferings";
    private static final String LIST_VOLUMES = "listVolumes";
    private CSCloud provider;
    private List<String> unixDeviceIdList = null;
    private List<String> windowsDeviceIdList = null;
    private transient Collection<VolumeProduct> products;

    Volumes(CSCloud provider) {
        this.provider = provider;
    }

    public void attach(@Nonnull String volumeId, @Nonnull String serverId, @Nullable String deviceId) throws InternalException, CloudException {
        Param[] params;
        VirtualMachine vm;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("attaching " + volumeId + " to " + serverId + " as " + deviceId));
        }
        if ((vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(serverId)) == null) {
            throw new CloudException("No such virtual machine: " + serverId);
        }
        long timeout = System.currentTimeMillis() + 600000L;
        while (timeout > System.currentTimeMillis() && !VmState.RUNNING.equals((Object)vm.getCurrentState()) && !VmState.STOPPED.equals((Object)vm.getCurrentState())) {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                vm = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(serverId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (vm != null) continue;
            throw new CloudException("Virtual machine " + serverId + " disappeared waiting for it to enter an attachable state");
        }
        if (deviceId == null) {
            params = new Param[]{new Param("id", volumeId), new Param("virtualMachineId", serverId)};
        } else {
            deviceId = this.toDeviceNumber(deviceId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Device mapping is: " + deviceId));
            }
            params = new Param[]{new Param("id", volumeId), new Param("virtualMachineId", serverId), new Param("deviceId", deviceId)};
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(ATTACH_VOLUME, params));
        if (doc == null) {
            throw new CloudException("No such volume or server");
        }
        this.provider.waitForJob(doc, "Attach Volume");
    }

    @Deprecated
    @Nonnull
    public String create(@Nullable String snapshotId, @Nonnegative int size, @Nullable String zoneId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was provided for this request");
        }
        String name = "vol_" + System.currentTimeMillis();
        if (size < 0) {
            size = 0;
        }
        VolumeCreateOptions options = snapshotId == null ? VolumeCreateOptions.getInstance((Storage)new Storage((Number)size, (StorageUnit)Storage.GIGABYTE), (String)name, (String)name) : VolumeCreateOptions.getInstanceForSnapshot((String)snapshotId, (Storage)new Storage((Number)size, (StorageUnit)Storage.GIGABYTE), (String)name, (String)name);
        if (zoneId != null) {
            options = options.inDataCenter(zoneId);
        }
        return this.createVolume(options);
    }

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions options) throws InternalException, CloudException {
        Storage s;
        Object size;
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was provided for this request");
        }
        String snapshotId = options.getSnapshotId();
        String productId = options.getVolumeProductId();
        VolumeProduct product = null;
        if (productId != null) {
            for (VolumeProduct prd : this.listVolumeProducts()) {
                if (!productId.equals(prd.getProviderProductId())) continue;
                product = prd;
                break;
            }
        }
        if (snapshotId == null) {
            if (product == null) {
                size = options.getVolumeSize();
                if (size.intValue() < this.getMinimumVolumeSize().intValue()) {
                    size = this.getMinimumVolumeSize();
                }
                Iterable<VolumeProduct> products = this.listVolumeProducts();
                VolumeProduct best = null;
                for (VolumeProduct p : products) {
                    long bestSize;
                    Storage s2 = p.getVolumeSize();
                    if (s2 == null || s2.intValue() == 0) {
                        product = p;
                        break;
                    }
                    long currentSize = s2.getQuantity().longValue();
                    s2 = best == null ? null : best.getVolumeSize();
                    long l = bestSize = s2 == null ? 0L : s2.getQuantity().longValue();
                    if (size.longValue() > 0L && size.longValue() == currentSize) {
                        product = p;
                        break;
                    }
                    if (best == null) {
                        best = p;
                        continue;
                    }
                    if (bestSize <= 0L && currentSize <= 0L) continue;
                    if (size.longValue() > 0L) {
                        if (bestSize < size.longValue() && bestSize > 0L && currentSize > size.longValue()) {
                            best = p;
                            continue;
                        }
                        if (bestSize <= size.longValue() || currentSize <= size.longValue() || currentSize >= bestSize) continue;
                        best = p;
                        continue;
                    }
                    if (currentSize <= 0L || currentSize >= bestSize) continue;
                    best = p;
                }
                if (product == null) {
                    product = best;
                }
            } else {
                size = product.getVolumeSize();
                if (size == null || size.intValue() < 1) {
                    size = options.getVolumeSize();
                }
            }
            if (product == null && size.longValue() < 1L) {
                throw new CloudException("No offering matching " + options.getVolumeProductId());
            }
        } else {
            Snapshot snapshot = this.provider.getComputeServices().getSnapshotSupport().getSnapshot(snapshotId);
            if (snapshot == null) {
                throw new CloudException("No such snapshot: " + snapshotId);
            }
            int s3 = snapshot.getSizeInGb();
            size = s3 < 1 || s3 < this.getMinimumVolumeSize().intValue() ? this.getMinimumVolumeSize() : new Storage((Number)s3, (StorageUnit)Storage.GIGABYTE);
        }
        Param[] params = product == null && snapshotId == null ? new Param[]{new Param("name", options.getName()), new Param("zoneId", ctx.getRegionId()), new Param("size", String.valueOf(size.longValue()))} : (snapshotId != null ? new Param[]{new Param("name", options.getName()), new Param("zoneId", ctx.getRegionId()), new Param("snapshotId", snapshotId), new Param("size", String.valueOf(size.longValue()))} : ((s = product.getVolumeSize()) == null || s.intValue() < 1 ? new Param[]{new Param("name", options.getName()), new Param("zoneId", ctx.getRegionId()), new Param("diskOfferingId", product.getProviderProductId()), new Param("size", String.valueOf(size.longValue()))} : new Param[]{new Param("name", options.getName()), new Param("zoneId", ctx.getRegionId()), new Param("diskOfferingId", product.getProviderProductId())}));
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_VOLUME, params));
        NodeList matches = doc.getElementsByTagName("volumeid");
        String volumeId = null;
        if (matches.getLength() > 0) {
            volumeId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (volumeId == null && (matches = doc.getElementsByTagName("id")).getLength() > 0) {
            volumeId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (volumeId == null) {
            throw new CloudException("Failed to create volume");
        }
        this.provider.waitForJob(doc, "Create Volume");
        return volumeId;
    }

    public void detach(@Nonnull String volumeId) throws InternalException, CloudException {
        this.detach(volumeId, false);
    }

    public void detach(@Nonnull String volumeId, boolean force) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DETACH_VOLUME, new Param("id", volumeId)));
        this.provider.waitForJob(doc, "Detach Volume");
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    @Nonnull
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)5000, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    Collection<DiskOffering> getDiskOfferings() throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_DISK_OFFERINGS, new Param[0]));
        ArrayList<DiskOffering> offerings = new ArrayList<DiskOffering>();
        NodeList matches = doc.getElementsByTagName("diskoffering");
        for (int i = 0; i < matches.getLength(); ++i) {
            DiskOffering offering = new DiskOffering();
            Node node = matches.item(i);
            NodeList attributes = node.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (n.getNodeName().equals("id")) {
                    offering.id = value;
                    continue;
                }
                if (n.getNodeName().equals("disksize")) {
                    offering.diskSize = Long.parseLong(value);
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("name")) {
                    offering.name = value;
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("displayText")) continue;
                offering.description = value;
            }
            if (offering.id == null) continue;
            if (offering.name == null) {
                offering.name = offering.diskSize > 0L ? offering.diskSize + " GB" : "Custom #" + offering.id;
            }
            if (offering.description == null) {
                offering.description = offering.name;
            }
            offerings.add(offering);
        }
        return offerings;
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "volume";
    }

    @Nullable
    String getRootVolumeId(@Nonnull String serverId) throws InternalException, CloudException {
        Volume volume = this.getRootVolume(serverId);
        return volume == null ? null : volume.getProviderVolumeId();
    }

    @Nullable
    private Volume getRootVolume(@Nonnull String serverId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VOLUMES, new Param("virtualMachineId", serverId)));
        NodeList matches = doc.getElementsByTagName("volume");
        for (int i = 0; i < matches.getLength(); ++i) {
            Volume volume;
            Node v = matches.item(i);
            if (v == null || (volume = this.toVolume(v, true)) == null) continue;
            return volume;
        }
        return null;
    }

    @Nullable
    public Volume getVolume(@Nonnull String volumeId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was configured for this request");
        }
        try {
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_VOLUMES, new Param("id", volumeId), new Param("zoneId", ctx.getRegionId())));
            NodeList matches = doc.getElementsByTagName("volume");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node v = matches.item(i);
                if (v == null) continue;
                return this.toVolume(v, false);
            }
            return null;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.REQUIRED;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        if (platform.isWindows()) {
            if (this.windowsDeviceIdList == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("hde");
                list.add("hdf");
                list.add("hdg");
                list.add("hdh");
                list.add("hdi");
                list.add("hdj");
                this.windowsDeviceIdList = Collections.unmodifiableList(list);
            }
            return this.windowsDeviceIdList;
        }
        if (this.unixDeviceIdList == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("/dev/xvdc");
            list.add("/dev/xvde");
            list.add("/dev/xvdf");
            list.add("/dev/xvdg");
            list.add("/dev/xvdh");
            list.add("/dev/xvdi");
            list.add("/dev/xvdj");
            this.unixDeviceIdList = Collections.unmodifiableList(list);
        }
        return this.unixDeviceIdList;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException {
        if (this.products == null) {
            ArrayList<VolumeProduct> list = new ArrayList<VolumeProduct>();
            for (DiskOffering offering : this.getDiskOfferings()) {
                VolumeProduct p = this.toProduct(offering);
                if (p == null) continue;
                list.add(p);
            }
            this.products = Collections.unmodifiableList(list);
        }
        return this.products;
    }

    @Nonnull
    public Iterable<ResourceStatus> listVolumeStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VOLUMES, new Param("zoneId", ctx.getRegionId())));
        ArrayList<ResourceStatus> volumes = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("volume");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus volume;
            Node v = matches.item(i);
            if (v == null || (volume = this.toStatus(v)) == null) continue;
            volumes.add(volume);
        }
        return volumes;
    }

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException {
        return this.listVolumes(false);
    }

    @Nonnull
    private Collection<Volume> listVolumes(boolean rootOnly) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was specified for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_VOLUMES, new Param("zoneId", ctx.getRegionId())));
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        NodeList matches = doc.getElementsByTagName("volume");
        for (int i = 0; i < matches.getLength(); ++i) {
            Volume volume;
            Node v = matches.item(i);
            if (v == null || (volume = this.toVolume(v, rootOnly)) == null) continue;
            volumes.add(volume);
        }
        return volumes;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void remove(@Nonnull String volumeId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DELETE_VOLUME, new Param("id", volumeId)));
        this.provider.waitForJob(doc, "Delete Volume");
    }

    @Nonnull
    private String toDeviceNumber(@Nonnull String deviceId) {
        if (!deviceId.startsWith("/dev/") && !deviceId.startsWith("hd")) {
            deviceId = "/dev/" + deviceId;
        }
        if (deviceId.equals("/dev/xvda")) {
            return "0";
        }
        if (deviceId.equals("/dev/xvdb")) {
            return "1";
        }
        if (deviceId.equals("/dev/xvdc")) {
            return "2";
        }
        if (deviceId.equals("/dev/xvde")) {
            return "4";
        }
        if (deviceId.equals("/dev/xvdf")) {
            return "5";
        }
        if (deviceId.equals("/dev/xvdg")) {
            return "6";
        }
        if (deviceId.equals("/dev/xvdh")) {
            return "7";
        }
        if (deviceId.equals("/dev/xvdi")) {
            return "8";
        }
        if (deviceId.equals("/dev/xvdj")) {
            return "9";
        }
        if (deviceId.equals("hda")) {
            return "0";
        }
        if (deviceId.equals("hdb")) {
            return "1";
        }
        if (deviceId.equals("hdc")) {
            return "2";
        }
        if (deviceId.equals("hdd")) {
            return "3";
        }
        if (deviceId.equals("hde")) {
            return "4";
        }
        if (deviceId.equals("hdf")) {
            return "5";
        }
        if (deviceId.equals("hdg")) {
            return "6";
        }
        if (deviceId.equals("hdh")) {
            return "7";
        }
        if (deviceId.equals("hdi")) {
            return "8";
        }
        if (deviceId.equals("hdj")) {
            return "9";
        }
        return "9";
    }

    @Nullable
    private VolumeProduct toProduct(@Nullable DiskOffering offering) throws InternalException, CloudException {
        if (offering == null) {
            return null;
        }
        if (offering.diskSize < 1L) {
            return VolumeProduct.getInstance((String)offering.id, (String)offering.name, (String)offering.description, (VolumeType)VolumeType.HDD);
        }
        return VolumeProduct.getInstance((String)offering.id, (String)offering.name, (String)offering.description, (VolumeType)VolumeType.HDD, (Storage)new Storage((Number)offering.diskSize, (StorageUnit)Storage.GIGABYTE));
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws InternalException, CloudException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VolumeState volumeState = null;
        String volumeId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute == null) continue;
            String name = attribute.getNodeName();
            if (name.equals("id")) {
                volumeId = attribute.getFirstChild().getNodeValue().trim();
            } else if (name.equals("state") && attribute.hasChildNodes()) {
                String state = attribute.getFirstChild().getNodeValue();
                if (state == null) {
                    volumeState = VolumeState.PENDING;
                } else if (state.equalsIgnoreCase("created") || state.equalsIgnoreCase("ready") || state.equalsIgnoreCase("allocated")) {
                    volumeState = VolumeState.AVAILABLE;
                } else {
                    logger.warn((Object)("DEBUG: Unknown state for CloudStack volume: " + state));
                    volumeState = VolumeState.PENDING;
                }
            }
            if (volumeId != null && volumeState != null) break;
        }
        if (volumeId == null) {
            return null;
        }
        if (volumeState == null) {
            volumeState = VolumeState.PENDING;
        }
        return new ResourceStatus(volumeId, (Object)volumeState);
    }

    @Nullable
    private Volume toVolume(@Nullable Node node, boolean rootOnly) throws InternalException, CloudException {
        if (node == null) {
            return null;
        }
        Volume volume = new Volume();
        String offeringId = null;
        NodeList attributes = node.getChildNodes();
        String volumeName = null;
        String description = null;
        boolean root = false;
        volume.setFormat(VolumeFormat.BLOCK);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute == null) continue;
            String name = attribute.getNodeName();
            if (name.equals("id")) {
                volume.setProviderVolumeId(attribute.getFirstChild().getNodeValue().trim());
            }
            if (name.equals("zoneid")) {
                String zid = attribute.getFirstChild().getNodeValue().trim();
                if (this.provider.getContext().getRegionId().equals(zid)) continue;
                System.out.println("Zone mismatch: " + this.provider.getContext().getRegionId());
                System.out.println("               " + zid);
                return null;
            }
            if (name.equals("type") && attribute.hasChildNodes()) {
                if (!attribute.getFirstChild().getNodeValue().equalsIgnoreCase("root")) continue;
                root = true;
                continue;
            }
            if (name.equals("diskofferingid") && attribute.hasChildNodes()) {
                offeringId = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("name") && attribute.hasChildNodes()) {
                volumeName = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equalsIgnoreCase("virtualmachineid") && attribute.hasChildNodes()) {
                volume.setProviderVirtualMachineId(attribute.getFirstChild().getNodeValue());
                continue;
            }
            if (name.equals("displayname") && attribute.hasChildNodes()) {
                description = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (name.equals("size") && attribute.hasChildNodes()) {
                long size = Long.parseLong(attribute.getFirstChild().getNodeValue()) / 1024000000L;
                volume.setSize(new Storage((Number)size, (StorageUnit)Storage.GIGABYTE));
                continue;
            }
            if (name.equals("state") && attribute.hasChildNodes()) {
                String state = attribute.getFirstChild().getNodeValue();
                if (state == null || state.equalsIgnoreCase("allocated")) {
                    volume.setCurrentState(VolumeState.PENDING);
                    continue;
                }
                if (state.equalsIgnoreCase("created") || state.equalsIgnoreCase("ready")) {
                    volume.setCurrentState(VolumeState.AVAILABLE);
                    continue;
                }
                logger.warn((Object)("DEBUG: Unknown state for CloudStack volume: " + state));
                volume.setCurrentState(VolumeState.PENDING);
                continue;
            }
            if (!name.equals("created") || !attribute.hasChildNodes()) continue;
            String date = attribute.getFirstChild().getNodeValue();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            try {
                volume.setCreationTimestamp(df.parse(date).getTime());
                continue;
            }
            catch (ParseException e) {
                volume.setCreationTimestamp(0L);
            }
        }
        if (!root && rootOnly) {
            return null;
        }
        if (volume.getProviderVolumeId() == null) {
            return null;
        }
        if (volumeName == null) {
            volume.setName(volume.getProviderVolumeId());
        } else {
            volume.setName(volumeName);
        }
        if (description == null) {
            volume.setDescription(volume.getName());
        } else {
            volume.setDescription(description);
        }
        if (offeringId != null) {
            volume.setProviderProductId(offeringId);
        }
        volume.setProviderRegionId(this.provider.getContext().getRegionId());
        volume.setProviderDataCenterId(this.provider.getContext().getRegionId());
        if (volume.getProviderVirtualMachineId() != null && root) {
            volume.setDeviceId("/dev/xvda2");
        }
        volume.setRootVolume(root);
        volume.setType(VolumeType.HDD);
        return volume;
    }

    public static class DiskOffering {
        public String id;
        public long diskSize;
        public String name;
        public String description;

        public String toString() {
            return "DiskOffering [" + this.id + "] of size " + this.diskSize;
        }
    }
}

