/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityGroup
implements FirewallSupport {
    private static final Logger logger = Logger.getLogger(SecurityGroup.class);
    public static final String AUTHORIZE_SECURITY_GROUP_EGRESS = "authorizeSecurityGroupEgress";
    public static final String AUTHORIZE_SECURITY_GROUP_INGRESS = "authorizeSecurityGroupIngress";
    public static final String CREATE_SECURITY_GROUP = "createSecurityGroup";
    public static final String DELETE_SECURITY_GROUP = "deleteSecurityGroup";
    public static final String LIST_SECURITY_GROUPS = "listSecurityGroups";
    public static final String REVOKE_SECURITY_GROUP_INGRESS = "revokeSecurityGroupIngress";
    private CSCloud cloudstack;

    private static boolean isIP(@Nonnull String test) {
        String[] parts = test.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                Integer x = Integer.parseInt(part);
                if (x >= 0 && x <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    SecurityGroup(CSCloud cloudstack) {
        this.cloudstack = cloudstack;
    }

    @Deprecated
    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        return this.authorize(firewallId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, beginPort, endPort);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        return this.authorize(firewallId, direction, Permission.ALLOW, cidr, protocol, beginPort, endPort);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        return this.authorize(firewallId, direction, permission, cidr, protocol, RuleTarget.getCIDR((String)cidr), beginPort, endPort);
    }

    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, @Nonnull RuleTarget target, int beginPort, int endPort) throws CloudException, InternalException {
        if (!permission.equals((Object)Permission.ALLOW)) {
            throw new OperationNotSupportedException("Only ALLOW arules are supported");
        }
        boolean group = false;
        if (source.indexOf(47) == -1) {
            if (SecurityGroup.isIP(source)) {
                source = source + "/32";
            } else {
                group = true;
            }
        }
        CSMethod method = new CSMethod(this.cloudstack);
        if (group) {
            throw new CloudException("Security group sources are not supported");
        }
        Param[] params = new Param[]{new Param("securitygroupid", firewallId), new Param("cidrlist", source), new Param("startport", String.valueOf(beginPort)), new Param("endport", String.valueOf(endPort)), new Param("protocol", protocol.name())};
        if (direction.equals((Object)Direction.INGRESS)) {
            method.get(method.buildUrl(AUTHORIZE_SECURITY_GROUP_INGRESS, params));
        } else {
            method.get(method.buildUrl(AUTHORIZE_SECURITY_GROUP_EGRESS, params));
        }
        for (FirewallRule rule : this.getRules(firewallId)) {
            RuleTarget t = rule.getTarget();
            if (!t.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) || !source.equals(rule.getSource()) || !protocol.equals((Object)rule.getProtocol()) || rule.getStartPort() != beginPort || rule.getEndPort() != endPort) continue;
            return rule.getProviderRuleId();
        }
        throw new CloudException("Unable to identify newly created firewall rule ID");
    }

    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description) throws InternalException, CloudException {
        Param[] params = new Param[]{new Param("name", name), new Param("description", description)};
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(CREATE_SECURITY_GROUP, params));
        NodeList matches = doc.getElementsByTagName("id");
        String groupId = null;
        if (matches.getLength() > 0) {
            groupId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (groupId == null) {
            throw new CloudException("Failed to create firewall");
        }
        return groupId;
    }

    @Nonnull
    public String createInVLAN(@Nonnull String name, @Nonnull String description, @Nonnull String providerVlanId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Firewalls may not be created for specified VLANs");
    }

    public void delete(@Nonnull String firewallId) throws InternalException, CloudException {
        try {
            for (FirewallRule rule : this.getRules(firewallId)) {
                try {
                    this.revoke(rule.getProviderRuleId());
                }
                catch (Throwable ignore) {}
            }
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        CSMethod method = new CSMethod(this.cloudstack);
        method.get(method.buildUrl(DELETE_SECURITY_GROUP, new Param("id", firewallId)));
    }

    @Nullable
    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        try {
            Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("id", firewallId)));
            NodeList matches = doc.getElementsByTagName("securitygroup");
            for (int i = 0; i < matches.getLength(); ++i) {
                Firewall fw;
                Node node = matches.item(i);
                if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
                return fw;
            }
            return null;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        FirewallRule rule;
        Node node;
        int i;
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("id", firewallId)));
        ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
        NodeList matches = doc.getElementsByTagName("ingressrule");
        for (i = 0; i < matches.getLength(); ++i) {
            node = matches.item(i);
            if (node == null || (rule = this.toRule(firewallId, node)) == null) continue;
            rules.add(rule);
        }
        matches = doc.getElementsByTagName("egressrule");
        for (i = 0; i < matches.getLength(); ++i) {
            node = matches.item(i);
            if (node == null || (rule = this.toRule(firewallId, node)) == null) continue;
            rules.add(rule);
        }
        return rules;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        return this.cloudstack.getDataCenterServices().supportsSecurityGroups(regionId, false);
    }

    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param[0]));
        ArrayList<Firewall> firewalls = new ArrayList<Firewall>();
        NodeList matches = doc.getElementsByTagName("securitygroup");
        for (int i = 0; i < matches.getLength(); ++i) {
            Firewall fw;
            Node node = matches.item(i);
            if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
            firewalls.add(fw);
        }
        return firewalls;
    }

    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param[0]));
        ArrayList<ResourceStatus> firewalls = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("securitygroup");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus fw;
            Node node = matches.item(i);
            if (node == null || (fw = this.toStatus(node)) == null) continue;
            firewalls.add(fw);
        }
        return firewalls;
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        return Collections.singletonList(RuleTargetType.GLOBAL);
    }

    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        Param[] params = new Param[]{new Param("id", providerFirewallRuleId)};
        CSMethod method = new CSMethod(this.cloudstack);
        method.get(method.buildUrl(REVOKE_SECURITY_GROUP_INGRESS, params));
    }

    @Nonnull
    public Iterable<String> listFirewallsForVM(@Nonnull String vmId) throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("virtualmachineId", vmId)));
        ArrayList<String> firewalls = new ArrayList<String>();
        NodeList matches = doc.getElementsByTagName("securitygroup");
        for (int i = 0; i < matches.getLength(); ++i) {
            Firewall fw;
            Node node = matches.item(i);
            if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
            firewalls.add(fw.getProviderFirewallId());
        }
        return firewalls;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void revoke(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal(), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal(), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, permission, source, protocol, RuleTarget.getGlobal(), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, @Nonnull RuleTarget target, int beginPort, int endPort) throws CloudException, InternalException {
        if (!Permission.ALLOW.equals((Object)permission)) {
            throw new OperationNotSupportedException("Only ALLOW rules are supported");
        }
        FirewallRule rule = null;
        for (FirewallRule r : this.getRules(firewallId)) {
            if (!r.getTarget().getRuleTargetType().equals((Object)target.getRuleTargetType()) || !r.getDirection().equals((Object)direction) || !source.equals(r.getSource()) || !protocol.equals((Object)r.getProtocol()) || r.getStartPort() != beginPort || r.getEndPort() != endPort) continue;
            rule = r;
            break;
        }
        if (rule == null) {
            logger.warn((Object)("No such rule for " + firewallId + ": " + direction + "/" + permission + "/" + source + "/" + protocol + "/" + beginPort + "/" + endPort));
            return;
        }
        this.revoke(rule.getProviderRuleId());
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return !inVlan && permission.equals((Object)Permission.ALLOW);
    }

    public boolean supportsFirewallSources() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    private Firewall toFirewall(@Nullable Node node, @Nonnull ProviderContext ctx) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was specified for this request");
        }
        NodeList attributes = node.getChildNodes();
        Firewall firewall = new Firewall();
        firewall.setActive(true);
        firewall.setAvailable(true);
        firewall.setRegionId(regionId);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                firewall.setProviderFirewallId(value);
                continue;
            }
            if (name.equalsIgnoreCase("description") && value != null) {
                firewall.setDescription(value);
                continue;
            }
            if (!name.equalsIgnoreCase("name") || value == null) continue;
            firewall.setName(value);
        }
        if (firewall.getProviderFirewallId() == null) {
            logger.warn((Object)("Discovered firewall " + firewall.getProviderFirewallId() + " with an empty firewall ID"));
            return null;
        }
        String id = firewall.getProviderFirewallId();
        if (id == null) {
            return null;
        }
        String name = firewall.getName();
        if (name == null) {
            name = id;
            firewall.setName(name);
        }
        if (firewall.getDescription() == null) {
            firewall.setDescription(name);
        }
        return firewall;
    }

    private FirewallRule toRule(String firewallId, Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        int startPort = -1;
        int endPort = -1;
        Protocol protocol = Protocol.TCP;
        Direction direction = Direction.INGRESS;
        String source = "0.0.0.0/0";
        String ruleId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("cidr") && value != null) {
                source = value;
                continue;
            }
            if (name.equalsIgnoreCase("endport") && value != null) {
                endPort = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("startport") && value != null) {
                startPort = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("protocol") && value != null) {
                protocol = Protocol.valueOf((String)value.toUpperCase());
                continue;
            }
            if (!name.equalsIgnoreCase("ruleId") || value == null) continue;
            ruleId = value;
        }
        if (!(startPort != -1 && endPort != -1 || startPort == -1 && endPort == -1)) {
            if (startPort == -1) {
                startPort = endPort;
            } else {
                endPort = startPort;
            }
        }
        return FirewallRule.getInstance(ruleId, (String)firewallId, (String)source, (Direction)direction, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getGlobal(), (int)startPort, (int)endPort);
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (!name.equalsIgnoreCase("id") || value == null) continue;
            return new ResourceStatus(value, (Object)true);
        }
        return null;
    }
}

