/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSTopology;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.CSComputeServices;
import org.dasein.cloud.cloudstack.identity.CSIdentityServices;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSCloud
extends AbstractCloud {
    private transient CSServiceProvider serviceProvider;
    private transient CSVersion version;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = CSCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("cloudstack") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.cloudstack." + type + "." + pkg + CSCloud.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "Citrix";
        }
        String name = ctx.getCloudName();
        if (name == null) {
            return "Citrix";
        }
        return name;
    }

    @Nonnull
    public CSComputeServices getComputeServices() {
        return new CSComputeServices(this);
    }

    @Nonnull
    public CSTopology getDataCenterServices() {
        return new CSTopology(this);
    }

    @Nullable
    public CSIdentityServices getIdentityServices() {
        if (this.getVersion().greaterThan(CSVersion.CS21)) {
            return new CSIdentityServices(this);
        }
        return null;
    }

    @Nonnull
    public CSNetworkServices getNetworkServices() {
        return new CSNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "Citrix";
        }
        String name = ctx.getProviderName();
        if (name == null) {
            return "Citrix";
        }
        return name;
    }

    public CSServiceProvider getServiceProvider() {
        if (this.serviceProvider == null) {
            String pn = this.getProviderName();
            this.serviceProvider = "kt".equalsIgnoreCase(pn) ? CSServiceProvider.KT : ("datapipe".equalsIgnoreCase(pn) ? CSServiceProvider.DATAPIPE : ("tata".equalsIgnoreCase(pn) ? CSServiceProvider.TATA : CSServiceProvider.INTERNAL));
        }
        return this.serviceProvider;
    }

    @Nonnull
    public CSVersion getVersion() {
        if (this.version == null) {
            ProviderContext ctx = this.getContext();
            Properties properties = ctx == null ? null : ctx.getCustomProperties();
            String versionString = properties == null ? "CS3" : properties.getProperty("apiVersion", "CS3");
            try {
                this.version = CSVersion.valueOf(versionString);
            }
            catch (Throwable t) {
                this.version = CSVersion.CS3;
            }
        }
        return this.version;
    }

    @Nonnegative
    public long parseTime(@Nonnull String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            return df.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            try {
                return df.parse(timestamp).getTime();
            }
            catch (ParseException another) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        String string;
        Logger logger = CSCloud.getLogger(CSCloud.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + CSCloud.class.getName() + ".testContext()"));
        }
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                String string2 = null;
                return string2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"testContext(): Checking CSCloud compute credentials");
            }
            if (!this.getComputeServices().getVirtualMachineSupport().isSubscribed()) {
                logger.warn((Object)"testContext(): CSCloud compute credentials are not subscribed for VM services");
                String string3 = null;
                return string3;
            }
            if (this.hasStorageServices()) {
                BlobStoreSupport support;
                StorageServices services;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("testContext(): Checking " + ctx.getStorage() + " storage credentials"));
                }
                if ((services = this.getStorageServices()) != null && services.hasBlobStoreSupport() && (support = services.getBlobStoreSupport()) != null) {
                    try {
                        support.list(null).iterator().hasNext();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("testContext(): Storage credentials failed: " + t.getMessage()));
                        t.printStackTrace();
                        String string4 = null;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("exit - " + CSCloud.class.getName() + ".testContext()"));
                        }
                        return string4;
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"testContext(): Credentials validated");
            }
            string = ctx.getAccountNumber();
            return string;
        }
        catch (Throwable t) {
            logger.warn((Object)("testContext(): Failed to test cloudstack context: " + t.getMessage()));
            t.printStackTrace();
            string = null;
            return string;
        }
        finally {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("exit - " + CSCloud.class.getName() + ".testContext()"));
            }
        }
    }

    public Document waitForJob(Document doc, String jobName) throws CloudException, InternalException {
        NodeList matches = doc.getElementsByTagName("jobid");
        if (matches.getLength() > 0) {
            return this.waitForJob(matches.item(0).getFirstChild().getNodeValue(), jobName);
        }
        return null;
    }

    public Document waitForJob(String jobId, String jobName) throws CloudException, InternalException {
        int code;
        NodeList matches;
        Document doc;
        CSMethod method = new CSMethod(this);
        String url = method.buildUrl("queryAsyncJobResult", new Param("jobId", jobId));
        while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            doc = method.get(url);
            matches = doc.getElementsByTagName("jobstatus");
            int status = 0;
            if (matches.getLength() > 0) {
                status = Integer.parseInt(matches.item(0).getFirstChild().getNodeValue());
            }
            if (status <= 0) continue;
            code = status;
            if (status == 1) {
                return doc;
            }
            if (status == 2) break;
        }
        matches = doc.getElementsByTagName("jobresult");
        if (matches.getLength() > 0) {
            String str = matches.item(0).getFirstChild().getNodeValue();
            if (str == null || str.trim().length() < 1) {
                NodeList nodes = matches.item(0).getChildNodes();
                String message = null;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node n = nodes.item(i);
                    if (n.getNodeName().equalsIgnoreCase("errorcode")) {
                        try {
                            code = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
                        }
                        catch (NumberFormatException ignore) {}
                        continue;
                    }
                    if (!n.getNodeName().equalsIgnoreCase("errortext")) continue;
                    message = n.getFirstChild().getNodeValue().trim();
                }
                CSMethod.ParsedError error = new CSMethod.ParsedError();
                error.code = code;
                error.message = message;
                throw new CSException(error);
            }
            throw new CloudException(str);
        }
        throw new CloudException(jobName + " failed with an unexplained error.");
    }
}

