/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.SnapshotSupport;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.identity.ServiceAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Snapshots
implements SnapshotSupport {
    private static final Logger logger = Logger.getLogger(Snapshots.class);
    private static final String CREATE_SNAPSHOT = "createSnapshot";
    private static final String DELETE_SNAPSHOT = "deleteSnapshot";
    private static final String LIST_SNAPSHOTS = "listSnapshots";
    private CSCloud provider;

    Snapshots(CSCloud provider) {
        this.provider = provider;
    }

    public void addSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Snapshot sharing is not supported");
    }

    public void addPublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Snapshot sharing is not supported");
    }

    @Deprecated
    @Nonnull
    public String create(@Nonnull String volumeId, @Nonnull String description) throws InternalException, CloudException {
        String name = description == null ? "From " + volumeId : description;
        return this.snapshot(volumeId, name, name, new Tag[0]).getProviderSnapshotId();
    }

    @Nullable
    public Snapshot getSnapshot(@Nonnull String snapshotId) throws InternalException, CloudException {
        for (Snapshot snapshot : this.listSnapshots()) {
            if (!snapshot.getProviderSnapshotId().equals(snapshotId)) continue;
            return snapshot;
        }
        return null;
    }

    public void remove(@Nonnull String snapshotId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(DELETE_SNAPSHOT, new Param("id", snapshotId));
        Document doc = method.get(url);
        this.provider.waitForJob(doc, "Delete Snapshot");
    }

    public void removeAllSnapshotShares(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Snapshot sharing is not supported");
    }

    public void removeSnapshotShare(@Nonnull String providerSnapshotId, @Nonnull String accountNumber) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Snapshot sharing is not supported");
    }

    public void removePublicShare(@Nonnull String providerSnapshotId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Snapshot sharing is not supported");
    }

    @Nonnull
    public Iterable<Snapshot> searchSnapshots(@Nullable String ownerId, @Nullable String keyword) throws InternalException, CloudException {
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        if (keyword != null) {
            keyword = keyword.toLowerCase();
        }
        for (Snapshot s : this.listSnapshots()) {
            if (ownerId != null && !ownerId.equals(s.getOwner()) || keyword != null && !s.getName().toLowerCase().contains(keyword) && !s.getDescription().toLowerCase().contains(keyword)) continue;
            snapshots.add(s);
        }
        return snapshots;
    }

    @Nonnull
    public String getProviderTermForSnapshot(@Nonnull Locale locale) {
        return "snapshot";
    }

    @Nonnull
    public Iterable<String> listShares(@Nonnull String snapshotId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listSnapshotStatus() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()));
        Document doc = method.get(url);
        ArrayList<ResourceStatus> snapshots = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("snapshot");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus snapshot;
            Node s = matches.item(i);
            if (s == null || (snapshot = this.toStatus(s)) == null) continue;
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    @Nonnull
    public Requirement identifyAttachmentRequirement() throws InternalException, CloudException {
        return Requirement.REQUIRED;
    }

    public boolean isPublic(@Nonnull String snapshotId) throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public boolean supportsSnapshotSharing() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsSnapshotSharingWithPublic() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<Snapshot> listSnapshots() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        Iterable<Volume> volumes = this.provider.getComputeServices().getVolumeSupport().listVolumes();
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()));
        Document doc = method.get(url);
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        NodeList matches = doc.getElementsByTagName("snapshot");
        for (int i = 0; i < matches.getLength(); ++i) {
            Snapshot snapshot;
            Node s = matches.item(i);
            if (s == null || (snapshot = this.toSnapshot(s, ctx, volumes)) == null) continue;
            snapshots.add(snapshot);
        }
        return snapshots;
    }

    private Snapshot getLatestSnapshot(String forVolumeId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()), new Param("volumeId", forVolumeId));
        Volume volume = this.provider.getComputeServices().getVolumeSupport().getVolume(forVolumeId);
        List<Object> volumes = volume == null ? Collections.emptyList() : Collections.singletonList(volume);
        Document doc = method.get(url);
        Snapshot latest = null;
        NodeList matches = doc.getElementsByTagName("snapshot");
        for (int i = 0; i < matches.getLength(); ++i) {
            Snapshot snapshot;
            Node s = matches.item(i);
            if (s == null || (snapshot = this.toSnapshot(s, ctx, volumes)) == null || snapshot.getVolumeId() == null || !snapshot.getVolumeId().equals(forVolumeId) || latest != null && snapshot.getSnapshotTimestamp() <= latest.getSnapshotTimestamp()) continue;
            latest = snapshot;
        }
        return latest;
    }

    public void shareSnapshot(@Nonnull String arg0, String arg1, boolean arg2) throws InternalException, CloudException {
        throw new OperationNotSupportedException();
    }

    @Nonnull
    public Snapshot snapshot(@Nonnull String volumeId, @Nonnull String name, @Nonnull String description, Tag ... tags) throws InternalException, CloudException {
        NodeList matches;
        Document doc;
        Volume volume = this.provider.getComputeServices().getVolumeSupport().getVolume(volumeId);
        if (volume == null) {
            throw new CloudException("No such volume: " + volumeId);
        }
        if (volume.getProviderVirtualMachineId() == null) {
            throw new CloudException("You must attach this volume before you can snapshot it.");
        }
        long timeout = System.currentTimeMillis() + 600000L;
        while (timeout > System.currentTimeMillis() && !VolumeState.AVAILABLE.equals((Object)volume.getCurrentState())) {
            if (VolumeState.DELETED.equals((Object)volume.getCurrentState())) {
                throw new CloudException("Volume " + volumeId + " disappeared before a snapshot could be taken");
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            try {
                volume = this.provider.getComputeServices().getVolumeSupport().getVolume(volumeId);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            if (volume != null) continue;
            throw new CloudException("Volume " + volumeId + " disappeared before a snapshot could be taken");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(CREATE_SNAPSHOT, new Param("volumeId", volumeId));
        try {
            doc = method.get(url);
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 431 && e.getMessage() != null && e.getMessage().contains("no change since last snapshot")) {
                Snapshot s = this.getLatestSnapshot(volumeId);
                if (s == null) {
                    throw e;
                }
                return s;
            }
            if (this.provider.getVersion().equals((Object)CSVersion.CS21) && (code == 500 || code == 530) && e.getMessage() != null && e.getMessage().contains("Snapshot could not be scheduled")) {
                long then = System.currentTimeMillis() - 540000L;
                long now = System.currentTimeMillis() - 60000L;
                Snapshot wtf = null;
                timeout = now + 1200000L;
                while (System.currentTimeMillis() < timeout) {
                    Snapshot latest = this.getLatestSnapshot(volumeId);
                    if (latest != null && latest.getSnapshotTimestamp() >= now) {
                        return latest;
                    }
                    if (latest != null && latest.getSnapshotTimestamp() >= then) {
                        wtf = latest;
                    }
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException ignore) {}
                }
                if (wtf != null) {
                    return wtf;
                }
                return this.snapshot(volumeId, name, description, tags);
            }
            throw e;
        }
        if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
            matches = doc.getElementsByTagName("id");
        } else {
            matches = doc.getElementsByTagName("snapshotid");
            if (matches.getLength() < 1) {
                matches = doc.getElementsByTagName("id");
            }
        }
        String snapshotId = null;
        if (matches.getLength() > 0) {
            snapshotId = matches.item(0).getFirstChild().getNodeValue();
        }
        if (snapshotId == null) {
            throw new CloudException("Failed to create a snapshot");
        }
        try {
            this.provider.waitForJob(doc, "Create Snapshot");
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                logger.warn((Object)("CSCloud opted not to make a snapshot: " + e.getMessage()));
                Snapshot s = this.getLatestSnapshot(volumeId);
                if (s == null) {
                    throw e;
                }
                return s;
            }
            throw e;
        }
        catch (CloudException e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("no change since last snapshot")) {
                Snapshot s = this.getLatestSnapshot(volumeId);
                if (s == null) {
                    throw e;
                }
                return s;
            }
            throw e;
        }
        Snapshot s = this.getSnapshot(snapshotId);
        if (s == null) {
            throw new CloudException("Created snapshot " + snapshotId + " but it does not really exist");
        }
        return s;
    }

    public boolean supportsSnapshotCreation() throws CloudException, InternalException {
        return true;
    }

    @Nullable
    private Snapshot toSnapshot(@Nullable Node node, @Nonnull ProviderContext ctx, @Nonnull Iterable<Volume> volumes) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        Snapshot snapshot = new Snapshot();
        NodeList attrs = node.getChildNodes();
        String type = null;
        snapshot.setCurrentState(SnapshotState.AVAILABLE);
        snapshot.setOwner(ctx.getAccountNumber());
        snapshot.setProgress("100%");
        snapshot.setRegionId(ctx.getRegionId());
        snapshot.setSizeInGb(1);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = null;
            if (attr.hasChildNodes()) {
                value = attr.getFirstChild().getNodeValue();
            }
            if (name.equalsIgnoreCase("id")) {
                snapshot.setProviderSnapshotId(value);
                continue;
            }
            if (name.equalsIgnoreCase("volumeid")) {
                snapshot.setVolumeId(value);
                if (value == null) continue;
                Volume v = null;
                for (Volume volume : volumes) {
                    if (!volume.getProviderVolumeId().equals(value)) continue;
                    v = volume;
                    break;
                }
                if (v == null) continue;
                snapshot.setSizeInGb(v.getSize().intValue());
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                snapshot.setName(value);
                continue;
            }
            if (value != null && name.equalsIgnoreCase("created")) {
                snapshot.setSnapshotTimestamp(this.provider.parseTime(value));
                continue;
            }
            if (name.equalsIgnoreCase("snapshottype")) {
                type = value;
                continue;
            }
            if (!name.equals("account")) continue;
            snapshot.setOwner(value);
        }
        if (snapshot.getProviderSnapshotId() == null) {
            return null;
        }
        if (snapshot.getName() == null) {
            snapshot.setName(snapshot.getProviderSnapshotId());
        }
        if (snapshot.getDescription() == null) {
            if (type == null) {
                snapshot.setDescription(snapshot.getName());
            } else {
                snapshot.setDescription(snapshot.getName() + " (" + type + ")");
            }
        }
        return snapshot;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String snapId = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = null;
            if (attr.hasChildNodes()) {
                value = attr.getFirstChild().getNodeValue();
            }
            if (!name.equalsIgnoreCase("id")) continue;
            snapId = value;
            break;
        }
        if (snapId == null) {
            return null;
        }
        return new ResourceStatus(snapId, (Object)SnapshotState.AVAILABLE);
    }

    public boolean isSubscribed() throws InternalException, CloudException {
        return this.provider.getComputeServices().getVolumeSupport().isSubscribed();
    }
}

